/*
 * Decompiled with CFR 0.152.
 */
package exc.openacc;

import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockIterator;
import exc.block.BlockList;
import exc.block.CforBlock;
import exc.block.PragmaBlock;
import exc.block.topdownBlockIterator;
import exc.object.Ident;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.openacc.ACCexception;
import exc.openacc.ACCglobalDecl;
import exc.openacc.ACCpragma;
import exc.openacc.ACCvar;
import exc.openacc.AccDirective;
import exc.openacc.AccInformation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class AccLoop
extends AccDirective {
    private final List<ACCpragma> parallelismList = Arrays.asList(ACCpragma.GANG, ACCpragma.VECTOR);

    AccLoop(ACCglobalDecl aCCglobalDecl, AccInformation accInformation, PragmaBlock pragmaBlock) {
        super(aCCglobalDecl, accInformation, pragmaBlock);
    }

    @Override
    void analyze() throws ACCexception {
        this.checkParallelism();
        this.addInductionVariableAsPrivate();
        super.analyze();
    }

    @Override
    void generate() throws ACCexception {
    }

    @Override
    void rewrite() throws ACCexception {
        this._pb.replace(Bcons.COMPOUND(this._pb.getBody()));
    }

    void addInductionVariableAsPrivate() throws ACCexception {
        Object object;
        PragmaBlock pragmaBlock;
        Object object2;
        Object object322;
        if (this._info.hasClause(ACCpragma.SEQ)) {
            return;
        }
        int n = 1;
        Xobject xobject = this._info.getIntExpr(ACCpragma.COLLAPSE);
        if (xobject != null) {
            n = xobject.getInt();
        }
        XobjList xobjList = this.checkCollapsedLoop(this._pb.getBody().getHead(), n);
        LinkedHashSet<Ident> linkedHashSet = new LinkedHashSet<Ident>();
        CforBlock cforBlock = AccLoop.findOutermostTightlyNestedForBlock(this._pb.getBody().getHead());
        for (Object object322 : xobjList) {
            Ident propObject2 = (Ident)object322;
            object2 = propObject2.getName();
            if (cforBlock.findVarIdent((String)object2) != propObject2) continue;
            linkedHashSet.add(propObject2);
        }
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(cforBlock.getBody());
        ((BlockIterator)topdownBlockIterator2).init();
        while (!(((BlockIterator)topdownBlockIterator2).end() || ((Block)(object322 = topdownBlockIterator2.getBlock())).Opcode() == Xcode.ACC_PRAGMA && ACCpragma.valueOf((pragmaBlock = (PragmaBlock)object322).getPragma()).isLoop())) {
            if (((Block)object322).Opcode() == Xcode.FOR_STATEMENT) {
                Ident ident;
                CforBlock cforBlock2 = (CforBlock)object322;
                if (!cforBlock2.isCanonical()) {
                    cforBlock2.Canonicalize();
                }
                if ((object2 = cforBlock2.getInductionVar()) != null && (ident = cforBlock2.findVarIdent((String)(object = ((Xobject)object2).getName()))) != null && ident == cforBlock.findVarIdent((String)object)) {
                    linkedHashSet.add(ident);
                }
            }
            ((BlockIterator)topdownBlockIterator2).next();
        }
        for (Ident ident : linkedHashSet) {
            object2 = ident.getName();
            object = this._info.findACCvar((String)object2);
            if (object == null) {
                this._info.addVar(ACCpragma.PRIVATE, Xcons.Symbol(Xcode.VAR, (String)object2));
                continue;
            }
            if (((ACCvar)object).isPrivate()) continue;
            throw new ACCexception((String)object2 + " is induction variable but not private");
        }
    }

    void checkParallelism() throws ACCexception {
        Set<ACCpragma> set = AccLoop.getParallelismSet(this._info);
        if (set.contains((Object)ACCpragma.AUTO) && set.size() != 1 || set.contains((Object)ACCpragma.SEQ) && set.size() != 1) {
            throw new ACCexception("invalid parallelism");
        }
        this.fixInputParallelism(set);
        Set<ACCpragma> set2 = this.getInnerParallelism();
        Set<ACCpragma> set3 = this.getOuterParallelism();
        ACCpragma aCCpragma = this.getTargetParallelism();
        EnumSet<ACCpragma> enumSet = EnumSet.noneOf(ACCpragma.class);
        ACCpragma aCCpragma2 = this.getCoarsestParallelism(set2);
        if (set.contains((Object)ACCpragma.AUTO)) {
            if (aCCpragma2 == aCCpragma) {
                enumSet.add(ACCpragma.SEQ);
            } else if (aCCpragma2 == ACCpragma.SEQ) {
                Set<ACCpragma> set4 = this.getFullParallelism();
                set4.removeAll(set3);
                enumSet.addAll((Collection<ACCpragma>)set4);
            } else if (aCCpragma == ACCpragma.VECTOR) {
                enumSet.add(ACCpragma.SEQ);
            } else {
                enumSet.add(aCCpragma);
            }
        } else {
            enumSet.addAll(set);
        }
        for (ACCpragma aCCpragma3 : enumSet) {
            if (this._info.hasClause(aCCpragma3)) continue;
            this._info.addClause(aCCpragma3);
        }
    }

    private Set<ACCpragma> getFullParallelism() {
        return EnumSet.copyOf(this.parallelismList);
    }

    private Set<ACCpragma> getInnerParallelism() {
        EnumSet<ACCpragma> enumSet = EnumSet.noneOf(ACCpragma.class);
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(this._pb.getBody());
        ((BlockIterator)topdownBlockIterator2).init();
        while (!((BlockIterator)topdownBlockIterator2).end()) {
            AccDirective accDirective;
            AccInformation accInformation;
            Block block = topdownBlockIterator2.getBlock();
            if (block.Opcode() == Xcode.ACC_PRAGMA && (accInformation = (accDirective = (AccDirective)block.getProp("_ACC_DIRECTIVE")).getInfo()).getPragma() == ACCpragma.LOOP) {
                enumSet.addAll(AccLoop.getParallelismSet(accInformation));
            }
            ((BlockIterator)topdownBlockIterator2).next();
        }
        if (enumSet.size() > 1 && enumSet.contains((Object)ACCpragma.AUTO)) {
            enumSet.remove((Object)ACCpragma.AUTO);
        }
        return enumSet;
    }

    private static Set<ACCpragma> getParallelismSet(AccInformation accInformation) {
        EnumSet<ACCpragma> enumSet = EnumSet.noneOf(ACCpragma.class);
        if (accInformation.hasClause(ACCpragma.GANG)) {
            enumSet.add(ACCpragma.GANG);
        }
        if (accInformation.hasClause(ACCpragma.WORKER)) {
            enumSet.add(ACCpragma.WORKER);
        }
        if (accInformation.hasClause(ACCpragma.VECTOR)) {
            enumSet.add(ACCpragma.VECTOR);
        }
        if (accInformation.hasClause(ACCpragma.SEQ)) {
            enumSet.add(ACCpragma.SEQ);
        }
        if (enumSet.isEmpty()) {
            enumSet.add(ACCpragma.AUTO);
        }
        return enumSet;
    }

    private Set<ACCpragma> getOuterParallelism() {
        return AccLoop.getOuterParallelism(this._pb);
    }

    static Set<ACCpragma> getOuterParallelism(Block block) {
        EnumSet<ACCpragma> enumSet = EnumSet.noneOf(ACCpragma.class);
        for (Block block2 = block.getParentBlock(); block2 != null; block2 = block2.getParentBlock()) {
            if (block2.Opcode() != Xcode.ACC_PRAGMA) continue;
            AccDirective accDirective = (AccDirective)block2.getProp("_ACC_DIRECTIVE");
            AccInformation accInformation = accDirective.getInfo();
            if (!accInformation.getPragma().isLoop()) {
                if (!accInformation.getPragma().isCompute()) continue;
                break;
            }
            enumSet.addAll(AccLoop.getParallelismSet(accInformation));
        }
        return enumSet;
    }

    private ACCpragma getTargetParallelism() {
        Set<ACCpragma> set = this.getOuterParallelism();
        EnumSet<ACCpragma> enumSet = EnumSet.of(ACCpragma.GANG, ACCpragma.WORKER, ACCpragma.VECTOR);
        enumSet.removeAll(set);
        return this.getCoarsestParallelism(enumSet);
    }

    private ACCpragma getCoarsestParallelism(Set<ACCpragma> set) {
        if (set.contains((Object)ACCpragma.AUTO)) {
            return ACCpragma.AUTO;
        }
        for (ACCpragma aCCpragma : this.parallelismList) {
            if (!set.contains((Object)aCCpragma)) continue;
            return aCCpragma;
        }
        return ACCpragma.SEQ;
    }

    private void fixInputParallelism(Set<ACCpragma> set) {
        ACCpragma aCCpragma;
        if (set.size() < 2) {
            return;
        }
        ACCpragma aCCpragma2 = this.getCoarsestParallelism(set);
        LinkedList<ACCpragma> linkedList = new LinkedList<ACCpragma>(this.parallelismList);
        Collections.reverse(linkedList);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext() && !set.contains((Object)(aCCpragma = (ACCpragma)((Object)iterator.next())))) {
        }
        while (iterator.hasNext() && (aCCpragma = (ACCpragma)((Object)iterator.next())) != aCCpragma2) {
            set.add(aCCpragma);
        }
    }

    static CforBlock findOutermostTightlyNestedForBlock(Block block) {
        if (block.Opcode() == Xcode.FOR_STATEMENT) {
            return (CforBlock)block;
        }
        if (block.Opcode() == Xcode.COMPOUND_STATEMENT) {
            BlockList blockList = block.getBody();
            XobjList xobjList = blockList.getIdentList();
            if (blockList.isSingle()) {
                return AccLoop.findOutermostTightlyNestedForBlock(blockList.getHead());
            }
        }
        return null;
    }

    private XobjList checkCollapsedLoop(Block block, int n) throws ACCexception {
        CforBlock cforBlock = AccLoop.findOutermostTightlyNestedForBlock(block);
        if (block == null) {
            throw new ACCexception("lack of nested loops");
        }
        if (cforBlock == null) {
            throw new ACCexception("loop is not found");
        }
        if (!cforBlock.isCanonical()) {
            cforBlock.Canonicalize();
            if (!cforBlock.isCanonical()) {
                throw new ACCexception("loop is non-canonical");
            }
        }
        Xobject xobject = cforBlock.getInductionVar();
        Ident ident = cforBlock.findVarIdent(xobject.getName());
        if (n < 2) {
            return Xcons.List(ident);
        }
        BlockList blockList = cforBlock.getBody();
        if (!blockList.isSingle()) {
            throw new ACCexception("non tightly nested loop");
        }
        if (blockList.getIdentList() != null && !blockList.getIdentList().isEmpty()) {
            throw new ACCexception("no var declaration is allowed between nested loops");
        }
        XobjList xobjList = this.checkCollapsedLoop(blockList.getHead(), n - 1);
        xobjList.cons(ident);
        return xobjList;
    }

    @Override
    boolean isAcceptableClause(ACCpragma aCCpragma) {
        switch (aCCpragma) {
            case GANG: 
            case WORKER: 
            case VECTOR: 
            case COLLAPSE: 
            case SEQ: 
            case INDEPENDENT: 
            case PRIVATE: {
                return true;
            }
        }
        return aCCpragma.isReduction();
    }
}

