/*
 * Decompiled with CFR 0.152.
 */
package exc.openacc;

import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockIterator;
import exc.block.BlockList;
import exc.block.PragmaBlock;
import exc.block.topdownBlockIterator;
import exc.object.Ident;
import exc.object.StorageClass;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.openacc.ACCexception;
import exc.openacc.ACCglobalDecl;
import exc.openacc.ACCpragma;
import exc.openacc.AccData;
import exc.openacc.AccDirective;
import exc.openacc.AccInformation;
import exc.openacc.AccKernel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class AccKernels
extends AccData {
    private final List<Block> _kernelBlocks = new ArrayList<Block>();
    private final List<AccKernel> _accKernelList = new ArrayList<AccKernel>();

    AccKernels(ACCglobalDecl aCCglobalDecl, AccInformation accInformation, PragmaBlock pragmaBlock) {
        super(aCCglobalDecl, accInformation, pragmaBlock);
        List<List<Block>> list = this.divideBlocksBetweenKernels(this._pb);
        for (List<Block> list2 : list) {
            AccKernel accKernel = new AccKernel(this._decl, this._pb, this._info, list2);
            this._accKernelList.add(accKernel);
        }
    }

    @Override
    void analyze() throws ACCexception {
        Object object;
        if (this.isDisabled()) {
            return;
        }
        this.completeParallelism();
        for (AccKernel linkedHashSet2 : this._accKernelList) {
            linkedHashSet2.analyze();
        }
        Set<Ident> set = this.collectReadOnlyOuterIdSet(this._accKernelList);
        for (AccKernel accKernel : this._accKernelList) {
            accKernel.setReadOnlyOuterIdSet(set);
        }
        LinkedHashSet<Ident> linkedHashSet = new LinkedHashSet<Ident>();
        for (AccKernel accKernel : this._accKernelList) {
            object = accKernel.getOuterIdList();
            linkedHashSet.addAll((Collection<Ident>)object);
        }
        for (Ident ident : linkedHashSet) {
            object = ident.getSym();
            if (this._info.isDeclared((String)object)) continue;
            this._info.addVar(ACCpragma.PRESENT_OR_COPY, Xcons.Symbol(Xcode.VAR, (String)object));
        }
        super.analyze();
    }

    void completeParallelism() throws ACCexception {
        topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(this._pb.getBody());
        ((BlockIterator)topdownBlockIterator2).init();
        while (!((BlockIterator)topdownBlockIterator2).end()) {
            Block block = topdownBlockIterator2.getBlock();
            if (block.Opcode() == Xcode.ACC_PRAGMA) {
                AccDirective accDirective = (AccDirective)block.getProp("_ACC_DIRECTIVE");
                accDirective.analyze();
            }
            ((BlockIterator)topdownBlockIterator2).next();
        }
    }

    @Override
    void generate() throws ACCexception {
        if (this.isDisabled()) {
            return;
        }
        super.generate();
        for (AccKernel accKernel : this._accKernelList) {
            Block block = accKernel.makeLaunchFuncCallBlock();
            this._kernelBlocks.add(block);
        }
    }

    @Override
    void rewrite() throws ACCexception {
        boolean bl;
        Block block22;
        Object object222;
        if (this.isDisabled()) {
            this._pb.replace(Bcons.COMPOUND(this._pb.getBody()));
            return;
        }
        BlockList blockList = Bcons.emptyBody();
        for (Object object222 : this.initBlockList) {
            blockList.add((Block)object222);
        }
        for (Object object222 : this.copyinBlockList) {
            blockList.add((Block)object222);
        }
        BlockList blockList2 = Bcons.emptyBody();
        for (Block block22 : this.copyoutBlockList) {
            blockList2.add(block22);
        }
        for (Block block22 : this.finalizeBlockList) {
            blockList2.add(block22);
        }
        object222 = Bcons.COMPOUND(blockList);
        block22 = Bcons.COMPOUND(blockList2);
        BlockList blockList3 = Bcons.emptyBody();
        for (Block object3 : this._kernelBlocks) {
            blockList3.add(object3);
        }
        Block block3 = Bcons.COMPOUND(blockList3);
        BlockList blockList4 = Bcons.emptyBody();
        for (Xobject bl2 : this.idList) {
            blockList4.addIdent((Ident)bl2);
        }
        Xobject xobject = this._info.getIntExpr(ACCpragma.IF);
        boolean bl3 = bl = xobject == null || xobject.isIntConstant() && !xobject.isZeroConstant();
        if (bl) {
            blockList4.add((Block)object222);
            blockList4.add(block3);
            blockList4.add(block22);
        } else {
            Ident ident = blockList4.declLocalIdent("_ACC_DATA_IF_COND", Xtype.charType, StorageClass.AUTO, xobject);
            blockList4.add(Bcons.IF(ident.Ref(), (Block)object222, null));
            blockList4.add(Bcons.IF(ident.Ref(), block3, Bcons.COMPOUND(this._pb.getBody())));
            blockList4.add(Bcons.IF(ident.Ref(), block22, null));
        }
        this._pb.replace(Bcons.COMPOUND(blockList4));
    }

    private List<List<Block>> divideBlocksBetweenKernels(PragmaBlock pragmaBlock) {
        ArrayList<List<Block>> arrayList = new ArrayList<List<Block>>();
        if (!this._pb.getBody().isSingle()) {
            for (Block block = pragmaBlock.getBody().getHead(); block != null; block = block.getNext()) {
                ArrayList<Block> arrayList2 = new ArrayList<Block>();
                arrayList2.add(block);
                arrayList.add(arrayList2);
            }
        } else {
            ArrayList<PragmaBlock> arrayList3 = new ArrayList<PragmaBlock>();
            arrayList3.add(pragmaBlock);
            arrayList.add(arrayList3);
        }
        return arrayList;
    }

    private Set<Ident> collectReadOnlyOuterIdSet(List<AccKernel> list) {
        if (list.size() == 1) {
            return list.get(0).getReadOnlyOuterIdSet();
        }
        LinkedHashSet<Ident> linkedHashSet = new LinkedHashSet<Ident>();
        for (AccKernel accKernel : list) {
            linkedHashSet.addAll(accKernel.getOuterIdSet());
        }
        for (AccKernel accKernel : list) {
            LinkedHashSet<Ident> linkedHashSet2 = new LinkedHashSet<Ident>(accKernel.getOuterIdSet());
            linkedHashSet2.removeAll(accKernel.getReadOnlyOuterIdSet());
            linkedHashSet.removeAll(linkedHashSet2);
        }
        return linkedHashSet;
    }

    @Override
    boolean isAcceptableClause(ACCpragma aCCpragma) {
        switch (aCCpragma) {
            case IF: 
            case ASYNC: {
                return true;
            }
        }
        return aCCpragma.isDataClause();
    }
}

