/*
 * Decompiled with CFR 0.152.
 */
package exc.openacc;

import exc.block.BasicBlockExprIterator;
import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockIterator;
import exc.block.BlockList;
import exc.block.CforBlock;
import exc.block.CondBlock;
import exc.block.FunctionBlock;
import exc.block.PragmaBlock;
import exc.block.topdownBlockIterator;
import exc.object.ArrayType;
import exc.object.FunctionType;
import exc.object.Ident;
import exc.object.PropObject;
import exc.object.StorageClass;
import exc.object.VarScope;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjConst;
import exc.object.XobjInt;
import exc.object.XobjList;
import exc.object.XobjString;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectDefEnv;
import exc.object.XobjectFile;
import exc.object.XobjectIterator;
import exc.object.Xtype;
import exc.object.topdownXobjectIterator;
import exc.openacc.ACC;
import exc.openacc.ACCexception;
import exc.openacc.ACCglobalDecl;
import exc.openacc.ACCpragma;
import exc.openacc.ACCutil;
import exc.openacc.ACCvar;
import exc.openacc.AccAtomic;
import exc.openacc.AccDirective;
import exc.openacc.AccInformation;
import exc.openacc.AccLoop;
import exc.openacc.AccManager;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AccKernel {
    private static final String ACC_CALC_IDX_FUNC = "_ACC_calc_idx";
    private static final String ACC_INIT_ITER_FUNC_PREFIX = "_ACC_init_iter_";
    private static final String ACC_MPOOL_ALLOC_FUNCNAME = "_ACC_mpool_alloc";
    private static final String ACC_MPOOL_FREE_FUNCNAME = "_ACC_mpool_free";
    private final ACCglobalDecl _decl;
    private final PragmaBlock _pb;
    private final AccInformation _kernelInfo;
    private final AccManager gpuManager;
    private static final String ACC_FUNC_PREFIX = "_ACC_kernel_";
    private static final String ACC_REDUCTION_VAR_PREFIX = "_ACC_reduction_";
    private static final String ACC_CACHE_VAR_PREFIX = "_ACC_cache_";
    private static final String ACC_REDUCTION_TMP_VAR = "_ACC_GPU_RED_TMP";
    private static final String ACC_REDUCTION_CNT_VAR = "_ACC_GPU_RED_CNT";
    public static final String ACC_GPU_DEVICE_FUNC_SUFFIX = "_DEVICE";
    private static final String ACC_CL_KERNEL_LAUNCHER_NAME = "_ACC_launch";
    private final Xobject _accThreadIndex = Xcons.Symbol(Xcode.VAR, Xtype.intType, "_ACC_thread_x_id");
    private final Xobject _accBlockIndex = Xcons.Symbol(Xcode.VAR, Xtype.intType, "_ACC_block_x_id");
    private final Xobject _accSyncThreads = ACCutil.getMacroFuncId("_ACC_sync_threads", Xtype.voidType).Call();
    private final Xobject _accSyncGangs = ACCutil.getMacroFuncId("_ACC_sync_gangs", Xtype.voidType).Call();
    private final Xobject _accAsyncSync = Xcons.Symbol(Xcode.VAR, Xtype.intType, "ACC_ASYNC_SYNC");
    private final Xobject _accFlush = ACCutil.getMacroFuncId("_ACC_flush", Xtype.voidType).Call();
    private final List<Block> _kernelBlocks;
    private List<Ident> _outerIdList;
    private Set<Ident> _readOnlyOuterIdSet;
    private final ArrayDeque<Loop> loopStack = new ArrayDeque();
    private final SharedMemory sharedMemory = new SharedMemory();
    private final ReductionManager reductionManager = new ReductionManager();
    private final Set<Ident> _useMemPoolOuterIdSet = new LinkedHashSet<Ident>();
    private final List<XobjList> allocList = new ArrayList<XobjList>();
    private List<ACCvar> _outerVarList;
    private boolean hasGangSync = false;

    public AccKernel(ACCglobalDecl aCCglobalDecl, PragmaBlock pragmaBlock, AccInformation accInformation, List<Block> list) {
        this._decl = aCCglobalDecl;
        this._pb = pragmaBlock;
        this._kernelInfo = accInformation;
        this._kernelBlocks = list;
        this.gpuManager = new AccManager(this._kernelInfo, this._pb);
    }

    private XobjList getFuncInfo(Block block) {
        for (Block block2 = block; block2 != null; block2 = block2.getParentBlock()) {
            if (block2.Opcode() != Xcode.FUNCTION_DEFINITION) continue;
            FunctionBlock functionBlock = (FunctionBlock)block2;
            String string = functionBlock.getName();
            XobjList xobjList = functionBlock.getBody().getIdentList();
            return Xcons.List(Xcons.String(string), xobjList);
        }
        ACC.fatal("cant't get func info");
        return null;
    }

    private void collectOuterVar() {
        this._outerVarList = new ArrayList<ACCvar>();
        for (Ident ident : this._outerIdList) {
            ACCvar aCCvar = this._kernelInfo.findACCvar(ident.getSym());
            if (aCCvar == null) {
                ACC.fatal(ident.getName() + " not found");
                continue;
            }
            this._outerVarList.add(aCCvar);
        }
    }

    public Block makeLaunchFuncCallBlock() {
        List<Block> list = this._kernelBlocks;
        String string = this.getFuncInfo(this._pb).getArg(0).getString();
        int n = list.get(0).getLineNo().lineNo();
        String string2 = ACC_FUNC_PREFIX + string + "_L" + n;
        String string3 = "";
        switch (ACC.platform) {
            case CUDA: {
                string3 = string2;
                break;
            }
            case OpenCL: {
                string3 = ACC_CL_KERNEL_LAUNCHER_NAME;
            }
        }
        this.collectOuterVar();
        String string4 = string2 + ACC_GPU_DEVICE_FUNC_SUFFIX;
        XobjectDef xobjectDef = this.makeDeviceKernelDef(string4, this._outerIdList, list);
        XobjectFile xobjectFile = this._decl.getEnvDevice();
        xobjectFile.add(xobjectDef);
        return this.makeLaunchFuncBlock(string3, xobjectDef);
    }

    private Block makeKernelLaunchBlock(String string, String string2, XobjList xobjList, Ident ident, Xobject xobject) {
        Xobject xobject22;
        BlockList blockList = Bcons.emptyBody();
        XobjList xobjList2 = Xcons.List();
        XobjList xobjList3 = Xcons.List();
        for (Xobject xobject22 : xobjList) {
            if (xobject22.Opcode() != Xcode.CAST_EXPR) {
                xobjList2.add(Xcons.AddrOf(xobject22));
            } else {
                xobjList2.add(Xcons.AddrOfVar(xobject22.getArg(0)));
            }
            if (xobject22.Type().isPointer()) {
                xobjList3.add(Xcons.SizeOf(Xtype.voidPtrType));
                continue;
            }
            xobjList3.add(Xcons.SizeOf(xobject22.Type()));
        }
        Ident ident2 = blockList.declLocalIdent("_ACC_argsizes", Xtype.Array((Xtype)Xtype.unsignedlonglongType, null), StorageClass.AUTO, xobjList3);
        xobject22 = blockList.declLocalIdent("_ACC_args", Xtype.Array(Xtype.voidPtrType, null), StorageClass.AUTO, xobjList2);
        Ident ident3 = ACCutil.getMacroFuncId(string, Xtype.voidType);
        int n = this._decl.declKernel(string2);
        Ident ident4 = this._decl.getProgramId();
        int n2 = xobjList.Nargs();
        XobjList xobjList4 = Xcons.List(ident4.Ref(), Xcons.IntConstant(n), ident.Ref(), xobject, Xcons.IntConstant(n2), ident2.Ref(), ((Ident)xobject22).Ref());
        blockList.add(ident3.Call(xobjList4));
        return Bcons.COMPOUND(blockList);
    }

    private Block makeKernelLaunchBlockCUDA(Ident ident, XobjList xobjList, XobjList xobjList2, Xobject xobject) {
        Xobject xobject2 = ident.Call(xobjList);
        xobject2.setProp("OEPNACC_GPU_FUNC_CONF_PROP", xobjList2);
        xobject2.setProp("OEPNACC_GPU_FUNC_CONF_ASYNC_PROP", Xcons.List(xobject));
        if (this.sharedMemory.isUsed()) {
            Xobject xobject3 = this.sharedMemory.getMaxSize();
            xobject2.setProp("OEPNACC_GPU_FUNC_CONF_SHAREDMEMORY_PROP", xobject3);
        }
        return Bcons.Statement(xobject2);
    }

    private Xobject makeLaunchFuncArg(ACCvar aCCvar) {
        if (aCCvar.isArray()) {
            Ident ident = aCCvar.getDevicePtr();
            Xobject xobject = ident.Ref();
            Xtype xtype = aCCvar.getId().Type();
            if (!xtype.equals(ident.Type())) {
                return Xcons.Cast(xtype, xobject);
            }
            return xobject;
        }
        Ident ident = aCCvar.getId();
        if (this._useMemPoolOuterIdSet.contains(ident)) {
            return ident.getAddr();
        }
        if (!aCCvar.isArray() && aCCvar.isFirstprivate()) {
            return ident.Ref();
        }
        Ident ident2 = aCCvar.getDevicePtr();
        Xobject xobject = ident2.Ref();
        Xtype xtype = aCCvar.getElementType();
        if (!xtype.equals(ident2.Type())) {
            return Xcons.Cast(Xtype.Pointer(xtype), xobject);
        }
        return xobject;
    }

    private Xobject getAsyncExpr() {
        if (!this._kernelInfo.hasClause(ACCpragma.ASYNC)) {
            return Xcons.IntConstant(-1);
        }
        Xobject xobject = this._kernelInfo.getIntExpr(ACCpragma.ASYNC);
        if (xobject != null) {
            return xobject;
        }
        return Xcons.IntConstant(-2);
    }

    private Ident findInnerBlockIdent(Block block, BlockList blockList, String string) {
        for (BlockList blockList2 = blockList; blockList2 != null; blockList2 = blockList2.getParentList()) {
            Ident ident = blockList2.findLocalIdent(string);
            if (ident != null) {
                return ident;
            }
            if (blockList2 == block.getParent()) break;
        }
        return null;
    }

    private XobjectDef makeDeviceKernelDef(String string, List<Ident> list, List<Block> list2) {
        Object object;
        Object object22;
        DeviceKernelBuildInfo deviceKernelBuildInfo = new DeviceKernelBuildInfo();
        for (Ident object42 : list) {
            if (ACC.device.getUseReadOnlyDataCache() && this._readOnlyOuterIdSet.contains(object42) && (object42.Type().isArray() || object42.Type().isPointer())) {
                object22 = this.makeConstRestrictVoidType();
                Ident ident = Ident.Param("_ACC_cosnt_" + object42.getName(), (Xtype)object22);
                object = Xtype.Pointer(object42.Type().getRef());
                Ident ident2 = Ident.Local(object42.getName(), (Xtype)object);
                Xobject xobject = Xcons.Set(ident2.Ref(), Xcons.Cast((Xtype)object, ident.Ref()));
                deviceKernelBuildInfo.addParamId(ident);
                deviceKernelBuildInfo.addLocalId(ident2);
                deviceKernelBuildInfo.addInitBlock(Bcons.Statement(xobject));
                continue;
            }
            deviceKernelBuildInfo.addParamId(this.makeParamId_new(object42));
        }
        Block block = this.makeCoreBlock(list2, deviceKernelBuildInfo);
        if (this._kernelInfo.getPragma() == ACCpragma.PARALLEL) {
            List<ACCvar> list3 = this._kernelInfo.getACCvarList();
            for (ACCvar aCCvar : list3) {
                if (!aCCvar.isPrivate()) continue;
                object = Ident.Local(aCCvar.getName(), aCCvar.getId().Type());
                ((PropObject)object).setProp("OPENACC_GPU_SHARED", true);
                deviceKernelBuildInfo.addLocalId((Ident)object);
            }
        }
        if (this.sharedMemory.isUsed()) {
            deviceKernelBuildInfo.addLocalId(this.sharedMemory.externSmId);
            deviceKernelBuildInfo.addLocalId(this.sharedMemory.smOffsetId);
        }
        for (Object object22 : this.reductionManager.getBlockReductionLocalIds()) {
            deviceKernelBuildInfo.addLocalId((Ident)object22);
        }
        if (this.reductionManager.hasUsingTmpReduction()) {
            for (Object object22 : this.reductionManager.getBlockReductionParamIds()) {
                deviceKernelBuildInfo.addParamId((Ident)object22);
            }
            this.allocList.add(Xcons.List(this.reductionManager.tempPtr, Xcons.IntConstant(0), this.reductionManager.totalElementSize));
        }
        if (this.sharedMemory.isUsed()) {
            deviceKernelBuildInfo.addInitBlock(this.sharedMemory.makeInitFunc());
        }
        deviceKernelBuildInfo.addInitBlock(this.reductionManager.makeLocalVarInitFuncs());
        deviceKernelBuildInfo.addFinalizeBlock(this.reductionManager.makeReduceAndFinalizeFuncs());
        BlockList blockList = Bcons.emptyBody(deviceKernelBuildInfo.getLocalIdList(), null);
        for (Block block2 : deviceKernelBuildInfo.getInitBlockList()) {
            blockList.add(block2);
        }
        blockList.add(block);
        for (Block block3 : deviceKernelBuildInfo.getFinalizeBlockList()) {
            blockList.add(block3);
        }
        object22 = deviceKernelBuildInfo.getParamIdList();
        Block block4 = Bcons.COMPOUND(blockList);
        this.rewriteReferenceType(block4, (XobjList)object22);
        object = this._decl.getEnvDevice().declGlobalIdent(string, Xtype.Function(Xtype.voidType));
        ((FunctionType)((Xobject)object).Type()).setFuncParamIdList((Xobject)object22);
        return XobjectDef.Func((Xobject)object, (Xobject)object22, null, block4.toXobject());
    }

    private Xtype makeConstRestrictVoidType() {
        Xtype xtype = Xtype.voidType.copy();
        xtype.setIsConst(true);
        Xtype xtype2 = Xtype.Pointer(xtype);
        xtype2.setIsRestrict(true);
        return xtype2;
    }

    void rewriteReferenceType(Block block, XobjList xobjList) {
        BasicBlockExprIterator basicBlockExprIterator = new BasicBlockExprIterator(block);
        basicBlockExprIterator.init();
        while (!basicBlockExprIterator.end()) {
            Xobject xobject = basicBlockExprIterator.getExpr();
            topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobject);
            topdownXobjectIterator2.init();
            while (!topdownXobjectIterator2.end()) {
                Xobject xobject2 = topdownXobjectIterator2.getXobject();
                switch (xobject2.Opcode()) {
                    case VAR: {
                        Xobject xobject3;
                        Object object = xobject2.getName();
                        if (((String)object).startsWith("_ACC_") || basicBlockExprIterator.getBasicBlock().getParent().findVarIdent((String)object) != null || (xobject3 = ACCutil.getIdent(xobjList, (String)object)) == null || xobject2.Type().equals(xobject3.Type())) break;
                        if (xobject3.Type().equals(Xtype.Pointer(xobject2.Type()))) {
                            Xobject xobject4 = Xcons.PointerRef(((Ident)xobject3).Ref());
                            topdownXobjectIterator2.setXobject(xobject4);
                            break;
                        }
                        ACC.fatal("type mismatch");
                        break;
                    }
                    case VAR_ADDR: {
                        Xobject xobject3;
                        Object object = ACCutil.getIdent(xobjList, xobject2.getName());
                        if (object == null || xobject2.Type().equals(Xtype.Pointer(((Xobject)object).Type()))) break;
                        if (xobject2.Type().equals(((Xobject)object).Type())) {
                            xobject3 = ((Ident)object).Ref();
                            topdownXobjectIterator2.setXobject(xobject3);
                            break;
                        }
                        ACC.fatal("type mismatch");
                        break;
                    }
                }
                topdownXobjectIterator2.next();
            }
            basicBlockExprIterator.next();
        }
    }

    private Block makeCoreBlock(Block block, DeviceKernelBuildInfo deviceKernelBuildInfo) {
        Set<ACCpragma> set = AccLoop.getOuterParallelism(block);
        switch (block.Opcode()) {
            case FOR_STATEMENT: {
                return this.makeCoreBlockForStatement((CforBlock)block, deviceKernelBuildInfo);
            }
            case COMPOUND_STATEMENT: {
                return this.makeCoreBlock(block.getBody(), deviceKernelBuildInfo);
            }
            case ACC_PRAGMA: {
                Object object;
                Object object2 = (PragmaBlock)block;
                Object object3 = ACCpragma.valueOf(((PragmaBlock)object2).getPragma());
                if (object3 == ACCpragma.ATOMIC) {
                    object = (AccAtomic)block.getProp("_ACC_DIRECTIVE");
                    try {
                        return ((AccAtomic)object).makeAtomicBlock();
                    }
                    catch (ACCexception aCCexception) {
                        aCCexception.printStackTrace();
                        ACC.fatal("failed at atomic");
                    }
                } else {
                    return this.makeCoreBlock(block.getBody(), deviceKernelBuildInfo);
                }
            }
            case IF_STATEMENT: {
                Object object;
                Object object3;
                Object object2;
                if (!set.contains((Object)ACCpragma.VECTOR)) {
                    object2 = Bcons.emptyBody();
                    object3 = ((BlockList)object2).declLocalIdent("_ACC_if_cond", Xtype.charType);
                    ((PropObject)object3).setProp("OPENACC_GPU_SHARED", true);
                    object = Bcons.IF(Xcons.binaryOp(Xcode.LOG_EQ_EXPR, this._accThreadIndex, Xcons.IntConstant(0)), Bcons.Statement(Xcons.Set(((Ident)object3).Ref(), block.getCondBBlock().toXobject())), null);
                    Block block2 = Bcons.IF(((Ident)object3).Ref(), this.makeCoreBlock(block.getThenBody(), deviceKernelBuildInfo), this.makeCoreBlock(block.getElseBody(), deviceKernelBuildInfo));
                    ((BlockList)object2).add((Block)object);
                    ((BlockList)object2).add(this._accSyncThreads);
                    ((BlockList)object2).add(block2);
                    return Bcons.COMPOUND((BlockList)object2);
                }
                return block.copy();
            }
        }
        Block block3 = block.copy();
        if (set.isEmpty() || !set.contains((Object)ACCpragma.GANG)) {
            block3 = Bcons.IF(Xcons.binaryOp(Xcode.LOG_EQ_EXPR, this._accBlockIndex, Xcons.IntConstant(0)), block3, Bcons.emptyBlock());
        } else if (!set.contains((Object)ACCpragma.VECTOR)) {
            Block block4 = Bcons.IF(Xcons.binaryOp(Xcode.LOG_EQ_EXPR, this._accThreadIndex, Xcons.IntConstant(0)), block3, null);
            Block block5 = Bcons.Statement(this._accSyncThreads);
            block3 = Bcons.COMPOUND(Bcons.blockList(block4, block5));
        }
        return block3;
    }

    private Block makeCoreBlock(BlockList blockList, DeviceKernelBuildInfo deviceKernelBuildInfo) {
        Iterator<Xobject> iterator;
        Object object3;
        if (blockList == null) {
            return Bcons.emptyBlock();
        }
        XobjList xobjList = blockList.getIdentList();
        Xobject xobject = blockList.getDecls();
        Block block = null;
        Set<ACCpragma> set = AccLoop.getOuterParallelism(blockList.getParent());
        if (!set.contains((Object)ACCpragma.VECTOR)) {
            Object object2;
            if (xobjList != null) {
                for (Object object3 : xobjList) {
                    object2 = (Ident)object3;
                    ((PropObject)object2).setProp("OPENACC_GPU_SHARED", true);
                }
            }
            iterator = blockList.getHead();
            if (!(xobject == null || ((Block)((Object)iterator)).Opcode() == Xcode.FOR_STATEMENT && ((CforBlock)((Object)iterator)).getInitBBlock().isEmpty())) {
                Object object4;
                PropObject propObject;
                object3 = new ArrayList();
                for (Object object5 : (XobjList)xobject) {
                    propObject = (XobjList)object5;
                    if (((XobjList)propObject).right() == null) continue;
                    object4 = ((XobjList)propObject).left().getString();
                    Ident ident = ACCutil.getIdent(xobjList, (String)object4);
                    Xobject xobject2 = ((XobjList)propObject).right();
                    ((XobjList)propObject).setRight(null);
                    object3.add(Bcons.Statement(Xcons.Set(ident.Ref(), xobject2)));
                }
                if (!object3.isEmpty()) {
                    Object object5;
                    object2 = Bcons.emptyBody();
                    object5 = object3.iterator();
                    while (object5.hasNext()) {
                        propObject = (Block)object5.next();
                        ((BlockList)object2).add((Block)propObject);
                    }
                    object5 = Xcons.Symbol(Xcode.VAR, Xtype.intType, "_ACC_thread_x_id");
                    propObject = Bcons.IF(Xcons.binaryOp(Xcode.LOG_EQ_EXPR, (Xobject)object5, Xcons.IntConstant(0)), Bcons.COMPOUND((BlockList)object2), null);
                    object4 = Bcons.Statement(this._accSyncThreads);
                    block = Bcons.COMPOUND(Bcons.blockList(new Block[]{propObject, object4}));
                }
            }
        }
        iterator = Bcons.emptyBody(xobjList, xobject);
        ((BlockList)((Object)iterator)).add(block);
        for (object3 = blockList.getHead(); object3 != null; object3 = ((Block)object3).getNext()) {
            ((BlockList)((Object)iterator)).add(this.makeCoreBlock((Block)object3, deviceKernelBuildInfo));
        }
        return Bcons.COMPOUND(iterator);
    }

    private Block makeCoreBlock(List<Block> list, DeviceKernelBuildInfo deviceKernelBuildInfo) {
        BlockList blockList = Bcons.emptyBody();
        for (Block block : list) {
            blockList.add(this.makeCoreBlock(block, deviceKernelBuildInfo));
        }
        return this.makeBlock(blockList);
    }

    private Block makeBlock(BlockList blockList) {
        if (blockList == null || blockList.isEmpty()) {
            return Bcons.emptyBlock();
        }
        if (blockList.isSingle()) {
            Xobject xobject = blockList.getDecls();
            XobjList xobjList = blockList.getIdentList();
            if ((xobject == null || xobject.isEmpty()) && (xobjList == null || xobjList.isEmpty())) {
                return blockList.getHead();
            }
        }
        return Bcons.COMPOUND(blockList);
    }

    private Block makeCoreBlockForStatement(CforBlock cforBlock, DeviceKernelBuildInfo deviceKernelBuildInfo) {
        Object object;
        Block block4;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        PropObject propObject2;
        Object object6;
        Xobject xobject;
        Xobject xobject2;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Object object11;
        Xobject xobject3;
        Xobject xobject4;
        Object object12;
        BlockListBuilder blockListBuilder = new BlockListBuilder();
        AccInformation accInformation = null;
        Block block2 = cforBlock.getParentBlock();
        if (block2.Opcode() == Xcode.ACC_PRAGMA) {
            object12 = (AccDirective)block2.getProp("_ACC_DIRECTIVE");
            accInformation = ((AccDirective)object12).getInfo();
        }
        if (accInformation == null || !accInformation.getPragma().isLoop()) {
            return this.makeSequentialLoop(cforBlock, deviceKernelBuildInfo, null);
        }
        object12 = accInformation.getIntExpr(ACCpragma.NUM_GANGS);
        if (object12 == null) {
            object12 = accInformation.getIntExpr(ACCpragma.GANG);
        }
        if ((xobject4 = accInformation.getIntExpr(ACCpragma.VECT_LEN)) == null) {
            xobject4 = accInformation.getIntExpr(ACCpragma.VECTOR);
        }
        if (object12 != null) {
            this.gpuManager.setNumGangs((Xobject)object12);
        }
        if (xobject4 != null) {
            this.gpuManager.setVectorLength(xobject4);
        }
        String string = this.gpuManager.getMethodName(cforBlock);
        EnumSet<ACCpragma> enumSet = this.gpuManager.getMethodType(cforBlock);
        if (enumSet.isEmpty() || enumSet.contains((Object)ACCpragma.SEQ)) {
            return this.makeSequentialLoop(cforBlock, deviceKernelBuildInfo, accInformation);
        }
        ArrayList arrayList = new ArrayList();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        ArrayList<Reduction> arrayList2 = cforBlock;
        linkedList.add(cforBlock);
        linkedHashSet.add(cforBlock.getInductionVar().getSym());
        Xobject object132 = accInformation.getIntExpr(ACCpragma.COLLAPSE);
        int n = object132 != null ? object132.getInt() : 1;
        for (int xobjList2 = 1; xobjList2 < n; ++xobjList2) {
            arrayList2 = AccLoop.findOutermostTightlyNestedForBlock(((CondBlock)((Object)arrayList2)).getBody().getHead());
            linkedList.add(arrayList2);
            linkedHashSet.add(((CforBlock)((Object)arrayList2)).getInductionVar().getSym());
        }
        for (ACCvar aCCvar : accInformation.getACCvarList()) {
            if (!aCCvar.isPrivate() || linkedHashSet.contains(aCCvar.getSymbol())) continue;
            Xtype xtype = aCCvar.getId().Type();
            if (enumSet.contains((Object)ACCpragma.VECTOR)) {
                blockListBuilder.declLocalIdent(aCCvar.getName(), xtype);
                continue;
            }
            if (!enumSet.contains((Object)ACCpragma.GANG)) continue;
            if (xtype.isArray()) {
                Ident ident = Ident.Local(aCCvar.getName(), Xtype.Pointer(xtype.getRef()));
                xobject3 = Ident.Param("_ACC_prv_" + aCCvar.getName(), Xtype.voidPtrType);
                deviceKernelBuildInfo.addLocalId(ident);
                deviceKernelBuildInfo.addParamId((Ident)xobject3);
                try {
                    object11 = Xcons.binaryOp(Xcode.MUL_EXPR, ACCutil.getArrayElmtCountObj(xtype), Xcons.SizeOf(xtype.getArrayElementType()));
                    object10 = Xcons.List(new Xobject[]{Xcons.Cast(Xtype.Pointer(Xtype.voidPtrType), ident.getAddr()), ((Ident)xobject3).Ref(), object11});
                    Block block3 = ACCutil.createFuncCallBlock("_ACC_init_private", (XobjList)object10);
                    deviceKernelBuildInfo.addInitBlock(block3);
                    this.allocList.add(Xcons.List(new Xobject[]{aCCvar.getId(), Xcons.IntConstant(0), object11}));
                }
                catch (Exception exception) {
                    ACC.fatal(exception.getMessage());
                }
                continue;
            }
            Ident ident = Ident.Local(aCCvar.getName(), xtype);
            ident.setProp("OPENACC_GPU_SHARED", true);
            deviceKernelBuildInfo.addLocalId(ident);
        }
        arrayList2 = new ArrayList<Reduction>();
        for (ACCvar aCCvar : accInformation.getACCvarList()) {
            if (!aCCvar.isReduction()) continue;
            Reduction reduction = this.reductionManager.addReduction(aCCvar, enumSet);
            if (this._readOnlyOuterIdSet.contains(aCCvar.getId())) {
                ACC.fatal("reduction variable is read-only, isn't it?");
            }
            if (!reduction.onlyKernelLast()) {
                blockListBuilder.addIdent(reduction.getLocalReductionVarId());
                blockListBuilder.addInitBlock(reduction.makeInitReductionVarFuncCall());
                blockListBuilder.addFinalizeBlock(reduction.makeInKernelReductionFuncCall(null));
            }
            arrayList2.add(reduction);
        }
        ArrayList<Block> arrayList3 = new ArrayList<Block>();
        XobjList xobjList = Xcons.IDList();
        XobjList xobjList2 = Xcons.IDList();
        xobject3 = Xcons.IDList();
        object11 = false;
        for (CforBlock cforBlock2 : linkedList) {
            object9 = cforBlock2.getInductionVar().getName();
            object8 = cforBlock2.findVarIdent((String)object9).Type();
            object7 = Xtype.unsignedType;
            switch (((Xtype)object8).getBasicType()) {
                case 7: 
                case 8: {
                    object7 = Xtype.unsignedType;
                    break;
                }
                case 11: 
                case 12: {
                    object7 = Xtype.unsignedlonglongType;
                    object11 = true;
                }
            }
            xobject2 = cforBlock2.getLowerBound().copy();
            xobject = cforBlock2.getUpperBound().copy();
            object6 = cforBlock2.getStep().copy();
            propObject2 = Ident.Local("_ACC_idx_" + (String)object9, (Xtype)object7);
            object5 = Ident.Local((String)object9, (Xtype)object8);
            object4 = blockListBuilder.declLocalIdent("_ACC_niter_" + (String)object9, (Xtype)object7);
            object3 = ACCutil.createFuncCallBlock("_ACC_calc_niter", Xcons.List(new Xobject[]{((Ident)object4).getAddr(), xobject2, xobject, object6}));
            object2 = ACCutil.createFuncCallBlock(ACC_CALC_IDX_FUNC, Xcons.List(new Xobject[]{propObject2.Ref(), ((Ident)object5).getAddr(), xobject2, xobject, object6}));
            blockListBuilder.addInitBlock((Block)object3);
            xobjList.add((Xobject)propObject2);
            xobjList2.add((Xobject)object4);
            ((XobjList)xobject3).add((Xobject)object5);
            arrayList3.add((Block)object2);
        }
        object10 = ((Boolean)object11).booleanValue() ? Xtype.unsignedlonglongType : Xtype.unsignedType;
        Ident ident = blockListBuilder.declLocalIdent("_ACC_" + string + "_idx", (Xtype)object10);
        object9 = blockListBuilder.declLocalIdent("_ACC_" + string + "_init", (Xtype)object10);
        object8 = blockListBuilder.declLocalIdent("_ACC_" + string + "_cond", (Xtype)object10);
        object7 = blockListBuilder.declLocalIdent("_ACC_" + string + "_step", (Xtype)object10);
        xobject2 = Xcons.List(((Ident)object9).getAddr(), ((Ident)object8).getAddr(), ((Ident)object7).getAddr());
        xobject = Xcons.IntConstant(1);
        for (PropObject propObject2 : xobjList2) {
            object5 = propObject2;
            xobject = Xcons.binaryOp(Xcode.MUL_EXPR, xobject, ((Ident)object5).Ref());
        }
        ((XobjList)xobject2).add(xobject);
        object6 = ACCutil.createFuncCallBlock(ACC_INIT_ITER_FUNC_PREFIX + string, (XobjList)xobject2);
        blockListBuilder.addInitBlock((Block)object6);
        propObject2 = this.makeCalcIdxFuncCall(xobjList, xobjList2, ident);
        object5 = new Loop(cforBlock, ident, (Ident)object9, (Ident)object8, (Ident)object7);
        this.loopStack.push((Loop)object5);
        object4 = new ArrayList();
        object3 = Bcons.emptyBody();
        ((BlockList)object3).add((Block)propObject2);
        for (Block block4 : arrayList3) {
            ((BlockList)object3).add(block4);
        }
        for (Block block4 : arrayList) {
            ((BlockList)object3).add(block4);
        }
        object2 = ((CforBlock)linkedList.getLast()).getBody();
        block4 = this.makeCoreBlock((BlockList)object2, deviceKernelBuildInfo);
        Object object13 = object4.iterator();
        while (object13.hasNext()) {
            object = (Cache)object13.next();
            ((Cache)object).rewrite(block4);
        }
        ((BlockList)object3).add(block4);
        if (!arrayList.isEmpty()) {
            ((BlockList)object3).add(this._accSyncThreads);
        }
        object13 = (XobjList)((XobjList)xobject3).copy();
        ((XobjList)object13).mergeList(xobjList);
        ((BlockList)object3).setIdentList((Xobject)object13);
        object13 = Bcons.FOR(Xcons.Set(ident.Ref(), ((Ident)object9).Ref()), Xcons.binaryOp(Xcode.LOG_LT_EXPR, ident.Ref(), ((Ident)object8).Ref()), Xcons.asgOp(Xcode.ASG_PLUS_EXPR, ident.Ref(), ((Ident)object7).Ref()), Bcons.COMPOUND((BlockList)object3));
        for (Reduction reduction : arrayList2) {
            reduction.rewrite((Block)object13);
        }
        blockListBuilder.add((Block)object13);
        if (enumSet.contains((Object)ACCpragma.VECTOR)) {
            blockListBuilder.addFinalizeBlock(Bcons.Statement(this._accSyncThreads));
        }
        if (this.hasGangSync && enumSet.contains((Object)ACCpragma.GANG)) {
            blockListBuilder.addFinalizeBlock(Bcons.Statement(this._accSyncGangs));
        }
        this.loopStack.pop();
        object = blockListBuilder.build();
        return Bcons.COMPOUND((BlockList)object);
    }

    private void transLoopCache(CforBlock cforBlock, BlockListBuilder blockListBuilder, List<Block> list, List<Cache> list2) {
        AccDirective accDirective;
        AccInformation accInformation;
        Block block = cforBlock.getBody().getHead();
        if (block != null && block.Opcode() == Xcode.ACC_PRAGMA && (accInformation = (accDirective = (AccDirective)block.getProp("_ACC_DIRECTIVE")).getInfo()).getPragma() == ACCpragma.CACHE) {
            for (ACCvar aCCvar : accInformation.getACCvarList()) {
                if (!aCCvar.isCache()) continue;
                Ident ident = aCCvar.getId();
                XobjList xobjList = aCCvar.getSubscripts();
                Cache cache = this.sharedMemory.alloc(ident, xobjList);
                blockListBuilder.addInitBlock(cache.initFunc);
                list.add(cache.loadBlock);
                blockListBuilder.addIdent(cache.cacheId);
                blockListBuilder.addIdent(cache.cacheSizeArrayId);
                blockListBuilder.addIdent(cache.cacheOffsetArrayId);
                list2.add(cache);
            }
        }
    }

    private Block makeSequentialLoop(CforBlock cforBlock, DeviceKernelBuildInfo deviceKernelBuildInfo, AccInformation accInformation) {
        Ident ident;
        PropObject propObject;
        this.loopStack.push(new Loop(cforBlock));
        BlockList blockList = Bcons.blockList(this.makeCoreBlock(cforBlock.getBody(), deviceKernelBuildInfo));
        this.loopStack.pop();
        cforBlock.Canonicalize();
        Ident ident2 = null;
        Xobject xobject = null;
        if (cforBlock.isCanonical()) {
            xobject = cforBlock.getInductionVar();
            ident2 = cforBlock.findVarIdent(xobject.getName());
        } else {
            ACC.fatal("non canonical loop");
        }
        Set<ACCpragma> set = AccLoop.getOuterParallelism(cforBlock);
        BlockList blockList2 = Bcons.emptyBody();
        if (accInformation != null) {
            for (ACCvar object2 : accInformation.getACCvarList()) {
                if (!object2.isPrivate() || object2.getId() == ident2) continue;
                blockList2.declLocalIdent(object2.getName(), object2.getId().Type());
            }
        }
        if (set.contains((Object)ACCpragma.VECTOR)) {
            blockList2.add(Bcons.FOR(cforBlock.getInitBBlock(), cforBlock.getCondBBlock(), cforBlock.getIterBBlock(), blockList));
            return Bcons.COMPOUND(blockList2);
        }
        XobjList xobjList = blockList2.getIdentList();
        if (xobjList != null) {
            Iterator<Xobject> iterator = xobjList.iterator();
            while (iterator.hasNext()) {
                propObject = iterator.next();
                ident = (Ident)propObject;
                ident.setProp("OPENACC_GPU_SHARED", true);
            }
        }
        Ident ident3 = blockList2.declLocalIdent("_ACC_loop_iter_" + xobject.getName(), xobject.Type());
        propObject = Bcons.FOR(Xcons.Set(ident3.Ref(), cforBlock.getLowerBound()), Xcons.binaryOp(Xcode.LOG_LT_EXPR, ident3.Ref(), cforBlock.getUpperBound()), Xcons.asgOp(Xcode.ASG_PLUS_EXPR, ident3.Ref(), cforBlock.getStep()), Bcons.COMPOUND(blockList));
        blockList2.add((Block)propObject);
        Ident ident4 = ident = accInformation != null ? accInformation.findACCvar(xobject.getName()) : null;
        if (ident == null || !((ACCvar)((Object)ident)).isPrivate() && !((ACCvar)((Object)ident)).isFirstprivate()) {
            Block block = Bcons.IF(Xcons.binaryOp(Xcode.LOG_EQ_EXPR, this._accThreadIndex, Xcons.IntConstant(0)), Bcons.Statement(Xcons.Set(xobject, ident3.Ref())), null);
            blockList2.add(block);
        }
        blockList2.add(this._accSyncThreads);
        this.replaceVar((Block)propObject, ident2, ident3);
        return Bcons.COMPOUND(blockList2);
    }

    private Block makeCalcIdxFuncCall(XobjList xobjList, XobjList xobjList2, Ident ident) {
        Ident ident2;
        Xobject xobject = ident.Ref();
        Ident ident3 = ACCutil.getMacroFuncId("_ACC_calc_vidx", Xtype.intType);
        for (int i = xobjList.Nargs() - 1; i > 0; --i) {
            ident2 = (Ident)xobjList.getArg(i);
            Ident ident4 = (Ident)xobjList2.getArg(i);
            Block block = Bcons.Statement(ident3.Call(Xcons.List(ident2.getAddr(), ident4.Ref(), xobject)));
            xobject = block.toXobject();
        }
        ident2 = (Ident)xobjList.getArg(0);
        xobject = Xcons.Set(ident2.Ref(), xobject);
        return Bcons.Statement(xobject);
    }

    /*
     * WARNING - void declaration
     */
    private Block makeLaunchFuncBlock(String string, XobjectDef xobjectDef) {
        PropObject propObject;
        Block block;
        Block block2;
        PropObject propObject2;
        Object object;
        Object object2;
        PropObject propObject3;
        Object object4;
        PropObject propObject4;
        XobjList xobjList = Xcons.List();
        BlockListBuilder blockListBuilder = new BlockListBuilder();
        XobjList xobjList2 = this.gpuManager.getBlockThreadSize();
        Ident ident = ACCutil.getMacroFuncId("_ACC_adjust_num_gangs", Xtype.voidType);
        Xobject xobject = ident.Call(Xcons.List(xobjList2.getArg(0), Xcons.IntConstant(ACC.device.getMaxNumGangs())));
        Ident ident2 = blockListBuilder.declLocalIdent("_ACC_num_gangs", Xtype.intType, xobject);
        Ident ident3 = blockListBuilder.declLocalIdent("_ACC_num_workers", Xtype.intType, xobjList2.getArg(1));
        Ident ident4 = blockListBuilder.declLocalIdent("_ACC_vec_len", Xtype.intType, xobjList2.getArg(2));
        Ident ident5 = Ident.Local("_ACC_mpool", Xtype.voidPtrType);
        Ident ident6 = Ident.Local("_ACC_mpool_pos", Xtype.longlongType);
        if (!this.allocList.isEmpty() || !this._useMemPoolOuterIdSet.isEmpty()) {
            propObject4 = Bcons.Statement(Xcons.Set(ident6.Ref(), Xcons.LongLongConstant(0L, 0L)));
            object4 = this._kernelInfo.getIntExpr(ACCpragma.ASYNC);
            if (object4 == null) {
                object4 = Xcons.IntConstant(-1);
            }
            Block block3 = ACCutil.createFuncCallBlock("_ACC_mpool_get_async", Xcons.List(new Xobject[]{ident5.getAddr(), object4}));
            blockListBuilder.addIdent(ident5);
            blockListBuilder.addIdent(ident6);
            blockListBuilder.addInitBlock((Block)propObject4);
            blockListBuilder.addInitBlock(block3);
        }
        propObject4 = Xcons.List();
        int n = 0;
        for (ACCvar object32 : this._outerVarList) {
            propObject3 = object32.getId();
            if (this._useMemPoolOuterIdSet.contains(propObject3)) {
                object2 = blockListBuilder.declLocalIdent("_ACC_dev_" + ((Ident)propObject3).getName(), Xtype.voidPtrType);
                object = object32.getSize();
                propObject2 = ACCutil.createFuncCallBlock(ACC_MPOOL_ALLOC_FUNCNAME, Xcons.List(new Xobject[]{((Ident)object2).getAddr(), object, ident5.Ref(), ident6.getAddr()}));
                block2 = ACCutil.createFuncCallBlock(ACC_MPOOL_FREE_FUNCNAME, Xcons.List(((Ident)object2).Ref(), ident5.Ref()));
                block = ACCutil.createFuncCallBlock("_ACC_copy_async", Xcons.List(new Xobject[]{((Ident)propObject3).getAddr(), ((Ident)object2).Ref(), object, Xcons.IntConstant(400), this.getAsyncExpr()}));
                Block block3 = ACCutil.createFuncCallBlock("_ACC_copy_async", Xcons.List(new Xobject[]{((Ident)propObject3).getAddr(), ((Ident)object2).Ref(), object, Xcons.IntConstant(401), this.getAsyncExpr()}));
                blockListBuilder.addInitBlock((Block)propObject2);
                blockListBuilder.addInitBlock(block);
                blockListBuilder.addFinalizeBlock(block3);
                blockListBuilder.addFinalizeBlock(block2);
                propObject = Xcons.Cast(Xtype.Pointer(((Xobject)propObject3).Type()), ((Ident)object2).Ref());
            } else {
                propObject = this.makeLaunchFuncArg(object32);
            }
            xobjList.add((Xobject)propObject);
            object2 = this.reductionManager.findReduction((Ident)propObject3);
            if (object2 == null || !((Reduction)object2).needsExternalReduction()) continue;
            ((XobjList)propObject4).add((Xobject)propObject);
            ++n;
        }
        for (XobjList xobjList3 : this.allocList) {
            propObject3 = (Ident)xobjList3.getArg(0);
            propObject = xobjList3.getArg(1);
            object2 = xobjList3.getArg(2);
            object = blockListBuilder.declLocalIdent("_ACC_gpu_device_" + ((Ident)propObject3).getName(), Xtype.voidPtrType);
            xobjList.add(((Ident)object).Ref());
            if (((Ident)propObject3).getName().equals(ACC_REDUCTION_TMP_VAR)) {
                ((XobjList)propObject4).add(((Ident)object).Ref());
            }
            propObject2 = Xcons.binaryOp(Xcode.PLUS_EXPR, propObject, Xcons.binaryOp(Xcode.MUL_EXPR, (Xobject)object2, ident2.Ref()));
            block2 = ACCutil.createFuncCallBlock(ACC_MPOOL_ALLOC_FUNCNAME, Xcons.List(new Xobject[]{((Ident)object).getAddr(), propObject2, ident5.Ref(), ident6.getAddr()}));
            block = ACCutil.createFuncCallBlock(ACC_MPOOL_FREE_FUNCNAME, Xcons.List(((Ident)object).Ref(), ident5.Ref()));
            blockListBuilder.addInitBlock(block2);
            blockListBuilder.addFinalizeBlock(block);
        }
        if (this.reductionManager.hasUsingTmpReduction()) {
            void var16_22;
            object4 = blockListBuilder.declLocalIdent("_ACC_gpu_block_count", Xtype.Pointer(Xtype.unsignedType));
            xobjList.add(((Ident)object4).Ref());
            propObject3 = this._kernelInfo.getIntExpr(ACCpragma.ASYNC);
            if (propObject3 != null) {
                Block block4 = ACCutil.createFuncCallBlock("_ACC_gpu_get_block_count_async", Xcons.List(new Xobject[]{((Ident)object4).getAddr(), propObject3}));
            } else {
                Block block5 = ACCutil.createFuncCallBlock("_ACC_gpu_get_block_count", Xcons.List(((Ident)object4).getAddr()));
            }
            blockListBuilder.addInitBlock((Block)var16_22);
        }
        object4 = Bcons.emptyBlock();
        switch (ACC.platform) {
            case CUDA: {
                object4 = this.makeLauncherFuncCallCUDA(string, xobjectDef, xobjList, ident2.Ref(), ident3.Ref(), ident4.Ref(), this.getAsyncExpr());
                break;
            }
            case OpenCL: {
                String string2 = xobjectDef.getName();
                propObject3 = blockListBuilder.declLocalIdent("_ACC_conf", Xtype.Array((Xtype)Xtype.intType, null), Xcons.List(ident2.Ref(), ident3.Ref(), ident4.Ref()));
                object4 = this.makeKernelLaunchBlock(ACC_CL_KERNEL_LAUNCHER_NAME, string2, xobjList, (Ident)propObject3, this.getAsyncExpr());
                break;
            }
            default: {
                ACC.fatal("not supported platform");
            }
        }
        blockListBuilder.add((Block)object4);
        if (this.reductionManager.hasUsingTmpReduction()) {
            XobjectDef xobjectDef2 = this.reductionManager.makeReductionKernelDef(string + "_red" + ACC_GPU_DEVICE_FUNC_SUFFIX);
            propObject3 = this._decl.getEnvDevice();
            ((XobjectDefEnv)propObject3).add(xobjectDef2);
            ((XobjList)propObject4).add(ident2.Ref());
            propObject = Bcons.emptyBlock();
            switch (ACC.platform) {
                case CUDA: {
                    propObject = this.makeLauncherFuncCallCUDA(string + "_red", xobjectDef2, (XobjList)propObject4, Xcons.IntConstant(n), Xcons.IntConstant(1), Xcons.IntConstant(ACC.device.getDefaultVectorLength()), this.getAsyncExpr());
                    break;
                }
                case OpenCL: {
                    object2 = Bcons.emptyBody();
                    object = xobjectDef2.getName();
                    propObject2 = ((BlockList)object2).declLocalIdent("_ACC_conf", Xtype.Array((Xtype)Xtype.intType, null), StorageClass.AUTO, Xcons.List(ident2.Ref(), ident3.Ref(), ident4.Ref()));
                    ((BlockList)object2).add(this.makeKernelLaunchBlock(ACC_CL_KERNEL_LAUNCHER_NAME, (String)object, (XobjList)propObject4, (Ident)propObject2, this.getAsyncExpr()));
                    propObject = Bcons.COMPOUND((BlockList)object2);
                    break;
                }
                default: {
                    ACC.fatal("not supported platform");
                }
            }
            object2 = Bcons.IF(Xcons.binaryOp(Xcode.LOG_GT_EXPR, ident2.Ref(), Xcons.IntConstant(1)), (Block)propObject, null);
            blockListBuilder.add((Block)object2);
        }
        if (!this._kernelInfo.hasClause(ACCpragma.ASYNC)) {
            blockListBuilder.addFinalizeBlock(ACCutil.createFuncCallBlock("_ACC_gpu_wait", Xcons.List(Xcons.IntConstant(-1))));
        }
        BlockList blockList = blockListBuilder.build();
        return Bcons.COMPOUND(blockList);
    }

    private Block makeLauncherFuncCallCUDA(String string, XobjectDef xobjectDef, XobjList xobjList, Xobject xobject, Xobject xobject2, Xobject xobject3, Xobject xobject4) {
        XobjInt xobjInt = Xcons.IntConstant(1);
        BlockList blockList = Bcons.emptyBody();
        XobjList xobjList2 = Xcons.List(xobject, xobjInt, xobjInt, xobject3, xobject2, xobjInt);
        Ident ident = blockList.declLocalIdent("_ACC_conf", Xtype.Array((Xtype)Xtype.intType, 6L), StorageClass.AUTO, xobjList2);
        XobjectDef xobjectDef2 = this.makeLauncherFuncDefCUDA(string, xobjectDef, xobjList);
        XobjectFile xobjectFile = this._decl.getEnvDevice();
        xobjectFile.add(xobjectDef2);
        Ident ident2 = this._decl.declExternIdent(xobjectDef2.getName(), xobjectDef2.getFuncType());
        XobjList xobjList3 = Xcons.List();
        for (Xobject xobject5 : xobjList) {
            if (xobject5.Opcode() == Xcode.CAST_EXPR && xobject5.Type().isArray()) {
                xobject5 = Xcons.Cast(Xtype.Pointer(xobject5.Type().getRef()), xobject5.getArg(0));
            }
            xobjList3.add(xobject5);
        }
        xobjList3.add(ident.Ref());
        xobjList3.add(xobject4);
        blockList.add(Bcons.Statement(ident2.Call(xobjList3)));
        return Bcons.COMPOUND(blockList);
    }

    private XobjectDef makeLauncherFuncDefCUDA(String string, XobjectDef xobjectDef, XobjList xobjList) {
        Xobject xobject;
        Object object;
        Xobject xobject22;
        XobjList xobjList2 = Xcons.IDList();
        BlockList blockList = Bcons.emptyBody();
        XobjList xobjList3 = Xcons.List();
        for (Xobject xobject22 : xobjList) {
            object = xobject22.Type();
            if (xobject22.Opcode() == Xcode.CAST_EXPR) {
                xobject22 = xobject22.getArg(0);
            }
            String string2 = xobject22.getName();
            xobject = Ident.Param(string2, (Xtype)object);
            xobjList2.add(xobject);
            xobjList3.add(xobject22);
        }
        int n = 6;
        xobject22 = Ident.Param("_ACC_conf", Xtype.Array((Xtype)Xtype.intType, n));
        xobjList2.add(xobject22);
        object = Xcons.List();
        for (int i = 0; i < n; ++i) {
            ((XobjList)object).add(Xcons.arrayRef(Xtype.intType, ((Ident)xobject22).getAddr(), Xcons.List(Xcons.IntConstant(i))));
        }
        Ident ident = Ident.Param("_ACC_async_num", Xtype.intType);
        xobjList2.add(ident);
        xobject = ident.Ref();
        Ident ident2 = (Ident)xobjectDef.getNameObj();
        Block block = this.makeKernelLaunchBlockCUDA(ident2, xobjList3, (XobjList)object, xobject);
        blockList.add(block);
        Ident ident3 = this._decl.getEnvDevice().declGlobalIdent(string, Xtype.Function(Xtype.voidType));
        ((FunctionType)ident3.Type()).setFuncParamIdList(xobjList2);
        return XobjectDef.Func(ident3, xobjList2, null, blockList.toXobject());
    }

    private Ident makeParamId_new(Ident ident) {
        String string = ident.getName();
        switch (ident.Type().getKind()) {
            case 6: 
            case 7: {
                return Ident.Local(string, ident.Type());
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                ACCvar aCCvar = this._kernelInfo.findACCvar(ACCpragma.FIRSTPRIVATE, string);
                if (aCCvar == null || this._useMemPoolOuterIdSet.contains(ident) || aCCvar.getDevicePtr() != null) {
                    return Ident.Local(string, Xtype.Pointer(ident.Type()));
                }
                return Ident.Local(string, ident.Type());
            }
        }
        ACC.fatal("unknown type");
        return null;
    }

    public void analyze() {
        this.gpuManager.analyze();
        LinkedHashSet<Ident> linkedHashSet = new LinkedHashSet<Ident>();
        OuterIdCollector outerIdCollector = new OuterIdCollector();
        for (Block iterator : this._kernelBlocks) {
            linkedHashSet.addAll(outerIdCollector.collect(iterator));
        }
        this._readOnlyOuterIdSet = new LinkedHashSet<Ident>(linkedHashSet);
        AssignedIdCollector assignedIdCollector = new AssignedIdCollector();
        for (Block block : this._kernelBlocks) {
            this._readOnlyOuterIdSet.removeAll(assignedIdCollector.collect(block));
        }
        this._outerIdList = new ArrayList<Ident>(linkedHashSet);
        for (Ident ident : this._outerIdList) {
            ACCvar aCCvar;
            ACCvar aCCvar2 = this._kernelInfo.findACCvar(ident.getSym());
            if (aCCvar2 == null || !aCCvar2.isReduction() || (aCCvar = this.findParentVar(ident)) != null) continue;
            this._useMemPoolOuterIdSet.add(ident);
        }
    }

    ACCvar findParentVar(Ident ident) {
        if (this._pb != null) {
            for (Block block = this._pb.getParentBlock(); block != null; block = block.getParentBlock()) {
                AccInformation accInformation;
                ACCvar aCCvar;
                if (block.Opcode() != Xcode.ACC_PRAGMA || (aCCvar = (accInformation = ((AccDirective)block.getProp("_ACC_DIRECTIVE")).getInfo()).findACCvar(ident.getSym())) == null || aCCvar.getId() != ident) continue;
                return aCCvar;
            }
        }
        return null;
    }

    private boolean hasBody(Block block) {
        switch (block.Opcode()) {
            case FOR_STATEMENT: 
            case COMPOUND_STATEMENT: 
            case DO_STATEMENT: 
            case SWITCH_STATEMENT: 
            case WHILE_STATEMENT: {
                return true;
            }
        }
        return false;
    }

    private void replaceVar(Block block, Ident ident, Ident ident2) {
        Block block2;
        Object object;
        BasicBlockExprIterator basicBlockExprIterator = new BasicBlockExprIterator(block);
        basicBlockExprIterator.init();
        while (!basicBlockExprIterator.end()) {
            object = basicBlockExprIterator.getExpr();
            block2 = basicBlockExprIterator.getBasicBlock().getParent();
            this.replaceVar(block, ident, ident2, (Xobject)object, block2);
            basicBlockExprIterator.next();
        }
        object = new topdownBlockIterator(block);
        ((BlockIterator)object).init();
        while (!((BlockIterator)object).end()) {
            block2 = ((BlockIterator)object).getBlock();
            if (this.hasBody(block2)) {
                Xobject xobject = block2.getBody().getDecls();
                this.replaceVarInDecls(block, ident, ident2, block2, (XobjList)xobject);
            } else if (block2.Opcode() == Xcode.IF_STATEMENT) {
                this.replaceVarInDecls(block, ident, ident2, block2, (XobjList)block2.getThenBody().getDecls());
                this.replaceVarInDecls(block, ident, ident2, block2, (XobjList)block2.getElseBody().getDecls());
            }
            ((BlockIterator)object).next();
        }
    }

    private void replaceVarInDecls(Block block, Ident ident, Ident ident2, Block block2, XobjList xobjList) {
        if (xobjList == null) {
            return;
        }
        for (Xobject xobject : xobjList) {
            Xobject xobject2 = xobject.right();
            xobject.setRight(this.replaceVar(block, ident, ident2, xobject2, block2));
        }
    }

    private Xobject replaceVar(Block block, Ident ident, Ident ident2, Xobject xobject, Block block2) {
        topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobject);
        topdownXobjectIterator2.init();
        while (!topdownXobjectIterator2.end()) {
            Xobject xobject2 = topdownXobjectIterator2.getXobject();
            if (xobject2.Opcode() == Xcode.VAR) {
                Ident ident3;
                String string = xobject2.getName();
                if (ident.getName().equals(string) && (ident3 = this.findInnerBlockIdent(block, block2.getParent(), string)) == null) {
                    Xobject xobject3 = ident2.Ref();
                    if (xobject == xobject2) {
                        return xobject3;
                    }
                    topdownXobjectIterator2.setXobject(xobject3);
                }
            }
            topdownXobjectIterator2.next();
        }
        return xobject;
    }

    public void setReadOnlyOuterIdSet(Set<Ident> set) {
        this._readOnlyOuterIdSet = set;
    }

    public Set<Ident> getReadOnlyOuterIdSet() {
        return this._readOnlyOuterIdSet;
    }

    public Set<Ident> getOuterIdSet() {
        return new LinkedHashSet<Ident>(this._outerIdList);
    }

    public List<Ident> getOuterIdList() {
        return this._outerIdList;
    }

    private class BlockListBuilder {
        private final List<Block> initBlockList = new ArrayList<Block>();
        private final List<Block> finalizeBlockList = new ArrayList<Block>();
        private final List<Block> mainBlockList = new ArrayList<Block>();
        private final BlockList blockList = Bcons.emptyBody();

        private BlockListBuilder() {
        }

        public void addInitBlock(Block block) {
            this.initBlockList.add(block);
        }

        public void addFinalizeBlock(Block block) {
            this.finalizeBlockList.add(block);
        }

        public void add(Block block) {
            this.mainBlockList.add(block);
        }

        public Ident declLocalIdent(String string, Xtype xtype) {
            return this.blockList.declLocalIdent(string, xtype);
        }

        public Ident declLocalIdent(String string, Xtype xtype, Xobject xobject) {
            return this.blockList.declLocalIdent(string, xtype, StorageClass.AUTO, xobject);
        }

        public void addIdent(Ident ident) {
            this.blockList.addIdent(ident);
        }

        public BlockList build() {
            BlockList blockList = this.blockList.copy();
            for (Block block : this.initBlockList) {
                blockList.add(block);
            }
            for (Block block : this.mainBlockList) {
                blockList.add(block);
            }
            for (Block block : this.finalizeBlockList) {
                blockList.add(block);
            }
            return blockList;
        }
    }

    class Reduction {
        final EnumSet<ACCpragma> execMethodSet;
        final Ident localVarId;
        final Ident varId;
        final ACCvar var;

        Reduction(ACCvar aCCvar, EnumSet<ACCpragma> enumSet) {
            this.var = aCCvar;
            this.varId = aCCvar.getId();
            this.execMethodSet = EnumSet.copyOf(enumSet);
            String string = AccKernel.ACC_REDUCTION_VAR_PREFIX;
            if (enumSet.contains((Object)ACCpragma.GANG)) {
                string = string + "b";
            }
            if (enumSet.contains((Object)ACCpragma.VECTOR)) {
                string = string + "t";
            }
            string = string + "_";
            this.localVarId = Ident.Local(string + this.varId.getName(), this.varId.Type());
            if (enumSet.contains((Object)ACCpragma.GANG) && !enumSet.contains((Object)ACCpragma.VECTOR)) {
                this.localVarId.setProp("OPENACC_GPU_SHARED", true);
            }
        }

        public Block makeSingleBlockReductionFuncCall(Ident ident) {
            XobjList xobjList = Xcons.List(this.varId.getAddr(), ident.Ref(), Xcons.IntConstant(this.getReductionKindInt()));
            return ACCutil.createFuncCallBlock("_ACC_gpu_reduction_singleblock", xobjList);
        }

        public Block makeSingleBlockReductionFuncCall() {
            return this.makeSingleBlockReductionFuncCall(this.localVarId);
        }

        public void rewrite(Block block) {
            BasicBlockExprIterator basicBlockExprIterator = new BasicBlockExprIterator(block);
            basicBlockExprIterator.init();
            while (!basicBlockExprIterator.end()) {
                Xobject xobject = basicBlockExprIterator.getExpr();
                topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobject);
                topdownXobjectIterator2.init();
                while (!topdownXobjectIterator2.end()) {
                    Xobject xobject2 = topdownXobjectIterator2.getXobject();
                    switch (xobject2.Opcode()) {
                        case VAR: {
                            String string = xobject2.getName();
                            if (!string.equals(this.varId.getName())) break;
                            topdownXobjectIterator2.setXobject(this.localVarId.Ref());
                            break;
                        }
                        case VAR_ADDR: {
                            String string = xobject2.getName();
                            if (!string.equals(this.varId.getName())) break;
                            topdownXobjectIterator2.setXobject(this.localVarId.getAddr());
                        }
                    }
                    topdownXobjectIterator2.next();
                }
                basicBlockExprIterator.next();
            }
        }

        public boolean useThread() {
            return this.execMethodSet.contains((Object)ACCpragma.VECTOR);
        }

        public Ident getLocalReductionVarId() {
            return this.localVarId;
        }

        public Block makeInitReductionVarFuncCall(Ident ident) {
            String string = "_ACC_gpu_init_reduction_var";
            if (!this.execMethodSet.contains((Object)ACCpragma.VECTOR)) {
                string = string + "_single";
            }
            return ACCutil.createFuncCallBlock(string, Xcons.List(ident.getAddr(), Xcons.IntConstant(this.getReductionKindInt())));
        }

        public Block makeInitReductionVarFuncCall() {
            return this.makeInitReductionVarFuncCall(this.localVarId);
        }

        public Block makeBlockReductionFuncCall(Ident ident, Xobject xobject, Ident ident2) {
            XobjList xobjList = Xcons.List(this.varId.Ref(), Xcons.IntConstant(this.getReductionKindInt()), ident.Ref(), xobject);
            if (ident2 != null) {
                xobjList.add(ident2.Ref());
            }
            return ACCutil.createFuncCallBlock("_ACC_gpu_reduction_block", xobjList);
        }

        String makeExecString(EnumSet<ACCpragma> enumSet) {
            StringBuilder stringBuilder = new StringBuilder();
            if (enumSet.contains((Object)ACCpragma.GANG)) {
                stringBuilder.append('b');
            }
            if (enumSet.contains((Object)ACCpragma.VECTOR)) {
                stringBuilder.append('t');
            }
            return stringBuilder.toString();
        }

        public Block makeInKernelReductionFuncCall_CUDA(Ident ident) {
            Xobject xobject = null;
            EnumSet<ACCpragma> enumSet = EnumSet.copyOf(this.execMethodSet);
            Xobject xobject2 = xobject = ident != null ? ident.getAddr() : this.varId.getAddr();
            if (this.needsExternalReduction()) {
                enumSet.remove((Object)ACCpragma.GANG);
                if (ident == null) {
                    ACC.fatal("dstId must be specified");
                }
            }
            String string = "_ACC_gpu_reduction_" + this.makeExecString(enumSet);
            XobjList xobjList = Xcons.List(xobject, Xcons.IntConstant(this.getReductionKindInt()), this.localVarId.Ref());
            return ACCutil.createFuncCallBlock(string, xobjList);
        }

        public Block makeInKernelReductionFuncCall(Ident ident) {
            switch (ACC.platform) {
                case CUDA: 
                case OpenCL: {
                    return this.makeInKernelReductionFuncCall_CUDA(ident);
                }
            }
            return null;
        }

        public Block makeThreadReductionFuncCall(Ident ident) {
            XobjList xobjList = Xcons.List(ident.getAddr(), this.localVarId.Ref(), Xcons.IntConstant(this.getReductionKindInt()));
            return ACCutil.createFuncCallBlock("_ACC_gpu_reduction_thread", xobjList);
        }

        public Block makeTempWriteFuncCall(Ident ident, Xobject xobject) {
            return this.makeTempWriteFuncCall(this.localVarId, ident, xobject);
        }

        public Block makeTempWriteFuncCall(Ident ident, Ident ident2, Xobject xobject) {
            return ACCutil.createFuncCallBlock("_ACC_gpu_reduction_tmp", Xcons.List(ident.Ref(), ident2.Ref(), xobject));
        }

        private int getReductionKindInt() {
            ACCpragma aCCpragma = this.var.getReductionOperator();
            if (!aCCpragma.isReduction()) {
                ACC.fatal(aCCpragma.getName() + " is not reduction clause");
            }
            switch (aCCpragma) {
                case REDUCTION_PLUS: {
                    return 0;
                }
                case REDUCTION_MUL: {
                    return 1;
                }
                case REDUCTION_MAX: {
                    return 2;
                }
                case REDUCTION_MIN: {
                    return 3;
                }
                case REDUCTION_BITAND: {
                    return 4;
                }
                case REDUCTION_BITOR: {
                    return 5;
                }
                case REDUCTION_BITXOR: {
                    return 6;
                }
                case REDUCTION_LOGAND: {
                    return 7;
                }
                case REDUCTION_LOGOR: {
                    return 8;
                }
            }
            return -1;
        }

        public boolean useBlock() {
            return this.execMethodSet.contains((Object)ACCpragma.GANG);
        }

        public boolean existsAtomicOperation() {
            ACCpragma aCCpragma = this.var.getReductionOperator();
            switch (this.var.getId().Type().getBasicType()) {
                case 7: 
                case 13: {
                    return aCCpragma != ACCpragma.REDUCTION_MUL;
                }
            }
            return false;
        }

        public boolean onlyKernelLast() {
            return this.execMethodSet.contains((Object)ACCpragma.GANG);
        }

        public boolean needsExternalReduction() {
            return !this.existsAtomicOperation() && this.execMethodSet.contains((Object)ACCpragma.GANG);
        }
    }

    class ReductionManager {
        Ident counterPtr = null;
        Ident tempPtr = null;
        final List<Reduction> reductionList = new ArrayList<Reduction>();
        Xobject totalElementSize = Xcons.IntConstant(0);
        final Map<Reduction, Xobject> offsetMap = new HashMap<Reduction, Xobject>();
        Ident isLastVar = null;

        ReductionManager() {
            this.counterPtr = Ident.Param(AccKernel.ACC_REDUCTION_CNT_VAR, Xtype.Pointer(Xtype.unsignedType));
            this.tempPtr = Ident.Param(AccKernel.ACC_REDUCTION_TMP_VAR, Xtype.voidPtrType);
            this.isLastVar = Ident.Local("_ACC_GPU_IS_LAST_BLOCK", Xtype.intType);
            this.isLastVar.setProp("OPENACC_GPU_SHARED", true);
        }

        public XobjectDef makeReductionKernelDef(String string) {
            PropObject propObject;
            Object object;
            BlockList blockList = Bcons.emptyBody();
            XobjList xobjList = Xcons.IDList();
            XobjString xobjString = Xcons.Symbol(Xcode.VAR, Xtype.intType, "_ACC_block_x_id");
            Ident ident = Ident.Param("_ACC_GPU_RED_NUM", Xtype.intType);
            int n = 0;
            Iterator<Reduction> iterator = AccKernel.this.reductionManager.BlockReductionIterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!((Reduction)object).needsExternalReduction()) continue;
                PropObject propObject2 = ((Reduction)object).makeBlockReductionFuncCall(this.tempPtr, this.offsetMap.get(object), ident);
                propObject = Bcons.IF(Xcons.binaryOp(Xcode.LOG_EQ_EXPR, xobjString, Xcons.IntConstant(n)), (Block)propObject2, null);
                blockList.add((Block)propObject);
                ++n;
            }
            for (PropObject propObject2 : AccKernel.this._outerIdList) {
                propObject = (Ident)propObject2;
                Reduction reduction = AccKernel.this.reductionManager.findReduction((Ident)propObject);
                if (reduction == null || !reduction.needsExternalReduction()) continue;
                xobjList.add(AccKernel.this.makeParamId_new(propObject));
            }
            xobjList.add(this.tempPtr);
            xobjList.add(ident);
            object = AccKernel.this._decl.getEnvDevice().declGlobalIdent(string, Xtype.Function(Xtype.voidType));
            ((FunctionType)((Xobject)object).Type()).setFuncParamIdList(xobjList);
            return XobjectDef.Func((Xobject)object, xobjList, null, Bcons.COMPOUND(blockList).toXobject());
        }

        public XobjList getBlockReductionParamIds() {
            return Xcons.List(Xcode.ID_LIST, this.tempPtr, this.counterPtr);
        }

        public Block makeLocalVarInitFuncs() {
            BlockList blockList = Bcons.emptyBody();
            Iterator<Reduction> iterator = AccKernel.this.reductionManager.BlockReductionIterator();
            while (iterator.hasNext()) {
                Reduction reduction = iterator.next();
                if (!reduction.onlyKernelLast()) continue;
                blockList.add(reduction.makeInitReductionVarFuncCall());
            }
            if (blockList.isSingle()) {
                return blockList.getHead();
            }
            return Bcons.COMPOUND(blockList);
        }

        public XobjList getBlockReductionLocalIds() {
            XobjList xobjList = Xcons.IDList();
            Iterator<Reduction> iterator = AccKernel.this.reductionManager.BlockReductionIterator();
            while (iterator.hasNext()) {
                Reduction reduction = iterator.next();
                if (!reduction.onlyKernelLast()) continue;
                xobjList.add(reduction.getLocalReductionVarId());
            }
            return xobjList;
        }

        public Block makeReduceAndFinalizeFuncs() {
            Object object;
            BlockList blockList = Bcons.emptyBody();
            BlockList blockList2 = Bcons.emptyBody();
            BlockList blockList3 = Bcons.emptyBody();
            Iterator<Reduction> iterator = AccKernel.this.reductionManager.BlockReductionIterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (((Reduction)object).needsExternalReduction()) {
                    Ident ident = Ident.Local("_ACC_gpu_reduction_tmp_" + ((Reduction)object).var.getName(), ((Reduction)object).varId.Type());
                    if (((Reduction)object).useThread()) {
                        blockList.addIdent(ident);
                        blockList.add(((Reduction)object).makeInitReductionVarFuncCall(ident));
                        blockList.add(((Reduction)object).makeInKernelReductionFuncCall(ident));
                        blockList3.add(((Reduction)object).makeTempWriteFuncCall(ident, this.tempPtr, this.offsetMap.get(object)));
                        blockList2.add(((Reduction)object).makeSingleBlockReductionFuncCall(ident));
                        continue;
                    }
                    blockList3.add(((Reduction)object).makeTempWriteFuncCall(this.tempPtr, this.offsetMap.get(object)));
                    blockList2.add(((Reduction)object).makeSingleBlockReductionFuncCall());
                    continue;
                }
                if (!((Reduction)object).onlyKernelLast()) continue;
                blockList.add(((Reduction)object).makeInKernelReductionFuncCall(null));
            }
            if (!blockList2.isEmpty()) {
                object = Xcons.Symbol(Xcode.VAR, Xtype.unsignedType, "_ACC_grid_x_dim");
                blockList.add(Bcons.IF(Xcons.binaryOp(Xcode.LOG_EQ_EXPR, (Xobject)object, Xcons.IntConstant(1)), Bcons.COMPOUND(blockList2), Bcons.COMPOUND(blockList3)));
            }
            return Bcons.COMPOUND(blockList);
        }

        Reduction addReduction(ACCvar aCCvar, EnumSet<ACCpragma> enumSet) {
            Reduction reduction = new Reduction(aCCvar, enumSet);
            this.reductionList.add(reduction);
            if (!reduction.needsExternalReduction()) {
                return reduction;
            }
            this.offsetMap.put(reduction, this.totalElementSize);
            Xtype xtype = aCCvar.getId().Type();
            Xobject xobject = xtype.isPointer() ? Xcons.SizeOf(xtype.getRef()) : Xcons.SizeOf(xtype);
            this.totalElementSize = Xcons.binaryOp(Xcode.PLUS_EXPR, this.totalElementSize, xobject);
            return reduction;
        }

        Reduction findReduction(Ident ident) {
            for (Reduction reduction : this.reductionList) {
                if (reduction.varId != ident) continue;
                return reduction;
            }
            return null;
        }

        Iterator<Reduction> BlockReductionIterator() {
            return new BlockReductionIterator(this.reductionList);
        }

        boolean hasUsingTmpReduction() {
            return !this.offsetMap.isEmpty();
        }

        class BlockReductionIterator
        implements Iterator<Reduction> {
            final Iterator<Reduction> reductionIterator;
            Reduction re;

            public BlockReductionIterator(List<Reduction> list) {
                this.reductionIterator = list.iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.reductionIterator.hasNext()) {
                    this.re = this.reductionIterator.next();
                    if (!this.re.useBlock()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Reduction next() {
                return this.re;
            }

            @Override
            public void remove() {
            }
        }
    }

    class Cache {
        final XobjList localIds = Xcons.IDList();
        final Ident cacheSizeArrayId;
        final Ident cacheOffsetArrayId;
        final Xtype elementType;
        final Ident cacheId;
        final Ident varId;
        final XobjList subscripts;
        final int cacheDim;
        Xobject cacheTotalSize;
        final Block initFunc;
        final Block loadBlock;

        Cache(Ident ident, XobjList xobjList) {
            this.varId = ident;
            this.subscripts = xobjList;
            this.elementType = ident.Type().isArray() ? ident.Type().getArrayElementType() : ident.Type();
            Xtype xtype = ident.Type().isArray() ? Xtype.Pointer(this.elementType) : this.elementType;
            this.cacheId = Ident.Local(AccKernel.ACC_CACHE_VAR_PREFIX + ident.getName(), xtype);
            this.cacheDim = xobjList.Nargs();
            this.cacheSizeArrayId = Ident.Local("_ACC_cache_size_" + ident.getName(), Xtype.Array((Xtype)Xtype.intType, this.cacheDim));
            this.cacheSizeArrayId.setProp("OPENACC_GPU_SHARED", true);
            this.cacheOffsetArrayId = Ident.Local("_ACC_cache_offset_" + ident.getName(), Xtype.Array((Xtype)Xtype.intType, this.cacheDim));
            this.localIds.add(this.cacheOffsetArrayId);
            this.localIds.add(this.cacheSizeArrayId);
            this.initFunc = this.makeCacheInitializeFunc();
            this.loadBlock = this.makeCacheLoadBlock();
        }

        Block makeCacheInitializeFunc() {
            XobjList xobjList = Xcons.List(((AccKernel)AccKernel.this).sharedMemory.externSmId.Ref(), ((AccKernel)AccKernel.this).sharedMemory.smOffsetId.Ref(), this.cacheId.getAddr(), this.cacheSizeArrayId.getAddr());
            for (Xobject xobject : this.subscripts) {
                XobjList xobjList2 = this.getSimpleSubarray(xobject);
                Xobject xobject2 = xobjList2.getArg(0);
                Xobject xobject3 = xobjList2.getArg(2);
                Loop loop = null;
                for (Loop loop2 : AccKernel.this.loopStack) {
                    if (!loop2.forBlock.getInductionVar().getName().equals(xobject2.getName())) continue;
                    loop = loop2;
                    break;
                }
                if (loop == null) {
                    ACC.fatal(xobject2.getName() + " is not loop variable");
                }
                assert (loop != null);
                Xobject xobject4 = loop.forBlock.getStep();
                xobjList.mergeList(Xcons.List(xobject4, xobject3));
            }
            return ACCutil.createFuncCallBlock("_ACC_gpu_init_cache", xobjList);
        }

        Block makeCacheLoadBlock() {
            Object object;
            PropObject propObject;
            Xobject xobject;
            Xobject xobject2;
            Xobject xobject3;
            Xobject xobject4;
            Xobject xobject5;
            XobjList xobjList;
            PropObject propObject22;
            BlockList blockList = Bcons.emptyBody();
            XobjList xobjList2 = Xcons.IDList();
            Ident ident = Ident.Local("_ACC_cache_load_size_" + this.varId.getName(), Xtype.Array((Xtype)Xtype.intType, this.cacheDim));
            ident.setProp("OPENACC_GPU_SHARED", true);
            xobjList2.add(ident);
            int n = 0;
            Xobject xobject6 = Xcons.IntConstant(1);
            for (PropObject propObject22 : this.subscripts) {
                Object object2;
                PropObject propObject3;
                Object object32;
                xobjList = this.getSimpleSubarray((Xobject)propObject22);
                xobject5 = xobjList.getArg(0);
                Xobject xobject7 = xobjList.getArg(1);
                xobject4 = xobjList.getArg(2);
                xobject3 = Xcons.arrayRef(Xtype.intType, ident.getAddr(), Xcons.List(Xcons.IntConstant(n)));
                xobject2 = Xcons.arrayRef(Xtype.intType, this.cacheOffsetArrayId.getAddr(), Xcons.List(Xcons.IntConstant(n)));
                xobject = Xcons.List(Xcons.AddrOf(xobject3), Xcons.arrayRef(Xtype.intType, this.cacheSizeArrayId.getAddr(), Xcons.List(Xcons.IntConstant(n))));
                propObject = Xcons.List(Xcons.AddrOf(xobject2), xobject5, xobject7);
                object = null;
                for (Object object32 : AccKernel.this.loopStack) {
                    if (!((Loop)object32).forBlock.getInductionVar().getName().equals(xobject5.getName())) continue;
                    object = object32;
                    break;
                }
                if (object == null) {
                    ACC.fatal(xobject5.getName() + " is not loop variable");
                }
                assert (object != null);
                if (((Loop)object).isParallelized) {
                    object32 = ((Loop)object).abstIdx.Ref();
                    propObject3 = ((Loop)object).abstCond.Ref();
                    Xobject xobject8 = ((Loop)object).abstStep.Ref();
                    Xobject xobject9 = ((Loop)object).forBlock.getStep();
                    ((XobjList)xobject).mergeList(Xcons.List(new Xobject[]{object32, propObject3, xobject8, xobject9}));
                    String string = AccKernel.this.gpuManager.getMethodName(((Loop)object).forBlock);
                    XobjConst xobjConst = string.endsWith("thread_x") ? Xcons.Symbol(Xcode.VAR, Xtype.intType, "_ACC_GPU_DIM3_thread_x") : (string.endsWith("thread_y") ? Xcons.Symbol(Xcode.VAR, Xtype.intType, "_ACC_GPU_DIM3_thread_y") : (string.endsWith("thread_z") ? Xcons.Symbol(Xcode.VAR, Xtype.intType, "_ACC_GPU_DIM3_thread_z") : Xcons.IntConstant(1)));
                    object2 = Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.binaryOp(Xcode.MUL_EXPR, Xcons.binaryOp(Xcode.MINUS_EXPR, xobjConst, Xcons.IntConstant(1)), xobject9), xobject4);
                } else {
                    object32 = Xcons.IntConstant(0);
                    propObject3 = ((Loop)object).forBlock.getStep();
                    ((XobjList)xobject).mergeList(Xcons.List(new Xobject[]{object32, object32, object32, propObject3}));
                    object2 = xobject4;
                }
                object32 = ACCutil.createFuncCallBlock("_ACC_gpu_get_cache_load_size", (XobjList)xobject);
                propObject3 = ACCutil.createFuncCallBlock("_ACC_gpu_get_cache_offset", (XobjList)propObject);
                blockList.add((Block)object32);
                blockList.add((Block)propObject3);
                xobject6 = Xcons.binaryOp(Xcode.MUL_EXPR, xobject6, (Xobject)object2);
                ++n;
            }
            this.cacheTotalSize = Xcons.binaryOp(Xcode.MUL_EXPR, xobject6, Xcons.SizeOf(this.elementType));
            Object object4 = Bcons.emptyBlock();
            propObject22 = null;
            xobjList = Xcons.List();
            xobject5 = Xcons.List();
            for (int i = 0; i < this.cacheDim; ++i) {
                xobject4 = Ident.Local("_ACC_iter_idx" + i, Xtype.intType);
                xobjList2.add(xobject4);
                xobject2 = Xcons.arrayRef(Xtype.intType, ident.getAddr(), Xcons.List(Xcons.IntConstant(i)));
                if (i == this.cacheDim - 1) {
                    propObject = Ident.Local("_ACC_thread_x_id", Xtype.intType);
                    xobject3 = propObject.Ref();
                    object = Ident.Local("_ACC_block_size_x", Xtype.intType);
                    xobject = ((Ident)object).Ref();
                } else if (i == this.cacheDim - 2) {
                    propObject = Ident.Local("_ACC_thread_y_id", Xtype.intType);
                    xobject3 = propObject.Ref();
                    object = Ident.Local("_ACC_block_size_y", Xtype.intType);
                    xobject = ((Ident)object).Ref();
                } else if (i == this.cacheDim - 3) {
                    propObject = Ident.Local("_ACC_thread_z_id", Xtype.intType);
                    xobject3 = propObject.Ref();
                    object = Ident.Local("_ACC_block_size_z", Xtype.intType);
                    xobject = ((Ident)object).Ref();
                } else {
                    xobject3 = Xcons.IntConstant(0);
                    xobject = Xcons.IntConstant(1);
                }
                if (xobjList.isEmpty()) {
                    xobjList.add(((Ident)xobject4).Ref());
                } else {
                    propObject = xobjList.getArg(0);
                    propObject = Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.binaryOp(Xcode.MUL_EXPR, propObject, Xcons.arrayRef(Xtype.intType, this.cacheSizeArrayId.getAddr(), Xcons.List(Xcons.IntConstant(i)))), ((Ident)xobject4).Ref());
                    xobjList.setArg(0, (Xobject)propObject);
                }
                ((XobjList)xobject5).add(Xcons.binaryOp(Xcode.MINUS_EXPR, ((Ident)xobject4).Ref(), Xcons.arrayRef(Xtype.intType, this.cacheOffsetArrayId.getAddr(), Xcons.List(Xcons.IntConstant(i)))));
                if (propObject22 == null) {
                    propObject22 = Bcons.FORall(((Ident)xobject4).Ref(), xobject3, xobject2, xobject, Xcode.LOG_LT_EXPR, Bcons.blockList(new Block[]{object4}));
                    continue;
                }
                propObject = Bcons.emptyBlock();
                object = Bcons.FORall(((Ident)xobject4).Ref(), xobject3, xobject2, xobject, Xcode.LOG_LT_EXPR, Bcons.blockList(new Block[]{propObject}));
                ((Block)object4).replace((Block)object);
                object4 = propObject;
            }
            Xobject xobject10 = Xcons.Set(Xcons.arrayRef(this.elementType, this.cacheId.getAddr(), xobjList), Xcons.arrayRef(this.elementType, this.varId.getAddr(), (XobjList)xobject5));
            ((Block)object4).replace(Bcons.Statement(xobject10));
            blockList.add((Block)propObject22);
            blockList.add(ACCutil.createFuncCallBlock("_ACC_gpu_barrier", Xcons.List()));
            blockList.setIdentList(xobjList2);
            blockList.setIdentList(xobjList2);
            return Bcons.COMPOUND(blockList);
        }

        void rewrite(Block block) {
            BasicBlockExprIterator basicBlockExprIterator = new BasicBlockExprIterator(block);
            basicBlockExprIterator.init();
            while (!basicBlockExprIterator.end()) {
                Xobject xobject = basicBlockExprIterator.getExpr();
                topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobject);
                topdownXobjectIterator2.init();
                while (!topdownXobjectIterator2.end()) {
                    Xobject xobject2 = topdownXobjectIterator2.getXobject();
                    switch (xobject2.Opcode()) {
                        case VAR: {
                            String string = xobject2.getName();
                            if (!string.equals(this.varId.getName())) break;
                            topdownXobjectIterator2.setXobject(this.cacheId.Ref());
                            break;
                        }
                        case ARRAY_REF: {
                            String string = xobject2.getArg(0).getName();
                            if (!string.equals(this.varId.getName())) break;
                            XobjList xobjList = (XobjList)xobject2.getArg(1);
                            Xobject xobject3 = null;
                            int n = 0;
                            for (Xobject xobject4 : xobjList) {
                                Xobject xobject5 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject4, Xcons.arrayRef(Xtype.intType, this.cacheOffsetArrayId.getAddr(), Xcons.List(Xcons.IntConstant(n))));
                                xobject3 = xobject3 == null ? xobject5 : Xcons.binaryOp(Xcode.PLUS_EXPR, Xcons.binaryOp(Xcode.MUL_EXPR, xobject3, Xcons.arrayRef(Xtype.intType, this.cacheSizeArrayId.getAddr(), Xcons.List(Xcons.IntConstant(n)))), xobject5);
                                ++n;
                            }
                            Xobject xobject6 = Xcons.arrayRef(xobject2.Type(), this.cacheId.Ref(), Xcons.List(xobject3));
                            topdownXobjectIterator2.setXobject(xobject6);
                        }
                    }
                    topdownXobjectIterator2.next();
                }
                basicBlockExprIterator.next();
            }
        }

        private XobjList getSimpleSubarray(Xobject xobject) {
            Xobject xobject2;
            Xobject xobject3;
            Xobject xobject4;
            Xobject xobject5;
            if (xobject.Opcode() != Xcode.LIST) {
                xobject5 = xobject;
                xobject4 = Xcons.IntConstant(1);
            } else {
                xobject5 = xobject.getArg(0);
                xobject4 = xobject.getArgOrNull(1);
            }
            switch (xobject5.Opcode()) {
                case PLUS_EXPR: {
                    xobject3 = xobject5.getArg(0);
                    xobject2 = xobject5.getArg(1);
                    break;
                }
                case MINUS_EXPR: {
                    xobject3 = xobject5.getArg(0);
                    xobject2 = Xcons.unaryOp(Xcode.UNARY_MINUS_EXPR, xobject5.getArg(1));
                    break;
                }
                case INT_CONSTANT: {
                    xobject3 = Xcons.IntConstant(0);
                    xobject2 = xobject5;
                    break;
                }
                default: {
                    xobject3 = xobject5;
                    xobject2 = Xcons.IntConstant(0);
                }
            }
            return Xcons.List(xobject3, xobject2, xobject4);
        }
    }

    class SharedMemory {
        final Ident externSmId;
        final Ident smOffsetId;
        final ArrayDeque<Xobject> smStack = new ArrayDeque();
        Xobject maxSize = Xcons.IntConstant(0);
        boolean isUsed = false;

        SharedMemory() {
            ArrayType arrayType = Xtype.Array((Xtype)Xtype.charType, null);
            this.externSmId = Ident.Var("_ACC_sm", arrayType, Xtype.Pointer(arrayType), VarScope.GLOBAL);
            this.externSmId.setStorageClass(StorageClass.EXTERN);
            this.externSmId.setProp("OPENACC_GPU_SHARED", true);
            this.smOffsetId = Ident.Local("_ACC_sm_offset", Xtype.intType);
            this.smOffsetId.setProp("OPENACC_GPU_SHARED", true);
        }

        public Xobject getMaxSize() {
            return this.maxSize;
        }

        public boolean isUsed() {
            return this.isUsed;
        }

        Cache alloc(Ident ident, XobjList xobjList) {
            Cache cache = new Cache(ident, xobjList);
            this.smStack.push(cache.cacheTotalSize);
            Xobject xobject = Xcons.IntConstant(0);
            for (Xobject xobject2 : this.smStack) {
                xobject = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject, xobject2);
            }
            this.maxSize = Xcons.List(Xcode.CONDITIONAL_EXPR, Xcons.binaryOp(Xcode.LOG_LT_EXPR, xobject, this.maxSize), Xcons.List(this.maxSize, xobject));
            this.isUsed = true;
            return cache;
        }

        Block makeInitFunc() {
            return ACCutil.createFuncCallBlock("_ACC_gpu_init_sm_offset", Xcons.List(this.smOffsetId.getAddr()));
        }
    }

    class Loop {
        final CforBlock forBlock;
        final boolean isParallelized;
        final Ident abstIdx;
        final Ident abstInit;
        final Ident abstCond;
        final Ident abstStep;

        Loop(CforBlock cforBlock) {
            this(cforBlock, null, null, null, null);
        }

        Loop(CforBlock cforBlock, Ident ident, Ident ident2, Ident ident3, Ident ident4) {
            this.forBlock = cforBlock;
            this.abstIdx = ident;
            this.abstInit = ident2;
            this.abstCond = ident3;
            this.abstStep = ident4;
            this.isParallelized = ident != null;
        }
    }

    private class AssignedIdCollector {
        private AssignedIdCollector() {
        }

        Set<Ident> collect(Block block) {
            Object object;
            LinkedHashSet<Ident> linkedHashSet = new LinkedHashSet<Ident>();
            BasicBlockExprIterator basicBlockExprIterator = new BasicBlockExprIterator(block);
            basicBlockExprIterator.init();
            while (!basicBlockExprIterator.end()) {
                object = this.collect(basicBlockExprIterator.getExpr(), basicBlockExprIterator.getBasicBlock().getParent());
                linkedHashSet.addAll((Collection<Ident>)object);
                basicBlockExprIterator.next();
            }
            object = new topdownBlockIterator(block);
            ((BlockIterator)object).init();
            while (!((BlockIterator)object).end()) {
                Object object2;
                Xobject xobject;
                Block block2 = ((BlockIterator)object).getBlock();
                if (AccKernel.this.hasBody(block2)) {
                    xobject = block2.getBody().getDecls();
                    object2 = this.collect(xobject, block2);
                    linkedHashSet.addAll((Collection<Ident>)object2);
                } else if (block2.Opcode() == Xcode.IF_STATEMENT) {
                    xobject = block2.getThenBody().getDecls();
                    object2 = block2.getElseBody().getDecls();
                    linkedHashSet.addAll(this.collect(xobject, block2));
                    linkedHashSet.addAll(this.collect((Xobject)object2, block2));
                }
                ((BlockIterator)object).next();
            }
            return linkedHashSet;
        }

        private Set<Ident> collect(Xobject xobject, Block block) {
            LinkedHashSet<Ident> linkedHashSet = new LinkedHashSet<Ident>();
            if (xobject == null) {
                return linkedHashSet;
            }
            topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobject);
            ((XobjectIterator)topdownXobjectIterator2).init();
            while (!((XobjectIterator)topdownXobjectIterator2).end()) {
                Xobject xobject2;
                Xobject xobject3 = topdownXobjectIterator2.getXobject();
                if (xobject3 != null && (xobject2 = this.findAssignedExpr(xobject3)) != null) {
                    Ident ident = this.getAssignedId(xobject2, block);
                    linkedHashSet.add(ident);
                }
                ((XobjectIterator)topdownXobjectIterator2).next();
            }
            return linkedHashSet;
        }

        private Ident getAssignedId(Xobject xobject, Block block) {
            Ident ident = null;
            try {
                Xobject xobject2 = this.getAssignedXobject(xobject);
                String string = xobject2.getName();
                ident = block.findVarIdent(string);
                if (ident == null) {
                    throw new ACCexception("variable '" + string + "' is not found");
                }
            }
            catch (ACCexception aCCexception) {
                ACC.fatal("getAssignedId: " + aCCexception.getMessage());
            }
            return ident;
        }

        private Xobject getAssignedXobject(Xobject xobject) throws ACCexception {
            switch (xobject.Opcode()) {
                case VAR: 
                case ARRAY_ADDR: 
                case INT_CONSTANT: {
                    return xobject;
                }
                case ARRAY_REF: 
                case MEMBER_REF: 
                case ADDR_OF: 
                case POINTER_REF: 
                case CAST_EXPR: 
                case MEMBER_ADDR: 
                case MEMBER_ARRAY_REF: {
                    return this.getAssignedXobject(xobject.getArg(0));
                }
                case PLUS_EXPR: 
                case MINUS_EXPR: {
                    if (!xobject.Type().isPointer()) {
                        throw new ACCexception("not pointer");
                    }
                    Xobject xobject2 = xobject.getArg(0);
                    Xobject xobject3 = xobject.getArg(1);
                    if (xobject2.Type().isPointer()) {
                        return this.getAssignedXobject(xobject2);
                    }
                    if (xobject3.Type().isPointer()) {
                        return this.getAssignedXobject(xobject3);
                    }
                    throw new ACCexception("no pointer operand for PLUS or MINUS");
                }
                case FUNCTION_CALL: {
                    Xobject xobject4 = xobject.getArg(0);
                    if (!xobject4.getName().startsWith("_XMP_M_GET_ADDR_E")) break;
                    Xobject xobject5 = xobject.getArg(1);
                    return xobject5.getArg(0);
                }
            }
            throw new ACCexception("not supported type: " + (Object)((Object)xobject.Opcode()));
        }

        private Xobject findAssignedExpr(Xobject xobject) {
            switch (xobject.Opcode()) {
                case PRE_INCR_EXPR: 
                case PRE_DECR_EXPR: 
                case POST_INCR_EXPR: 
                case POST_DECR_EXPR: {
                    return xobject.getArg(0);
                }
            }
            if (xobject.Opcode().isAsgOp()) {
                return xobject.getArg(0);
            }
            return null;
        }
    }

    private class OuterIdCollector {
        private OuterIdCollector() {
        }

        public Set<Ident> collect(Block block) {
            LinkedHashSet<Ident> linkedHashSet = new LinkedHashSet<Ident>();
            this.collectVarIdents(block, linkedHashSet);
            this.collectlVarIdentsInDecl(block, linkedHashSet);
            return linkedHashSet;
        }

        private void collectlVarIdentsInDecl(Block block, Set<Ident> set) {
            topdownBlockIterator topdownBlockIterator2 = new topdownBlockIterator(block);
            ((BlockIterator)topdownBlockIterator2).init();
            while (!((BlockIterator)topdownBlockIterator2).end()) {
                Block block2 = topdownBlockIterator2.getBlock();
                if (AccKernel.this.hasBody(block2)) {
                    Xobject xobject = block2.getBody().getDecls();
                    this.collectVarIdentsInDecls(block, set, block2, xobject);
                } else if (block2.Opcode() == Xcode.IF_STATEMENT) {
                    this.collectVarIdentsInDecls(block, set, block2, block2.getThenBody().getDecls());
                    this.collectVarIdentsInDecls(block, set, block2, block2.getElseBody().getDecls());
                }
                ((BlockIterator)topdownBlockIterator2).next();
            }
        }

        private void collectVarIdentsInDecls(Block block, Set<Ident> set, Block block2, Xobject xobject) {
            if (xobject == null) {
                return;
            }
            Set<String> set2 = this.collectVarNames(xobject);
            for (String string : set2) {
                Ident ident = this.find(block, block2, string);
                if (ident == null) continue;
                set.add(ident);
            }
        }

        private void collectVarIdents(Block block, Set<Ident> set) {
            BasicBlockExprIterator basicBlockExprIterator = new BasicBlockExprIterator(block);
            basicBlockExprIterator.init();
            while (!basicBlockExprIterator.end()) {
                for (String string : this.collectVarNames(basicBlockExprIterator.getExpr())) {
                    Ident ident = this.find(block, basicBlockExprIterator.getBasicBlock().getParent(), string);
                    if (ident == null) continue;
                    set.add(ident);
                }
                basicBlockExprIterator.next();
            }
        }

        private Set<String> collectVarNames(Xobject xobject) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobject);
            ((XobjectIterator)topdownXobjectIterator2).init();
            while (!((XobjectIterator)topdownXobjectIterator2).end()) {
                Xobject xobject2 = topdownXobjectIterator2.getXobject();
                if (xobject2 != null) {
                    switch (xobject2.Opcode()) {
                        case VAR: {
                            String string = xobject2.getName();
                            linkedHashSet.add(string);
                            break;
                        }
                        case ARRAY_REF: {
                            String string = xobject2.getArg(0).getName();
                            linkedHashSet.add(string);
                            break;
                        }
                    }
                }
                ((XobjectIterator)topdownXobjectIterator2).next();
            }
            return linkedHashSet;
        }

        private boolean isPrivate(PragmaBlock pragmaBlock, String string) {
            AccDirective accDirective = (AccDirective)pragmaBlock.getProp("_ACC_DIRECTIVE");
            AccInformation accInformation = accDirective.getInfo();
            if (accInformation == null) {
                return false;
            }
            ACCvar aCCvar = accInformation.findACCvar(string);
            return aCCvar != null && aCCvar.isPrivate();
        }

        private Ident find(Block block, Block block2, String string) {
            for (Block block3 = block2; block3 != null && block3 != block.getParentBlock(); block3 = block3.getParentBlock()) {
                if (block3.Opcode() == Xcode.ACC_PRAGMA && this.isPrivate((PragmaBlock)block3, string)) {
                    return null;
                }
                if (!this.hasLocalIdent(block3.getBody(), string)) continue;
                return null;
            }
            return block.findVarIdent(string);
        }

        private boolean hasLocalIdent(BlockList blockList, String string) {
            return blockList != null && blockList.findLocalIdent(string) != null;
        }
    }

    private class DeviceKernelBuildInfo {
        private final List<Block> initBlockList = new ArrayList<Block>();
        private final List<Block> finalizeBlockList = new ArrayList<Block>();
        private final XobjList paramIdList = Xcons.IDList();
        private final XobjList localIdList = Xcons.IDList();

        private DeviceKernelBuildInfo() {
        }

        public List<Block> getInitBlockList() {
            return this.initBlockList;
        }

        public List<Block> getFinalizeBlockList() {
            return this.finalizeBlockList;
        }

        public void addInitBlock(Block block) {
            this.initBlockList.add(block);
        }

        public void addFinalizeBlock(Block block) {
            this.finalizeBlockList.add(block);
        }

        public XobjList getParamIdList() {
            return this.paramIdList;
        }

        public void addParamId(Ident ident) {
            this.paramIdList.add(ident);
        }

        XobjList getLocalIdList() {
            return this.localIdList;
        }

        public void addLocalId(Ident ident) {
            this.localIdList.add(ident);
        }
    }
}

