/*
 * Decompiled with CFR 0.152.
 */
package exc.openacc;

import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.openacc.ACCexception;
import exc.openacc.ACCpragma;
import exc.openacc.ACCvar;
import exc.openacc.AccDirective;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class AccInformation {
    private final ACCpragma _pragma;
    private final List<Clause> _clauseList = new ArrayList<Clause>();
    private final Set<String> _declaredSymbolSet = new HashSet<String>();
    private final Set<ACCpragma> _singleClauseSet = new HashSet<ACCpragma>();

    private void addClause(Clause clause) {
        this._clauseList.add(clause);
    }

    AccInformation(ACCpragma aCCpragma, Xobject xobject) throws ACCexception {
        this._pragma = aCCpragma;
        if (aCCpragma == ACCpragma.WAIT || aCCpragma == ACCpragma.CACHE) {
            this.addClause(this.makeClause(aCCpragma, xobject));
            return;
        }
        for (Xobject xobject2 : (XobjList)xobject) {
            XobjList xobjList = (XobjList)xobject2;
            ACCpragma aCCpragma2 = ACCpragma.valueOf(xobjList.getArg(0));
            Xobject xobject3 = xobjList.getArgOrNull(1);
            this.addClause(this.makeClause(aCCpragma2, xobject3));
        }
    }

    Clause makeClause(ACCpragma aCCpragma, Xobject xobject) throws ACCexception {
        switch (aCCpragma) {
            case INDEPENDENT: 
            case SEQ: 
            case NOHOST: {
                return new Clause(aCCpragma);
            }
            case IF: 
            case NUM_GANGS: 
            case NUM_WORKERS: 
            case VECT_LEN: 
            case COLLAPSE: {
                return new IntExprClause(aCCpragma, xobject);
            }
            case GANG: 
            case WORKER: 
            case VECTOR: 
            case WAIT: 
            case ASYNC: {
                if (xobject == null) {
                    return new Clause(aCCpragma);
                }
                return new IntExprClause(aCCpragma, xobject);
            }
            case BIND: 
            case ROUTINE_ARG: {
                return new SymbolClause(aCCpragma, xobject.getArg(0));
            }
        }
        return new VarListClause(aCCpragma, (XobjList)xobject);
    }

    void checkDuplication(ACCvar aCCvar) throws ACCexception {
        String string = aCCvar.getSymbol();
        if (this._declaredSymbolSet.contains(string)) {
            throw new ACCexception("symbol '" + string + "' is already specified");
        }
        this._declaredSymbolSet.add(string);
    }

    void addVar(ACCpragma aCCpragma, Xobject xobject) throws ACCexception {
        VarListClause varListClause = null;
        if (aCCpragma != ACCpragma.HOST && aCCpragma != ACCpragma.DEVICE) {
            varListClause = (VarListClause)this.findClause(aCCpragma);
        }
        if (varListClause == null) {
            varListClause = new VarListClause(aCCpragma);
            this.addClause(varListClause);
        }
        varListClause.addVar(xobject);
    }

    void addClause(ACCpragma aCCpragma) throws ACCexception {
        this.addClause(this.makeClause(aCCpragma, null));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#_pragma acc");
        if (this._pragma != ACCpragma.CACHE && this._pragma != ACCpragma.WAIT) {
            stringBuilder.append(' ');
            stringBuilder.append(this._pragma.getName());
        }
        for (Clause clause : this._clauseList) {
            stringBuilder.append(clause);
        }
        return new String(stringBuilder);
    }

    List<Clause> findAllClauses(ACCpragma aCCpragma) {
        ArrayList<Clause> arrayList = new ArrayList<Clause>();
        for (Clause clause : this._clauseList) {
            if (clause._clauseKind != aCCpragma) continue;
            arrayList.add(clause);
        }
        return arrayList;
    }

    Clause findClause(ACCpragma aCCpragma) {
        List<Clause> list = this.findAllClauses(aCCpragma);
        return list.isEmpty() ? null : list.get(0);
    }

    Xobject toXobject() {
        if (this._pragma == ACCpragma.CACHE || this._pragma == ACCpragma.WAIT) {
            Clause clause = this.findClause(this._pragma);
            return clause.toXobject();
        }
        XobjList xobjList = Xcons.List();
        for (Clause clause : this._clauseList) {
            xobjList.add(clause.toXobject());
        }
        return xobjList;
    }

    boolean isDeclared(String string) {
        return this._declaredSymbolSet.contains(string);
    }

    List<ACCvar> getACCvarList() {
        ArrayList<ACCvar> arrayList = new ArrayList<ACCvar>();
        for (Clause clause : this._clauseList) {
            List<ACCvar> list = clause.getVarList();
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    List<ACCvar> getDeclarativeACCvarList() {
        ArrayList<ACCvar> arrayList = new ArrayList<ACCvar>();
        for (Clause clause : this._clauseList) {
            if (!clause._clauseKind.isDeclarativeClause()) continue;
            arrayList.addAll(clause.getVarList());
        }
        return arrayList;
    }

    Xobject getIntExpr(ACCpragma aCCpragma) {
        Clause clause = this.findClause(aCCpragma);
        if (clause == null) {
            return null;
        }
        return clause.getIntExpr();
    }

    ACCvar findACCvar(List<Clause> list, String string) {
        for (Clause clause : list) {
            ACCvar aCCvar = clause.findVar(string);
            if (aCCvar == null) continue;
            return aCCvar;
        }
        return null;
    }

    ACCvar findACCvar(String string) {
        return this.findACCvar(this._clauseList, string);
    }

    ACCvar findACCvar(ACCpragma aCCpragma, String string) {
        return this.findACCvar(this.findAllClauses(aCCpragma), string);
    }

    ACCvar findReductionACCvar(String string) {
        ArrayList<Clause> arrayList = new ArrayList<Clause>();
        for (Clause clause : this._clauseList) {
            if (!clause._clauseKind.isReduction()) continue;
            arrayList.add(clause);
        }
        return this.findACCvar(arrayList, string);
    }

    ACCpragma getPragma() {
        return this._pragma;
    }

    boolean hasClause(ACCpragma aCCpragma) {
        return !this.findAllClauses(aCCpragma).isEmpty();
    }

    void validate(AccDirective accDirective) throws ACCexception {
        for (Clause clause : this._clauseList) {
            clause.validate(accDirective);
        }
    }

    class VarListClause
    extends Clause {
        final List<ACCvar> varList;

        VarListClause(ACCpragma aCCpragma, XobjList xobjList) throws ACCexception {
            super(aCCpragma);
            this.varList = new ArrayList<ACCvar>();
            if (xobjList == null) {
                return;
            }
            for (Xobject xobject : xobjList) {
                this.addVar(xobject);
            }
        }

        VarListClause(ACCpragma aCCpragma) throws ACCexception {
            this(aCCpragma, null);
        }

        void addVar(Xobject xobject) throws ACCexception {
            ACCvar aCCvar = new ACCvar(xobject, this._clauseKind);
            if (this._clauseKind.isDeclarativeClause()) {
                AccInformation.this.checkDuplication(aCCvar);
            }
            this.varList.add(aCCvar);
        }

        @Override
        ACCvar findVar(String string) {
            for (ACCvar aCCvar : this.varList) {
                if (!aCCvar.getSymbol().equals(string)) continue;
                return aCCvar;
            }
            return null;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(super.toString());
            stringBuilder.append('(');
            if (this.varList.size() > 0) {
                stringBuilder.append(this.varList.get(0));
                for (int i = 1; i < this.varList.size(); ++i) {
                    stringBuilder.append(',');
                    stringBuilder.append(this.varList.get(i));
                }
            }
            stringBuilder.append(')');
            return new String(stringBuilder);
        }

        @Override
        Xobject toXobject() {
            XobjList xobjList = Xcons.List();
            for (ACCvar aCCvar : this.varList) {
                xobjList.add(aCCvar.toXobject());
            }
            Xobject xobject = super.toXobject();
            xobject.add(xobjList);
            return xobject;
        }

        @Override
        List<ACCvar> getVarList() {
            return this.varList;
        }

        @Override
        void validate(AccDirective accDirective) throws ACCexception {
            super.validate(accDirective);
            for (ACCvar aCCvar : this.varList) {
                accDirective.setVarIdent(aCCvar);
            }
        }

        @Override
        boolean isSingle() {
            return false;
        }
    }

    class SymbolClause
    extends Clause {
        private final Xobject arg;

        SymbolClause(ACCpragma aCCpragma, Xobject xobject) throws ACCexception {
            super(aCCpragma);
            if (xobject == null) {
                throw new ACCexception("null symbol");
            }
            this.arg = xobject;
        }

        @Override
        public String toString() {
            return super.toString() + '(' + this.arg + ')';
        }

        @Override
        Xobject toXobject() {
            Xobject xobject = super.toXobject();
            xobject.add(this.arg);
            return xobject;
        }

        @Override
        void validate(AccDirective accDirective) throws ACCexception {
            super.validate(accDirective);
            boolean bl = accDirective.isSymbol(this.arg.getSym());
            if (!bl) {
                throw new ACCexception("'" + this.arg + "' is not found");
            }
        }

        @Override
        String getSymbol() {
            return this.arg.getSym();
        }
    }

    class IntExprClause
    extends Clause {
        private final Xobject arg;

        IntExprClause(ACCpragma aCCpragma, Xobject xobject) throws ACCexception {
            super(aCCpragma);
            if (xobject == null) {
                throw new ACCexception("null expr");
            }
            this.arg = xobject;
        }

        @Override
        public String toString() {
            return super.toString() + '(' + this.arg + ')';
        }

        @Override
        Xobject toXobject() {
            Xobject xobject = super.toXobject();
            xobject.add(this.arg);
            return xobject;
        }

        @Override
        void validate(AccDirective accDirective) throws ACCexception {
            super.validate(accDirective);
            if (!accDirective.isIntExpr(this.arg)) {
                throw new ACCexception("'" + this.arg + "' is not int expr");
            }
        }

        @Override
        Xobject getIntExpr() {
            return this.arg;
        }
    }

    class Clause {
        final ACCpragma _clauseKind;

        Clause(ACCpragma aCCpragma) throws ACCexception {
            this._clauseKind = aCCpragma;
            if (this.isSingle()) {
                if (AccInformation.this._singleClauseSet.contains((Object)aCCpragma)) {
                    throw new ACCexception("'" + aCCpragma.getName() + "' is already specified");
                }
                AccInformation.this._singleClauseSet.add(aCCpragma);
            }
        }

        public String toString() {
            return " " + this._clauseKind.getName();
        }

        Xobject toXobject() {
            return Xcons.List(Xcons.String(this._clauseKind.toString()));
        }

        List<ACCvar> getVarList() {
            return null;
        }

        ACCvar findVar(String string) {
            return null;
        }

        void validate(AccDirective accDirective) throws ACCexception {
            if (!accDirective.isAcceptableClause(this._clauseKind)) {
                throw new ACCexception(this._clauseKind.getName() + " clause is not allowed");
            }
        }

        Xobject getIntExpr() {
            return null;
        }

        String getSymbol() {
            return null;
        }

        boolean isSingle() {
            return true;
        }
    }
}

