/*
 * Decompiled with CFR 0.152.
 */
package exc.openacc;

import exc.block.PragmaBlock;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.openacc.ACC;
import exc.openacc.ACCexception;
import exc.openacc.ACCglobalDecl;
import exc.openacc.ACCpragma;
import exc.openacc.AccAtomic;
import exc.openacc.AccData;
import exc.openacc.AccDeclare;
import exc.openacc.AccEnterData;
import exc.openacc.AccExitData;
import exc.openacc.AccHostData;
import exc.openacc.AccInformation;
import exc.openacc.AccKernels;
import exc.openacc.AccKernelsLoop;
import exc.openacc.AccLoop;
import exc.openacc.AccParallel;
import exc.openacc.AccParallelLoop;
import exc.openacc.AccProcessor;
import exc.openacc.AccRoutine;
import exc.openacc.AccUpdate;
import exc.openacc.AccWait;

class AccInfoReader
extends AccProcessor {
    public AccInfoReader(ACCglobalDecl aCCglobalDecl) {
        super(aCCglobalDecl, true, true);
    }

    @Override
    void doGlobalAccPragma(Xobject xobject) throws ACCexception {
        String string = xobject.getArg(0).getString();
        ACCpragma aCCpragma = ACCpragma.valueOf(string);
        if (!aCCpragma.isGlobalDirective()) {
            throw new ACCexception(aCCpragma.getName() + " is not global directive");
        }
        Xobject xobject2 = xobject.getArg(1);
        AccInformation accInformation = new AccInformation(aCCpragma, xobject2);
        XobjectDef xobjectDef = (XobjectDef)xobject.getParent();
        switch (aCCpragma) {
            case DECLARE: {
                xobject.setProp("_ACC_DIRECTIVE", new AccDeclare(this._globalDecl, accInformation, xobjectDef));
                break;
            }
            case ROUTINE: {
                xobject.setProp("_ACC_DIRECTIVE", new AccRoutine(this._globalDecl, accInformation, xobjectDef));
                break;
            }
            default: {
                ACC.fatal("unknown directive: " + aCCpragma.getName());
            }
        }
    }

    @Override
    void doLocalAccPragma(PragmaBlock pragmaBlock) throws ACCexception {
        String string = pragmaBlock.getPragma();
        ACCpragma aCCpragma = ACCpragma.valueOf(string);
        if (!aCCpragma.isLocalDirective()) {
            throw new ACCexception(string + " is not local directive");
        }
        Xobject xobject = pragmaBlock.getClauses();
        AccInformation accInformation = new AccInformation(aCCpragma, xobject);
        switch (aCCpragma) {
            case DATA: {
                pragmaBlock.setProp("_ACC_DIRECTIVE", new AccData(this._globalDecl, accInformation, pragmaBlock));
                break;
            }
            case PARALLEL: {
                pragmaBlock.setProp("_ACC_DIRECTIVE", new AccParallel(this._globalDecl, accInformation, pragmaBlock));
                break;
            }
            case PARALLEL_LOOP: {
                pragmaBlock.setProp("_ACC_DIRECTIVE", new AccParallelLoop(this._globalDecl, accInformation, pragmaBlock));
                break;
            }
            case LOOP: {
                pragmaBlock.setProp("_ACC_DIRECTIVE", new AccLoop(this._globalDecl, accInformation, pragmaBlock));
                break;
            }
            case UPDATE: {
                pragmaBlock.setProp("_ACC_DIRECTIVE", new AccUpdate(this._globalDecl, accInformation, pragmaBlock));
                break;
            }
            case HOST_DATA: {
                pragmaBlock.setProp("_ACC_DIRECTIVE", new AccHostData(this._globalDecl, accInformation, pragmaBlock));
                break;
            }
            case WAIT: {
                pragmaBlock.setProp("_ACC_DIRECTIVE", new AccWait(this._globalDecl, accInformation, pragmaBlock));
                break;
            }
            case KERNELS: {
                pragmaBlock.setProp("_ACC_DIRECTIVE", new AccKernels(this._globalDecl, accInformation, pragmaBlock));
                break;
            }
            case KERNELS_LOOP: {
                pragmaBlock.setProp("_ACC_DIRECTIVE", new AccKernelsLoop(this._globalDecl, accInformation, pragmaBlock));
                break;
            }
            case ENTER_DATA: {
                pragmaBlock.setProp("_ACC_DIRECTIVE", new AccEnterData(this._globalDecl, accInformation, pragmaBlock));
                break;
            }
            case EXIT_DATA: {
                pragmaBlock.setProp("_ACC_DIRECTIVE", new AccExitData(this._globalDecl, accInformation, pragmaBlock));
                break;
            }
            case ATOMIC: {
                pragmaBlock.setProp("_ACC_DIRECTIVE", new AccAtomic(this._globalDecl, accInformation, pragmaBlock));
                break;
            }
            case DECLARE: {
                pragmaBlock.setProp("_ACC_DIRECTIVE", new AccDeclare(this._globalDecl, accInformation, pragmaBlock));
                break;
            }
            default: {
                ACC.fatal("unknown directive: " + aCCpragma.getName());
            }
        }
    }
}

