/*
 * Decompiled with CFR 0.152.
 */
package exc.openacc;

import exc.block.Block;
import exc.block.PragmaBlock;
import exc.object.Ident;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.openacc.ACC;
import exc.openacc.ACCexception;
import exc.openacc.ACCglobalDecl;
import exc.openacc.ACCpragma;
import exc.openacc.ACCvar;
import exc.openacc.AccInformation;

abstract class AccDirective {
    public static final String prop = "_ACC_DIRECTIVE";
    final AccInformation _info;
    final XobjectDef _xobjDef;
    final PragmaBlock _pb;
    final ACCglobalDecl _decl;

    AccDirective(ACCglobalDecl aCCglobalDecl, AccInformation accInformation) {
        this(aCCglobalDecl, accInformation, null, null);
    }

    AccDirective(ACCglobalDecl aCCglobalDecl, AccInformation accInformation, XobjectDef xobjectDef) {
        this(aCCglobalDecl, accInformation, xobjectDef, null);
    }

    AccDirective(ACCglobalDecl aCCglobalDecl, AccInformation accInformation, PragmaBlock pragmaBlock) {
        this(aCCglobalDecl, accInformation, null, pragmaBlock);
    }

    AccDirective(ACCglobalDecl aCCglobalDecl, AccInformation accInformation, XobjectDef xobjectDef, PragmaBlock pragmaBlock) {
        this._decl = aCCglobalDecl;
        this._info = accInformation;
        this._xobjDef = xobjectDef;
        this._pb = pragmaBlock;
        ACC.debug(accInformation.toString());
    }

    void analyze() throws ACCexception {
        this._info.validate(this);
    }

    void setVarIdent(ACCvar aCCvar) throws ACCexception {
        String string = aCCvar.getSymbol();
        Ident ident = this.findVarIdent(string);
        if (ident == null) {
            throw new ACCexception("symbol '" + string + "' is not exist");
        }
        ACCvar aCCvar2 = this.findParentVar(ident);
        if (aCCvar2 != null && aCCvar != aCCvar2) {
            aCCvar.setParent(aCCvar2);
        } else {
            aCCvar.setIdent(ident);
            if (this._info.getPragma() == ACCpragma.DECLARE) {
                this.setPropVar(ident, aCCvar);
            }
        }
    }

    abstract void generate() throws ACCexception;

    abstract void rewrite() throws ACCexception;

    Ident findVarIdent(String string) {
        if (this._pb == null) {
            return this._decl.findVarIdent(string);
        }
        if (this._info.getPragma().isLoop()) {
            return this._pb.getBody().getHead().findVarIdent(string);
        }
        return this._pb.findVarIdent(string);
    }

    ACCvar findParentVar(Ident ident) {
        Object object = this.getPropVar(ident);
        if (object != null) {
            return object;
        }
        if (this._pb != null) {
            for (object = this._pb.getParentBlock(); object != null; object = ((Block)object).getParentBlock()) {
                AccInformation accInformation;
                ACCvar aCCvar;
                AccDirective accDirective = this.getPropDirective((Block)object);
                if (accDirective == null || (aCCvar = (accInformation = accDirective.getInfo()).findACCvar(ident.getSym())) == null || aCCvar.getId() != ident) continue;
                return aCCvar;
            }
            object = this._decl.findACCvar(ident);
            if (object != null) {
                return object;
            }
        }
        return null;
    }

    boolean isGlobal() {
        return this._pb == null;
    }

    AccInformation getInfo() {
        return this._info;
    }

    abstract boolean isAcceptableClause(ACCpragma var1);

    boolean isIntExpr(Xobject xobject) throws ACCexception {
        if (xobject == null) {
            return false;
        }
        if (xobject.Opcode() == Xcode.VAR) {
            String string = xobject.getName();
            Ident ident = this._pb.findVarIdent(string);
            if (ident == null) {
                throw new ACCexception("Symbol '" + string + "' is not found");
            }
            if (ident.Type().isIntegral()) {
                return true;
            }
        } else if (xobject.isIntConstant()) {
            return true;
        }
        return true;
    }

    boolean isSymbol(String string) throws ACCexception {
        if (string == null) {
            return false;
        }
        Ident ident = this.findVarIdent(string);
        return ident != null;
    }

    private void setPropVar(Ident ident, ACCvar aCCvar) {
        ident.setProp("_ACC_VAR", aCCvar);
    }

    private ACCvar getPropVar(Ident ident) {
        Object object = ident.getProp("_ACC_VAR");
        if (object != null) {
            return (ACCvar)object;
        }
        return null;
    }

    private AccDirective getPropDirective(Block block) {
        Object object = block.getProp(prop);
        if (object != null) {
            return (AccDirective)object;
        }
        return null;
    }

    Xobject getAsyncExpr() {
        boolean bl = this._info.hasClause(ACCpragma.ASYNC);
        if (!bl) {
            return Xcons.IntConstant(-1);
        }
        Xobject xobject = this._info.getIntExpr(ACCpragma.ASYNC);
        if (xobject == null) {
            return Xcons.IntConstant(-2);
        }
        return xobject;
    }
}

