/*
 * Decompiled with CFR 0.152.
 */
package exc.openacc;

import exc.openacc.ACC;

public enum AccDevice {
    NVIDIA("NVIDIA", 0, 0, 0, 0, false),
    NONE("", 0, 0, 0, 0, false);

    private String name;
    private int majorVersion;
    private int minorVersion;
    private int maxNumGangs;
    private int maxNumWorkers;
    private int maxVectorLength;
    private int defaultVectorLength;
    private boolean readOnlyDataCacheAvailable = true;
    private boolean useReadOnlyDataCache;

    private AccDevice(String string2, int n2, int n3, int n4, int n5, boolean bl) {
        this.name = string2;
        this.maxNumGangs = n2;
        this.maxNumWorkers = n3;
        this.maxVectorLength = n4;
        this.defaultVectorLength = n5;
        this.readOnlyDataCacheAvailable = this.useReadOnlyDataCache = bl;
    }

    public static AccDevice getDevice(String string) {
        if (string.matches("^[cC][cC]\\d\\d$")) {
            return AccDevice.getNvidiaDevice(Integer.parseInt(string.substring(2)));
        }
        switch (string) {
            case "Fermi": {
                return AccDevice.getNvidiaDevice(20);
            }
            case "Kepler": {
                return AccDevice.getNvidiaDevice(35);
            }
            case "Maxwell": {
                return AccDevice.getNvidiaDevice(52);
            }
            case "Pascal": {
                return AccDevice.getNvidiaDevice(60);
            }
        }
        return AccDevice.valueOf(string);
    }

    static AccDevice getNvidiaDevice(int n) {
        AccDevice accDevice = NVIDIA;
        int n2 = n / 10;
        int n3 = n % 10;
        accDevice.majorVersion = n2;
        accDevice.minorVersion = n3;
        accDevice.maxNumGangs = n2 <= 2 ? 65535 : Integer.MAX_VALUE;
        accDevice.maxNumWorkers = 1;
        accDevice.maxVectorLength = 1024;
        accDevice.defaultVectorLength = 256;
        accDevice.readOnlyDataCacheAvailable = n >= 35;
        accDevice.useReadOnlyDataCache = accDevice.readOnlyDataCacheAvailable;
        return accDevice;
    }

    String getName() {
        return this.name;
    }

    int getMaxNumGangs() {
        return this.maxNumGangs;
    }

    int getMaxNumWorkers() {
        return this.maxNumWorkers;
    }

    int getMaxVectorLength() {
        return this.maxVectorLength;
    }

    public void setDefaultVectorLength(int n) {
        if (n <= 0 || n > this.maxVectorLength) {
            ACC.fatal("invalid vectorlength");
        }
        this.defaultVectorLength = n;
    }

    int getDefaultVectorLength() {
        return this.defaultVectorLength;
    }

    public void setUseReadOnlyDataCache(boolean bl) {
        if (!this.readOnlyDataCacheAvailable && bl) {
            ACC.warning("Read-only data cache is unavailable");
            return;
        }
        this.useReadOnlyDataCache = bl;
    }

    boolean getUseReadOnlyDataCache() {
        return this.useReadOnlyDataCache;
    }
}

