/*
 * Decompiled with CFR 0.152.
 */
package exc.openacc;

import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockList;
import exc.block.PragmaBlock;
import exc.object.Ident;
import exc.object.StorageClass;
import exc.object.VarScope;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.Xtype;
import exc.openacc.ACCexception;
import exc.openacc.ACCglobalDecl;
import exc.openacc.ACCpragma;
import exc.openacc.ACCutil;
import exc.openacc.ACCvar;
import exc.openacc.AccDirective;
import exc.openacc.AccInformation;
import java.util.ArrayList;
import java.util.List;

class AccData
extends AccDirective {
    private static final String DEVICE_PTR_PREFIX = "_ACC_DEVICE_ADDR_";
    private static final String HOST_DESC_PREFIX = "_ACC_HOST_DESC_";
    final List<Block> initBlockList = new ArrayList<Block>();
    final List<Block> copyinBlockList = new ArrayList<Block>();
    final List<Block> copyoutBlockList = new ArrayList<Block>();
    final List<Block> finalizeBlockList = new ArrayList<Block>();
    final XobjList idList = Xcons.IDList();

    AccData(ACCglobalDecl aCCglobalDecl, AccInformation accInformation, PragmaBlock pragmaBlock) {
        super(aCCglobalDecl, accInformation, pragmaBlock);
    }

    AccData(ACCglobalDecl aCCglobalDecl, AccInformation accInformation, XobjectDef xobjectDef) {
        super(aCCglobalDecl, accInformation, xobjectDef);
    }

    @Override
    boolean isAcceptableClause(ACCpragma aCCpragma) {
        switch (aCCpragma) {
            case IF: {
                return true;
            }
        }
        return aCCpragma.isDataClause();
    }

    boolean isDisabled() {
        Xobject xobject = this._info.getIntExpr(ACCpragma.IF);
        return xobject != null && xobject.isZeroConstant();
    }

    @Override
    void generate() throws ACCexception {
        if (this.isDisabled()) {
            return;
        }
        for (ACCvar aCCvar : this._info.getDeclarativeACCvarList()) {
            this.generate(aCCvar);
        }
    }

    void generate(ACCvar aCCvar) throws ACCexception {
        Object object = this._info.findReductionACCvar(aCCvar.getSymbol());
        if (object != null) {
            return;
        }
        if (aCCvar.getParent() != null) {
            return;
        }
        if (aCCvar.isPrivate() || aCCvar.isFirstprivate()) {
            return;
        }
        if (aCCvar.isDeviceptr()) {
            return;
        }
        object = aCCvar.getName();
        StorageClass storageClass = aCCvar.getId().getStorageClass();
        aCCvar.setHostDesc(this.declHostDesc((String)object, storageClass));
        aCCvar.setDevicePtr(this.declDevicePtr((String)object, storageClass));
        if (this._info.getPragma() == ACCpragma.DECLARE && storageClass == StorageClass.EXTERN) {
            return;
        }
        this.initBlockList.add(this.makeInitFuncCallBlock(aCCvar));
        int n = 0;
        this.finalizeBlockList.add(this.makeFinalizeFuncCallBlock(aCCvar, n));
        this.copyinBlockList.add(this.makeCopyBlock(aCCvar, true, this.getAsyncExpr()));
        this.copyoutBlockList.add(this.makeCopyBlock(aCCvar, false, this.getAsyncExpr()));
    }

    Ident declDevicePtr(String string, StorageClass storageClass) {
        return this.declVar(DEVICE_PTR_PREFIX + string, storageClass);
    }

    Ident declHostDesc(String string, StorageClass storageClass) {
        return this.declVar(HOST_DESC_PREFIX + string, storageClass);
    }

    private Ident declVar(String string, StorageClass storageClass) {
        boolean bl = this._pb == null;
        VarScope varScope = bl ? VarScope.GLOBAL : VarScope.LOCAL;
        Ident ident = null;
        if (bl) {
            ident = storageClass == StorageClass.EXTERN ? this._decl.declExternIdent(string, Xtype.voidPtrType) : this._decl.declGlobalIdent(string, Xtype.voidPtrType);
        } else {
            ident = Ident.Var(string, Xtype.voidPtrType, Xtype.Pointer(Xtype.voidPtrType), varScope);
            this.idList.add(ident);
        }
        return ident;
    }

    Block makeInitFuncCallBlock(ACCvar aCCvar) throws ACCexception {
        Object object2;
        Xobject xobject = aCCvar.getAddress();
        Ident ident = aCCvar.getHostDesc();
        Ident ident2 = aCCvar.getDevicePtr();
        Xtype xtype = aCCvar.getElementType();
        int n = aCCvar.getDim();
        int n2 = aCCvar.getPointerDimBit();
        XobjList xobjList = Xcons.List();
        XobjList xobjList2 = Xcons.List();
        for (Object object2 : aCCvar.getSubscripts()) {
            xobjList.add(((Xobject)object2).left());
            xobjList2.add(((Xobject)object2).right());
        }
        XobjList xobjList3 = Xcons.List(ident.getAddr(), ident2.getAddr(), xobject, Xcons.SizeOf(xtype), Xcons.IntConstant(n), Xcons.IntConstant(n2));
        object2 = this.getInitFuncName(aCCvar);
        return ACCutil.createFuncCallBlockWithArrayRange((String)object2, xobjList3, Xcons.List(xobjList, xobjList2));
    }

    Block makeFinalizeFuncCallBlock(ACCvar aCCvar, int n) {
        Ident ident = aCCvar.getHostDesc();
        return ACCutil.createFuncCallBlock("_ACC_finalize_data", Xcons.List(ident.Ref(), Xcons.IntConstant(n)));
    }

    Block makeCopyBlock(ACCvar aCCvar, boolean bl, Xobject xobject) {
        boolean bl2;
        boolean bl3 = bl2 = bl ? aCCvar.copiesHtoD() : aCCvar.copiesDtoH();
        if (bl2) {
            String string = this.getCopyFuncName(aCCvar);
            Ident ident = aCCvar.getHostDesc();
            int n = bl ? 400 : 401;
            return ACCutil.createFuncCallBlock(string, Xcons.List(ident.Ref(), Xcons.IntConstant(n), xobject));
        }
        return Bcons.emptyBlock();
    }

    private String getCopyFuncName(ACCvar aCCvar) {
        if (aCCvar.isPresentOr()) {
            return "_ACC_pcopy_data";
        }
        return "_ACC_copy_data";
    }

    String getInitFuncName(ACCvar aCCvar) {
        String string = aCCvar.isPresent() ? "_ACC_find_data" : (aCCvar.isPresentOr() ? "_ACC_pinit_data" : (aCCvar.isDeviceptr() ? "_ACC_devptr_init_data" : "_ACC_init_data"));
        return string;
    }

    @Override
    void rewrite() throws ACCexception {
        boolean bl;
        Block block3;
        BlockList blockList = Bcons.emptyBody();
        for (Block object2 : this.initBlockList) {
            blockList.add(object2);
        }
        for (Block block2 : this.copyinBlockList) {
            blockList.add(block2);
        }
        BlockList blockList2 = Bcons.emptyBody();
        for (Block block3 : this.copyoutBlockList) {
            blockList2.add(block3);
        }
        for (Block block3 : this.finalizeBlockList) {
            blockList2.add(block3);
        }
        Block block4 = Bcons.COMPOUND(blockList);
        block3 = Bcons.COMPOUND(blockList2);
        BlockList blockList3 = Bcons.emptyBody();
        for (Xobject xobject : this.idList) {
            blockList3.addIdent((Ident)xobject);
        }
        Xobject xobject = this._info.getIntExpr(ACCpragma.IF);
        boolean bl2 = bl = xobject == null || xobject.isIntConstant();
        if (bl) {
            blockList3.add(block4);
            blockList3.add(Bcons.COMPOUND(this._pb.getBody()));
            blockList3.add(block3);
        } else {
            Ident ident = blockList3.declLocalIdent("_ACC_DATA_IF_COND", Xtype.charType, StorageClass.AUTO, xobject);
            blockList3.add(Bcons.IF(ident.Ref(), block4, null));
            blockList3.add(Bcons.COMPOUND(this._pb.getBody()));
            blockList3.add(Bcons.IF(ident.Ref(), block3, null));
        }
        this._pb.replace(Bcons.COMPOUND(blockList3));
    }
}

