/*
 * Decompiled with CFR 0.152.
 */
package exc.openacc;

import exc.block.BasicBlock;
import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockList;
import exc.block.PragmaBlock;
import exc.block.Statement;
import exc.object.Ident;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.openacc.ACCexception;
import exc.openacc.ACCglobalDecl;
import exc.openacc.ACCpragma;
import exc.openacc.ACCutil;
import exc.openacc.AccDirective;
import exc.openacc.AccInformation;
import java.util.HashSet;

class AccAtomic
extends AccDirective {
    private Xtype _type;
    private Xcode _operator;
    private Xobject _operand;
    private Xobject _val;
    private boolean _capturesNewValue;
    private Xobject _capture;

    AccAtomic(ACCglobalDecl aCCglobalDecl, AccInformation accInformation, PragmaBlock pragmaBlock) {
        super(aCCglobalDecl, accInformation, pragmaBlock);
    }

    @Override
    void analyze() throws ACCexception {
        super.analyze();
        HashSet<ACCpragma> hashSet = new HashSet<ACCpragma>(){
            {
                this.add(ACCpragma.READ);
                this.add(ACCpragma.WRITE);
                this.add(ACCpragma.UPDATE);
                this.add(ACCpragma.CAPTURE);
            }
        };
        ACCpragma aCCpragma = ACCpragma.UPDATE;
        int n = 0;
        for (ACCpragma aCCpragma2 : hashSet) {
            if (!this._info.hasClause(aCCpragma2)) continue;
            aCCpragma = aCCpragma2;
            ++n;
        }
        if (n > 1) {
            throw new ACCexception("more than one attributes are specified");
        }
        switch (aCCpragma) {
            case UPDATE: {
                this.checkUpdateStatement();
                break;
            }
            case CAPTURE: {
                this.checkCaptureStatementOrStructuredBlock();
                break;
            }
            default: {
                throw new ACCexception("'" + aCCpragma.getName() + "' is not supported");
            }
        }
    }

    @Override
    void generate() throws ACCexception {
    }

    @Override
    void rewrite() throws ACCexception {
    }

    @Override
    boolean isAcceptableClause(ACCpragma aCCpragma) {
        switch (aCCpragma) {
            case UPDATE: 
            case CAPTURE: 
            case READ: 
            case WRITE: {
                return true;
            }
        }
        return false;
    }

    private void checkUpdateStatement() throws ACCexception {
        BlockList blockList = this._pb.getBody();
        if (blockList.isEmpty() || !blockList.isSingle()) {
            throw new ACCexception("not a single statement");
        }
        Statement statement = this.getSingleStatement(blockList.getHead());
        Xobject xobject = statement.getExpr();
        this.checkUpdateExpr(xobject);
    }

    private void checkUpdateExpr(Xobject xobject) throws ACCexception {
        Xcode xcode = xobject.Opcode();
        switch (xcode) {
            case POST_DECR_EXPR: 
            case POST_INCR_EXPR: 
            case PRE_DECR_EXPR: 
            case PRE_INCR_EXPR: {
                this._operand = xobject.getArg(0);
                this._val = null;
                this._operator = xcode;
                break;
            }
            case ASG_PLUS_EXPR: 
            case ASG_MUL_EXPR: 
            case ASG_MINUS_EXPR: 
            case ASG_DIV_EXPR: 
            case ASG_BIT_AND_EXPR: 
            case ASG_BIT_XOR_EXPR: 
            case ASG_BIT_OR_EXPR: 
            case ASG_LSHIFT_EXPR: 
            case ASG_RSHIFT_EXPR: {
                this._operand = xobject.getArg(0);
                this._val = xobject.getArg(1);
                this._operator = xcode;
                break;
            }
            case ASSIGN_EXPR: {
                Xobject xobject2 = xobject.left();
                Xobject xobject3 = xobject.right();
                Xobject xobject4 = xobject3.left();
                Xobject xobject5 = xobject3.right();
                boolean bl = xobject2.equals(xobject4);
                boolean bl2 = xobject2.equals(xobject5);
                if (bl && !bl2) {
                    this._operand = xobject2;
                    this._val = xobject5;
                    this._operator = xobject3.Opcode();
                    break;
                }
                if (!bl && bl2) {
                    this._operand = xobject2;
                    this._val = xobject4;
                    this._operator = xobject3.Opcode();
                    if (this._operator != Xcode.MINUS_EXPR && this._operator != Xcode.DIV_EXPR) break;
                    throw new ACCexception("'x = expr {-,/} x' is not supported yet");
                }
                throw new ACCexception("not vaild");
            }
            default: {
                throw new ACCexception("unsupported statement");
            }
        }
        this._type = this._operand.Type();
        if (!this._type.isNumeric()) {
            throw new ACCexception("not numerical");
        }
    }

    void checkCaptureStatementOrStructuredBlock() throws ACCexception {
        BlockList blockList = this._pb.getBody();
        if (blockList.isEmpty() || !blockList.isSingle()) {
            throw new ACCexception("not a single block");
        }
        Statement statement = this.getSingleStatement(blockList.getHead());
        if (statement == null) {
            throw new ACCexception("capture clause for structured-block is unimplemented");
        }
        Xobject xobject = statement.getExpr();
        if (xobject.Opcode() != Xcode.ASSIGN_EXPR) {
            throw new ACCexception("no captured value");
        }
        Xobject xobject2 = xobject.left();
        Xobject xobject3 = xobject.right();
        this.checkUpdateExpr(xobject3);
        this._capture = xobject2;
        switch (this._operator) {
            case POST_DECR_EXPR: 
            case POST_INCR_EXPR: {
                this._capturesNewValue = false;
                break;
            }
            default: {
                this._capturesNewValue = true;
            }
        }
    }

    Block makeAtomicBlock() throws ACCexception {
        Xobject xobject = this.makeCudaAtomicFuncCall(Xcons.AddrOf(this._operand), this._val, this._operator);
        return Bcons.Statement(Xcons.List(xobject));
    }

    private Statement getSingleStatement(Block block) {
        if (block.Opcode() != Xcode.LIST) {
            return null;
        }
        BasicBlock basicBlock = block.getBasicBlock();
        if (basicBlock.isSingle()) {
            return basicBlock.getHead();
        }
        return null;
    }

    private Xobject makeCudaAtomicFuncCall(Xobject xobject, Xobject xobject2, Xcode xcode) throws ACCexception {
        String string;
        if (!xobject.Type().isPointer()) {
            throw new ACCexception("not addr");
        }
        if (this._capturesNewValue) {
            throw new ACCexception("capturing new value is unimplemented");
        }
        Xtype xtype = null;
        switch (xcode) {
            case POST_INCR_EXPR: 
            case PRE_INCR_EXPR: {
                xobject2 = Xcons.IntConstant(1);
            }
            case ASG_PLUS_EXPR: 
            case PLUS_EXPR: {
                string = "Add";
                xtype = this.getCudaAtomicAddCastType();
                break;
            }
            case POST_DECR_EXPR: 
            case PRE_DECR_EXPR: {
                xobject2 = Xcons.IntConstant(1);
            }
            case ASG_MINUS_EXPR: 
            case MINUS_EXPR: {
                string = "Add";
                xtype = this.getCudaAtomicAddCastType();
                xobject2 = Xcons.unaryOp(Xcode.UNARY_MINUS_EXPR, xobject2);
                break;
            }
            case ASG_BIT_AND_EXPR: 
            case BIT_AND_EXPR: {
                string = "And";
                break;
            }
            case ASG_BIT_XOR_EXPR: 
            case BIT_XOR_EXPR: {
                string = "Xor";
                break;
            }
            case ASG_BIT_OR_EXPR: 
            case BIT_OR_EXPR: {
                string = "Or";
                break;
            }
            case ASG_MUL_EXPR: 
            case ASG_DIV_EXPR: 
            case ASG_LSHIFT_EXPR: 
            case ASG_RSHIFT_EXPR: 
            case MUL_EXPR: 
            case DIV_EXPR: 
            case LSHIFT_EXPR: 
            case RSHIFT_EXPR: {
                throw new ACCexception("unimplemented operator");
            }
            default: {
                throw new ACCexception("unsupported operator");
            }
        }
        if (xtype != null) {
            xobject = Xcons.Cast(Xtype.Pointer(xtype), xobject);
            xobject2 = Xcons.Cast(xtype, xobject2);
        } else {
            xobject = Xcons.Cast(Xtype.Pointer(this._type), xobject);
            xobject2 = Xcons.Cast(this._type, xobject2);
        }
        Ident ident = ACCutil.getMacroFuncId("atomic" + string, xtype);
        XobjList xobjList = Xcons.List(xobject);
        if (xobject2 != null) {
            xobjList.add(xobject2);
        }
        Xobject xobject3 = ident.Call(xobjList);
        if (this._capture != null) {
            return Xcons.Set(this._capture, xobject3);
        }
        return xobject3;
    }

    private Xtype getCudaAtomicAddCastType() {
        if (this._type.equals(Xtype.longType) || this._type.equals(Xtype.unsignedlongType)) {
            return Xtype.unsignedlonglongType;
        }
        if (this._type.equals(Xtype.longlongType)) {
            return Xtype.unsignedlonglongType;
        }
        return null;
    }
}

