/*
 * Decompiled with CFR 0.152.
 */
package exc.openacc;

import exc.object.ArrayType;
import exc.object.Ident;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjArgs;
import exc.object.XobjList;
import exc.object.XobjString;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.openacc.ACC;
import exc.openacc.ACCexception;
import exc.openacc.ACCpragma;
import exc.openacc.ACCutil;
import java.util.EnumSet;

public class ACCvar {
    public static final String prop = "_ACC_VAR";
    private final String symbol;
    private Ident id;
    private final EnumSet<Attribute> atrEnumSet = EnumSet.noneOf(Attribute.class);
    private ACCpragma dataClause = null;
    private Ident deviceptr = null;
    private Ident hostDesc = null;
    private ACCpragma reductionOp = null;
    private int dim;
    private Xtype elementType;
    private XobjList rangeList = Xcons.List();
    private boolean isSubarray = false;
    private XobjList _subscripts;
    private int pointerDimBit;
    private ACCvar _parent;

    ACCvar(Ident ident, ACCpragma aCCpragma, ACCvar aCCvar) throws ACCexception {
        this(ident, null, aCCpragma, aCCvar);
    }

    ACCvar(Ident ident, XobjList xobjList, ACCpragma aCCpragma, ACCvar aCCvar) throws ACCexception {
        this.id = ident;
        if (aCCpragma != ACCpragma.USE_DEVICE) {
            if (xobjList != null && !xobjList.isEmpty()) {
                this.rangeList = this.makeRange(xobjList);
                this.isSubarray = true;
            } else {
                this.rangeList = this.makeRange(ident.Type());
            }
        }
        this.dim = this.rangeList.Nargs();
        this.setAttribute(aCCpragma);
        if (aCCvar == null || ident == aCCvar.getId()) {
            // empty if block
        }
        this.symbol = ident.getSym();
    }

    ACCvar(String string) {
        this.symbol = string;
        this.id = null;
    }

    ACCvar(Xobject xobject, ACCpragma aCCpragma) throws ACCexception {
        XobjList xobjList = null;
        if (xobject.Opcode() == Xcode.LIST) {
            Xobject xobject2 = xobject.getArg(0);
            this.symbol = xobject2.getName();
            xobjList = (XobjList)xobject.copy();
            xobjList.removeFirstArgs();
        } else {
            this.symbol = xobject.getName();
        }
        if (xobjList != null && !xobjList.isEmpty()) {
            this._subscripts = xobjList;
            this.isSubarray = true;
        } else {
            this._subscripts = null;
        }
        this.dim = 0;
        this.setAttribute(aCCpragma);
        this.id = null;
    }

    private void setAttribute(ACCpragma aCCpragma) throws ACCexception {
        boolean bl = false;
        if (aCCpragma.isDataClause() && bl) {
            ACC.fatal("ACCvar: " + this.id.getName() + " is already specified data attribute");
        }
        if (aCCpragma.isReduction()) {
            this.atrEnumSet.add(Attribute.isReduction);
            this.reductionOp = aCCpragma;
            return;
        }
        switch (aCCpragma) {
            case COPY: {
                this.atrEnumSet.add(Attribute.create);
                this.atrEnumSet.add(Attribute.copyHostToDevice);
                this.atrEnumSet.add(Attribute.copyDeviceToHost);
                break;
            }
            case COPYIN: {
                this.atrEnumSet.add(Attribute.create);
                this.atrEnumSet.add(Attribute.copyHostToDevice);
                break;
            }
            case COPYOUT: {
                this.atrEnumSet.add(Attribute.create);
                this.atrEnumSet.add(Attribute.copyDeviceToHost);
                break;
            }
            case CREATE: {
                this.atrEnumSet.add(Attribute.create);
                break;
            }
            case DELETE: {
                this.atrEnumSet.add(Attribute.delete);
                break;
            }
            case PRESENT: {
                this.atrEnumSet.add(Attribute.isPresent);
                break;
            }
            case PRESENT_OR_COPY: {
                this.atrEnumSet.add(Attribute.isPresentOr);
                this.atrEnumSet.add(Attribute.create);
                this.atrEnumSet.add(Attribute.copyHostToDevice);
                this.atrEnumSet.add(Attribute.copyDeviceToHost);
                break;
            }
            case PRESENT_OR_COPYIN: {
                this.atrEnumSet.add(Attribute.isPresentOr);
                this.atrEnumSet.add(Attribute.create);
                this.atrEnumSet.add(Attribute.copyHostToDevice);
                break;
            }
            case PRESENT_OR_COPYOUT: {
                this.atrEnumSet.add(Attribute.isPresentOr);
                this.atrEnumSet.add(Attribute.create);
                this.atrEnumSet.add(Attribute.copyDeviceToHost);
                break;
            }
            case PRESENT_OR_CREATE: {
                this.atrEnumSet.add(Attribute.isPresentOr);
                this.atrEnumSet.add(Attribute.create);
                break;
            }
            case DEVICEPTR: {
                this.atrEnumSet.add(Attribute.isDeviceptr);
                break;
            }
            case PRIVATE: {
                this.atrEnumSet.add(Attribute.isPrivate);
                break;
            }
            case FIRSTPRIVATE: {
                this.atrEnumSet.add(Attribute.isFirstprivate);
                break;
            }
            case CACHE: {
                this.atrEnumSet.add(Attribute.isCache);
                break;
            }
            case HOST: {
                this.atrEnumSet.add(Attribute.copyDeviceToHost);
                break;
            }
            case DEVICE: {
                this.atrEnumSet.add(Attribute.copyHostToDevice);
                break;
            }
            case USE_DEVICE: {
                this.atrEnumSet.add(Attribute.isUseDevice);
                this.atrEnumSet.add(Attribute.isPresent);
                break;
            }
            default: {
                throw new ACCexception("var:" + this.id.getName() + ", attribute:" + (Object)((Object)aCCpragma) + " is not valid");
            }
        }
        this.dataClause = aCCpragma;
    }

    public boolean is(ACCpragma aCCpragma) {
        return aCCpragma == this.dataClause || aCCpragma == this.reductionOp;
    }

    public String getName() {
        return this.symbol;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.symbol);
        if (this.rangeList != null) {
            for (Xobject xobject : this.rangeList) {
                stringBuilder.append('[');
                stringBuilder.append(xobject.getArg(0).getName());
                stringBuilder.append(':');
                stringBuilder.append(xobject.getArg(1).getName());
                stringBuilder.append(']');
            }
        }
        return new String(stringBuilder);
    }

    public boolean isPresent() {
        return this.atrEnumSet.contains((Object)Attribute.isPresent);
    }

    public boolean isPresentOr() {
        return this.atrEnumSet.contains((Object)Attribute.isPresentOr);
    }

    public boolean allocatesDeviceMemory() {
        return this.atrEnumSet.contains((Object)Attribute.create);
    }

    public boolean copiesHtoD() {
        return this.atrEnumSet.contains((Object)Attribute.copyHostToDevice);
    }

    public boolean copiesDtoH() {
        return this.atrEnumSet.contains((Object)Attribute.copyDeviceToHost);
    }

    public boolean isPrivate() {
        return this.atrEnumSet.contains((Object)Attribute.isPrivate);
    }

    public boolean isFirstprivate() {
        return this.atrEnumSet.contains((Object)Attribute.isFirstprivate);
    }

    public boolean isReduction() {
        return this.atrEnumSet.contains((Object)Attribute.isReduction);
    }

    public boolean isCache() {
        return this.atrEnumSet.contains((Object)Attribute.isCache);
    }

    public boolean isDeviceptr() {
        return this.atrEnumSet.contains((Object)Attribute.isDeviceptr);
    }

    public boolean is(Attribute attribute) {
        return this.atrEnumSet.contains((Object)attribute);
    }

    public Ident getId() {
        if (this._parent != null) {
            return this._parent.getId();
        }
        return this.id;
    }

    public boolean isUse_device() {
        return this.atrEnumSet.contains((Object)Attribute.isUseDevice);
    }

    public Ident getDevicePtr() {
        if (this._parent != null) {
            return this._parent.getDevicePtr();
        }
        if (this.isDeviceptr()) {
            return this.id;
        }
        return this.deviceptr;
    }

    public void setDevicePtr(Ident ident) {
        this.deviceptr = ident;
    }

    public void setHostDesc(Ident ident) {
        this.hostDesc = ident;
    }

    public Ident getHostDesc() {
        if (this._parent != null) {
            return this._parent.getHostDesc();
        }
        return this.hostDesc;
    }

    public boolean isAllocated() {
        return this.deviceptr != null || this.atrEnumSet.contains((Object)Attribute.create);
    }

    public ACCpragma getDataClause() {
        return this.dataClause;
    }

    public ACCpragma getReductionOperator() {
        return this.reductionOp;
    }

    public boolean contains(XobjList xobjList) {
        return true;
    }

    private void addRange(XobjList xobjList, Xobject xobject, ArrayType arrayType) throws ACCexception {
        Xobject xobject2;
        Xobject xobject3;
        if (xobject.Opcode() != Xcode.LIST) {
            xobject3 = xobject;
            xobject2 = Xcons.IntConstant(1);
        } else {
            xobject3 = xobject.getArg(0);
            xobject2 = xobject.getArgOrNull(1);
            if (xobject2 == null) {
                if (arrayType != null) {
                    xobject2 = Xcons.binaryOp(Xcode.MINUS_EXPR, this.getArraySize(arrayType), xobject3);
                } else {
                    throw new ACCexception("length is unspecified");
                }
            }
        }
        if (arrayType != null && !this.isCorrectRange(arrayType, xobject3, xobject2)) {
            throw new ACCexception("array bound exceeded : " + this.getName());
        }
        xobjList.add(Xcons.List(xobject3, xobject2));
    }

    private XobjList makeRange(XobjList xobjList) throws ACCexception {
        XobjList xobjList2 = Xcons.List();
        Xtype xtype = this.id.Type();
        XobjArgs xobjArgs = xobjList.getArgs();
        this.pointerDimBit = 0;
        int n = 0;
        while (xobjArgs != null) {
            Xobject xobject = xobjArgs.getArg();
            switch (xtype.getKind()) {
                case 6: {
                    ArrayType arrayType = (ArrayType)xtype;
                    this.addRange(xobjList2, xobject, arrayType);
                    xtype = arrayType.getRef();
                    break;
                }
                case 7: {
                    this.addRange(xobjList2, xobject, null);
                    xtype = xtype.getRef();
                    this.pointerDimBit += 1 << n;
                    break;
                }
                default: {
                    throw new ACCexception("too many subscripts");
                }
            }
            if (xobjArgs != null) {
                xobjArgs = xobjArgs.nextArgs();
            }
            ++n;
        }
        if (xtype.isArray()) {
            throw new ACCexception("too few subscripts");
        }
        this.elementType = xtype;
        return xobjList2;
    }

    private boolean isCorrectRange(ArrayType arrayType, Xobject xobject, Xobject xobject2) {
        Xobject xobject3 = this.getArraySize(arrayType);
        if (xobject3 == null) {
            return true;
        }
        if (!(xobject3 = ACCutil.foldIntConstant_mod(xobject3)).isIntConstant()) {
            return true;
        }
        int n = xobject3.getInt();
        Xobject xobject4 = ACCutil.foldIntConstant_mod(xobject);
        Xobject xobject5 = ACCutil.foldIntConstant_mod(xobject2);
        int n2 = 0;
        int n3 = 1;
        if (xobject4.isIntConstant()) {
            n2 = xobject4.getInt();
        }
        if (xobject5.isIntConstant()) {
            n3 = xobject5.getInt();
        }
        if (n2 < 0 || n3 < 1) {
            return false;
        }
        return n2 + n3 <= n;
    }

    private XobjList makeRange(Xtype xtype) throws ACCexception {
        XobjList xobjList = Xcons.List();
        this.pointerDimBit = 0;
        if (this.isDeviceptr()) {
            xobjList.add(Xcons.List(Xcons.IntConstant(0)));
            return xobjList;
        }
        int n = 0;
        while (true) {
            switch (xtype.getKind()) {
                case 6: {
                    ArrayType arrayType = (ArrayType)xtype;
                    Xobject xobject = this.getArraySize(arrayType);
                    if (xobject == null) {
                        throw new ACCexception("array size of '" + this.getName() + "' is unknown");
                    }
                    xobjList.add(Xcons.List(Xcons.IntConstant(0), xobject));
                    xtype = arrayType.getRef();
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.elementType = xtype;
                    return xobjList;
                }
                case 7: {
                    ACC.warning("pointer '" + this.getName() + "' is treated as \"" + this.getName() + "[0:1]\"");
                    xobjList.add(Xcons.List(Xcons.IntConstant(0), Xcons.IntConstant(1)));
                    xtype = xtype.getRef();
                    this.pointerDimBit += 1 << n;
                    break;
                }
                default: {
                    ACC.fatal("unsupposed type");
                }
            }
            ++n;
        }
    }

    private Xobject getArraySize(ArrayType arrayType) {
        long l = arrayType.getArraySize();
        if (l <= 0L) {
            return arrayType.getArraySizeExpr();
        }
        if (l > Integer.MAX_VALUE) {
            return Xcons.LongLongConstant(0L, l);
        }
        return Xcons.IntConstant((int)l);
    }

    public Xobject getAddress() throws ACCexception {
        Xtype xtype = this.id.Type();
        switch (xtype.getKind()) {
            case 1: 
            case 3: 
            case 4: {
                return this.id.getAddr();
            }
            case 7: {
                return this.id.Ref();
            }
            case 6: {
                ArrayType arrayType = (ArrayType)xtype;
                switch (arrayType.getArrayElementType().getKind()) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 7: {
                        return this.id.Ref();
                    }
                }
                throw new ACCexception("array '" + this.getName() + "' has a wrong data type for acc data");
            }
        }
        throw new ACCexception("'" + this.getName() + "' has a wrong data type for acc data");
    }

    public Xobject getSize() {
        Xobject xobject = Xcons.SizeOf(this.elementType);
        for (Xobject xobject2 : this.rangeList) {
            xobject = Xcons.binaryOp(Xcode.MUL_EXPR, xobject, xobject2.left());
        }
        return xobject;
    }

    public boolean conllidesWith(XobjList xobjList) {
        int n = Math.max(this.rangeList.Nargs(), xobjList.Nargs());
        for (int i = 0; i < n; ++i) {
            Xobject xobject = this.rangeList.getArg(i);
            Xobject xobject2 = xobjList.getArg(i);
            long l = 0L;
            long l2 = 1L;
            long l3 = 0L;
            long l4 = 1L;
            try {
                if (xobject.Opcode() != Xcode.LIST) {
                    l = this.toLong(xobject);
                } else {
                    l = this.toLong(xobject.getArg(0));
                    l2 = this.toLong(xobject.getArgOrNull(1));
                }
                if (xobject2.Opcode() != Xcode.LIST) {
                    l3 = this.toLong(xobject2);
                } else {
                    l3 = this.toLong(xobject2.getArg(0));
                    l4 = this.toLong(xobject2.getArgOrNull(1));
                }
            }
            catch (ACCexception aCCexception) {
                return false;
            }
            if (!this.hasIntersect(l, l2, l3, l4)) continue;
            return true;
        }
        return false;
    }

    private long toLong(Xobject xobject) throws ACCexception {
        if (xobject == null) {
            throw new ACCexception("null");
        }
        if (xobject.isIntConstant()) {
            return xobject.getInt();
        }
        if (xobject.Opcode() == Xcode.LONGLONG_CONSTANT) {
            return xobject.getLong();
        }
        throw new ACCexception("not constant");
    }

    private boolean hasIntersect(long l, long l2, long l3, long l4) {
        if (l < l3) {
            return l + l2 > l3;
        }
        return l3 + l4 > l;
    }

    public XobjList getSubscripts() {
        return this.rangeList;
    }

    public boolean isSubarray() {
        return this.isSubarray;
    }

    public Xtype getElementType() {
        if (this._parent != null) {
            return this._parent.getElementType();
        }
        return this.elementType;
    }

    public int getDim() {
        return this.dim;
    }

    public boolean isArray() {
        if (this._parent != null) {
            return this._parent.isArray();
        }
        return this.dim > 0;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Xobject toXobject() {
        XobjString xobjString = Xcons.Symbol(Xcode.VAR, this.symbol);
        if (this.rangeList == null) {
            return xobjString;
        }
        XobjList xobjList = Xcons.List(xobjString);
        xobjList.mergeList(this.rangeList);
        return xobjList;
    }

    public void setIdent(Ident ident) throws ACCexception {
        this.id = ident;
        if (this._subscripts != null && !this._subscripts.isEmpty()) {
            this.rangeList = this.makeRange(this._subscripts);
            this.isSubarray = true;
        } else {
            this.rangeList = this.makeRange(ident.Type());
        }
        this.dim = this.rangeList.Nargs();
    }

    public void setParent(ACCvar aCCvar) throws ACCexception {
        this._parent = aCCvar;
        this.id = aCCvar.getId();
        if (this._subscripts != null && !this._subscripts.isEmpty()) {
            this.rangeList = this.makeRange(this._subscripts);
            this.isSubarray = true;
        } else {
            this.rangeList = this._parent.rangeList;
        }
        this.dim = this.rangeList.Nargs();
    }

    ACCvar getParent() {
        return this._parent;
    }

    int getPointerDimBit() {
        return this.pointerDimBit;
    }

    public static enum Attribute {
        isPresent,
        isPresentOr,
        create,
        delete,
        copyHostToDevice,
        copyDeviceToHost,
        isFirstprivate,
        isPrivate,
        isCache,
        isUseDevice,
        isReduction,
        isDeviceptr;

    }
}

