/*
 * Decompiled with CFR 0.152.
 */
package exc.openacc;

import exc.block.Bcons;
import exc.block.Block;
import exc.block.BlockList;
import exc.object.ArrayType;
import exc.object.Ident;
import exc.object.StorageClass;
import exc.object.VarScope;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.openacc.ACCexception;

class ACCutil {
    ACCutil() {
    }

    public static long getArrayElmtCount(Xtype xtype) throws ACCexception {
        if (xtype.isArray()) {
            ArrayType arrayType = (ArrayType)xtype;
            long l = arrayType.getArraySize();
            if (l == 0L || l == -1L) {
                throw new ACCexception("array size should be declared statically");
            }
            return l * ACCutil.getArrayElmtCount(arrayType.getRef());
        }
        return 1L;
    }

    public static Xobject getArrayElmtCountObj(Xtype xtype) throws ACCexception {
        if (xtype.isArray()) {
            ArrayType arrayType = (ArrayType)xtype;
            long l = arrayType.getArraySize();
            if (l == 0L) {
                throw new ACCexception("array size should be declared statically");
            }
            Xobject xobject = l == -1L ? arrayType.getArraySizeExpr() : Xcons.LongLongConstant(0L, l);
            return Xcons.binaryOp(Xcode.MUL_EXPR, xobject, ACCutil.getArrayElmtCountObj(arrayType.getRef()));
        }
        return Xcons.IntConstant(1);
    }

    public static Ident getMacroFuncId(String string, Xtype xtype) {
        return new Ident(string, StorageClass.EXTERN, Xtype.Function(xtype), Xcons.Symbol(Xcode.FUNC_ADDR, Xtype.Pointer(Xtype.Function(xtype)), string), VarScope.GLOBAL);
    }

    public static boolean hasElmt(XobjList xobjList, String string) {
        for (Xobject xobject : xobjList) {
            if (xobject == null || xobject.Opcode() != Xcode.STRING || !xobject.getString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasIdent(XobjList xobjList, String string) {
        for (Xobject xobject : xobjList) {
            Ident ident = (Ident)xobject;
            if (ident == null || !ident.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static Ident getIdent(XobjList xobjList, String string) {
        for (Xobject xobject : xobjList) {
            Ident ident = (Ident)xobject;
            if (ident == null || !ident.getName().equals(string)) continue;
            return ident;
        }
        return null;
    }

    public static Block createFuncCallBlock(String string, XobjList xobjList) {
        Ident ident = ACCutil.getMacroFuncId(string, Xtype.voidType);
        return Bcons.Statement(ident.Call(xobjList));
    }

    public static XobjList getDecls(XobjList xobjList) {
        XobjList xobjList2 = Xcons.List();
        for (Xobject xobject : xobjList) {
            Ident ident = (Ident)xobject;
            xobjList2.add(Xcons.List(Xcode.VAR_DECL, ident, null, null));
        }
        return xobjList2;
    }

    public static XobjList getRefs(XobjList xobjList) {
        XobjList xobjList2 = Xcons.List();
        for (Xobject xobject : xobjList) {
            Ident ident = (Ident)xobject;
            xobjList2.add(ident.Ref());
        }
        return xobjList2;
    }

    public static Xobject foldIntConstant(Xobject xobject) {
        if (xobject.isBinaryOp()) {
            Xcode xcode = xobject.Opcode();
            Xobject xobject2 = ACCutil.foldIntConstant(xobject.left());
            Xobject xobject3 = ACCutil.foldIntConstant(xobject.right());
            if (xobject2.isIntConstant() && xobject3.isIntConstant()) {
                switch (xcode) {
                    case PLUS_EXPR: {
                        return Xcons.IntConstant(xobject2.getInt() + xobject3.getInt());
                    }
                    case MINUS_EXPR: {
                        return Xcons.IntConstant(xobject2.getInt() - xobject3.getInt());
                    }
                    case MUL_EXPR: {
                        return Xcons.IntConstant(xobject2.getInt() * xobject3.getInt());
                    }
                    case DIV_EXPR: {
                        return Xcons.IntConstant(xobject2.getInt() / xobject3.getInt());
                    }
                }
            }
        }
        return xobject;
    }

    public static Xobject foldIntConstant_mod(Xobject xobject) {
        if (xobject.isBinaryOp()) {
            boolean bl;
            Xcode xcode = xobject.Opcode();
            Xobject xobject2 = ACCutil.foldIntConstant(xobject.left());
            Xobject xobject3 = ACCutil.foldIntConstant(xobject.right());
            boolean bl2 = xobject2.isIntConstant() || xobject2.Opcode() == Xcode.LONGLONG_CONSTANT;
            boolean bl3 = bl = xobject3.isIntConstant() || xobject3.Opcode() == Xcode.LONGLONG_CONSTANT;
            if (bl2 && bl) {
                long l = xobject2.isIntConstant() ? (long)xobject2.getInt() : ACCutil.getLong(xobject2);
                long l2 = xobject3.isIntConstant() ? (long)xobject3.getInt() : ACCutil.getLong(xobject3);
                switch (xcode) {
                    case PLUS_EXPR: {
                        long l3 = l + l2;
                        break;
                    }
                    case MINUS_EXPR: {
                        long l4 = l - l2;
                        break;
                    }
                    case MUL_EXPR: {
                        long l5 = l * l2;
                        break;
                    }
                    case DIV_EXPR: {
                        long l6 = l / l2;
                        break;
                    }
                    case MOD_EXPR: {
                        long l7 = l % l2;
                        break;
                    }
                }
            }
        }
        return xobject;
    }

    public static long getLong(Xobject xobject) {
        long l = xobject.getLongLow();
        long l2 = xobject.getLongHigh();
        return l2 << (int)(32L + l);
    }

    public static String removeExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static Block createFuncCallBlockWithArrayRange(String string, XobjList xobjList, XobjList xobjList2) {
        XobjList xobjList3 = xobjList != null ? (XobjList)xobjList.copy() : Xcons.List();
        int n = 0;
        BlockList blockList = Bcons.emptyBody();
        XobjList xobjList4 = Xcons.List();
        for (Xobject xobject : xobjList2) {
            Xobject xobject2;
            XobjList xobjList5 = (XobjList)xobject;
            if (xobjList5 != null && !xobjList5.isEmpty()) {
                xobject2 = blockList.declLocalIdent("_ACC_funcarg_" + n, Xtype.Array((Xtype)Xtype.unsignedlonglongType, null));
                ((Ident)xobject2).setIsDeclared(true);
                xobjList4.add(Xcons.List(Xcode.VAR_DECL, xobject2, xobjList5, null));
                xobjList3.add(((Ident)xobject2).Ref());
            } else {
                xobject2 = Xcons.Cast(Xtype.voidPtrType, Xcons.IntConstant(0));
                xobjList3.add(xobject2);
            }
            ++n;
        }
        blockList.setDecls(xobjList4);
        blockList.add(ACCutil.createFuncCallBlock(string, xobjList3));
        return Bcons.COMPOUND(blockList);
    }
}

