/*
 * Decompiled with CFR 0.152.
 */
package exc.openacc;

import exc.object.Ident;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.XobjectFile;
import exc.object.Xtype;
import exc.openacc.ACC;
import exc.openacc.ACCglobalDecl;
import exc.openacc.ACCgpuDecompileWriter;
import exc.openacc.ACCutil;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import xcodeml.util.XmOption;

class ACCgpuDecompiler {
    private static final int BUFFER_SIZE = 4096;
    private final String CUDA_SRC_EXTENSION = ".cu";
    private final String OPENCL_SRC_EXTENSION = ".cl";
    public static final String GPU_FUNC_CONF = "OEPNACC_GPU_FUNC_CONF_PROP";
    public static final String GPU_FUNC_CONF_ASYNC = "OEPNACC_GPU_FUNC_CONF_ASYNC_PROP";
    public static final String GPU_FUNC_CONF_SHAREDMEMORY = "OEPNACC_GPU_FUNC_CONF_SHAREDMEMORY_PROP";
    public static final String GPU_STRAGE_SHARED = "OPENACC_GPU_SHARED";

    ACCgpuDecompiler() {
    }

    public void decompile(ACCglobalDecl aCCglobalDecl) {
        Object object;
        XobjectFile xobjectFile = aCCglobalDecl.getEnv();
        XobjectFile xobjectFile2 = aCCglobalDecl.getEnvDevice();
        if (xobjectFile2.getDefs().isEmpty()) {
            return;
        }
        xobjectFile2.collectAllTypes();
        XobjList xobjList = (XobjList)xobjectFile.getGlobalIdentList();
        XobjList xobjList2 = (XobjList)xobjectFile2.getGlobalIdentList();
        for (Xtype object2 : xobjectFile2.getTypeList()) {
            if (!object2.isStruct() && !object2.isEnum() && !object2.isUnion() || (object = this.findIdent(xobjList, object2)) == null) continue;
            xobjList2.cons((Xobject)object);
            object2.setTagIdent((Ident)object);
        }
        try {
            Object object3 = ACCutil.removeExtension(xobjectFile.getSourceFileName());
            switch (ACC.platform) {
                case CUDA: {
                    object3 = (String)object3 + ".cu";
                    break;
                }
                case OpenCL: {
                    object3 = (String)object3 + ".cl";
                    break;
                }
                default: {
                    ACC.fatal("unknown platform");
                }
            }
            xobjectFile2.setProgramAttributes((String)object3, "CUDA", "", "", "");
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter((String)object3), 4096);
            object = new ACCgpuDecompileWriter((Writer)bufferedWriter, xobjectFile2);
            ArrayList<String> arrayList = new ArrayList<String>();
            switch (ACC.platform) {
                case CUDA: {
                    arrayList.add("#include \"acc.h\"");
                    arrayList.add("#include \"acc_gpu_func.hpp\"");
                    break;
                }
                case OpenCL: {
                    arrayList.add("#include \"acc_cl.h\"");
                    break;
                }
                default: {
                    ACC.fatal("unknown platform");
                }
            }
            if (XmOption.isXcalableMP()) {
                arrayList.add("#include \"xmp_index_macro.h\"");
            }
            for (String string : arrayList) {
                ((PrintWriter)object).println(string);
            }
            ((PrintWriter)object).println();
            ((ACCgpuDecompileWriter)object).printAll();
            ((PrintWriter)object).flush();
            ((PrintWriter)object).close();
        }
        catch (IOException iOException) {
            ACC.fatal("error in gpu decompiler: " + iOException.getMessage());
        }
    }

    private Ident findIdent(XobjList xobjList, Xtype xtype) {
        for (Xobject xobject : xobjList) {
            Ident ident = (Ident)xobject;
            if (ident.Type() != xtype) continue;
            return ident;
        }
        return null;
    }
}

