/*
 * Decompiled with CFR 0.152.
 */
package exc.openacc;

import exc.block.Bcons;
import exc.block.BlockList;
import exc.object.FunctionType;
import exc.object.Ident;
import exc.object.StorageClass;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectFile;
import exc.object.Xtype;
import exc.object.topdownXobjectDefIterator;
import exc.openacc.ACC;
import exc.openacc.ACCexception;
import exc.openacc.ACCutil;
import exc.openacc.ACCvar;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ACCglobalDecl {
    private static final String ACC_DESTRUCTOR_FUNC_PREFIX = "acc_traverse_finalize_file_";
    private static final String ACC_CONSTRUCTOR_FUNC_PREFIX = "acc_traverse_init_file_";
    private static final String ACC_TRAVERSE_INIT_FUNC_NAME = "acc_traverse_init";
    private static final String ACC_TRAVERSE_FINALIZE_FUNC_NAME = "acc_traverse_finalize";
    private static final String ACC_KERNELS_FINALIZE_FUNC_NAME = "_ACC_program_finalize";
    public static final String ACC_KERNELS_INIT_FUNC_NAME = "_ACC_program_init";
    private XobjectFile _env;
    private XobjList _globalConstructorFuncBody;
    private XobjList _globalDestructorFuncBody;
    private XobjectFile _env_device;
    private Map<Ident, ACCvar> globalVarMap = new HashMap<Ident, ACCvar>();
    private List<String> _kernelNames = new ArrayList<String>();
    private Ident _programId = null;
    private static String ACC_INIT_FUNC_NAME = "_ACC_init";
    private static String ACC_FINALIZE_FUNC_NAME = "_ACC_finalize";
    private static String ACC_GPU_INIT_FUNC_NAME = "_ACC_gpu_init";
    private static String ACC_GPU_FINALIZE_FUNC_NAME = "_ACC_gpu_finalize";

    public ACCglobalDecl(XobjectFile xobjectFile) {
        this._env = xobjectFile;
        this._globalConstructorFuncBody = Xcons.List();
        this._globalDestructorFuncBody = Xcons.List();
        this._env_device = new XobjectFile();
        this._env_device.setIdentList(Xcons.IDList());
    }

    public XobjectFile getEnv() {
        return this._env;
    }

    public XobjectFile getEnvDevice() {
        return this._env_device;
    }

    public void setupGlobalConstructor() {
        Ident ident = Ident.Param("argv", Xtype.Pointer(Xtype.Pointer(Xtype.charType)));
        Ident ident2 = Ident.Param("argc", Xtype.intType);
        XobjList xobjList = Xcons.IDList();
        xobjList.add(ident2);
        xobjList.add(ident);
        XobjList xobjList2 = Xcons.List(ident2.Ref(), ident.Ref());
        FunctionType functionType = Xtype.Function(Xtype.voidType);
        String string = this.getSourceBaseName();
        Ident ident3 = this._env.declExternIdent(ACC_CONSTRUCTOR_FUNC_PREFIX + string, functionType);
        this._env.add(XobjectDef.Func(ident3, null, null, Xcons.List(Xcode.COMPOUND_STATEMENT, new Xobject[]{null, null, this._globalConstructorFuncBody})));
    }

    public void setupGlobalDestructor() {
        FunctionType functionType = Xtype.Function(Xtype.voidType);
        String string = this.getSourceBaseName();
        Ident ident = this._env.declExternIdent(ACC_DESTRUCTOR_FUNC_PREFIX + string, functionType);
        this._env.add(XobjectDef.Func(ident, null, null, Xcons.List(Xcode.COMPOUND_STATEMENT, new Xobject[]{null, null, this._globalDestructorFuncBody})));
    }

    public void setupMain() {
        topdownXobjectDefIterator topdownXobjectDefIterator2 = new topdownXobjectDefIterator(this._env);
        topdownXobjectDefIterator2.init();
        while (!topdownXobjectDefIterator2.end()) {
            XobjectDef xobjectDef = topdownXobjectDefIterator2.getDef();
            if (xobjectDef.isFuncDef() && xobjectDef.getName().equals("main")) {
                try {
                    this.addArgsIntoMain(xobjectDef);
                    this.replaceMain(xobjectDef);
                }
                catch (ACCexception aCCexception) {
                    ACC.fatal(aCCexception.getMessage());
                }
                break;
            }
            topdownXobjectDefIterator2.next();
        }
    }

    public void addGlobalConstructor(Xobject xobject) {
        this._globalConstructorFuncBody.add(xobject);
    }

    public void addGlobalDestructor(Xobject xobject) {
        this._globalDestructorFuncBody.add(xobject);
    }

    Ident declExternFunc(String string) {
        return ACCutil.getMacroFuncId(string, Xtype.voidType);
    }

    public Ident declExternIdent(String string, Xtype xtype) {
        return this._env.declExternIdent(string, xtype);
    }

    public Ident declGlobalIdent(String string, Xtype xtype) {
        return this._env.declGlobalIdent(string, xtype);
    }

    public void finish() {
        this._env.collectAllTypes();
        this._env.fixupTypeRef();
    }

    public void setupHeaderInclude() {
        this._env.addHeaderLine("# include \"acc.h\"");
    }

    public Ident findVarIdent(String string) {
        return this._env.findVarIdent(string);
    }

    private void addArgsIntoMain(XobjectDef xobjectDef) throws ACCexception {
        Xobject xobject = xobjectDef.getFuncIdList();
        int n = xobject.Nargs();
        Ident ident = Ident.Param("argc", Xtype.intType);
        Ident ident2 = Ident.Param("argv", Xtype.Pointer(Xtype.Pointer(Xtype.charType)));
        Ident ident3 = this.findVarIdent("main");
        if (n == 1) {
            xobject.add(ident2);
            ((FunctionType)ident3.Type()).setFuncParamIdList(xobject);
        } else if (n == 0) {
            xobject.add(ident);
            xobject.add(ident2);
            ((FunctionType)ident3.Type()).setFuncParamIdList(xobject);
        }
        Xobject xobject2 = xobject.getArgOrNull(0);
        Xobject xobject3 = xobject.getArgOrNull(1);
        this.checkFirstArg(xobject2);
        this.checkSecondArg(xobject3);
    }

    private void checkFirstArg(Xobject xobject) throws ACCexception {
        if (!xobject.Type().isBasic()) {
            throw new ACCexception("Type of first argument in main() must be an interger.");
        }
        if (xobject.Type().getBasicType() != 7) {
            throw new ACCexception("Type of first argument in main() must be an interger.");
        }
    }

    private void checkSecondArg(Xobject xobject) throws ACCexception {
        if (!xobject.Type().isPointer()) {
            throw new ACCexception("Type of second argument in main() must be char **.");
        }
        boolean bl = false;
        if (xobject.Type().getRef().isPointer() && xobject.Type().getRef().getRef().isBasic() && xobject.Type().getRef().getRef().getBasicType() == 3) {
            bl = true;
        }
        if (!bl) {
            throw new ACCexception("Type of second argument in main() must be char **.");
        }
    }

    private void replaceMain(XobjectDef xobjectDef) {
        Xobject xobject;
        Ident ident = this._env.findVarIdent("main");
        Xtype xtype = ident.Type().getBaseRefType();
        XobjList xobjList = (XobjList)xobjectDef.getFuncIdList();
        Xobject xobject2 = xobjectDef.getFuncDecls();
        Xobject xobject3 = xobjectDef.getFuncBody();
        Ident ident2 = this._env.declStaticIdent("acc_main", Xtype.Function(xtype));
        Ident ident3 = this.declExternIdent(ACC_INIT_FUNC_NAME, Xtype.Function(Xtype.voidType));
        Ident ident4 = this.declExternIdent(ACC_FINALIZE_FUNC_NAME, Xtype.Function(Xtype.voidType));
        Ident ident5 = this.declExternIdent(ACC_TRAVERSE_INIT_FUNC_NAME, Xtype.Function(Xtype.voidType));
        Ident ident6 = this.declExternIdent(ACC_TRAVERSE_FINALIZE_FUNC_NAME, Xtype.Function(Xtype.voidType));
        this._env.add(XobjectDef.Func(ident2, xobjList, xobject2, xobject3));
        BlockList blockList = Bcons.emptyBody();
        blockList.setIdentList(Xcons.IDList());
        blockList.setDecls(Xcons.List());
        XobjList xobjList2 = ACCutil.getRefs(xobjList);
        blockList.add(ident3.Call(xobjList2));
        blockList.add(ident5.Call());
        if (xtype.equals(Xtype.voidType)) {
            blockList.add(ident2.Call(xobjList2));
            blockList.add(ident6.Call());
            blockList.add(ident4.Call(null));
        } else {
            xobject = Ident.Local("r", xtype);
            blockList.addIdent((Ident)xobject);
            blockList.add(Xcons.Set(xobject.Ref(), ident2.Call(xobjList2)));
            blockList.add(ident6.Call());
            blockList.add(ident4.Call(null));
            blockList.add(Xcons.List(Xcode.RETURN_STATEMENT, xobject.Ref()));
        }
        xobject = Xcons.List(Xcode.FUNCTION_DEFINITION, ident, xobjList, xobject2, blockList.toXobject());
        xobjectDef.setDef(xobject);
    }

    private String getSourceBaseName() {
        String string = this._env.getSourceFileName();
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(47);
        return string.substring(n2 + 1, n);
    }

    ACCvar findACCvar(Ident ident) {
        return this.globalVarMap.get(ident);
    }

    void addACCvar(ACCvar aCCvar) {
        Ident ident = aCCvar.getId();
        if (this.globalVarMap.containsKey(ident)) {
            ACC.fatal("variable '" + ident + "' is already declared");
            return;
        }
        this.globalVarMap.put(ident, aCCvar);
    }

    int declKernel(String string) {
        int n = this._kernelNames.size();
        if (n == 0) {
            this._programId = this._env.declStaticIdent("_ACC_program", Xtype.voidPtrType);
        }
        this._kernelNames.add(string);
        return n;
    }

    Ident getProgramId() {
        return this._programId;
    }

    void setupKernelsInitAndFinalize() {
        int n = this._kernelNames.size();
        if (n == 0) {
            return;
        }
        Ident ident = ACCutil.getMacroFuncId(ACC_KERNELS_INIT_FUNC_NAME, Xtype.voidType);
        Object object2 = Xcons.List();
        for (String object3 : this._kernelNames) {
            ((XobjList)object2).add(Xcons.StringConstant(object3));
        }
        Object object4 = Bcons.emptyBody();
        Ident ident2 = ((BlockList)object4).declLocalIdent("_ACC_kernel_names", Xtype.Array(Xtype.stringType, n), StorageClass.AUTO, (Xobject)object2);
        String string = new File(this._env_device.getSourceFileName()).getName();
        XobjList xobjList = Xcons.List(Xcons.AddrOf(this._programId.getAddr()), Xcons.StringConstant(string), Xcons.IntConstant(n), ident2.Ref());
        ((BlockList)object4).add(ident.Call(xobjList));
        this.addGlobalConstructor(Bcons.COMPOUND((BlockList)object4).toXobject());
        ident = ACCutil.getMacroFuncId(ACC_KERNELS_FINALIZE_FUNC_NAME, Xtype.voidType);
        object2 = Bcons.emptyBody();
        object4 = Xcons.List(this._programId.Ref());
        ((BlockList)object2).add(ident.Call((Xobject)object4));
        this.addGlobalDestructor(Bcons.COMPOUND((BlockList)object2).toXobject());
    }
}

