/*
 * Decompiled with CFR 0.152.
 */
package exc.object;

import exc.object.LineNo;
import exc.object.Xcode;
import exc.object.XobjArgs;
import exc.object.XobjBool;
import exc.object.XobjComplex;
import exc.object.XobjFloat;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.Xtype;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import xcodeml.util.XmLog;

public class XobjectPrintWriter
extends PrintWriter {
    public XobjectPrintWriter(OutputStream outputStream) {
        super(outputStream, true);
    }

    public XobjectPrintWriter(Writer writer) {
        super(writer, true);
    }

    public void print(Xobject xobject) {
        this.printObject(xobject);
    }

    public void printInt(long l) {
        this.print("0x");
        this.print(Long.toHexString(l));
    }

    public void printBool(boolean bl) {
        if (bl) {
            this.print("1");
        } else {
            this.print("0");
        }
    }

    public void printObject(Xobject xobject) {
        this.printObjectRec(xobject, 0);
        this.println();
        this.flush();
    }

    private void printDefs(List<XobjectDef> list, int n) {
        for (XobjectDef xobjectDef : list) {
            if (xobjectDef.getDef() != null) {
                this.printObjectRec(xobjectDef.getDef(), n);
                this.println();
                this.flush();
            }
            if (!xobjectDef.hasChildren()) continue;
            this.indent(n + 1);
            this.print("(F_CONTAINS_STATEMENT");
            this.println();
            this.printDefs(xobjectDef.getChildren(), n + 2);
            this.indent(n + 1);
            this.print(")");
            this.println();
            this.flush();
        }
    }

    public void printDefs(List<XobjectDef> list) {
        this.printDefs(list, 0);
    }

    public void printObjectNoIndent(Xobject xobject) {
        this.printObjectRec(xobject, -1);
        this.flush();
    }

    private void indent(int n) {
        for (int i = 0; i < n; ++i) {
            this.print("  ");
        }
    }

    void printObjectRec(Xobject xobject, int n) {
        LineNo lineNo;
        this.indent(n);
        if (xobject == null) {
            this.print("()");
            return;
        }
        Xcode xcode = xobject.Opcode();
        if (xcode != null && xcode.isBuiltinCode()) {
            this.print("(");
            this.print(xcode.toXcodeString());
            Xtype xtype = xobject.Type();
            if (xtype != null) {
                this.print(":");
                this.printType(xtype);
            }
        } else {
            this.print(xobject.toString());
            return;
        }
        if (xobject.isTerminal()) {
            switch (xcode) {
                case ID_LIST: {
                    this.printIdentList(xobject, n + 1);
                    this.indent(n);
                    this.print(")");
                    return;
                }
                case IDENT: 
                case VAR_ADDR: 
                case VAR: 
                case ARRAY_ADDR: 
                case FUNC_ADDR: 
                case CPP_OPERATOR_ADDR: 
                case MOE_CONSTANT: {
                    this.print(" " + xobject.getSym() + ")");
                    return;
                }
                case INT_CONSTANT: 
                case REG: {
                    this.print(" 0x" + Integer.toHexString(xobject.getInt()) + ")");
                    return;
                }
                case LONGLONG_CONSTANT: {
                    this.print(" 0x" + Long.toHexString(xobject.getLongHigh()) + " 0x" + Long.toHexString(xobject.getLongLow()) + ")");
                    return;
                }
                case FLOAT_CONSTANT: {
                    this.print(" " + ((XobjFloat)xobject).getFloatString() + ")");
                    return;
                }
                case F_COMPLEX_CONSTATNT: {
                    this.print(" " + ((XobjComplex)xobject).getReValue() + " " + ((XobjComplex)xobject).getImValue() + ")");
                    return;
                }
                case F_LOGICAL_CONSTATNT: {
                    this.print(" " + ((XobjBool)xobject).getBoolValue() + ")");
                    return;
                }
                case STRING: 
                case STRING_CONSTANT: 
                case F_CHARACTER_CONSTATNT: {
                    this.print(" \"" + xobject.getString() + "\")");
                    return;
                }
            }
            XmLog.fatal((String)("unknown terminal : " + xobject.OpcodeName()));
        }
        if ((lineNo = xobject.getLineNo()) != null) {
            this.print("@" + lineNo.lineNo() + "." + lineNo.fileName());
        }
        if (xobject.getArgs() != null) {
            if (n < 0) {
                this.print(" ");
            } else {
                this.println();
                ++n;
            }
            for (XobjArgs xobjArgs = xobject.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
                this.printObjectRec(xobjArgs.getArg(), n);
                if (xobjArgs.nextArgs() == null) continue;
                if (n < 0) {
                    this.print(" ");
                    continue;
                }
                this.println();
            }
        }
        this.print(")");
    }

    public void printIdentList(Xobject xobject, int n) {
        this.println();
        int n2 = xobject.Nargs();
        for (Xobject xobject2 : (XobjList)xobject) {
            this.indent(n);
            if (--n2 == 0) {
                this.print(xobject2);
                continue;
            }
            this.println(xobject2);
        }
    }

    public void printType(Xtype xtype) {
        String string = xtype.getXcodeCId();
        if (string == null) {
            string = xtype.getXcodeFId();
        }
        this.print(string != null ? string : "<NA>");
    }
}

