/*
 * Decompiled with CFR 0.152.
 */
package exc.object;

import exc.object.ArrayType;
import exc.object.BasicType;
import exc.object.CompositeType;
import exc.object.FarrayType;
import exc.object.FunctionType;
import exc.object.Ident;
import exc.object.PointerType;
import exc.object.StorageClass;
import exc.object.StructType;
import exc.object.VarScope;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.XobjString;
import exc.object.Xobject;
import exc.object.XobjectDefEnv;
import exc.object.XobjectIterator;
import exc.object.XobjectPrintWriter;
import exc.object.Xtype;
import exc.object.topdownXobjectDefIterator;
import exc.object.topdownXobjectIterator;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class XobjectFile
extends XobjectDefEnv {
    private List<Xtype> typeList = new ArrayList<Xtype>();
    protected HashMap<String, Xtype> typeIdTable = new HashMap();
    private String sourceFileName;
    private String compilerInfo;
    private String version;
    private String time;
    private String language;
    private List<String> headerLines;
    private List<String> tailerLines;
    private int gensym;
    public boolean debugFlag;
    public static boolean gcc_huge_common_bug;

    static void fatal(String string) {
        System.err.println("Fatal XobjectFile: " + string);
        Thread.dumpStack();
        System.exit(1);
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public String getCompilerInfo() {
        return this.compilerInfo;
    }

    public String getTime() {
        return this.time;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLanguageAttribute() {
        return this.language;
    }

    public void setProgramAttributes(String string, String string2, String string3, String string4, String string5) {
        this.sourceFileName = string;
        this.language = string2;
        this.compilerInfo = string3;
        this.version = string4;
        this.time = string5;
    }

    private Ident createGlobalIdent(String string, Xtype xtype, StorageClass storageClass) {
        Xtype xtype2 = xtype;
        Xcode xcode = xtype.isArray() ? Xcode.ARRAY_ADDR : (xtype.isFunction() ? Xcode.FUNC_ADDR : Xcode.VAR_ADDR);
        xtype2 = Xtype.Pointer(xtype);
        return new Ident(string, storageClass, xtype, Xcons.Symbol(xcode, xtype2, string), VarScope.GLOBAL, null);
    }

    public Ident declGlobalIdent(String string, Xtype xtype) {
        Ident ident = this.findVarIdent(string);
        if (ident != null) {
            if (ident.Type().equals(xtype)) {
                switch (ident.getStorageClass()) {
                    case EXTERN: {
                        ident.setStorageClass(StorageClass.EXTDEF);
                    }
                    case EXTDEF: 
                    case STATIC: {
                        return ident;
                    }
                }
            }
            XobjectFile.fatal("declGlobalIdent: id is already defined," + ident);
            return null;
        }
        ident = this.createGlobalIdent(string, xtype, StorageClass.EXTDEF);
        this.identList.add(ident);
        return ident;
    }

    public Ident declStaticIdent(String string, Xtype xtype) {
        Ident ident = this.findVarIdent(string);
        if (ident != null) {
            if (ident.Type().equals(xtype)) {
                switch (ident.getStorageClass()) {
                    case EXTERN: 
                    case EXTDEF: {
                        ident.setStorageClass(StorageClass.STATIC);
                    }
                    case STATIC: {
                        return ident;
                    }
                }
            }
            XobjectFile.fatal("declStaticIdent: id is already defined," + ident);
            return null;
        }
        ident = this.createGlobalIdent(string, xtype, StorageClass.STATIC);
        this.identList.add(ident);
        return ident;
    }

    public Ident declExternIdent(String string, Xtype xtype) {
        Ident ident = this.findVarIdent(string);
        if (ident != null) {
            if (ident.Type().equals(xtype)) {
                switch (ident.getStorageClass()) {
                    case EXTERN: 
                    case EXTDEF: 
                    case STATIC: {
                        return ident;
                    }
                }
            }
            XobjectFile.fatal("declExternIdent: id is already defined," + ident);
            return null;
        }
        ident = this.createGlobalIdent(string, xtype, StorageClass.EXTERN);
        this.identList.add(ident);
        return ident;
    }

    public String genExportSym(String string, String string2) {
        String string3 = string;
        string3 = string3 + "_" + string2 + "_" + this.gensym++;
        string3.intern();
        return string3;
    }

    public String genSym(String string) {
        String string2 = string;
        string2 = string2 + "_" + this.gensym++;
        string2.intern();
        return string2;
    }

    public Xtype findType(String string) {
        Xtype.TypeInfo typeInfo = BasicType.getTypeInfoByName(string);
        if (typeInfo != null) {
            return typeInfo.type;
        }
        Xtype xtype = this.typeIdTable.get(string);
        if (xtype != null) {
            return xtype;
        }
        xtype = new Xtype(0, string, 0L, null);
        return xtype;
    }

    public void fixupTypeRef() {
        Iterator<Xtype> iterator = this.typeList.iterator();
        while (iterator.hasNext()) {
            Xobject[] xobjectArray2;
            Object object;
            Xtype xtype = iterator.next();
            if (xtype instanceof FunctionType) {
                object = (FunctionType)xtype;
                if (((FunctionType)object).ref.getKind() == 0) {
                    ((FunctionType)object).ref = this.findTypeId(((FunctionType)object).ref.Id());
                }
                if (xtype.getFuncParam() == null) continue;
                for (xobjectArray2 = xtype.getFuncParam().getArgs(); xobjectArray2 != null; xobjectArray2 = xobjectArray2.nextArgs()) {
                    Xobject xobject = xobjectArray2.getArg();
                    if (xobject == null || xobject.type == null || xobject.type.getKind() != 0) continue;
                    xobject.type = this.findTypeId(xobject.type.Id());
                }
                continue;
            }
            if (xtype instanceof PointerType) {
                object = (PointerType)xtype;
                if (((PointerType)object).ref.getKind() != 0) continue;
                ((PointerType)object).ref = this.findTypeId(((PointerType)object).ref.Id());
                continue;
            }
            if (xtype instanceof ArrayType) {
                object = (ArrayType)xtype;
                if (((ArrayType)object).ref.getKind() == 0) {
                    ((ArrayType)object).ref = this.findTypeId(((ArrayType)object).ref.Id());
                }
                if (((ArrayType)object).getArraySizeExpr() == null) continue;
                this.fixupTypeRefExpr(((ArrayType)object).getArraySizeExpr());
                continue;
            }
            if (xtype instanceof CompositeType) {
                for (Xobject[] xobjectArray2 : xtype.getMemberList()) {
                    Ident ident = (Ident)xobjectArray2;
                    if (ident.type.getKind() != 0) continue;
                    ident.type = this.findTypeId(ident.type.Id());
                }
                continue;
            }
            if (xtype instanceof FarrayType) {
                object = (FarrayType)xtype;
                if (((FarrayType)object).getRef().getKind() == 0) {
                    ((FarrayType)object).setRef(this.findTypeId(((FarrayType)object).getRef().Id()));
                }
                if (((FarrayType)object).getFarraySizeExpr() == null) continue;
                xobjectArray2 = ((FarrayType)object).getFarraySizeExpr();
                int n = xobjectArray2.length;
                for (int i = 0; i < n; ++i) {
                    Xobject xobject = xobjectArray2[i];
                    this.fixupTypeRefExpr(xobject);
                }
                continue;
            }
            if (!xtype.getClass().equals(Xtype.class) || xtype.getKind() != 0) continue;
            object = this.findType(xtype.Id());
            if (object == null) {
                throw new IllegalArgumentException("markType: undefined type ID=" + xtype.Id());
            }
            iterator.remove();
        }
    }

    private void fixupTypeRefExpr(Xobject xobject) {
        if (xobject == null) {
            return;
        }
        topdownXobjectIterator topdownXobjectIterator2 = new topdownXobjectIterator(xobject);
        ((XobjectIterator)topdownXobjectIterator2).init();
        while (!((XobjectIterator)topdownXobjectIterator2).end()) {
            Xobject xobject2 = topdownXobjectIterator2.getXobject();
            if (xobject2 != null && xobject2.type != null && xobject2.type.getKind() == 0) {
                xobject2.type = this.findTypeId(xobject2.type.Id());
            }
            ((XobjectIterator)topdownXobjectIterator2).next();
        }
    }

    Xtype findTypeId(String string) {
        Xtype xtype = this.typeIdTable.get(string);
        if (xtype != null) {
            return xtype;
        }
        XobjectFile.fatal("findTypeId: type is not found, id=" + string);
        return null;
    }

    public void addHeaderLine(String string) {
        if (this.headerLines == null) {
            this.headerLines = new ArrayList<String>();
        }
        this.headerLines.add(string);
    }

    public List<String> getHeaderLines() {
        return this.headerLines;
    }

    public void addTailerLine(String string) {
        if (this.tailerLines == null) {
            this.tailerLines = new ArrayList<String>();
        }
        this.tailerLines.add(string);
    }

    public List<String> getTailerLines() {
        return this.tailerLines;
    }

    private void outputType(Xtype xtype, XobjectPrintWriter xobjectPrintWriter) {
        Object object;
        xobjectPrintWriter.print("{");
        xobjectPrintWriter.print(Xtype.getKindName(xtype.getKind()));
        xobjectPrintWriter.print(" ");
        if (xtype instanceof CompositeType && (object = ((CompositeType)xtype).getTagNames()) != null) {
            xobjectPrintWriter.print(((XobjString)object).getName() + "(\"" + ((XobjString)object).getAlias() + "\")");
            xobjectPrintWriter.print(" ");
        }
        xobjectPrintWriter.printType(xtype);
        xobjectPrintWriter.print(" (");
        if (xtype.isConst()) {
            xobjectPrintWriter.print(" const");
        }
        if (xtype.isVolatile()) {
            xobjectPrintWriter.print(" volatile");
        }
        if (xtype.isFvolatile()) {
            xobjectPrintWriter.print(" volatile");
        }
        if (xtype.isRestrict()) {
            xobjectPrintWriter.print(" restrict");
        }
        if (xtype.isInline()) {
            xobjectPrintWriter.print(" inline");
        }
        if (xtype.isArrayStatic()) {
            xobjectPrintWriter.print(" array_static");
        }
        if (xtype.isFuncStatic()) {
            xobjectPrintWriter.print(" func_static");
        }
        if (xtype.isFpublic()) {
            xobjectPrintWriter.print(" fpublic");
        }
        if (xtype.isFprivate()) {
            xobjectPrintWriter.print(" fprivate");
        }
        if (xtype.isFpointer()) {
            xobjectPrintWriter.print(" fpointer");
        }
        if (xtype.isFoptional()) {
            xobjectPrintWriter.print(" foptional");
        }
        if (xtype.isFtarget()) {
            xobjectPrintWriter.print(" ftarget");
        }
        if (xtype.isFsave()) {
            xobjectPrintWriter.print(" fsave");
        }
        if (xtype.isFparameter()) {
            xobjectPrintWriter.print(" fparameter");
        }
        if (xtype.isFallocatable()) {
            xobjectPrintWriter.print(" fallocatable");
        }
        if (xtype.isFintentIN()) {
            xobjectPrintWriter.print(" fintentIN");
        }
        if (xtype.isFintentOUT()) {
            xobjectPrintWriter.print(" fintentOUT");
        }
        if (xtype.isFintentINOUT()) {
            xobjectPrintWriter.print(" fintentINOUT");
        }
        if (xtype.isFcrayPointer()) {
            xobjectPrintWriter.print(" fcrayPointer");
        }
        if (xtype.isFprogram()) {
            xobjectPrintWriter.print(" fprogram");
        }
        if (xtype.isFintrinsic()) {
            xobjectPrintWriter.print(" fintrinsic");
        }
        if (xtype.isFrecursive()) {
            xobjectPrintWriter.print(" frecursive");
        }
        if (xtype.isFinternal()) {
            xobjectPrintWriter.print(" finternal");
        }
        if (xtype.isFexternal()) {
            xobjectPrintWriter.print(" fexternal");
        }
        if (xtype.isFsequence()) {
            xobjectPrintWriter.print(" fsequence");
        }
        if (xtype.isFinternalPrivate()) {
            xobjectPrintWriter.print(" finternal_private");
        }
        if (xtype.isExtended()) {
            xobjectPrintWriter.print(" extends[" + ((CompositeType)xtype).parentId() + "]");
        }
        xobjectPrintWriter.print(") ");
        if (xtype.copied != null) {
            xobjectPrintWriter.printType(xtype.copied);
            object = xtype.getFTypeParamValues();
            if (object != null) {
                xobjectPrintWriter.print("\n  " + object);
            }
            xobjectPrintWriter.println("}");
            return;
        }
        switch (xtype.getKind()) {
            case 1: {
                object = BasicType.getTypeInfo(xtype.getBasicType());
                if (this.language.equalsIgnoreCase("f") || this.language.equalsIgnoreCase("fortran")) {
                    xobjectPrintWriter.print(((Xtype.TypeInfo)object).fname);
                    break;
                }
                xobjectPrintWriter.print(((Xtype.TypeInfo)object).cname);
                break;
            }
            case 7: {
                xobjectPrintWriter.printType(xtype.getRef());
                break;
            }
            case 5: {
                xobjectPrintWriter.printType(xtype.getRef());
                xobjectPrintWriter.print(" ");
                xobjectPrintWriter.printBool(xtype.isFuncProto());
                xobjectPrintWriter.print(" ");
                xobjectPrintWriter.printObjectNoIndent(xtype.getFuncParam());
                break;
            }
            case 6: {
                xobjectPrintWriter.printType(xtype.getRef());
                xobjectPrintWriter.print(" ");
                if (xtype.getArraySize() >= 0L) {
                    xobjectPrintWriter.printInt(xtype.getArraySize());
                } else {
                    xobjectPrintWriter.print("*");
                }
                xobjectPrintWriter.print(" ");
                if (xtype.getArraySizeExpr() != null) {
                    xobjectPrintWriter.printObjectNoIndent(xtype.getArraySizeExpr());
                    break;
                }
                xobjectPrintWriter.print("*");
                break;
            }
            case 3: {
                object = ((StructType)xtype).getFTypeParams();
                if (object != null) {
                    xobjectPrintWriter.print("\n  " + object);
                }
            }
            case 2: 
            case 4: {
                xobjectPrintWriter.printIdentList(xtype.getMemberList(), 1);
                break;
            }
            case 8: {
                xobjectPrintWriter.printType(xtype.getRef());
                if (xtype.getFarraySizeExpr() == null) break;
                Xobject[] xobjectArray = xtype.getFarraySizeExpr();
                xobjectPrintWriter.print(" (");
                for (Xobject xobject : xobjectArray) {
                    xobjectPrintWriter.print(" ");
                    xobjectPrintWriter.printObject(xobject);
                }
                xobjectPrintWriter.print(")");
                break;
            }
            case 0: {
                break;
            }
            default: {
                XobjectFile.fatal("Output, bad type : " + xtype);
            }
        }
        if (xtype.getGccAttributes() != null) {
            xobjectPrintWriter.print(xtype.getGccAttributes());
        }
        if (xtype.getGccAttributes() != null) {
            xobjectPrintWriter.print(xtype.getGccAttributes());
        }
        if (xtype.getFkind() != null) {
            xobjectPrintWriter.print(" ");
            xobjectPrintWriter.print(xtype.getFkind());
        }
        xobjectPrintWriter.println("}");
    }

    public void Output(Writer writer) {
        XobjectPrintWriter xobjectPrintWriter = new XobjectPrintWriter(writer);
        for (Xtype xtype : this.typeList) {
            if (xtype.getKind() == 1 && !xtype.isConst() && !xtype.isVolatile()) continue;
            this.outputType(xtype, xobjectPrintWriter);
        }
        xobjectPrintWriter.println("%");
        if (this.identList != null) {
            xobjectPrintWriter.printIdentList(this.identList, 0);
        }
        xobjectPrintWriter.println("%");
        xobjectPrintWriter.printDefs(this.getDefs());
        xobjectPrintWriter.flush();
    }

    public void collectAllTypes() {
        this.typeList.clear();
        this.collectType(this.identList);
        topdownXobjectDefIterator topdownXobjectDefIterator2 = new topdownXobjectDefIterator(this);
        topdownXobjectDefIterator2.init();
        while (!topdownXobjectDefIterator2.end()) {
            this.collectType(topdownXobjectDefIterator2.getDef().getDef());
            topdownXobjectDefIterator2.next();
        }
        for (Xtype xtype : this.typeList) {
            xtype.is_marked = false;
        }
    }

    public List<Xtype> getTypeList() {
        return this.typeList;
    }

    public void addType(Xtype xtype) {
        this.typeList.add(xtype);
        this.typeIdTable.put(xtype.Id(), xtype);
    }

    private void markType(Xtype xtype) {
        if (xtype == null || xtype.is_marked) {
            return;
        }
        xtype.is_marked = true;
        if (xtype.Id() == null) {
            if (!xtype.isQualified()) {
                if (xtype.isBasic()) {
                    return;
                }
                if ((xtype.isStruct() || xtype.isUnion() || xtype.isEnum()) && xtype.equals(xtype.getOriginal())) {
                    xtype.copied = xtype.getOriginal();
                    return;
                }
            }
            xtype.generateId();
        }
        this.addType(xtype);
        switch (xtype.getKind()) {
            case 1: {
                this.collectType(xtype.getFkind());
                this.collectType(xtype.getFlen());
                break;
            }
            case 7: {
                this.markType(xtype.getRef());
                break;
            }
            case 6: {
                this.markType(xtype.getRef());
                this.collectType(xtype.getArraySizeExpr());
                break;
            }
            case 8: {
                this.markType(xtype.getRef());
                for (Xobject xobject : xtype.getFarraySizeExpr()) {
                    this.collectType(xobject);
                }
                break;
            }
            case 5: {
                while (xtype.copied != null) {
                    xtype = xtype.copied;
                    this.markType(xtype);
                }
                this.markType(xtype.getRef());
                this.collectType(xtype.getFuncParam());
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.collectType(xtype.getMemberList());
            }
        }
        this.collectType(xtype.getGccAttributes());
        if (xtype.copied != null) {
            this.markType(xtype.copied);
        }
        if (xtype.getOriginal() != null) {
            this.markType(xtype.getOriginal());
        }
    }

    private void collectType(Xobject xobject) {
        if (xobject == null) {
            return;
        }
        this.markType(xobject.Type());
        if (xobject instanceof XobjList) {
            for (Xobject xobject2 : (XobjList)xobject) {
                this.collectType(xobject2);
            }
        } else if (xobject instanceof Ident) {
            Ident ident = (Ident)xobject;
            this.collectType(ident.getAddr());
            this.collectType(ident.getEnumValue());
            this.collectType(ident.getBitFieldExpr());
            this.collectType(ident.getGccAttributes());
        }
    }
}

