/*
 * Decompiled with CFR 0.152.
 */
package exc.object;

import exc.object.Xcode;
import exc.object.XobjConst;
import exc.object.Xobject;
import exc.object.Xtype;
import java.math.BigInteger;

public class XobjLong
extends XobjConst {
    long high;
    long low;
    private static final BigInteger _long64mask = new BigInteger("FFFFFFFFFFFFFFFF", 16);

    public XobjLong(Xcode xcode, Xtype xtype, long l, long l2, String string) {
        super(xcode, xtype, string);
        this.init(l, l2);
    }

    private void init(long l, long l2) {
        this.high = l;
        this.low = l2;
    }

    public XobjLong(Xcode xcode, Xtype xtype, BigInteger bigInteger, String string) {
        this(xcode, xtype, 0L, 0L, string);
        int n = bigInteger.signum();
        long l = (n < 0 ? bigInteger.negate() : bigInteger).shiftRight(64).longValue();
        long l2 = bigInteger.and(_long64mask).longValue();
        this.init(l * (long)n, l2);
    }

    public XobjLong(Xcode xcode, Xtype xtype, long l, long l2) {
        this(xcode, xtype, l, l2, null);
    }

    public XobjLong(long l, long l2) {
        this(Xcode.LONGLONG_CONSTANT, (Xtype)Xtype.longlongType, l, l2);
    }

    @Override
    public long getLongHigh() {
        return this.high;
    }

    @Override
    public long getLongLow() {
        return this.low;
    }

    public BigInteger getBigInteger() {
        BigInteger bigInteger = BigInteger.valueOf(this.low);
        if (this.high == 0L) {
            return bigInteger;
        }
        BigInteger bigInteger2 = BigInteger.valueOf(this.high > 0L ? this.high : -this.high).shiftLeft(64).and(bigInteger);
        if (this.high < 0L) {
            bigInteger2 = bigInteger2.negate();
        }
        return bigInteger2;
    }

    @Override
    public Xobject copy() {
        return this.copyTo(new XobjLong(this.code, this.type, this.high, this.low, this.getFkind()));
    }

    @Override
    public boolean equals(Xobject xobject) {
        return xobject.getLongHigh() == this.high && xobject.getLongLow() == this.low;
    }

    @Override
    public String toString() {
        return "(" + this.OpcodeName() + " 0x" + Long.toHexString(this.high) + " 0x" + Long.toHexString(this.low) + ")";
    }

    @Override
    public boolean isZeroConstant() {
        return this.high == 0L && this.low == 0L;
    }

    @Override
    public boolean isOneConstant() {
        return this.high == 0L && this.low == 1L;
    }
}

