/*
 * Decompiled with CFR 0.152.
 */
package exc.object;

import exc.block.Block;
import exc.object.FconstFolder;
import exc.object.Ident;
import exc.object.LineNo;
import exc.object.StorageClass;
import exc.object.Xcode;
import exc.object.XobjArgs;
import exc.object.XobjContainer;
import exc.object.XobjListIterator;
import exc.object.Xobject;
import exc.object.Xtype;
import java.util.Iterator;
import xcodeml.util.IXobject;

public class XobjList
extends Xobject
implements Iterable<Xobject>,
XobjContainer {
    XobjArgs args;
    XobjArgs tail;
    LineNo lineno;

    public XobjList() {
        super(Xcode.LIST, null);
    }

    public XobjList(Xcode xcode, Xtype xtype) {
        super(xcode, xtype);
    }

    public XobjList(Xcode xcode, Xtype xtype, XobjArgs xobjArgs) {
        super(xcode, xtype);
        this.args = xobjArgs;
    }

    public XobjList(Xcode xcode, Xtype xtype, Xobject ... xobjectArray) {
        super(xcode, xtype);
        XobjArgs xobjArgs = null;
        if (xobjectArray != null && xobjectArray.length > 0) {
            for (int i = xobjectArray.length - 1; i >= 0; --i) {
                xobjArgs = new XobjArgs(xobjectArray[i], xobjArgs);
            }
        }
        this.args = xobjArgs;
    }

    public XobjList(Xcode xcode) {
        super(xcode, null);
    }

    public XobjList(Xcode xcode, XobjArgs xobjArgs) {
        super(xcode, null);
        this.args = xobjArgs;
    }

    public XobjList(Xcode xcode, Xobject ... xobjectArray) {
        this(xcode, (Xtype)null, xobjectArray);
    }

    public void cons(Xobject xobject) {
        XobjArgs xobjArgs;
        this.args = this.args == null ? new XobjArgs(xobject, null) : (xobjArgs = new XobjArgs(xobject, this.args));
    }

    @Override
    public void add(Xobject xobject) {
        if (this.args == null) {
            this.tail = this.args = new XobjArgs(xobject, null);
            return;
        }
        if (this.tail == null) {
            this.tail = this.args;
            while (this.tail.nextArgs() != null) {
                this.tail = this.tail.nextArgs();
            }
        }
        this.tail = this.tail.next = new XobjArgs(xobject, null);
    }

    public void remove(Xobject xobject) {
        if (this.args == null) {
            return;
        }
        Object var2_2 = null;
        XobjArgs xobjArgs = this.args;
        XobjArgs xobjArgs2 = null;
        while (xobjArgs != null) {
            if (xobjArgs.getArg() == xobject) {
                if (xobjArgs2 == null) {
                    this.args = xobjArgs.next;
                } else {
                    xobjArgs2.next = xobjArgs.next;
                }
                if (this.tail == xobjArgs) {
                    this.tail = xobjArgs2;
                }
            }
            xobjArgs2 = xobjArgs;
            xobjArgs = xobjArgs.next;
        }
    }

    @Override
    public Xobject getTail() {
        if (this.tail == null) {
            return null;
        }
        return this.tail.getArg();
    }

    @Override
    public void insert(Xobject xobject) {
        if (this.args == null) {
            this.tail = this.args = new XobjArgs(xobject, null);
            return;
        }
        this.args = new XobjArgs(xobject, this.args);
    }

    @Override
    public Xobject operand() {
        if (this.args == null) {
            return null;
        }
        return this.args.getArg();
    }

    @Override
    public Xobject left() {
        if (this.args == null) {
            return null;
        }
        return this.args.getArg();
    }

    @Override
    public Xobject right() {
        if (this.args == null || this.args.nextArgs() == null) {
            return null;
        }
        return this.args.nextArgs().getArg();
    }

    @Override
    public void setOperand(Xobject xobject) {
        this.args.setArg(xobject);
    }

    @Override
    public void setLeft(Xobject xobject) {
        this.args.setArg(xobject);
    }

    @Override
    public void setRight(Xobject xobject) {
        this.args.nextArgs().setArg(xobject);
    }

    @Override
    public XobjArgs getArgs() {
        return this.args;
    }

    @Override
    public void setArgs(XobjArgs xobjArgs) {
        this.args = xobjArgs;
        this.tail = null;
    }

    @Override
    public Xobject removeArgs(XobjArgs xobjArgs) {
        if (this.args == null) {
            return null;
        }
        Xobject xobject = null;
        XobjArgs xobjArgs2 = this.args;
        XobjArgs xobjArgs3 = null;
        while (xobjArgs2 != null) {
            if (xobjArgs2 == xobjArgs) {
                xobject = xobjArgs2.arg;
                if (xobjArgs3 == null) {
                    this.args = xobjArgs2.next;
                } else {
                    xobjArgs3.next = xobjArgs2.next;
                }
                if (this.tail == xobjArgs2) {
                    this.tail = xobjArgs3;
                }
            }
            xobjArgs3 = xobjArgs2;
            xobjArgs2 = xobjArgs2.next;
        }
        return xobject;
    }

    @Override
    public Xobject removeFirstArgs() {
        if (this.args == null) {
            return null;
        }
        Xobject xobject = this.args.arg;
        this.args = this.args.next;
        if (this.args == null) {
            this.tail = null;
        }
        return xobject;
    }

    @Override
    public Xobject removeLastArgs() {
        if (this.tail == null) {
            return null;
        }
        Xobject xobject = this.tail.arg;
        XobjArgs xobjArgs = this.tail;
        if (this.args == this.tail) {
            this.args = null;
            this.tail = null;
            return xobject;
        }
        this.tail = this.args;
        while (this.tail.next != xobjArgs) {
            this.tail = this.tail.next;
        }
        this.tail.next = null;
        return xobject;
    }

    public void clear() {
        this.tail = null;
        this.args = null;
    }

    @Override
    public Xobject getArg(int n) {
        XobjArgs xobjArgs = this.args;
        int n2 = n;
        while (n > 0) {
            xobjArgs = xobjArgs.nextArgs();
            --n;
        }
        if (xobjArgs == null) {
            throw new NullPointerException("i=" + n2 + ", args=" + (this.args != null ? this.args.toString() : "null"));
        }
        return xobjArgs.getArg();
    }

    @Override
    public Xobject getArgOrNull(int n) {
        XobjArgs xobjArgs = this.args;
        if (xobjArgs == null) {
            return null;
        }
        while (n > 0) {
            if ((xobjArgs = xobjArgs.nextArgs()) == null) {
                return null;
            }
            --n;
        }
        return xobjArgs.getArg();
    }

    public Xobject getArgWithKeyword(String string, int n) {
        Object object;
        for (object = this.args; object != null; object = ((XobjArgs)object).nextArgs()) {
            Xobject xobject = ((XobjArgs)object).getArg();
            if (xobject.Opcode() != Xcode.F_NAMED_VALUE || !string.equalsIgnoreCase(xobject.getArg(0).getName())) continue;
            return xobject.getArg(1);
        }
        object = this.getArgOrNull(n);
        if (object != null && ((Xobject)object).Opcode() == Xcode.F_NAMED_VALUE) {
            return null;
        }
        return object;
    }

    @Override
    public void setArg(int n, Xobject xobject) {
        XobjArgs xobjArgs = this.args;
        while (n > 0) {
            xobjArgs = xobjArgs.nextArgs();
            --n;
        }
        xobjArgs.setArg(xobject);
    }

    @Override
    public int Nargs() {
        int n = 0;
        for (XobjArgs xobjArgs = this.args; xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            ++n;
        }
        return n;
    }

    @Override
    public void setLineNo(LineNo lineNo) {
        this.lineno = lineNo;
    }

    @Override
    public LineNo getLineNo() {
        return this.lineno;
    }

    @Override
    public Xobject copy() {
        XobjList xobjList = new XobjList(this.code, this.type);
        for (XobjArgs xobjArgs = this.args; xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            if (xobjArgs.getArg() == null) {
                xobjList.add(null);
                continue;
            }
            xobjList.add(xobjArgs.getArg().copy());
        }
        return this.copyTo(xobjList);
    }

    @Override
    public boolean equals(Xobject xobject) {
        if (xobject == null) {
            return false;
        }
        if (!super.equals(xobject)) {
            return false;
        }
        XobjArgs xobjArgs = this.args;
        XobjArgs xobjArgs2 = xobject.getArgs();
        while (xobjArgs != null) {
            if (xobjArgs2 == null) {
                return false;
            }
            if (xobjArgs.getArg() != xobjArgs2.getArg()) {
                if (xobjArgs.getArg() == null) {
                    return false;
                }
                if (!xobjArgs.getArg().equals(xobjArgs2.getArg())) {
                    return false;
                }
            }
            xobjArgs = xobjArgs.nextArgs();
            xobjArgs2 = xobjArgs2.nextArgs();
        }
        return xobjArgs2 == null;
    }

    @Override
    public String getName() {
        switch (this.Opcode()) {
            case F_VAR_REF: 
            case F_ARRAY_REF: 
            case CO_ARRAY_REF: 
            case FUNCTION_CALL: {
                return this.getArg(0).getName();
            }
        }
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public int getFrank(Block block) {
        switch (this.Opcode()) {
            case F_VAR_REF: 
            case F_ARRAY_REF: 
            case CO_ARRAY_REF: {
                Xobject xobject = this.getSubscripts();
                if (xobject == null) {
                    throw new UnsupportedOperationException("internal error: XobjList.getSubscripts() is null");
                }
                int n = 0;
                for (int i = 0; i < xobject.Nargs(); ++i) {
                    Xobject xobject2 = xobject.getArg(i);
                    n += xobject2.getFrank(block);
                }
                return n;
            }
            case F_ARRAY_INDEX: {
                return this.getArg(0).getFrank(block);
            }
            case F_INDEX_RANGE: {
                return 1;
            }
        }
        throw new UnsupportedOperationException("unexpected Opcode in XobjList.getFrank(): " + (Object)((Object)this.Opcode()));
    }

    @Override
    public Xobject getSubscripts() {
        switch (this.Opcode()) {
            case F_ARRAY_REF: {
                Xobject xobject = this.getArg(0);
                if (xobject.Opcode() != Xcode.F_VAR_REF) break;
                Xobject xobject2 = xobject.getArg(0);
                switch (xobject2.Opcode()) {
                    case VAR: {
                        return this.getArg(1);
                    }
                    case MEMBER_REF: {
                        return this.getArg(1);
                    }
                }
            }
            case CO_ARRAY_REF: {
                return this.getArg(0).getSubscripts();
            }
            case F_ARRAY_INDEX: {
                return null;
            }
            case F_VAR_REF: {
                return this.getArg(0).getSubscripts();
            }
        }
        throw new UnsupportedOperationException("unexpected Opcode in XobjList.getSubscripts(): " + (Object)((Object)this.Opcode()));
    }

    public void reverse() {
        if (this.args == null) {
            return;
        }
        XobjArgs xobjArgs = this.args;
        XobjArgs xobjArgs2 = null;
        XobjArgs xobjArgs3 = xobjArgs.next;
        while (xobjArgs != null) {
            xobjArgs.next = xobjArgs2;
            xobjArgs2 = xobjArgs;
            xobjArgs = xobjArgs3;
            xobjArgs3 = xobjArgs != null ? xobjArgs.next : null;
        }
        xobjArgs = this.args;
        this.args = this.tail;
        this.tail = xobjArgs;
    }

    @Override
    public boolean isEmpty() {
        return this.args == null;
    }

    @Override
    public String toString() {
        String string = "(" + this.OpcodeName();
        for (XobjArgs xobjArgs = this.args; xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            string = xobjArgs.getArg() == null ? string + " ()" : string + " " + xobjArgs.getArg();
        }
        return string + ")";
    }

    @Override
    public Iterator<Xobject> iterator() {
        return new XobjListIterator(this);
    }

    @Override
    public Ident getMember(String string) {
        if (this.Opcode() != Xcode.ID_LIST) {
            throw new IllegalStateException("not ID_LIST");
        }
        for (Xobject xobject : this) {
            if (!(xobject instanceof Ident)) {
                throw new IllegalStateException("not Ident : " + xobject.getClass());
            }
            if (!xobject.getName().equals(string)) continue;
            return (Ident)xobject;
        }
        return null;
    }

    @Override
    public void setParentRecursively(IXobject iXobject) {
        super.setParentRecursively(iXobject);
        for (Xobject xobject : this) {
            if (!(xobject instanceof XobjList)) continue;
            ((XobjList)xobject).setParentRecursively(this);
        }
    }

    @Override
    public Xobject cfold(Block block) {
        FconstFolder fconstFolder = new FconstFolder(this, block);
        Xobject xobject = fconstFolder.run();
        if (xobject == null) {
            return this;
        }
        return xobject;
    }

    @Override
    public Ident find(String string, int n) {
        return this.findIdent(string, n);
    }

    public Ident findIdent(String string, int n) {
        XobjList xobjList = null;
        switch (this.Opcode()) {
            case COMPOUND_STATEMENT: {
                xobjList = (XobjList)this.getArg(0);
                break;
            }
            case FUNCTION_DEFINITION: 
            case F_MODULE_DEFINITION: {
                xobjList = (XobjList)this.getArg(1);
                break;
            }
            case ID_LIST: {
                xobjList = this;
            }
        }
        if (xobjList != null) {
            for (Xobject xobject : xobjList) {
                Ident ident = (Ident)xobject;
                if (!ident.getName().equals(string)) continue;
                switch (n) {
                    case 0: {
                        return ident;
                    }
                    case 1: {
                        if (!ident.getStorageClass().isVarOrFunc()) break;
                        return ident;
                    }
                    case 2: {
                        if (ident.getStorageClass() != StorageClass.FCOMMON_NAME) break;
                        return ident;
                    }
                    case 3: {
                        if (ident.getStorageClass() != StorageClass.FTYPE_NAME && ident.getStorageClass() != StorageClass.TAGNAME) break;
                        return ident;
                    }
                }
            }
        }
        if (this.parent != null) {
            return (Ident)this.parent.find(string, n);
        }
        return null;
    }

    public boolean has(Xobject xobject) {
        for (Xobject xobject2 : this) {
            if (xobject != xobject2) continue;
            return true;
        }
        return false;
    }

    public boolean hasIdent(String string) {
        for (Xobject xobject : this) {
            if (!string.equals(xobject.getName())) continue;
            return true;
        }
        return false;
    }

    public Ident getIdent(String string) {
        for (Xobject xobject : this) {
            if (!string.equals(xobject.getName())) continue;
            return (Ident)xobject;
        }
        return null;
    }

    public Ident getStructTypeName(Xtype xtype) {
        for (Xobject xobject : this) {
            Ident ident = (Ident)xobject;
            if (ident.getStorageClass() != StorageClass.FTYPE_NAME || ident.Type().getBaseRefType() != xtype.getBaseRefType()) continue;
            return ident;
        }
        return null;
    }

    public void mergeList(XobjList xobjList) {
        if (xobjList != null) {
            for (Xobject xobject : xobjList) {
                this.add(xobject);
            }
        }
    }

    @Override
    public boolean hasNullArg() {
        if (this.args == null) {
            return false;
        }
        return this.args.hasNullArg();
    }
}

