/*
 * Decompiled with CFR 0.152.
 */
package exc.object;

import exc.object.Xcode;
import exc.object.XobjConst;
import exc.object.Xobject;
import exc.object.Xtype;

public class XobjInt
extends XobjConst {
    int value;

    public XobjInt(Xcode xcode, Xtype xtype, int n, String string) {
        super(xcode, xtype, string);
        this.value = n;
    }

    public XobjInt(Xcode xcode, int n) {
        this(xcode, Xtype.intType, n, null);
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public boolean canGetInt() {
        return true;
    }

    @Override
    public Xobject copy() {
        return this.copyTo(new XobjInt(this.code, this.type, this.value, this.getFkind()));
    }

    @Override
    public boolean equals(Xobject xobject) {
        return super.equals(xobject) && this.value == xobject.getInt();
    }

    @Override
    public String getName() {
        if (this.code == Xcode.REG) {
            return "r_" + Long.toHexString(this.value);
        }
        return Long.toString(this.value);
    }

    @Override
    public String toString() {
        return "(" + this.OpcodeName() + " 0x" + Long.toHexString(this.value) + ")";
    }

    @Override
    public boolean isZeroConstant() {
        return this.value == 0;
    }

    @Override
    public boolean isOneConstant() {
        return this.value == 1;
    }
}

