/*
 * Decompiled with CFR 0.152.
 */
package exc.object;

import exc.block.Block;
import exc.object.BasicType;
import exc.object.Ident;
import exc.object.StorageClass;
import exc.object.VarScope;
import exc.object.Xcode;
import exc.object.XobjArgs;
import exc.object.XobjBool;
import exc.object.XobjComplex;
import exc.object.XobjFloat;
import exc.object.XobjInt;
import exc.object.XobjList;
import exc.object.XobjLong;
import exc.object.XobjString;
import exc.object.Xobject;
import exc.object.Xtype;
import java.math.BigInteger;
import xcodeml.util.XmLog;
import xcodeml.util.XmOption;

public class Xcons {
    public static XobjString Symbol(Xcode xcode, String string) {
        return new XobjString(xcode, string);
    }

    public static XobjString Symbol(Xcode xcode, Xtype xtype, String string) {
        return new XobjString(xcode, xtype, string);
    }

    public static XobjString Symbol(Xcode xcode, Xtype xtype, String string, VarScope varScope) {
        XobjString xobjString = new XobjString(xcode, xtype, string);
        xobjString.setScope(varScope);
        return xobjString;
    }

    public static XobjString Symbol(Xcode xcode, Xtype xtype, String string, VarScope varScope, String string2, boolean bl) {
        XobjString xobjString = new XobjString(xcode, xtype, string);
        xobjString.setScope(varScope);
        xobjString.setAlias(string2);
        xobjString.setOp(bl);
        return xobjString;
    }

    public static XobjString StringConstant(String string) {
        return Xcons.StringConstant(Xtype.stringType, string);
    }

    public static XobjString StringConstant(Xtype xtype, String string) {
        return new XobjString(Xcode.STRING_CONSTANT, xtype, string, null);
    }

    public static XobjString FcharacterConstant(Xtype xtype, String string, String string2) {
        return new XobjString(Xcode.F_CHARACTER_CONSTATNT, xtype, string, string2);
    }

    public static XobjString String(String string) {
        return string != null ? new XobjString(Xcode.STRING, string) : null;
    }

    public static XobjInt Int(Xcode xcode, Xtype xtype, int n) {
        return new XobjInt(xcode, xtype, n, null);
    }

    public static XobjInt Int(Xcode xcode, int n) {
        return new XobjInt(xcode, n);
    }

    public static XobjInt IntConstant(int n) {
        return new XobjInt(Xcode.INT_CONSTANT, Xtype.intType, n, null);
    }

    public static XobjInt IntConstant(int n, Xtype xtype, String string) {
        return new XobjInt(Xcode.INT_CONSTANT, xtype, n, string);
    }

    public static XobjLong Long(Xcode xcode, Xtype xtype, long l) {
        return Xcons.Long(xcode, xtype, 0L, l);
    }

    public static XobjLong Long(Xcode xcode, Xtype xtype, long l, long l2) {
        return new XobjLong(xcode, xtype, l, l2);
    }

    public static XobjLong LongConstant(long l) {
        return Xcons.Long(Xcode.LONG_CONSTANT, Xtype.longType, l);
    }

    public static XobjLong LongLongConstant(long l, long l2) {
        return new XobjLong(l, l2);
    }

    public static XobjLong LongLongConstant(BigInteger bigInteger, Xtype xtype, String string) {
        return new XobjLong(Xcode.LONGLONG_CONSTANT, xtype, bigInteger, string);
    }

    public static XobjFloat Float(Xcode xcode, Xtype xtype, double d) {
        return new XobjFloat(xcode, xtype, d);
    }

    public static XobjFloat Float(Xcode xcode, Xtype xtype, String string) {
        return new XobjFloat(xcode, xtype, string);
    }

    public static XobjFloat FloatConstant(double d) {
        return new XobjFloat(Xcode.FLOAT_CONSTANT, (Xtype)Xtype.doubleType, d);
    }

    public static XobjFloat FloatConstant(Xtype xtype, String string, String string2) {
        return new XobjFloat(Xcode.FLOAT_CONSTANT, Xtype.floatType, string, string2);
    }

    public static XobjBool FlogicalConstant(Xtype xtype, boolean bl, String string) {
        return new XobjBool(Xcode.F_LOGICAL_CONSTATNT, xtype, bl, string);
    }

    public static XobjBool FlogicalConstant(boolean bl) {
        return Xcons.FlogicalConstant(Xtype.FlogicalType, bl, null);
    }

    public static XobjComplex ComplexConstant(Xtype xtype, Xobject xobject, Xobject xobject2) {
        return new XobjComplex(Xcode.F_COMPLEX_CONSTATNT, xtype, xobject, xobject2);
    }

    public static XobjList List() {
        return new XobjList();
    }

    public static XobjList List(Xcode xcode) {
        return new XobjList(xcode);
    }

    public static XobjList List(Xcode xcode, Xtype xtype) {
        return new XobjList(xcode, xtype);
    }

    public static XobjList List(Xcode xcode, Xtype xtype, XobjArgs xobjArgs) {
        return new XobjList(xcode, xtype, xobjArgs);
    }

    public static XobjList List(Xcode xcode, Xtype xtype, Xobject ... xobjectArray) {
        return new XobjList(xcode, xtype, xobjectArray);
    }

    public static XobjList List(Xcode xcode, XobjArgs xobjArgs) {
        return new XobjList(xcode, xobjArgs);
    }

    public static XobjList List(Xcode xcode, Xobject ... xobjectArray) {
        return new XobjList(xcode, xobjectArray);
    }

    public static XobjList List(XobjArgs xobjArgs) {
        return new XobjList(Xcode.LIST, xobjArgs);
    }

    public static XobjList List(Xobject ... xobjectArray) {
        return new XobjList(Xcode.LIST, xobjectArray);
    }

    public static XobjList IDList() {
        return new XobjList(Xcode.ID_LIST);
    }

    public static Ident Ident(String string, StorageClass storageClass, Xtype xtype, Xobject xobject, VarScope varScope) {
        return new Ident(string, storageClass, xtype, xobject, varScope, null);
    }

    public static Ident Ident(String string, StorageClass storageClass, Xtype xtype, Xobject xobject, VarScope varScope, Xobject xobject2) {
        return new Ident(string, storageClass, xtype, xobject, varScope, xobject2);
    }

    public static Xobject PointerRef(Xobject xobject) {
        if (!XmOption.isLanguageC()) {
            return xobject;
        }
        Xtype xtype = xobject.Type();
        if (xtype != null && xtype.isPointer()) {
            xtype = xtype.getRef();
        }
        switch (xobject.Opcode()) {
            case ARRAY_ADDR: {
                return Xcons.Symbol(Xcode.ARRAY_ADDR, xtype, xobject.getSym(), xobject.getScope());
            }
            case VAR_ADDR: {
                return Xcons.Symbol(Xcode.VAR, xtype, xobject.getSym(), xobject.getScope());
            }
            case FUNC_ADDR: {
                XmLog.fatal((String)"PointerRef(): FUNC_ADDR");
                break;
            }
            case ADDR_OF: {
                return xobject.operand();
            }
            default: {
                if (xtype == null || xobject.Type().isPointer()) {
                    return Xcons.List(Xcode.POINTER_REF, xtype, xobject);
                }
                XmLog.fatal((String)"PointerRef(): not Pointer");
            }
        }
        return null;
    }

    public static Xobject memberAddr(Xobject xobject, String string) {
        Ident ident;
        Xtype xtype = xobject.Type();
        if (!xtype.isPointer()) {
            XmLog.fatal((String)"memberRef: not Pointer");
        }
        if (!(xtype = xtype.getRef()).isStruct() && !xtype.isUnion()) {
            XmLog.fatal((String)"memberAddr: not struct/union");
        }
        if ((ident = xtype.getMemberList().getMember(string)) == null) {
            XmLog.fatal((String)("memberAddr: member name is not found: " + string));
        }
        xtype = ident.Type();
        return Xcons.List(Xcode.MEMBER_ADDR, Xtype.Pointer(ident.Type()), xobject, Xcons.Symbol(Xcode.IDENT, ident.Type(), ident.getName()));
    }

    public static Xobject memberRef(Xobject xobject, String string) {
        Ident ident;
        Xtype xtype = xobject.Type();
        if (!xtype.isPointer()) {
            XmLog.fatal((String)"memberRef: not Pointer");
        }
        if (!(xtype = xtype.getRef()).isStruct() && !xtype.isUnion()) {
            XmLog.fatal((String)"memberAddr: not struct/union");
        }
        if ((ident = xtype.getMemberList().getMember(string)) == null) {
            XmLog.fatal((String)("memberAddr: member name is not found: " + string));
        }
        xtype = ident.Type();
        return Xcons.List(Xcode.MEMBER_REF, ident.Type(), xobject, Xcons.Symbol(Xcode.IDENT, ident.Type(), ident.getName()));
    }

    public static Xobject memberAddr(Xobject xobject, Ident ident) {
        Xtype xtype = xobject.Type();
        if (!xtype.isPointer()) {
            XmLog.fatal((String)"memberAddr: not Pointer");
        }
        if (!(xtype = xtype.getRef()).isStruct() && !xtype.isUnion()) {
            XmLog.fatal((String)"memberAddr: not struct/union");
        }
        xtype = ident.Type();
        if (XmOption.isLanguageC()) {
            return Xcons.List(Xcode.MEMBER_ADDR, Xtype.Pointer(xtype), xobject, Xcons.Symbol(Xcode.IDENT, xtype, ident.getName()));
        }
        return Xcons.List(Xcode.MEMBER_REF, xtype, xobject, Xcons.Symbol(Xcode.IDENT, xtype, ident.getName()));
    }

    public static Xobject AddrOf(Xobject xobject) {
        if (xobject == null) {
            throw new NullPointerException("v");
        }
        if (!XmOption.isLanguageC()) {
            return xobject;
        }
        Xtype xtype = xobject.Type();
        if (xtype != null) {
            xtype = Xtype.Pointer(xtype);
        }
        return Xcons.List(Xcode.ADDR_OF, xtype, xobject);
    }

    public static Xobject AddrOfVar(Xobject xobject) {
        if (xobject == null) {
            throw new NullPointerException("x");
        }
        if (xobject instanceof Ident) {
            return Xcons.Symbol(Xcode.VAR_ADDR, Xtype.Pointer(xobject.Type()), xobject.getName());
        }
        if (!XmOption.isLanguageC()) {
            return xobject;
        }
        switch (xobject.Opcode()) {
            case VAR: {
                return Xcons.Symbol(Xcode.VAR_ADDR, Xtype.Pointer(xobject.Type()), xobject.getSym());
            }
            case ARRAY_REF: {
                return Xcons.Symbol(Xcode.ARRAY_ADDR, Xtype.Pointer(xobject.Type()), xobject.getSym());
            }
            case MEMBER_REF: {
                return Xcons.Symbol(Xcode.MEMBER_ADDR, Xtype.Pointer(xobject.Type()), xobject.getSym());
            }
        }
        XmLog.fatal((String)"AddrOfVar: not Variable");
        return null;
    }

    public static Xobject Set(Xobject xobject, Xobject xobject2) {
        if (xobject == null) {
            throw new NullPointerException("lv");
        }
        if (xobject2 == null) {
            throw new NullPointerException("rv");
        }
        if (XmOption.isLanguageC()) {
            return Xcons.List(Xcode.ASSIGN_EXPR, xobject.Type(), xobject, xobject2);
        }
        return Xcons.List(Xcode.F_ASSIGN_STATEMENT, xobject, xobject2);
    }

    public static Xobject Cast(Xtype xtype, Xobject xobject) {
        if (xobject == null) {
            throw new NullPointerException("v");
        }
        return Xcons.List(Xcode.CAST_EXPR, xtype, xobject);
    }

    public static Xobject functionCall(Xobject xobject, Xobject xobject2) {
        if (xobject == null) {
            throw new NullPointerException("f");
        }
        Xtype xtype = xobject.Opcode() == Xcode.FUNC_ADDR ? xobject.Type().getRef() : xobject.Type();
        if (!xtype.isFunction()) {
            XmLog.fatal((String)("fuctionCall: not Function : " + xobject.toString()));
        }
        return Xcons.List(Xcode.FUNCTION_CALL, xtype.getRef(), xobject, xobject2);
    }

    public static Xobject binaryOp(Xcode xcode, Xobject xobject, Xobject xobject2) {
        if (xobject == null) {
            throw new NullPointerException("x");
        }
        if (xobject2 == null) {
            throw new NullPointerException("y");
        }
        Xtype xtype = null;
        Xtype xtype2 = xobject.Type();
        Xtype xtype3 = xobject2.Type();
        if (xtype2.isFarray()) {
            xtype2 = xtype2.getRef();
        }
        if (xtype3.isFarray()) {
            xtype3 = xtype3.getRef();
        }
        switch (xcode) {
            case PLUS_EXPR: 
            case MINUS_EXPR: {
                if (xtype2.isPointer() && xtype3.isIntegral()) {
                    xtype = xtype2;
                    break;
                }
                if (xtype3.isPointer() && xtype2.isIntegral()) {
                    xtype = xtype3;
                    break;
                }
                if (xtype2.isIntegral() && xtype3.isFloating()) {
                    xtype = xtype2;
                    break;
                }
                if (xtype3.isIntegral() && xtype2.isFloating()) {
                    xtype = xtype3;
                    break;
                }
                if (xtype2.isIntegral() && xtype3.isIntegral()) {
                    xtype = Xcons.ConversionIntegral(xtype2, xtype3);
                    break;
                }
                if (xtype2.isNumeric() && xtype3.isNumeric()) {
                    xtype = BasicType.Conversion(xtype2, xtype3);
                    break;
                }
                XmLog.fatal((String)"BinaryOp: bad type");
            }
            case MUL_EXPR: {
                if (xobject2.isZeroConstant()) {
                    return Xcons.IntConstant(0);
                }
                if (xobject.isOneConstant()) {
                    return xobject2;
                }
            }
            case DIV_EXPR: {
                if (xobject.isZeroConstant()) {
                    return Xcons.IntConstant(0);
                }
                if (xobject2.isOneConstant()) {
                    return xobject;
                }
                if (xtype2.isIntegral() && xtype3.isFloating()) {
                    xtype = xtype2;
                    break;
                }
                if (xtype3.isIntegral() && xtype2.isFloating()) {
                    xtype = xtype3;
                    break;
                }
                if (xtype2.isIntegral() && xtype3.isIntegral()) {
                    xtype = Xcons.ConversionIntegral(xtype2, xtype3);
                    break;
                }
                if (xtype2.isNumeric() && xtype3.isNumeric()) {
                    xtype = BasicType.Conversion(xtype2, xtype3);
                    break;
                }
                XmLog.fatal((String)"BinaryOp: bad type");
            }
            case MOD_EXPR: {
                if (xobject2.isOneConstant()) {
                    return xobject;
                }
                if (xtype2.isIntegral() && xtype3.isIntegral()) {
                    xtype = Xcons.ConversionIntegral(xtype2, xtype3);
                    break;
                }
                if (xtype2.isNumeric() && xtype3.isNumeric()) {
                    xtype = BasicType.Conversion(xtype2, xtype3);
                    break;
                }
                XmLog.fatal((String)"BinaryOp: bad type");
            }
            case BIT_OR_EXPR: {
                if (xobject2.isZeroConstant()) {
                    return xobject;
                }
                if (xobject.isZeroConstant()) {
                    return xobject2;
                }
                if (xtype2.isIntegral() && xtype3.isIntegral()) {
                    xtype = Xcons.ConversionIntegral(xtype2, xtype3);
                    break;
                }
                XmLog.fatal((String)"BinaryOp: bad type");
            }
            case BIT_AND_EXPR: {
                if (xobject2.isZeroConstant() || xobject.isZeroConstant()) {
                    return Xcons.IntConstant(0);
                }
                if (xtype2.isIntegral() && xtype3.isIntegral()) {
                    xtype = Xcons.ConversionIntegral(xtype2, xtype3);
                    break;
                }
                XmLog.fatal((String)"BinaryOp: bad type");
            }
            case BIT_XOR_EXPR: {
                if (xtype2.isIntegral() && xtype3.isIntegral()) {
                    xtype = Xcons.ConversionIntegral(xtype2, xtype3);
                    break;
                }
                XmLog.fatal((String)"BinaryOp: bad type");
            }
            case LOG_GE_EXPR: 
            case LOG_GT_EXPR: 
            case LOG_LE_EXPR: 
            case LOG_LT_EXPR: 
            case LOG_EQ_EXPR: 
            case LOG_NEQ_EXPR: {
                if (xtype2.isIntegral() && xtype3.isFloating()) {
                    xtype = Xtype.intType;
                    break;
                }
                if (xtype3.isIntegral() && xtype2.isFloating()) {
                    xtype = Xtype.intType;
                    break;
                }
                if (xtype2.isIntegral() && xtype3.isIntegral()) {
                    xtype = Xtype.intType;
                    break;
                }
                if (xtype2.isFloating() && xtype3.isFloating()) {
                    xtype = Xtype.intType;
                    break;
                }
                XmLog.fatal((String)"BinaryOp: bad type");
            }
            case LOG_AND_EXPR: 
            case LOG_OR_EXPR: {
                xtype = Xtype.intType;
                break;
            }
            case LSHIFT_EXPR: 
            case RSHIFT_EXPR: {
                if (xtype2.isIntegral() && xtype3.isIntegral()) {
                    xtype = xtype2;
                    break;
                }
                XmLog.fatal((String)"BinaryOp: bad type");
            }
            default: {
                XmLog.fatal((String)"BinaryOp: bad code");
            }
        }
        switch (xcode) {
            case PLUS_EXPR: {
                if (xobject.isIntConstant() && xobject2.isIntConstant()) {
                    return Xcons.Int(Xcode.INT_CONSTANT, xtype, xobject.getInt() + xobject2.getInt());
                }
                if (xobject.isZeroConstant()) {
                    if (xtype3.equals(xtype)) {
                        return xobject2;
                    }
                    return Xcons.Cast(xtype, xobject2);
                }
            }
            case MINUS_EXPR: {
                if (xcode == Xcode.MINUS_EXPR) {
                    if (xobject.isIntConstant() && xobject2.isIntConstant()) {
                        return Xcons.Int(Xcode.INT_CONSTANT, xtype, xobject.getInt() - xobject2.getInt());
                    }
                    if (xobject.isZeroConstant()) {
                        return Xcons.List(Xcode.UNARY_MINUS_EXPR, xtype, xobject2);
                    }
                }
                if (!xobject2.isZeroConstant() || xobject.code == Xcode.ARRAY_ADDR) break;
                if (xtype2.equals(xtype)) {
                    return xobject;
                }
                return Xcons.Cast(xtype, xobject);
            }
        }
        return Xcons.List(xcode, xtype, xobject, xobject2);
    }

    public static Xobject asgOp(Xcode xcode, Xobject xobject, Xobject xobject2) {
        if (xobject == null) {
            throw new NullPointerException("x");
        }
        if (xobject2 == null) {
            throw new NullPointerException("y");
        }
        Xtype xtype = null;
        Xtype xtype2 = xobject.Type();
        Xtype xtype3 = xobject2.Type();
        switch (xcode) {
            case ASG_PLUS_EXPR: 
            case ASG_MINUS_EXPR: {
                if (xtype2.isPointer() && xtype3.isIntegral()) {
                    xtype = xtype2;
                    break;
                }
                if (xtype3.isPointer() && xtype2.isIntegral()) {
                    xtype = xtype3;
                    break;
                }
            }
            case ASG_MUL_EXPR: 
            case ASG_DIV_EXPR: {
                if (xtype2.isIntegral() && xtype3.isFloating()) {
                    xtype = xtype2;
                    break;
                }
                if (xtype3.isIntegral() && xtype2.isFloating()) {
                    xtype = xtype3;
                    break;
                }
                if (xtype2.isIntegral() && xtype3.isIntegral()) {
                    xtype = Xcons.ConversionIntegral(xtype2, xtype3);
                    break;
                }
                if (xtype2.isFloating() && xtype3.isFloating()) {
                    xtype = BasicType.Conversion(xtype2, xtype3);
                    break;
                }
                XmLog.fatal((String)"AgnOp: bad type");
            }
            case ASG_MOD_EXPR: 
            case ASG_BIT_OR_EXPR: 
            case ASG_BIT_AND_EXPR: 
            case ASG_BIT_XOR_EXPR: {
                if (xtype2.isIntegral() && xtype3.isIntegral()) {
                    xtype = Xcons.ConversionIntegral(xtype2, xtype3);
                    break;
                }
                XmLog.fatal((String)"AsgOp: bad type");
            }
            case ASG_LSHIFT_EXPR: 
            case ASG_RSHIFT_EXPR: {
                if (xtype2.isIntegral() && xtype3.isIntegral()) {
                    xtype = xtype2;
                    break;
                }
                XmLog.fatal((String)"AsgOp: bad type");
            }
            default: {
                XmLog.fatal((String)"AsgOp: bad code");
            }
        }
        return Xcons.List(xcode, xtype, xobject, xobject2);
    }

    public static Xcode unAsgOpcode(Xcode xcode) {
        switch (xcode) {
            case ASG_PLUS_EXPR: 
            case POST_INCR_EXPR: 
            case PRE_INCR_EXPR: {
                return Xcode.PLUS_EXPR;
            }
            case ASG_MINUS_EXPR: 
            case POST_DECR_EXPR: 
            case PRE_DECR_EXPR: {
                return Xcode.MINUS_EXPR;
            }
            case ASG_MUL_EXPR: {
                return Xcode.MUL_EXPR;
            }
            case ASG_DIV_EXPR: {
                return Xcode.DIV_EXPR;
            }
            case ASG_MOD_EXPR: {
                return Xcode.MOD_EXPR;
            }
            case ASG_BIT_OR_EXPR: {
                return Xcode.BIT_OR_EXPR;
            }
            case ASG_BIT_AND_EXPR: {
                return Xcode.BIT_AND_EXPR;
            }
            case ASG_BIT_XOR_EXPR: {
                return Xcode.BIT_XOR_EXPR;
            }
            case ASG_LSHIFT_EXPR: {
                return Xcode.LSHIFT_EXPR;
            }
            case ASG_RSHIFT_EXPR: {
                return Xcode.RSHIFT_EXPR;
            }
        }
        XmLog.fatal((String)("unAsgOpcode: bad code, " + (Object)((Object)xcode)));
        return null;
    }

    public static Xcode revLogicalOpcode(Xcode xcode) {
        switch (xcode) {
            case LOG_EQ_EXPR: {
                return Xcode.LOG_NEQ_EXPR;
            }
            case LOG_NEQ_EXPR: {
                return Xcode.LOG_EQ_EXPR;
            }
            case LOG_GE_EXPR: {
                return Xcode.LOG_LT_EXPR;
            }
            case LOG_GT_EXPR: {
                return Xcode.LOG_LE_EXPR;
            }
            case LOG_LE_EXPR: {
                return Xcode.LOG_GT_EXPR;
            }
            case LOG_LT_EXPR: {
                return Xcode.LOG_GT_EXPR;
            }
        }
        XmLog.fatal((String)("revLogicalOpcode: bad code, " + (Object)((Object)xcode)));
        return null;
    }

    public static Xobject unaryOp(Xcode xcode, Xobject xobject) {
        if (xobject == null) {
            throw new NullPointerException("x");
        }
        Xtype xtype = xobject.Type();
        switch (xcode) {
            case UNARY_MINUS_EXPR: {
                if (xobject.Opcode() == Xcode.INT_CONSTANT) {
                    return Xcons.Int(Xcode.INT_CONSTANT, xobject.Type(), -xobject.getInt());
                }
                if (xtype.isIntegral() || xtype.isFloating()) break;
                XmLog.fatal((String)"UnaryOp: bad type");
            }
            case LOG_NOT_EXPR: {
                if (xtype.isIntegral() || xtype.isFloating()) {
                    xtype = Xtype.intType;
                    break;
                }
                if (xtype.isBool()) break;
                XmLog.fatal((String)"UnaryOp: bad type");
            }
            case BIT_NOT_EXPR: {
                if (xtype.isIntegral()) break;
                XmLog.fatal((String)"UnaryOp: bad type");
            }
            default: {
                XmLog.fatal((String)"BinaryOp: bad code");
            }
        }
        return Xcons.List(xcode, xtype, xobject);
    }

    public static Xobject SizeOf(Xtype xtype) {
        return Xcons.List(Xcode.SIZE_OF_EXPR, (Xtype)Xtype.intType, Xcons.List(Xcode.TYPE_NAME, xtype));
    }

    public static Xtype ConversionIntegral(Xtype xtype, Xtype xtype2) {
        if (xtype.isEnum() && xtype2.isEnum()) {
            return xtype;
        }
        if (xtype.isEnum() && !xtype2.isEnum() || !xtype.isEnum() && xtype2.isEnum()) {
            Xtype xtype3;
            Xtype xtype4 = xtype.isEnum() ? xtype : xtype2;
            Xtype xtype5 = xtype3 = xtype.isEnum() ? xtype2 : xtype;
            if (xtype3.getKind() == 1) {
                switch (xtype3.getBasicType()) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        return xtype4;
                    }
                }
            }
            return xtype3;
        }
        return BasicType.Conversion(xtype, xtype2);
    }

    public static Xobject Reduce(Xobject xobject) {
        return Xcons.Reduce(xobject, null);
    }

    public static Xobject Reduce(Xobject xobject, Block block) {
        Xobject xobject2;
        Xobject xobject3;
        if (xobject == null) {
            return null;
        }
        if (block != null && XmOption.isLanguageF()) {
            Ident ident = null;
            if (xobject.isVarRef()) {
                ident = block.findVarIdent(xobject.getName());
            } else if (xobject instanceof Ident) {
                ident = (Ident)xobject;
            }
            if (ident != null && ident.getFparamValue() != null) {
                return Xcons.Reduce(ident.getFparamValue().getArg(0), block);
            }
        }
        if (!xobject.Type().isIntegral()) {
            return xobject;
        }
        switch (xobject.Opcode()) {
            case UNARY_MINUS_EXPR: {
                Xobject xobject4 = Xcons.Reduce(xobject, block);
                if (xobject4.isIntConstant()) {
                    return Xcons.Int(Xcode.INT_CONSTANT, xobject.Type(), -xobject4.getInt());
                }
                return xobject4;
            }
            case PLUS_EXPR: {
                xobject3 = Xcons.Reduce(xobject.left(), block);
                xobject2 = Xcons.Reduce(xobject.right(), block);
                if (xobject3.isIntConstant() && xobject2.isIntConstant()) {
                    return Xcons.Int(Xcode.INT_CONSTANT, xobject.Type(), xobject3.getInt() + xobject2.getInt());
                }
                if (xobject2.isZeroConstant()) {
                    return xobject3;
                }
                if (!xobject3.isZeroConstant()) break;
                return xobject2;
            }
            case MINUS_EXPR: {
                xobject3 = Xcons.Reduce(xobject.left(), block);
                xobject2 = Xcons.Reduce(xobject.right(), block);
                if (xobject3.isIntConstant() && xobject2.isIntConstant()) {
                    return Xcons.Int(Xcode.INT_CONSTANT, xobject.Type(), xobject3.getInt() - xobject2.getInt());
                }
                if (xobject2.isZeroConstant()) {
                    return xobject3;
                }
                if (!xobject3.isZeroConstant()) break;
                return Xcons.List(Xcode.UNARY_MINUS_EXPR, xobject.Type(), xobject2);
            }
            case MUL_EXPR: {
                xobject3 = Xcons.Reduce(xobject.left(), block);
                xobject2 = Xcons.Reduce(xobject.right(), block);
                if (xobject3.isIntConstant() && xobject2.isIntConstant()) {
                    return Xcons.Int(Xcode.INT_CONSTANT, xobject.Type(), xobject3.getInt() * xobject2.getInt());
                }
                if (xobject3.isZeroConstant() || xobject2.isZeroConstant()) {
                    return Xcons.IntConstant(0);
                }
                if (xobject3.isOneConstant()) {
                    return xobject2;
                }
                if (!xobject2.isOneConstant()) break;
                return xobject3;
            }
            case DIV_EXPR: {
                xobject3 = Xcons.Reduce(xobject.left(), block);
                xobject2 = Xcons.Reduce(xobject.right(), block);
                if (xobject2.isZeroConstant()) break;
                if (xobject3.isIntConstant() && xobject2.isIntConstant()) {
                    return Xcons.Int(Xcode.INT_CONSTANT, xobject.Type(), xobject3.getInt() / xobject2.getInt());
                }
                if (xobject3.isZeroConstant()) {
                    return Xcons.IntConstant(0);
                }
                if (!xobject2.isOneConstant()) break;
                return xobject3;
            }
            case F_POWER_EXPR: {
                xobject3 = Xcons.Reduce(xobject.left(), block);
                xobject2 = Xcons.Reduce(xobject.right(), block);
                if (xobject3.isIntConstant() && xobject2.isIntConstant()) {
                    return Xcons.Int(Xcode.INT_CONSTANT, xobject.Type(), (int)Math.pow(xobject3.getInt(), xobject2.getInt()));
                }
                if (xobject3.isZeroConstant() || xobject2.isZeroConstant()) {
                    return Xcons.IntConstant(0);
                }
                if (!xobject3.isOneConstant() && !xobject2.isOneConstant()) break;
                return xobject3;
            }
            default: {
                return xobject;
            }
        }
        if (xobject3 != xobject.left() || xobject2 != xobject.right()) {
            return Xcons.List(xobject.Opcode(), xobject.Type(), xobject3, xobject2);
        }
        return xobject;
    }

    public static Xobject SymbolRef(Ident ident) {
        Xcode xcode;
        Xtype xtype = ident.Type();
        if (xtype == null) {
            throw new IllegalArgumentException("type of '" + ident.getName() + "' is not set.");
        }
        switch (xtype.getKind()) {
            case 6: {
                xcode = Xcode.ARRAY_REF;
                break;
            }
            case 5: {
                xcode = Xcode.FUNC_ADDR;
                xtype = Xtype.Pointer(xtype);
                break;
            }
            default: {
                xcode = Xcode.VAR;
            }
        }
        return Xcons.Symbol(xcode, xtype, ident.getName(), ident.getScope());
    }

    public static Xobject arrayRef(Xtype xtype, Xobject xobject, XobjList xobjList) {
        return Xcons.List(Xcode.ARRAY_REF, xtype, xobject, xobjList);
    }

    public static Xobject CompoundStatement(Xobject xobject, Xobject xobject2, Xobject xobject3) {
        return Xcons.List(Xcode.COMPOUND_STATEMENT, xobject, xobject2, xobject3);
    }

    public static Xobject CompoundStatement(Xobject xobject) {
        return Xcons.CompoundStatement(Xcons.IDList(), Xcons.List(), xobject);
    }

    public static Xobject statementList() {
        return Xcons.List(XmOption.isLanguageC() ? Xcode.LIST : Xcode.F_STATEMENT_LIST);
    }

    public static Xobject FstatementList() {
        return Xcons.List(Xcode.F_STATEMENT_LIST);
    }

    public static Xobject FstatementList(Xobject ... xobjectArray) {
        return Xcons.List(Xcode.F_STATEMENT_LIST, xobjectArray);
    }

    public static Xobject FvarRef(Ident ident) {
        return Xcons.List(Xcode.F_VAR_REF, ident.getAddr());
    }

    public static Xobject FindexRange(Xobject xobject, Xobject xobject2, Xobject xobject3) {
        return Xcons.List(Xcode.F_INDEX_RANGE, xobject, xobject2, xobject3);
    }

    public static Xobject FindexRange(Xobject xobject, Xobject xobject2) {
        return Xcons.FindexRange(xobject, xobject2, null);
    }

    public static Xobject FindexRange(Xobject xobject) {
        return Xcons.FindexRange(Xcons.IntConstant(1), xobject, null);
    }

    public static Xobject FindexRangeOfAssumedShape() {
        return Xcons.List(Xcode.F_INDEX_RANGE, new Xobject[]{null, null, null, Xcons.IntConstant(1)});
    }

    public static Xobject FindexRangeOfAssumedShape(Xobject xobject) {
        return Xcons.FindexRange(xobject, null);
    }

    public static Xobject FindexRangeOfAssumedSize() {
        return Xcons.List(Xcode.F_INDEX_RANGE, new Xobject[]{null, null, null, null, Xcons.IntConstant(1)});
    }

    public static Xobject FarrayIndex(Xobject xobject) {
        return Xcons.List(Xcode.F_ARRAY_INDEX, xobject);
    }

    public static Xobject FarrayRef(Xobject xobject, Xobject ... xobjectArray) {
        XobjList xobjList = Xcons.List(Xcode.F_ARRAY_REF, xobject.Type().getRef(), Xcons.List(Xcode.F_VAR_REF, xobject));
        XobjList xobjList2 = Xcons.List();
        if (xobject.Type().isFarray()) {
            int n = xobject.Type().getNumDimensions() - xobjectArray.length;
            for (int i = 0; i < n; ++i) {
                ((Xobject)xobjList2).add(Xcons.FindexRangeOfAssumedShape());
            }
        }
        for (Xobject xobject2 : xobjectArray) {
            ((Xobject)xobjList2).add(Xcons.List(Xcode.F_ARRAY_INDEX, xobject2));
        }
        ((Xobject)xobjList).add(xobjList2);
        return xobjList;
    }

    public static Xobject Fallocate(Xobject xobject, Xobject ... xobjectArray) {
        XobjList xobjList = Xcons.List(xobjectArray);
        return Xcons.List(Xcode.F_ALLOCATE_STATEMENT, new Xobject[]{null, Xcons.List(Xcons.List(Xcode.F_ALLOC, xobject, xobjList))});
    }

    public static Xobject FallocateByList(Xobject xobject, XobjList xobjList) {
        return Xcons.List(Xcode.F_ALLOCATE_STATEMENT, new Xobject[]{null, Xcons.List(Xcons.List(Xcode.F_ALLOC, xobject, xobjList))});
    }

    public static Xobject FpointerAssignment(Xobject xobject, Xobject xobject2) {
        return Xcons.List(Xcode.F_POINTER_ASSIGN_STATEMENT, xobject, xobject2);
    }

    public static Xobject FinterfaceFunctionDecl(Ident ident, XobjList xobjList) {
        return Xcons.List(Xcode.F_INTERFACE_DECL, new Xobject[]{null, Xcons.IntConstant(0), Xcons.IntConstant(0), Xcons.List(Xcons.List(Xcode.FUNCTION_DECL, ident, null, null, xobjList))});
    }

    public static Xobject StatementLabel(String string) {
        return Xcons.List(Xcode.STATEMENT_LABEL, Xcons.StringConstant(string));
    }
}

