/*
 * Decompiled with CFR 0.152.
 */
package exc.object;

import xcodeml.util.XmLog;

public enum StorageClass {
    SNULL(null),
    AUTO("auto"),
    PARAM("param"),
    EXTERN("extern"),
    EXTDEF("extern_def"),
    STATIC("static"),
    REGISTER("register"),
    LABEL("label"),
    ULABEL("_label"),
    TAGNAME("tagname"),
    MOE("moe"),
    TYPEDEF_NAME("typedef_name"),
    REG("_reg"),
    MEMBER("_member"),
    GCC_LABEL("gccLabel"),
    FLOCAL("flocal"),
    FSAVE("fsave"),
    FCOMMON("fcommon"),
    FPARAM("fparam"),
    FFUNC("ffunc"),
    FTYPE_NAME("ftype_name"),
    FCOMMON_NAME("fcommon_name"),
    FNAMELIST_NAME("fnamelist_name");

    private String xcodeStr;

    private StorageClass(String string2) {
        this.xcodeStr = string2;
    }

    public String toXcodeString() {
        return this.xcodeStr;
    }

    public boolean canBeAddressed() {
        switch (this) {
            case PARAM: 
            case AUTO: 
            case EXTERN: 
            case EXTDEF: 
            case STATIC: {
                return true;
            }
        }
        return false;
    }

    public boolean isVarOrFunc() {
        switch (this) {
            case PARAM: 
            case AUTO: 
            case EXTERN: 
            case EXTDEF: 
            case STATIC: 
            case REGISTER: 
            case FLOCAL: 
            case FSAVE: 
            case FCOMMON: 
            case FPARAM: 
            case FFUNC: {
                return true;
            }
        }
        return false;
    }

    public boolean isBSS() {
        switch (this) {
            case EXTERN: 
            case EXTDEF: 
            case STATIC: 
            case FSAVE: 
            case FCOMMON: {
                return true;
            }
        }
        return false;
    }

    public boolean isFuncParam() {
        switch (this) {
            case PARAM: 
            case FPARAM: {
                return true;
            }
        }
        return false;
    }

    public static StorageClass get(String string) {
        if (string == null) {
            return null;
        }
        for (StorageClass storageClass : StorageClass.values()) {
            if (!string.equalsIgnoreCase(storageClass.xcodeStr)) continue;
            return storageClass;
        }
        XmLog.fatal((String)("unkown class '" + string + "'"));
        return null;
    }
}

