/*
 * Decompiled with CFR 0.152.
 */
package exc.object;

import exc.object.Ident;
import exc.object.PragmaSyntax;
import exc.object.XobjArgs;
import exc.object.XobjList;
import exc.object.Xobject;
import exc.object.XobjectFile;
import exc.openmp.OMPpragmaParser;
import java.util.Stack;
import xcodeml.util.XmException;

public class PragmaParser {
    private XobjectFile xobjFile;
    private OMPpragmaParser ompPragmaParser;
    protected Stack<XobjList> stackEnv = new Stack();

    public PragmaParser(XobjectFile xobjectFile) {
        this.xobjFile = xobjectFile;
        this.ompPragmaParser = new OMPpragmaParser(this);
        this.pushEnv((XobjList)xobjectFile.getGlobalIdentList());
    }

    public void pushEnv(XobjList xobjList) {
        this.stackEnv.push(xobjList);
    }

    public void popEnv() {
        this.stackEnv.pop();
    }

    public XobjList peekEnv() {
        return this.stackEnv.peek();
    }

    public Ident findIdent(String string, int n) {
        for (int i = this.stackEnv.size() - 1; i >= 0; --i) {
            XobjList xobjList = (XobjList)this.stackEnv.get(i);
            Ident ident = xobjList.findIdent(string, n);
            if (ident == null) continue;
            return ident;
        }
        return null;
    }

    public XobjectFile getXobjectFile() {
        return this.xobjFile;
    }

    public Xobject parse(Xobject xobject) throws XmException {
        switch (xobject.Opcode()) {
            case OMP_PRAGMA: {
                return this.ompPragmaParser.parse(xobject);
            }
            case XMP_PRAGMA: {
                return xobject;
            }
        }
        return xobject;
    }

    public boolean isPrePostPair(Xobject xobject, Xobject xobject2) {
        switch (xobject.Opcode()) {
            case OMP_PRAGMA: {
                return this.ompPragmaParser.isPrePostPair(xobject, xobject2);
            }
        }
        return false;
    }

    public void completePragmaEnd(Xobject xobject, Xobject xobject2) {
        switch (xobject.Opcode()) {
            case OMP_PRAGMA: {
                this.ompPragmaParser.completePragmaEnd(xobject, xobject2);
            }
        }
    }

    public XobjArgs getAbbrevPostfix(XobjArgs xobjArgs) {
        switch (xobjArgs.getArg().Opcode()) {
            case OMP_PRAGMA: {
                return this.ompPragmaParser.getAbbrevPostfix(xobjArgs);
            }
        }
        return null;
    }

    public void mergeStartAndPostfixArgs(Xobject xobject, Xobject xobject2) {
        switch (xobject.Opcode()) {
            case OMP_PRAGMA: {
                this.ompPragmaParser.mergeStartAndPostfixArgs(xobject, xobject2);
            }
        }
    }

    public class Result {
        public final PragmaSyntax pragma_syntax;
        public final Xobject xobject;

        public Result(PragmaSyntax pragmaSyntax, Xobject xobject) {
            this.pragma_syntax = pragmaSyntax;
            this.xobject = xobject;
        }
    }
}

