/*
 * Decompiled with CFR 0.152.
 */
package exc.object;

import exc.block.Block;
import exc.object.Ident;
import exc.object.Xcons;
import exc.object.XobjConst;
import exc.object.Xobject;
import exc.object.Xtype;

public class Ftype {
    public static final int UNKNOWN = 1000;
    public static final int INTEGER = 1001;
    public static final int REAL = 1002;
    public static final int COMPLEX = 1003;
    public static final int LOGICAL = 1004;
    public static final int CHARACTER = 1005;
    public static final int DERIVED = 1006;
    private static final int UNEVALUABLE = -1;
    private static final int ASTERISK = -2;
    private Xtype xtype = null;
    private int basicType = 0;
    private Ident structTag = null;
    public Block block = null;
    public int type;
    public int kind;
    public Xobject kindExpr;
    public int len;
    public Xobject lenExpr;

    public Ftype(Xobject xobject) {
        this(xobject, null);
    }

    public Ftype(Xobject xobject, Block block) {
        this(xobject.Type(), block);
        if (xobject.isConstant() && ((XobjConst)xobject).getFkind() != null) {
            this.kind = 1000;
            this.kindExpr = null;
        }
    }

    public Ftype(Xtype xtype) {
        this(xtype, null);
    }

    public Ftype(Xtype xtype, Block block) {
        this.block = block;
        this._setXtypeEtc(xtype);
        this._setType();
        this._setKindAndKindExpr();
        this._setLenAndLenExpr();
    }

    public static Ftype Ftype(Xtype xtype) {
        Ftype ftype = new Ftype(xtype);
        return ftype;
    }

    public Ftype(int n, int n2, int n3, Block block) {
        this.block = block;
        this.basicType = n;
        this.xtype = null;
        this.structTag = null;
        this._setType();
        this._setKindAndKindExpr(n2);
        this._setLenAndLenExpr(n3);
    }

    public Ftype(int n, int n2, Block block) {
        this.block = block;
        this.basicType = n;
        this.xtype = null;
        this.structTag = null;
        this._setType();
        this._setKindAndKindExpr(n2);
        this._setLenAndLenExpr();
    }

    private void _setXtypeEtc(Xtype xtype) {
        switch (xtype.getKind()) {
            case 1: {
                this.xtype = xtype;
                this.basicType = xtype.getBasicType();
                this.structTag = null;
                break;
            }
            case 3: {
                this.xtype = xtype;
                this.basicType = 0;
                this.structTag = xtype.getTagIdent();
                break;
            }
            case 8: 
            case 10: {
                this._setXtypeEtc(xtype.getRef());
            }
        }
    }

    private void _setType() {
        this.type = this._getType();
    }

    private int _getType() {
        switch (this.basicType) {
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                return 1001;
            }
            case 13: 
            case 14: 
            case 15: {
                return 1002;
            }
            case 19: 
            case 20: 
            case 21: {
                return 1003;
            }
            case 23: {
                return 1005;
            }
            case 2: {
                return 1004;
            }
            case 0: {
                return 1006;
            }
        }
        return 1000;
    }

    private void _setKindAndKindExpr() {
        if (this.xtype != null && this.xtype.getFkind() != null) {
            this.kindExpr = this.xtype.getFkind().cfold(this.block);
            this.kind = this.kindExpr.isIntConstant() ? this.kindExpr.getInt() : -1;
        } else {
            this.kind = this._getKind();
            this.kindExpr = this.kind > 0 ? Xcons.IntConstant(this.kind) : null;
        }
    }

    private void _setKindAndKindExpr(int n) {
        this.kind = n;
        this.kindExpr = n > 0 ? Xcons.IntConstant(n) : null;
    }

    private int _getKind() {
        switch (this.basicType) {
            case 2: 
            case 7: 
            case 13: 
            case 19: 
            case 23: {
                return this._getDefaultKind(this.type);
            }
            case 5: {
                return 2;
            }
            case 9: {
                return 4;
            }
            case 11: 
            case 14: 
            case 20: {
                return 8;
            }
            case 15: 
            case 21: {
                return 16;
            }
        }
        return 1000;
    }

    private void _setLenAndLenExpr() {
        if (this.type != 1005) {
            this.len = 1000;
            this.lenExpr = null;
            return;
        }
        if (this.xtype != null) {
            if (this.xtype.isFlenVariable()) {
                this.len = -2;
                this.lenExpr = null;
                return;
            }
            if (this.xtype.getFlen() != null) {
                this.lenExpr = this.xtype.getFlen().cfold(this.block);
                this.len = this.lenExpr.isIntConstant() ? this.lenExpr.getInt() : -1;
                return;
            }
        }
        this.len = this._getDefaultLen(this.type);
        this.lenExpr = Xcons.IntConstant(this.len);
    }

    private void _setLenAndLenExpr(int n) {
        this.len = n;
        this.lenExpr = n > 0 ? Xcons.IntConstant(n) : null;
    }

    private int _getDefaultKind(int n) {
        switch (n) {
            case 1005: {
                return 1;
            }
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: {
                return 4;
            }
        }
        return 1000;
    }

    private int _getDefaultLen(int n) {
        switch (n) {
            case 1005: {
                return 1;
            }
        }
        return 1000;
    }

    public Boolean sameTypeAndKind(Xobject xobject) {
        Ftype ftype = new Ftype(xobject);
        return this.sameTypeAndKind(ftype);
    }

    public Boolean sameTypeAndKind(Xobject xobject, Block block) {
        Ftype ftype = new Ftype(xobject, block);
        return this.sameTypeAndKind(ftype);
    }

    public Boolean sameTypeAndKind(Xtype xtype) {
        Ftype ftype = new Ftype(xtype);
        return this.sameTypeAndKind(ftype);
    }

    public Boolean sameTypeAndKind(Xtype xtype, Block block) {
        Ftype ftype = new Ftype(xtype, block);
        return this.sameTypeAndKind(ftype);
    }

    public Boolean sameTypeAndKind(Ftype ftype) {
        if (this.type == ftype.getType() && this.kind == ftype.getKind()) {
            return true;
        }
        return false;
    }

    public String getNameOfConvFunction() {
        switch (this.type) {
            case 1001: {
                return "int";
            }
            case 1002: {
                return "real";
            }
            case 1003: {
                return "cmplx";
            }
            case 1004: {
                return "logical";
            }
            case 1005: {
                return "char";
            }
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public int getKind() {
        return this.kind;
    }

    public Xobject getKindExpr() {
        return this.kindExpr;
    }

    public int getLen() {
        return this.len;
    }

    public Xobject getLenExpr() {
        return this.lenExpr;
    }

    public Xtype getXtype() {
        return this.xtype;
    }

    public String toString() {
        switch (this.type) {
            case 1001: {
                return "INTEGER(kind=" + this.kind + ")";
            }
            case 1002: {
                return "REAL(kind=" + this.kind + ")";
            }
            case 1003: {
                return "COMPLEX(kind=" + this.kind + ")";
            }
            case 1004: {
                return "LOGICAL(kind=" + this.kind + ")";
            }
            case 1005: {
                return "REAL(len=" + this.len + ")";
            }
            case 1006: {
                return "type(" + this.structTag.getName() + ")";
            }
            case 1000: {
                return "UNKNOWN";
            }
        }
        return "illegal type number=" + this.type;
    }
}

