/*
 * Decompiled with CFR 0.152.
 */
package exc.object;

import exc.block.Block;
import exc.object.FarrayType;
import exc.object.FindexRange;
import exc.object.Ident;
import exc.object.XobjString;
import exc.object.Xobject;
import exc.object.Xtype;

public class Fshape {
    private Block block = null;
    private int _n_subs;
    private Xobject[] _lbound;
    private Xobject[] _ubound;
    private Xobject[] _extent;

    public Fshape(FindexRange findexRange) {
        this._n_subs = findexRange.getNumSubs();
        this._lbound = findexRange.getLbounds();
        this._ubound = findexRange.getUbounds();
        this._extent = findexRange.getExtents();
    }

    public Fshape(FarrayType farrayType, Block block) {
        this(farrayType.getFindexRange(block));
        this.block = block;
    }

    public Fshape(Ident ident) {
        this._n_subs = ident.getFrank();
        if (this._n_subs == 0) {
            this._lbound = null;
            this._ubound = null;
            this._extent = null;
            return;
        }
        Xtype xtype = ident.Type();
        switch (xtype.getKind()) {
            case 1: {
                Fshape._restrict("Ident of Xtype.BASIC not supported. ident=" + ident);
                break;
            }
            case 8: {
                Fshape fshape = new Fshape((FarrayType)xtype, this.block);
                this._lbound = fshape.lbounds();
                this._ubound = fshape.ubounds();
                this._extent = fshape.extents();
                break;
            }
            case 10: {
                Fshape._restrict("Ident of Xtype.F_COARRAY not supported. ident=" + ident);
                break;
            }
            default: {
                Fshape._error("Found illegal type of ident. ident=" + ident);
                return;
            }
        }
    }

    public Fshape(XobjString xobjString, Block block) {
        this(xobjString.findIdent(block));
    }

    public Fshape(Xobject xobject) {
        this(xobject, null);
    }

    public Fshape(Xobject xobject, Block block) {
        this.block = block;
        Fshape._error("unexpected Xobject. xobj=" + xobject);
    }

    public Xobject[] lbounds() {
        return this._lbound;
    }

    public Xobject lbound(int n) {
        return this._lbound[n];
    }

    public Xobject[] ubounds() {
        return this._ubound;
    }

    public Xobject ubound(int n) {
        return this._ubound[n];
    }

    public Xobject[] extents() {
        return this._extent;
    }

    public Xobject extent(int n) {
        return this._extent[n];
    }

    private static void _info(String string) {
        System.err.println("[XMP Fshape] INFO: " + string);
    }

    private static void _warn(String string) {
        System.err.println("[XMP Fshape] WARNING: " + string);
    }

    private static void _error(String string) {
        System.err.println("[XMP Fshape] ERROR: " + string);
    }

    private static void _restrict(String string) {
        System.err.println("[XMP Fshape] RESTRICTION: " + string);
    }
}

