/*
 * Decompiled with CFR 0.152.
 */
package exc.object;

import exc.block.Block;
import exc.object.Ident;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjInt;
import exc.object.Xobject;
import exc.object.Xtype;
import exc.xmpF.XMPenv;

public class FindexRange {
    private int n_subs;
    private Xobject[] subscripts;
    private Block block = null;
    private XMPenv env = null;

    public FindexRange(Xobject[] xobjectArray) {
        this.n_subs = xobjectArray.length;
        this.subscripts = xobjectArray;
    }

    public FindexRange(Xobject[] xobjectArray, Block block) {
        this(xobjectArray);
        this.block = block;
    }

    public FindexRange(Xobject[] xobjectArray, Block block, XMPenv xMPenv) {
        this(xobjectArray, block);
        this.env = xMPenv;
    }

    public FindexRange(Xobject xobject) {
        this.n_subs = 1;
        this.subscripts = new Xobject[1];
        this.subscripts[0] = xobject;
    }

    public FindexRange(Xobject xobject, Block block) {
        this(xobject);
        this.block = block;
    }

    public FindexRange(Xobject xobject, Block block, XMPenv xMPenv) {
        this(xobject, block);
        this.env = xMPenv;
    }

    public Xobject getLbound(int n) {
        Xobject xobject = this.getLboundOrNull(n);
        if (xobject == null) {
            xobject = Xcons.IntConstant(1);
        }
        return xobject;
    }

    public Xobject getLboundOrNull(int n) {
        if (this.subscripts.length <= n || this.subscripts[n] == null) {
            return Xcons.IntConstant(1);
        }
        if (this.subscripts[n].code != Xcode.F_INDEX_RANGE) {
            return Xcons.IntConstant(1);
        }
        Xobject xobject = this.subscripts[n].getArg(0);
        if (xobject == null) {
            return null;
        }
        return xobject.cfold(this.block);
    }

    public Xobject getUbound(int n) {
        if (this.subscripts.length <= n || this.subscripts[n] == null) {
            return null;
        }
        Xobject xobject = this.subscripts[n].code == Xcode.F_INDEX_RANGE ? this.subscripts[n].getArg(1) : this.subscripts[n];
        if (xobject == null) {
            return null;
        }
        return xobject.cfold(this.block);
    }

    public Xobject[] getLbounds() {
        Xobject[] xobjectArray = new Xobject[this.n_subs];
        for (int i = 0; i < this.n_subs; ++i) {
            xobjectArray[i] = this.getLbound(i);
        }
        return xobjectArray;
    }

    public Xobject[] getUbounds() {
        Xobject[] xobjectArray = new Xobject[this.n_subs];
        for (int i = 0; i < this.n_subs; ++i) {
            xobjectArray[i] = this.getUbound(i);
        }
        return xobjectArray;
    }

    public Xobject getExtent(int n) {
        Xobject xobject = this.subscripts[n].code == Xcode.F_INDEX_RANGE ? this.getSizeFromLbUb(this.subscripts[n].getArg(0), this.subscripts[n].getArg(1)) : Xcons.IntConstant(1);
        return xobject;
    }

    public Xobject[] getExtents() {
        Xobject[] xobjectArray = new Xobject[this.n_subs];
        for (int i = 0; i < this.n_subs; ++i) {
            xobjectArray[i] = this.getExtent(i);
        }
        return xobjectArray;
    }

    public Xobject getTotalArraySizeExpr() {
        Xobject xobject = Xcons.IntConstant(1);
        for (int i = 0; i < this.n_subs; ++i) {
            Xobject xobject2 = this.getExtent(i);
            if (xobject2.isZeroConstant()) {
                return Xcons.IntConstant(0);
            }
            xobject = xobject2.isIntConstant() && xobject.isIntConstant() ? Xcons.IntConstant(((Xobject)xobject).getInt() * xobject2.getInt()) : Xcons.binaryOp(Xcode.MUL_EXPR, xobject, xobject2);
        }
        return xobject;
    }

    public Xobject getSizeFromIndexRange(Xobject xobject) {
        if (xobject == null) {
            throw new UnsupportedOperationException("internal error: index range is null");
        }
        Xobject xobject2 = xobject.getArg(0);
        Xobject xobject3 = xobject.getArg(1);
        return this.getSizeFromLbUb(xobject2, xobject3);
    }

    public Xobject getSizeFromLbUb(int n, Xobject xobject, Xobject xobject2) {
        if (xobject == null) {
            xobject = this.getLbound(n);
        }
        if (xobject2 == null) {
            xobject2 = this.getUbound(n);
        }
        return this.getSizeFromLbUb(xobject, xobject2);
    }

    public Xobject getSizeFromLbUb(Xobject xobject, Xobject xobject2) {
        Xobject xobject3;
        Xobject xobject4;
        if (xobject2 == null) {
            return null;
        }
        xobject2 = xobject2.cfold(this.block);
        if (xobject == null) {
            return xobject2;
        }
        if (xobject2.equals(xobject = xobject.cfold(this.block))) {
            return Xcons.IntConstant(1);
        }
        if (xobject.isIntConstant()) {
            if (xobject2.isIntConstant()) {
                int n = xobject2.getInt() - xobject.getInt() + 1;
                if (n < 0) {
                    n = 0;
                }
                return Xcons.IntConstant(n);
            }
            xobject4 = Xcons.IntConstant(xobject.getInt() - 1);
            xobject3 = Xcons.binaryOp(Xcode.MINUS_EXPR, xobject2, xobject4);
        } else if (xobject2.isIntConstant()) {
            xobject4 = Xcons.IntConstant(xobject2.getInt() + 1);
            xobject3 = Xcons.binaryOp(Xcode.MINUS_EXPR, xobject4, xobject);
        } else {
            xobject4 = Xcons.binaryOp(Xcode.MINUS_EXPR, xobject2, xobject);
            xobject3 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject4, Xcons.IntConstant(1));
        }
        xobject4 = Xcons.IntConstant(0);
        Ident ident = this.env.declIntrinsicIdent("max", Xtype.FintFunctionType);
        Xobject xobject5 = ident.Call(Xcons.List(xobject3, xobject4));
        return xobject5.cfold(this.block);
    }

    public Xobject getSizeFromTriplet(int n, Xobject xobject, Xobject xobject2, Xobject xobject3) {
        if (xobject == null) {
            xobject = this.getLbound(n);
        }
        if (xobject2 == null) {
            xobject2 = this.getUbound(n);
        }
        return this.getSizeFromTriplet(xobject, xobject2, xobject3);
    }

    public Xobject getSizeFromTriplet(Xobject xobject, Xobject xobject2, Xobject xobject3) {
        if (xobject3 == null) {
            return this.getSizeFromLbUb(xobject, xobject2);
        }
        if ((xobject3 = xobject3.cfold(this.block)).isIntConstant()) {
            if (xobject3.getInt() == 1) {
                return this.getSizeFromLbUb(xobject, xobject2);
            }
            if (xobject3.getInt() == -1) {
                return this.getSizeFromLbUb(xobject2, xobject);
            }
        }
        if (xobject2 == null) {
            return null;
        }
        if ((xobject2 = xobject2.cfold(this.block)).equals(xobject = xobject == null ? Xcons.IntConstant(1) : xobject.cfold(this.block))) {
            return Xcons.IntConstant(1);
        }
        if (xobject.isIntConstant() && xobject2.isIntConstant() && xobject3.isIntConstant()) {
            int n;
            int n2 = xobject3.getInt();
            int n3 = n = n2 > 0 ? (xobject2.getInt() - xobject.getInt() + n2) / n2 : (xobject.getInt() - xobject2.getInt() - n2) / -n2;
            if (n < 0) {
                n = 0;
            }
            return Xcons.IntConstant(n);
        }
        Xobject xobject4 = Xcons.binaryOp(Xcode.MINUS_EXPR, xobject2, xobject);
        Xobject xobject5 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject4, xobject3);
        Xobject xobject6 = Xcons.binaryOp(Xcode.DIV_EXPR, xobject5, xobject3);
        XobjInt xobjInt = Xcons.IntConstant(0);
        Ident ident = this.env.declIntrinsicIdent("max", Xtype.FintFunctionType);
        Xobject xobject7 = ident.Call(Xcons.List(xobject6, xobjInt));
        return xobject7.cfold(this.block);
    }

    public int getNumSubs() {
        return this.n_subs;
    }
}

