/*
 * Decompiled with CFR 0.152.
 */
package exc.object;

import exc.block.Block;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;
import java.math.BigInteger;

public class FconstFolder {
    public boolean verbose = false;
    private Block block;
    private Xobject expr;
    private String fname;
    private XobjList argList;
    private int nargs;
    private XobjList oprds;
    private boolean failed = false;

    public FconstFolder(Xobject xobject) {
        this(xobject, null);
    }

    public FconstFolder(Xobject xobject, Block block) {
        this.expr = xobject;
        this.block = block;
    }

    public Xobject run() {
        if (this.verbose) {
            FconstFolder._info("Valur of " + this.expr);
        }
        Xobject xobject = this.evalAsInitializationExpr();
        if (this.verbose) {
            FconstFolder._info("      is " + xobject);
        }
        return xobject;
    }

    public Xobject evalAsInitializationExpr() {
        Xobject xobject = this.evalAsScalarIntConstant();
        if (xobject != null) {
            return xobject;
        }
        if (this.expr.Opcode() == Xcode.FUNCTION_CALL) {
            this.fname = this.expr.left().getName().toLowerCase();
            this.argList = (XobjList)this.expr.right();
            this.nargs = 0;
            if (this.argList != null) {
                this.nargs = this.argList.Nargs();
            }
            if ((xobject = this.evalAsInquireIntrinsicFunction()) != null) {
                return xobject;
            }
            xobject = this.evalAsElementalIntrinsicFunction();
            if (xobject != null) {
                return xobject;
            }
        } else {
            this.oprds = (XobjList)this.expr;
            xobject = null;
            switch (this.oprds.Nargs()) {
                case 1: {
                    Xobject xobject2 = this.oprds.getArg(0).cfold(this.block);
                    if (!xobject2.isIntConstant()) break;
                    xobject = this.evalAsIntrinsicUnaryOp(xobject2.getInt());
                    break;
                }
                case 2: {
                    Xobject xobject3 = this.oprds.getArg(0).cfold(this.block);
                    Xobject xobject4 = this.oprds.getArg(1).cfold(this.block);
                    if (!xobject3.isIntConstant() || !xobject4.isIntConstant()) break;
                    xobject = this.evalAsIntrinsicBinaryOp(xobject3.getInt(), xobject4.getInt());
                    break;
                }
            }
            if (xobject != null) {
                return xobject;
            }
        }
        return null;
    }

    private Xobject evalAsScalarIntConstant() {
        if (this.expr.canGetInt()) {
            return this.expr;
        }
        return null;
    }

    private Xobject evalAsInquireIntrinsicFunction() {
        if (this.fname == "lbound") {
            if (this.nargs == 1) {
                return this._evalIntrinsic_lboundWithoutDim();
            }
            if (this.nargs == 2) {
                return this._evalIntrinsic_lboundWithDim();
            }
        } else if (this.fname == "ubound") {
            if (this.nargs == 1) {
                return this._evalIntrinsic_uboundWithoutDim();
            }
            if (this.nargs == 2) {
                return this._evalIntrinsic_uboundWithDim();
            }
        } else if (this.fname == "shape") {
            if (this.nargs == 1) {
                return this._evalIntrinsic_shape();
            }
        } else if (this.fname == "size") {
            if (this.nargs == 1) {
                return this._evalIntrinsic_sizeWithoutDim();
            }
            if (this.nargs == 2) {
                return this._evalIntrinsic_sizeWithDim();
            }
        } else {
            if (this.fname == "lcobound") {
                return this._evalIntrinsic_lcobound();
            }
            if (this.fname == "ucobound") {
                return this._evalIntrinsic_ucobound();
            }
            if (this.fname != "bit_size" && this.fname != "len") {
                if (this.fname == "kind") {
                    return this._evalIntrinsic_kind();
                }
                if (this.fname == "digits" || this.fname == "epsilon" || this.fname == "huge" || this.fname == "maxexponent" || this.fname == "minexponent" || this.fname == "precision" || this.fname == "radix" || this.fname == "range" || this.fname == "tiny" || this.fname == "repeat" || this.fname == "reshape" || this.fname == "selected_int_kind" || this.fname == "selected_real_kind" || this.fname == "transfer" || this.fname == "trim" || this.fname != "len" || this.nargs == 1) {
                    // empty if block
                }
            }
        }
        return null;
    }

    private Xobject _evalIntrinsic_lboundWithoutDim() {
        Xobject xobject = this._getArg("array", 0);
        if (this.failed) {
            return null;
        }
        FconstFolder._error("cannot evaluate intrinsic function 'lbound' without 'dim'");
        return null;
    }

    private Xobject _evalIntrinsic_lboundWithDim() {
        Xobject xobject = this._getArg("array", 0);
        int n = this._getArgAsInt("dim", 1);
        if (this.failed) {
            return null;
        }
        return xobject.lbound(n - 1, this.block);
    }

    private Xobject _evalIntrinsic_uboundWithoutDim() {
        Xobject xobject = this._getArg("array", 0);
        if (this.failed) {
            return null;
        }
        FconstFolder._error("cannot evaluate intrinsic function 'lbound' without 'dim'");
        return null;
    }

    private Xobject _evalIntrinsic_uboundWithDim() {
        Xobject xobject = this._getArg("array", 0);
        int n = this._getArgAsInt("dim", 1);
        if (this.failed) {
            return null;
        }
        return xobject.ubound(n - 1, this.block);
    }

    private Xobject _evalIntrinsic_shape() {
        Xobject xobject = this._getArg("source", 0);
        if (this.failed) {
            return null;
        }
        FconstFolder._error("cannot evaluate intrinsic function shape");
        return null;
    }

    private Xobject _evalIntrinsic_sizeWithoutDim() {
        Xobject xobject = this._getArg("array", 0);
        if (this.failed) {
            return null;
        }
        return this._eval_sizeProduct(xobject);
    }

    private Xobject _evalIntrinsic_sizeWithDim() {
        Xobject xobject = this._getArg("array", 0);
        int n = this._getArgAsInt("dim", 1);
        if (this.failed) {
            return null;
        }
        return xobject.extent(n - 1, this.block);
    }

    private Xobject _eval_sizeProduct(Xobject xobject) {
        int n = xobject.getFrank(this.block);
        long l = 1L;
        for (int i = 0; i < n; ++i) {
            Xobject xobject2 = xobject.extent(i);
            if (xobject2.isIntConstant()) {
                if ((l *= (long)xobject2.getInt()) < Integer.MIN_VALUE) continue;
                FconstFolder._warn("integer operation overflow to get array size");
                return null;
            }
            return null;
        }
        return Xcons.IntConstant((int)l);
    }

    private Xobject _evalIntrinsic_lcobound() {
        Xobject xobject = this._getArg("coarray", 0);
        if (this.failed) {
            return null;
        }
        FconstFolder._error("cannot evaluate intrinsic function 'lcobound'");
        return null;
    }

    private Xobject _evalIntrinsic_ucobound() {
        Xobject xobject = this._getArg("coarray", 0);
        if (this.failed) {
            return null;
        }
        FconstFolder._error("cannot evaluate intrinsic function 'ucobound'");
        return null;
    }

    private Xobject _evalIntrinsic_kind() {
        Xobject xobject = this._getArg("x", 0);
        if (this.failed) {
            return null;
        }
        FconstFolder._restrict("cannot evaluate intrinsic function 'kind'");
        System.out.println("GACCHA KIND");
        return null;
    }

    private Xobject evalAsElementalIntrinsicFunction() {
        if (this.expr.Opcode() != Xcode.FUNCTION_CALL) {
            return null;
        }
        XobjList xobjList = (XobjList)this.expr.right();
        int n = 0;
        if (xobjList != null) {
            n = xobjList.Nargs();
        }
        String string = this.expr.left().getName();
        if ((string = string.toLowerCase()) == "abs" && n == 1) {
            return this.evalIntrinsic_abs();
        }
        if (string == "dim" && n == 1) {
            return this.evalIntrinsic_dim();
        }
        if (string == "max" && n == 2) {
            return this.evalIntrinsic_max(n);
        }
        if (string == "min") {
            return this.evalIntrinsic_min(n);
        }
        if (string == "mod" && n == 2) {
            return this.evalIntrinsic_mod();
        }
        if (string == "modulo" && n == 2) {
            return this.evalIntrinsic_modulo();
        }
        if (string == "sign" && n == 1) {
            return this.evalIntrinsic_sign();
        }
        if (string != "len_trim" || n == 1) {
            // empty if block
        }
        return null;
    }

    private Xobject evalIntrinsic_abs() {
        int n = this._getArgAsInt("a", 0);
        if (this.failed) {
            return null;
        }
        int n2 = n >= 0 ? n : -n;
        return Xcons.IntConstant(n2);
    }

    private Xobject evalIntrinsic_dim() {
        int n = this._getArgAsInt("x", 0);
        int n2 = this._getArgAsInt("y", 1);
        if (this.failed) {
            return null;
        }
        int n3 = n > n2 ? n - n2 : 0;
        return Xcons.IntConstant(n3);
    }

    private Xobject evalIntrinsic_max(int n) {
        if (n < 2) {
            return null;
        }
        int n2 = this._getArgAsInt("a1", 0);
        if (this.failed) {
            return null;
        }
        for (int i = 2; i < n; ++i) {
            int n3 = this._getArgAsInt(null, i);
            if (this.failed) {
                return null;
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return Xcons.IntConstant(n2);
    }

    private Xobject evalIntrinsic_min(int n) {
        if (n < 2) {
            return null;
        }
        int n2 = this._getArgAsInt("a1", 0);
        if (this.failed) {
            return null;
        }
        for (int i = 1; i < n; ++i) {
            int n3 = this._getArgAsInt(null, i);
            if (this.failed) {
                return null;
            }
            if (n3 >= n2) continue;
            n2 = n3;
        }
        return Xcons.IntConstant(n2);
    }

    private Xobject evalIntrinsic_mod() {
        int n = this._getArgAsInt("a", 0);
        int n2 = this._getArgAsInt("p", 1);
        if (this.failed) {
            return null;
        }
        if (n2 == 0) {
            FconstFolder._error("division by zero in intrinsic function 'mod'");
            return null;
        }
        int n3 = n - n / n2 * n2;
        return Xcons.IntConstant(n3);
    }

    private Xobject evalIntrinsic_modulo() {
        int n = this._getArgAsInt("a", 0);
        int n2 = this._getArgAsInt("p", 1);
        if (this.failed) {
            return null;
        }
        if (n2 == 0) {
            FconstFolder._error("division by zero in intrinsic function 'modulo'");
            return null;
        }
        int n3 = n - n / n2 * n2;
        if (n < 0 && n2 > 0) {
            n3 += n2;
        } else if (n > 0 && n2 < 0) {
            n3 -= n2;
        }
        return Xcons.IntConstant(n3);
    }

    private Xobject evalIntrinsic_sign() {
        int n = this._getArgAsInt("a", 0);
        int n2 = this._getArgAsInt("b", 1);
        if (this.failed) {
            return null;
        }
        int n3 = n2 >= 0 ? (n >= 0 ? n : -n) : (n <= 0 ? n : -n);
        return Xcons.IntConstant(n3);
    }

    private Xobject evalAsIntrinsicUnaryOp(int n) {
        Xcode xcode = this.expr.Opcode();
        int n2 = 0;
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = BigInteger.valueOf(n);
        boolean bl = false;
        switch (xcode) {
            case UNARY_MINUS_EXPR: {
                n2 = -n;
                bigInteger = bigInteger2.negate();
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        if (bigInteger.compareTo(BigInteger.valueOf(n2)) != 0) {
            return null;
        }
        return Xcons.IntConstant(n2);
    }

    private Xobject evalAsIntrinsicBinaryOp(int n, int n2) {
        Xcode xcode = this.expr.Opcode();
        int n3 = 0;
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = BigInteger.valueOf(n);
        BigInteger bigInteger3 = BigInteger.valueOf(n2);
        boolean bl = false;
        switch (xcode) {
            case PLUS_EXPR: {
                n3 = n + n2;
                bigInteger = bigInteger2.add(bigInteger3);
                break;
            }
            case MINUS_EXPR: {
                n3 = n - n2;
                bigInteger = bigInteger2.subtract(bigInteger3);
                break;
            }
            case MUL_EXPR: {
                n3 = n * n2;
                bigInteger = bigInteger2.multiply(bigInteger3);
                break;
            }
            case DIV_EXPR: {
                n3 = n / n2;
                bigInteger = bigInteger2.divide(bigInteger3);
                break;
            }
            case F_POWER_EXPR: {
                bl = true;
                break;
            }
            case LOG_NOT_EXPR: 
            case LOG_EQ_EXPR: 
            case LOG_NEQ_EXPR: 
            case LOG_GE_EXPR: 
            case LOG_GT_EXPR: 
            case LOG_LE_EXPR: 
            case LOG_LT_EXPR: 
            case LOG_AND_EXPR: 
            case LOG_OR_EXPR: 
            case F_LOG_EQV_EXPR: 
            case F_LOG_NEQV_EXPR: {
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        if (bigInteger.compareTo(BigInteger.valueOf(n3)) != 0) {
            return null;
        }
        return Xcons.IntConstant(n3);
    }

    private int _getArgAsInt(String string, int n) {
        Xobject xobject = this._getIntConstArg(string, n);
        if (this.failed) {
            return 0;
        }
        return xobject.getInt();
    }

    private Xobject _getIntConstArg(String string, int n) {
        Xobject xobject = this._getArg(string, n);
        if (this.failed) {
            return null;
        }
        if (!(xobject = xobject.cfold(this.block)).isIntConstant()) {
            this.failed = true;
            return null;
        }
        return xobject;
    }

    private Xobject _getArg(String string, int n) {
        Xobject xobject = string != null ? this.argList.getArgWithKeyword(string, n) : this.argList.getArgOrNull(n);
        if (xobject == null) {
            this.failed = true;
            return null;
        }
        return xobject;
    }

    private static void _info(String string) {
        System.err.println("[XMP FconstFolder] INFO: " + string);
    }

    private static void _warn(String string) {
        System.err.println("[XMP FconstFolder] WARNING: " + string);
    }

    private static void _error(String string) {
        System.err.println("[XMP FconstFolder] ERROR: " + string);
    }

    private static void _restrict(String string) {
        System.err.println("[XMP FconstFolder] RESTRICTION: " + string);
    }
}

