/*
 * Decompiled with CFR 0.152.
 */
package exc.object;

import exc.block.Block;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.Xobject;
import exc.object.Xtype;
import java.util.HashMap;

public class BasicType
extends Xtype {
    public static final int UNDEF = 0;
    public static final int VOID = 1;
    public static final int BOOL = 2;
    public static final int CHAR = 3;
    public static final int UNSIGNED_CHAR = 4;
    public static final int SHORT = 5;
    public static final int UNSIGNED_SHORT = 6;
    public static final int INT = 7;
    public static final int UNSIGNED_INT = 8;
    public static final int LONG = 9;
    public static final int UNSIGNED_LONG = 10;
    public static final int LONGLONG = 11;
    public static final int UNSIGNED_LONGLONG = 12;
    public static final int FLOAT = 13;
    public static final int DOUBLE = 14;
    public static final int LONG_DOUBLE = 15;
    public static final int FLOAT_IMAGINARY = 16;
    public static final int DOUBLE_IMAGINARY = 17;
    public static final int LONG_DOUBLE_IMAGINARY = 18;
    public static final int FLOAT_COMPLEX = 19;
    public static final int DOUBLE_COMPLEX = 20;
    public static final int LONG_DOUBLE_COMPLEX = 21;
    public static final int GCC_BUILTIN_VA_LIST = 22;
    public static final int F_CHARACTER = 23;
    public static final int F_NUMERIC = 24;
    public static final int F_NUMERIC_ALL = 25;
    private int basic_type;
    private Xobject fkind;
    private Xobject flen;

    public BasicType(int n, String string, long l, Xobject xobject, Xobject xobject2, Xobject xobject3, Xobject[] xobjectArray) {
        super(1, string, l, xobject, xobjectArray);
        this.basic_type = n;
        this.fkind = xobject2;
        this.flen = xobject3;
    }

    public BasicType(int n) {
        this(n, (String)null, 0L, (Xobject)null, (Xobject)null, (Xobject)null);
    }

    public BasicType(int n, long l) {
        this(n, (String)null, l, (Xobject)null, (Xobject)null, (Xobject)null);
    }

    public BasicType(int n, String string, long l, Xobject xobject, Xobject xobject2, Xobject xobject3) {
        this(n, string, l, xobject, xobject2, xobject3, null);
    }

    @Override
    public int getBasicType() {
        return this.basic_type;
    }

    public static final Xtype.TypeInfo getTypeInfo(int n) {
        for (int i = 0; i < type_infos.length; ++i) {
            if (BasicType.type_infos[i].type.getBasicType() != n) continue;
            return type_infos[i];
        }
        return null;
    }

    public static final Xtype.TypeInfo getTypeInfoByName(String string) {
        for (int i = 0; i < type_infos.length; ++i) {
            if (!string.equals(BasicType.type_infos[i].cname) && !string.equals(BasicType.type_infos[i].fname)) continue;
            return type_infos[i];
        }
        return null;
    }

    public static final Xtype.TypeInfo getTypeInfoByCName(String string) {
        for (int i = 0; i < type_infos.length; ++i) {
            if (!string.equals(BasicType.type_infos[i].cname)) continue;
            return type_infos[i];
        }
        return null;
    }

    public static final Xtype.TypeInfo getTypeInfoByFName(String string) {
        for (int i = 0; i < type_infos.length; ++i) {
            if (!string.equals(BasicType.type_infos[i].fname)) continue;
            return type_infos[i];
        }
        return null;
    }

    @Override
    public boolean isUnsigned() {
        switch (this.basic_type) {
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isIntegral() {
        return this.basic_type >= 3 && this.basic_type <= 12;
    }

    @Override
    public boolean isBool() {
        return this.basic_type == 2;
    }

    @Override
    public boolean isFloating() {
        return this.basic_type >= 13 && this.basic_type <= 15;
    }

    @Override
    public boolean isComplexOrImaginary() {
        return this.basic_type >= 19 && this.basic_type <= 21;
    }

    @Override
    public boolean isNumeric() {
        return this.isIntegral() || this.isFloating() || this.isComplexOrImaginary() || this.basic_type == 24 || this.basic_type == 25;
    }

    @Override
    public boolean isVoid() {
        return this.basic_type == 1;
    }

    @Override
    public Xobject getFkind() {
        return this.fkind;
    }

    @Override
    public Xobject getFlen() {
        return this.flen;
    }

    public void setFlen(Xobject xobject) {
        this.flen = xobject;
    }

    @Override
    public boolean isFlenVariable() {
        return this.isFlenAssumedSize();
    }

    @Override
    public boolean isFlenAssumedShape() {
        return this.flen != null && this.flen.Opcode() == Xcode.INT_CONSTANT && this.flen.getInt() == -1;
    }

    @Override
    public boolean isFlenAssumedSize() {
        return this.flen != null && this.flen.Opcode() == Xcode.INT_CONSTANT && this.flen.getInt() == -2;
    }

    public static Xtype Conversion(Xtype xtype, Xtype xtype2) {
        int n;
        int n2 = xtype.getBasicType();
        if (n2 > (n = xtype2.getBasicType())) {
            return BasicType.getTypeInfo((int)n2).type;
        }
        return BasicType.getTypeInfo((int)n).type;
    }

    @Override
    public Xobject getTotalArraySizeExpr(Block block) {
        return Xcons.IntConstant(1);
    }

    @Override
    public Xobject getElementLengthExpr(Block block) {
        int n = this.getElementLength(block);
        return Xcons.IntConstant(n);
    }

    @Override
    public int getElementLength(Block block) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(){
            {
                this.put(0, 0);
                this.put(1, 0);
                this.put(2, 4);
                this.put(3, 1);
                this.put(4, 1);
                this.put(5, 2);
                this.put(6, 2);
                this.put(7, 4);
                this.put(8, 4);
                this.put(9, 4);
                this.put(10, 4);
                this.put(11, 8);
                this.put(12, 8);
                this.put(13, 4);
                this.put(14, 8);
                this.put(15, 8);
                this.put(16, 4);
                this.put(17, 8);
                this.put(18, 8);
                this.put(19, 8);
                this.put(20, 16);
                this.put(21, 32);
                this.put(22, 0);
                this.put(23, 1);
                this.put(24, 0);
                this.put(25, 0);
            }
        };
        if (this.basic_type == 23) {
            if (this.fkind != null && this.flen.getInt() != 1) {
                throw new UnsupportedOperationException("unsupported kind parameter for character: " + this.flen.getInt());
            }
            return this.flen == null ? ((Integer)hashMap.get(this.basic_type)).intValue() : this.flen.getInt();
        }
        if (this.fkind != null && this.fkind.canGetInt()) {
            if (this.basic_type == 19 || this.basic_type == 20 || this.basic_type == 21) {
                return this.fkind.getInt() * 2;
            }
            return this.fkind.getInt();
        }
        int n = (Integer)hashMap.get(this.basic_type);
        if (n < 0) {
            throw new UnsupportedOperationException("internal error: unexpected type here. basic_type=" + this.basic_type);
        }
        return n;
    }

    @Override
    public Xtype copy(String string) {
        BasicType basicType = new BasicType(this.basic_type, string, this.getTypeQualFlags(), this.getGccAttributes(), this.getFkind(), this.getFlen(), this.copyCodimensions());
        return basicType;
    }
}

