/*
 * Decompiled with CFR 0.152.
 */
package exc.block;

import exc.block.Block;
import exc.block.BlockIterator;
import exc.block.BlockList;
import exc.block.FmoduleBlock;
import exc.block.IfBlock;
import java.util.Vector;

public class topdownBlockIterator
extends BlockIterator {
    public topdownBlockIterator(Block block) {
        super(block);
    }

    public topdownBlockIterator(BlockList blockList) {
        super(blockList);
    }

    @Override
    public void init() {
        this.index = 0;
        if (this.blocks == null) {
            return;
        }
        if (this.blocks.size() > 0) {
            this.currentBlock = (Block)this.blocks.elementAt(0);
        }
    }

    @Override
    public void init(Block block) {
        if (block == null) {
            return;
        }
        this.blocks = new Vector();
        this.topdownTraverse(block);
        this.index = 0;
        if (this.blocks.size() > 0) {
            this.currentBlock = (Block)this.blocks.elementAt(0);
        }
    }

    @Override
    public void init(BlockList blockList) {
        if (blockList == null) {
            return;
        }
        this.blocks = new Vector();
        this.topdownTraverse(blockList);
        this.index = 0;
        if (this.blocks.size() > 0) {
            this.currentBlock = (Block)this.blocks.elementAt(0);
        }
    }

    void topdownTraverse(Block block) {
        if (block == null) {
            return;
        }
        this.blocks.addElement(block);
        if (block instanceof IfBlock) {
            this.topdownTraverse(block.getThenBody());
            this.topdownTraverse(block.getElseBody());
        } else if (block instanceof FmoduleBlock) {
            this.topdownTraverse(block.getBody());
            this.topdownTraverse(((FmoduleBlock)block).getFunctionBlocks());
        } else {
            this.topdownTraverse(block.getBody());
        }
    }

    void topdownTraverse(BlockList blockList) {
        if (blockList == null) {
            return;
        }
        for (Block block = blockList.getHead(); block != null; block = block.getNext()) {
            this.topdownTraverse(block);
        }
    }

    @Override
    public void next() {
        if (this.currentBlock == null) {
            return;
        }
        this.currentBlock = ++this.index >= this.blocks.size() ? null : (Block)this.blocks.elementAt(this.index);
    }

    @Override
    public boolean end() {
        if (this.currentBlock == null) {
            return true;
        }
        return this.index >= this.blocks.size();
    }

    @Override
    public int size() {
        if (this.blocks == null) {
            return 0;
        }
        return this.blocks.size();
    }
}

