/*
 * Decompiled with CFR 0.152.
 */
package exc.block;

import exc.block.BasicBlock;
import exc.block.Bcons;
import exc.block.Block;
import exc.object.LineNo;
import exc.object.Xobject;

public class Statement {
    Statement prev;
    Statement next;
    BasicBlock parent;
    Xobject statement;
    LineNo lineno;

    public Statement(Xobject xobject) {
        this.statement = xobject;
    }

    public Statement getNext() {
        return this.next;
    }

    public Statement getPrev() {
        return this.prev;
    }

    public BasicBlock getParent() {
        return this.parent;
    }

    public Xobject getExpr() {
        return this.statement;
    }

    public void setExpr(Xobject xobject) {
        this.statement = xobject;
    }

    public void setLineNo(LineNo lineNo) {
        this.lineno = lineNo;
    }

    public LineNo getLineNo() {
        return this.lineno;
    }

    public void remove() {
        if (this.parent == null) {
            return;
        }
        if (this.prev == null) {
            this.parent.head = this.next;
            if (this.next != null) {
                this.next.prev = null;
            }
        } else {
            this.prev.next = this.next;
        }
        if (this.next == null) {
            this.parent.tail = this.prev;
            if (this.prev != null) {
                this.prev.next = null;
            }
        } else {
            this.next.prev = this.prev;
        }
        this.parent = null;
        this.next = null;
        this.prev = null;
    }

    public boolean isRemoved() {
        return this.parent == null;
    }

    public Statement add(Xobject xobject) {
        return this.add(new Statement(xobject));
    }

    public Statement add(Statement statement) {
        statement.parent = this.parent;
        statement.next = this.next;
        this.next = statement;
        statement.prev = this;
        if (statement.next == null) {
            this.parent.tail = statement;
        } else {
            statement.next.prev = statement;
        }
        return statement;
    }

    public Statement insert(Xobject xobject) {
        return this.insert(new Statement(xobject));
    }

    public Statement insert(Statement statement) {
        statement.parent = this.parent;
        statement.prev = this.prev;
        this.prev = statement;
        statement.next = this;
        if (statement.prev == null) {
            this.parent.head = statement;
        } else {
            statement.prev.next = statement;
        }
        return statement;
    }

    public void insertBlock(Block block) {
        Block block2 = this.parent.parent;
        if (this.parent.head != this) {
            BasicBlock basicBlock = new BasicBlock();
            basicBlock.head = this.parent.head;
            Statement statement = this.parent.head;
            while (statement != this) {
                statement.parent = basicBlock;
                statement = statement.next;
            }
            this.prev.next = null;
            this.prev = null;
            this.parent.head = this;
            block2.insert(Bcons.BasicBlock(basicBlock));
        }
        block2.insert(block);
    }

    public String toString() {
        return this.statement == null ? "()" : this.statement.toString();
    }
}

