/*
 * Decompiled with CFR 0.152.
 */
package exc.block;

import exc.block.Block;
import exc.block.BlockList;
import exc.block.CompoundBlock;
import exc.object.LineNo;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;

public class PragmaBlock
extends CompoundBlock {
    String pragma;
    Xobject args;

    public PragmaBlock(Xcode xcode, String string, Xobject xobject, BlockList blockList) {
        super(xcode, blockList);
        LineNo lineNo = this.getLineNo();
        if (lineNo != null) {
            this.setLineNo(new LineNo(lineNo.fileName(), lineNo.lineNo() - 1));
        }
        this.code = xcode;
        this.pragma = string;
        this.args = xobject;
    }

    public PragmaBlock(PragmaBlock pragmaBlock) {
        super(pragmaBlock);
        LineNo lineNo = this.getLineNo();
        if (lineNo != null) {
            this.setLineNo(new LineNo(lineNo.fileName(), lineNo.lineNo() - 1));
        }
        this.code = pragmaBlock.Opcode();
        this.pragma = pragmaBlock.getPragma();
        this.args = pragmaBlock.getClauses().copy();
    }

    @Override
    public Block copy() {
        return new PragmaBlock(this);
    }

    public String getPragma() {
        return this.pragma;
    }

    public void setPragma(String string) {
        this.pragma = string;
    }

    public Xobject getClauses() {
        return this.args;
    }

    public void setClauses(Xobject xobject) {
        this.args = xobject;
    }

    public void addClauses(Xobject xobject) {
        if (this.args == null) {
            this.args = Xcons.List(xobject);
        } else {
            ((XobjList)this.args).add(xobject);
        }
    }

    @Override
    public Xobject toXobject() {
        XobjList xobjList = new XobjList(this.Opcode(), Xcons.String(this.pragma), this.args, super.toXobject());
        ((Xobject)xobjList).setLineNo(this.getLineNo());
        return xobjList;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("(PragmaBlock:" + this.Opcode().toString() + " super[");
        stringBuilder.append(super.toString());
        stringBuilder.append("])");
        return stringBuilder.toString();
    }
}

