/*
 * Decompiled with CFR 0.152.
 */
package exc.block;

import exc.block.BasicBlock;
import exc.block.BasicBlockVisitor;
import exc.block.Block;
import exc.block.BlockList;
import exc.object.Xcode;
import exc.object.XobjList;
import exc.object.Xobject;

public class IfBlock
extends Block {
    BlockList then_part;
    BlockList else_part;

    public IfBlock(BasicBlock basicBlock, BlockList blockList, BlockList blockList2) {
        this(Xcode.IF_STATEMENT, basicBlock, blockList, blockList2, null);
    }

    public IfBlock(Xcode xcode, BasicBlock basicBlock, BlockList blockList, BlockList blockList2, String string) {
        super(xcode, basicBlock, string);
        this.then_part = blockList;
        if (blockList != null) {
            blockList.parent = this;
        }
        this.else_part = blockList2;
        if (blockList2 != null) {
            blockList2.parent = this;
        }
    }

    public IfBlock(IfBlock ifBlock) {
        super(ifBlock);
        if (ifBlock.then_part != null) {
            this.then_part = ifBlock.then_part.copy();
        }
        if (ifBlock.else_part != null) {
            this.else_part = ifBlock.else_part.copy();
        }
    }

    @Override
    public Block copy() {
        return new IfBlock(this);
    }

    @Override
    public BasicBlock getCondBBlock() {
        return this.bblock;
    }

    public void setCondBBlock(BasicBlock basicBlock) {
        this.bblock = basicBlock;
        basicBlock.parent = this;
    }

    @Override
    public BlockList getThenBody() {
        return this.then_part;
    }

    @Override
    public BlockList getElseBody() {
        return this.else_part;
    }

    @Override
    public void setThenBody(BlockList blockList) {
        this.then_part = blockList;
        blockList.parent = this;
    }

    @Override
    public void setElseBody(BlockList blockList) {
        this.else_part = blockList;
        blockList.parent = this;
    }

    @Override
    public void visitBody(BasicBlockVisitor basicBlockVisitor) {
        basicBlockVisitor.visit(this.then_part);
        basicBlockVisitor.visit(this.else_part);
    }

    @Override
    public Xobject toXobject() {
        XobjList xobjList;
        Xobject xobject = null;
        Xobject xobject2 = null;
        if (this.getThenBody() != null) {
            xobject = this.getThenBody().toXobject();
        }
        if (this.getElseBody() != null) {
            xobject2 = this.getElseBody().toXobject();
        }
        switch (this.Opcode()) {
            case IF_STATEMENT: {
                xobjList = new XobjList(this.Opcode(), this.getCondBBlock().toXobject(), xobject, xobject2);
                break;
            }
            case F_IF_STATEMENT: 
            case F_WHERE_STATEMENT: {
                xobjList = new XobjList(this.Opcode(), this.getConstructNameObj(), this.getCondBBlock().toXobject(), xobject, xobject2);
                break;
            }
            default: {
                throw new IllegalStateException(this.Opcode().toString());
            }
        }
        ((Xobject)xobjList).setLineNo(this.getLineNo());
        return xobjList;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("(IfBlock ");
        stringBuilder.append((Object)this.Opcode());
        stringBuilder.append(" ");
        stringBuilder.append(this.then_part);
        stringBuilder.append(" ");
        stringBuilder.append(this.else_part);
        stringBuilder.append(" ");
        stringBuilder.append(this.getBasicBlock());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

