/*
 * Decompiled with CFR 0.152.
 */
package exc.block;

import exc.block.Block;
import exc.block.BlockList;
import exc.block.CompoundBlock;
import exc.block.FunctionBlock;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.XobjString;
import exc.object.Xobject;
import exc.object.XobjectDef;
import exc.object.XobjectFile;

public class FmoduleBlock
extends CompoundBlock {
    private Xobject name;
    private Xobject parent_name;
    private BlockList func_blocks;
    private XobjectFile env;

    public FmoduleBlock(String string, XobjectFile xobjectFile) {
        this(string, null, xobjectFile);
    }

    public FmoduleBlock(String string, String string2, XobjectFile xobjectFile) {
        super(Xcode.F_MODULE_DEFINITION, new BlockList(Xcons.IDList(), Xcons.List()));
        this.name = new XobjString(Xcode.IDENT, string);
        this.parent_name = string2 != null ? new XobjString(Xcode.IDENT, string2) : null;
        this.env = xobjectFile;
        this.func_blocks = new BlockList();
    }

    public void addFunctionBlock(FunctionBlock functionBlock) {
        this.func_blocks.add(functionBlock);
    }

    public Xobject getName() {
        return this.name;
    }

    public Xobject getParentName() {
        return this.parent_name;
    }

    public boolean isSub() {
        return this.parent_name != null;
    }

    public BlockList getFunctionBlocks() {
        return this.func_blocks;
    }

    public FunctionBlock getFunctionBlock(String string) {
        for (Block block = this.func_blocks.getHead(); block != null; block = block.getNext()) {
            if (!((FunctionBlock)block).getName().equals(string)) continue;
            return (FunctionBlock)block;
        }
        return null;
    }

    public boolean hasVar(String string) {
        XobjList xobjList = this.getBody().getIdentList();
        return xobjList.findVarIdent(string) != null;
    }

    public XobjectDef toXobjectDef() {
        XobjList xobjList = Xcons.List(Xcode.F_CONTAINS_STATEMENT);
        Block block = this.func_blocks.getHead();
        while (block != null) {
            ((Xobject)xobjList).add(block.toXobject());
            block = block.next;
        }
        return new XobjectDef((Xobject)Xcons.List(Xcode.F_MODULE_DEFINITION, this.name, this.getBody().getIdentList(), this.getBody().getDecls(), xobjList, this.parent_name), this.env);
    }
}

