/*
 * Decompiled with CFR 0.152.
 */
package exc.block;

import exc.block.BasicBlock;
import exc.block.BasicBlockVisitor;
import exc.block.Block;
import exc.block.BlockList;
import exc.block.ForBlock;
import exc.object.LineNo;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;

public class FdoBlock
extends Block
implements ForBlock {
    private BasicBlock ind_var_part;
    private BasicBlock lower_part;
    private BasicBlock upper_part;
    private BasicBlock step_part;
    private BlockList body;
    private boolean is_canonical;

    public FdoBlock(LineNo lineNo, Xobject xobject, Xobject xobject2, BlockList blockList, String string) {
        super(Xcode.F_DO_STATEMENT, null, string);
        this.setLineNo(lineNo);
        this.body = blockList;
        this.is_canonical = false;
        blockList.parent = this;
        this.ind_var_part = BasicBlock.Expr(this, xobject);
        if (xobject2 != null) {
            this.lower_part = BasicBlock.Expr(this, xobject2.getArg(0));
            this.upper_part = BasicBlock.Expr(this, xobject2.getArg(1));
            this.step_part = BasicBlock.Expr(this, xobject2.getArgOrNull(2));
        }
    }

    public FdoBlock(FdoBlock fdoBlock) {
        super(fdoBlock);
        this.setLineNo(fdoBlock.getLineNo());
        this.body = fdoBlock.getBody().copy();
        this.is_canonical = fdoBlock.is_canonical;
        this.body.parent = this;
        this.ind_var_part = BasicBlock.Expr(this, fdoBlock.getInductionVar());
        this.lower_part = BasicBlock.Expr(this, fdoBlock.getLowerBound());
        this.upper_part = BasicBlock.Expr(this, fdoBlock.getUpperBound());
        this.step_part = BasicBlock.Expr(this, fdoBlock.getStep());
    }

    @Override
    public Block copy() {
        return new FdoBlock(this);
    }

    @Override
    public void Canonicalize() {
        this.is_canonical = true;
    }

    @Override
    public Xcode getCheckOpcode() {
        return Xcode.LOG_NOT_EXPR;
    }

    @Override
    public Xobject getInductionVar() {
        return this.ind_var_part.getExpr();
    }

    @Override
    public Xobject getLowerBound() {
        return this.lower_part.getExpr();
    }

    @Override
    public Xobject getStep() {
        return this.step_part.getExpr();
    }

    @Override
    public Xobject getUpperBound() {
        return this.upper_part.getExpr();
    }

    @Override
    public boolean isCanonical() {
        return this.is_canonical;
    }

    @Override
    public void setLowerBound(Xobject xobject) {
        this.lower_part.setExpr(xobject);
    }

    @Override
    public void setStep(Xobject xobject) {
        this.step_part.setExpr(xobject);
    }

    @Override
    public void setUpperBound(Xobject xobject) {
        this.upper_part.setExpr(xobject);
    }

    @Override
    public BlockList getBody() {
        return this.body;
    }

    @Override
    public void setBody(BlockList blockList) {
        this.body = blockList;
        blockList.parent = this;
    }

    @Override
    public BasicBlock getInitBBlock() {
        return null;
    }

    @Override
    public BasicBlock getIterBBlock() {
        return null;
    }

    @Override
    public void visitBasicBlock(BasicBlockVisitor basicBlockVisitor) {
        basicBlockVisitor.visit(this.ind_var_part);
        basicBlockVisitor.visit(this.lower_part);
        basicBlockVisitor.visit(this.upper_part);
        basicBlockVisitor.visit(this.step_part);
        basicBlockVisitor.visit(this.bblock);
    }

    public void setInductionVar(Xobject xobject) {
        this.ind_var_part.setExpr(xobject);
    }

    @Override
    public Xobject toXobject() {
        XobjList xobjList = Xcons.List(this.Opcode(), this.getConstructNameObj(), this.ind_var_part != null ? this.ind_var_part.getExpr() : null, this.lower_part != null ? Xcons.List(Xcode.F_INDEX_RANGE, this.getLowerBound(), this.getUpperBound(), this.getStep()) : null, this.body.toXobject());
        ((Xobject)xobjList).setLineNo(this.getLineNo());
        return xobjList;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("(FdoBlock ");
        stringBuilder.append("(");
        stringBuilder.append(this.getInductionVar());
        stringBuilder.append(" ");
        stringBuilder.append(this.getLowerBound());
        stringBuilder.append(" ");
        stringBuilder.append(this.getUpperBound());
        stringBuilder.append(" ");
        stringBuilder.append(this.getStep());
        stringBuilder.append(")");
        stringBuilder.append(" ");
        stringBuilder.append(this.body);
        stringBuilder.append(" ");
        stringBuilder.append(this.getBasicBlock());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

