/*
 * Decompiled with CFR 0.152.
 */
package exc.block;

import exc.block.BasicBlock;
import exc.block.Block;
import exc.block.BlockList;
import exc.object.Xcode;
import exc.object.XobjList;
import exc.object.Xobject;

public class CondBlock
extends Block {
    BlockList body;

    public CondBlock(Xcode xcode, BasicBlock basicBlock, BlockList blockList, String string) {
        super(xcode, basicBlock, string);
        this.body = blockList;
        blockList.parent = this;
    }

    public CondBlock(CondBlock condBlock) {
        super(condBlock);
        this.body = condBlock.body.copy();
        this.body.parent = this;
    }

    @Override
    public Block copy() {
        return new CondBlock(this);
    }

    @Override
    public BlockList getBody() {
        return this.body;
    }

    @Override
    public void setBody(BlockList blockList) {
        this.body = blockList;
        blockList.parent = this;
    }

    @Override
    public BasicBlock getCondBBlock() {
        return this.bblock;
    }

    public void setCondBBlock(BasicBlock basicBlock) {
        this.bblock = basicBlock;
        basicBlock.parent = this;
    }

    @Override
    public Xobject toXobject() {
        XobjList xobjList;
        Xobject xobject = null;
        if (this.bblock != null) {
            xobject = this.bblock.toXobject();
        }
        switch (this.code) {
            case DO_STATEMENT: {
                xobjList = new XobjList(this.code, this.body.toXobject(), xobject);
                break;
            }
            case SWITCH_STATEMENT: 
            case WHILE_STATEMENT: 
            case FOR_STATEMENT: {
                xobjList = new XobjList(this.code, xobject, this.body.toXobject());
                break;
            }
            case F_DO_WHILE_STATEMENT: 
            case F_SELECT_CASE_STATEMENT: {
                xobjList = new XobjList(this.code, this.getConstructNameObj(), xobject, this.body.toXobject());
                break;
            }
            default: {
                throw new IllegalStateException(this.code.toString());
            }
        }
        ((Xobject)xobjList).setLineNo(this.getLineNo());
        return xobjList;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("(CondBlock ");
        stringBuilder.append((Object)this.Opcode());
        stringBuilder.append(" ");
        stringBuilder.append(this.body);
        stringBuilder.append(" ");
        stringBuilder.append(this.getBasicBlock());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

