/*
 * Decompiled with CFR 0.152.
 */
package exc.block;

import exc.block.Block;
import exc.block.BlockList;
import exc.object.Ident;
import exc.object.Xcode;
import exc.object.Xobject;
import exc.xmpF.XMPsymbolTable;

public class CompoundBlock
extends Block {
    BlockList body;
    private static final String SYMBOL_TABLE = "XMP_PROP_XMP_SYMBOL_TABLE";

    public CompoundBlock(BlockList blockList) {
        this(Xcode.COMPOUND_STATEMENT, blockList, null);
    }

    public CompoundBlock(Xcode xcode, BlockList blockList) {
        this(xcode, blockList, null);
    }

    public CompoundBlock(Xcode xcode, BlockList blockList, String string) {
        super(xcode, null, string);
        this.body = blockList;
        if (blockList != null) {
            blockList.parent = this;
            this.setLineNo(blockList.getHeadLineNo());
        }
    }

    public CompoundBlock(CompoundBlock compoundBlock) {
        super(compoundBlock);
        if (compoundBlock.body != null) {
            this.body = compoundBlock.body.copy();
            this.body.parent = this;
        }
    }

    @Override
    public Block copy() {
        return new CompoundBlock(this);
    }

    @Override
    public BlockList getBody() {
        return this.body;
    }

    @Override
    public void setBody(BlockList blockList) {
        this.body = blockList;
        blockList.parent = this;
    }

    @Override
    public Xobject toXobject() {
        if (this.body == null) {
            return null;
        }
        Xobject xobject = this.body.toXobject();
        if (xobject != null) {
            xobject.setLineNo(this.getLineNo());
        }
        return xobject;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("(CompoundBlock:" + this.Opcode().toString() + " ");
        stringBuilder.append(" body=");
        stringBuilder.append(this.body);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public Ident findVarIdent(String string) {
        return this.findVarIdent(string, this.getBody());
    }

    @Override
    public CompoundBlock findVarIdentBlock(String string) {
        return this.findVarIdentBlock(string, this.getBody());
    }

    @Override
    public XMPsymbolTable getXMPsymbolTable() {
        XMPsymbolTable xMPsymbolTable = (XMPsymbolTable)this.getProp(SYMBOL_TABLE);
        if (xMPsymbolTable == null) {
            xMPsymbolTable = new XMPsymbolTable();
            this.setProp(SYMBOL_TABLE, xMPsymbolTable);
        }
        return xMPsymbolTable;
    }
}

