/*
 * Decompiled with CFR 0.152.
 */
package exc.block;

import exc.block.BasicBlock;
import exc.block.BasicBlockVisitor;
import exc.block.Block;
import exc.block.BlockList;
import exc.block.CondBlock;
import exc.block.ForBlock;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.Xobject;

public class CforBlock
extends CondBlock
implements ForBlock {
    private BasicBlock init_part;
    private BasicBlock iter_part;
    private boolean is_canonical;
    private Xobject ind_var;
    private Xobject lowerb;
    private Xobject upperb;
    private Xobject step;
    private Xobject min_upperb;

    public CforBlock(BasicBlock basicBlock, BasicBlock basicBlock2, BasicBlock basicBlock3, BlockList blockList, String string) {
        super(Xcode.FOR_STATEMENT, basicBlock2, blockList, string);
        this.is_canonical = false;
        this.init_part = basicBlock;
        this.iter_part = basicBlock3;
        if (this.init_part != null) {
            this.init_part.parent = this;
        }
        if (this.iter_part != null) {
            this.iter_part.parent = this;
        }
    }

    public CforBlock(CforBlock cforBlock) {
        super(cforBlock);
        this.is_canonical = cforBlock.is_canonical;
        if (cforBlock.init_part != null) {
            this.init_part = cforBlock.init_part.copy();
            this.init_part.parent = this;
        }
        if (cforBlock.iter_part != null) {
            this.iter_part = cforBlock.iter_part.copy();
            this.iter_part.parent = this;
        }
    }

    @Override
    public Block copy() {
        return new CforBlock(this);
    }

    @Override
    public BasicBlock getInitBBlock() {
        return this.init_part;
    }

    @Override
    public BasicBlock getIterBBlock() {
        return this.iter_part;
    }

    public void setInitBlock(BasicBlock basicBlock) {
        this.init_part = basicBlock;
        basicBlock.parent = this;
    }

    public void setIterBlock(BasicBlock basicBlock) {
        this.iter_part = basicBlock;
        basicBlock.parent = this;
    }

    @Override
    public void visitBasicBlock(BasicBlockVisitor basicBlockVisitor) {
        basicBlockVisitor.visit(this.init_part);
        basicBlockVisitor.visit(this.bblock);
        basicBlockVisitor.visit(this.iter_part);
    }

    private Xobject getTranslatedForBlockIndVarDecl(String string) {
        Xobject xobject = null;
        BlockList blockList = this.getParent();
        xobject = blockList.findLocalDecl(string);
        if (xobject != null && blockList.getHead() == this) {
            return xobject;
        }
        return null;
    }

    @Override
    public void Canonicalize() {
        Xobject xobject;
        Xobject xobject2;
        Xobject xobject3;
        this.is_canonical = false;
        BasicBlock basicBlock = this.getCondBBlock();
        if (basicBlock.getHead() != null) {
            return;
        }
        Xobject xobject4 = basicBlock.getExpr();
        if (xobject4 == null) {
            return;
        }
        switch (xobject4.Opcode()) {
            case LOG_LE_EXPR: 
            case LOG_LT_EXPR: 
            case LOG_GE_EXPR: 
            case LOG_GT_EXPR: {
                break;
            }
            default: {
                return;
            }
        }
        Xobject xobject5 = xobject4.left();
        if (!xobject5.isVariable()) {
            return;
        }
        if (!xobject5.Type().isIntegral() && !xobject5.Type().isPointer()) {
            return;
        }
        Xobject xobject6 = xobject4.right();
        if (this.init_part.getHead() == null) {
            xobject3 = this.getTranslatedForBlockIndVarDecl(xobject5.getName());
            if (xobject3 == null) {
                return;
            }
            Xobject xobject7 = xobject3.getArg(1);
            if (xobject7 == null) {
                return;
            }
            this.init_part.add(Xcons.Set(xobject5, xobject7));
            xobject2 = xobject7;
            xobject3.setArg(1, null);
        } else {
            xobject4 = this.init_part.getTail().getExpr();
            if (xobject4.Opcode() != Xcode.ASSIGN_EXPR) {
                return;
            }
            if (!xobject4.left().equals(xobject5)) {
                return;
            }
            xobject2 = xobject4.right();
        }
        xobject4 = this.iter_part.getHead().getExpr();
        block3 : switch (xobject4.Opcode()) {
            case PRE_INCR_EXPR: 
            case POST_INCR_EXPR: {
                if (!xobject4.operand().equals(xobject5)) {
                    return;
                }
                xobject = Xcons.IntConstant(1);
                break;
            }
            case PRE_DECR_EXPR: 
            case POST_DECR_EXPR: {
                if (!xobject4.operand().equals(xobject5)) {
                    return;
                }
                xobject = Xcons.IntConstant(-1);
                break;
            }
            case ASG_PLUS_EXPR: {
                if (!xobject4.left().equals(xobject5)) {
                    return;
                }
                xobject = xobject4.right();
                break;
            }
            case ASG_MINUS_EXPR: {
                if (!xobject4.left().equals(xobject5)) {
                    return;
                }
                xobject = Xcons.unaryOp(Xcode.UNARY_MINUS_EXPR, xobject4.right());
                break;
            }
            case ASSIGN_EXPR: {
                if (!xobject4.left().equals(xobject5)) {
                    return;
                }
                switch (xobject4.right().Opcode()) {
                    case PLUS_EXPR: {
                        if (xobject4.right().left().equals(xobject5)) {
                            xobject = xobject4.right().right();
                            break block3;
                        }
                        if (xobject4.right().right().equals(xobject5)) {
                            xobject = xobject4.right().left();
                            break block3;
                        }
                        return;
                    }
                    case MINUS_EXPR: {
                        if (xobject4.right().left().equals(xobject5)) {
                            xobject = Xcons.unaryOp(Xcode.UNARY_MINUS_EXPR, xobject4.right().right());
                            break block3;
                        }
                        return;
                    }
                }
                return;
            }
            default: {
                return;
            }
        }
        if (xobject4.Opcode() != Xcode.ASG_PLUS_EXPR) {
            this.iter_part.getHead().setExpr(Xcons.asgOp(Xcode.ASG_PLUS_EXPR, xobject5, xobject));
        }
        if ((xobject4 = basicBlock.getExpr()).Opcode() == Xcode.LOG_LE_EXPR) {
            this.min_upperb = xobject6.copy();
            xobject6 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject6, Xcons.IntConstant(1));
            basicBlock.setExpr(Xcons.binaryOp(Xcode.LOG_LT_EXPR, xobject5, xobject6));
        } else if (xobject4.Opcode() == Xcode.LOG_GE_EXPR) {
            this.min_upperb = xobject6.copy();
            xobject6 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject6, Xcons.IntConstant(-1));
            basicBlock.setExpr(Xcons.binaryOp(Xcode.LOG_GT_EXPR, xobject5, xobject6));
        } else {
            xobject3 = xobject6.copy();
            this.min_upperb = Xcons.binaryOp(Xcode.MINUS_EXPR, xobject3, Xcons.IntConstant(1));
        }
        this.ind_var = xobject5;
        this.upperb = xobject6;
        this.lowerb = xobject2;
        this.step = xobject;
        this.is_canonical = true;
    }

    @Override
    public boolean isCanonical() {
        return this.is_canonical;
    }

    @Override
    public Xobject getInductionVar() {
        return this.ind_var;
    }

    @Deprecated
    public Xobject getLoopVar() {
        return this.getInductionVar();
    }

    @Override
    public Xobject getLowerBound() {
        return this.lowerb;
    }

    @Override
    public Xobject getUpperBound() {
        return this.upperb;
    }

    public Xobject getMinUpperBound() {
        return this.min_upperb;
    }

    @Override
    public Xobject getStep() {
        return this.step;
    }

    @Override
    public Xcode getCheckOpcode() {
        return this.getCondBBlock().getExpr().Opcode();
    }

    @Override
    public void setLowerBound(Xobject xobject) {
        this.init_part.getTail().getExpr().setRight(xobject);
    }

    @Override
    public void setUpperBound(Xobject xobject) {
        BasicBlock basicBlock = this.getCondBBlock();
        basicBlock.getExpr().setRight(xobject);
    }

    @Override
    public void setStep(Xobject xobject) {
        this.iter_part.getHead().getExpr().setRight(xobject);
    }

    @Override
    public Xobject toXobject() {
        Xobject xobject = null;
        Xobject xobject2 = null;
        Xobject xobject3 = null;
        if (this.getInitBBlock() != null) {
            xobject = this.getInitBBlock().toXobject();
        }
        if (this.getCondBBlock() != null) {
            xobject2 = this.getCondBBlock().toXobject();
        }
        if (this.getIterBBlock() != null) {
            xobject3 = this.getIterBBlock().toXobject();
        }
        XobjList xobjList = new XobjList(this.Opcode(), xobject, xobject2, xobject3, this.getBody().toXobject());
        ((Xobject)xobjList).setLineNo(this.getLineNo());
        return xobjList;
    }
}

