/*
 * Decompiled with CFR 0.152.
 */
package exc.block;

import exc.block.BasicBlock;
import exc.block.BasicBlockVisitor;
import exc.block.Block;
import exc.block.BlockList;
import exc.block.FunctionBlock;
import exc.block.PragmaBlock;
import exc.block.Statement;
import exc.object.XobjectPrintWriter;
import java.io.OutputStream;
import java.io.Writer;

public class BlockPrintWriter
extends XobjectPrintWriter
implements BasicBlockVisitor {
    int indent_level;

    public BlockPrintWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public BlockPrintWriter(Writer writer) {
        super(writer);
    }

    public void print(Block block) {
        this.indent_level = 0;
        this.visit(block);
        this.println();
        this.flush();
    }

    public void print(BlockList blockList) {
        this.indent_level = 0;
        for (Block block = blockList.getHead(); block != null; block = block.getNext()) {
            this.visit(block);
            this.println();
        }
        this.flush();
    }

    void indent() {
        for (int i = 0; i < this.indent_level; ++i) {
            this.print("  ");
        }
    }

    @Override
    public void visit(BasicBlock basicBlock) {
        if (basicBlock == null) {
            return;
        }
        this.indent();
        this.println(basicBlock.toString());
        for (Statement statement = basicBlock.getHead(); statement != null; statement = statement.getNext()) {
            this.indent();
            this.println("-: " + statement.getExpr());
        }
        if (basicBlock.getExpr() != null) {
            this.indent();
            this.println("@: " + basicBlock.getExpr());
        }
    }

    @Override
    public void visit(BlockList blockList) {
        if (blockList == null) {
            return;
        }
        if (blockList.getIdentList() != null || blockList.getDecls() != null) {
            this.indent();
            this.println(" id_list=" + blockList.getIdentList());
            this.indent();
            this.println(" decls=" + blockList.getDecls());
        }
        for (Block block = blockList.getHead(); block != null; block = block.getNext()) {
            this.visit(block);
        }
    }

    @Override
    public void visit(Block block) {
        if (block == null) {
            return;
        }
        this.indent();
        this.println(block.toString());
        ++this.indent_level;
        if (block instanceof PragmaBlock) {
            PragmaBlock pragmaBlock = (PragmaBlock)block;
            this.indent();
            this.println(" pramga=" + pragmaBlock.getPragma());
            this.indent();
            this.println(" args=" + pragmaBlock.getClauses());
        } else if (block instanceof FunctionBlock) {
            this.indent();
            this.println(" fname=" + ((FunctionBlock)block).getName());
        }
        block.visitBasicBlock(this);
        block.visitBody(this);
        --this.indent_level;
    }
}

