/*
 * Decompiled with CFR 0.152.
 */
package exc.block;

import exc.block.BasicBlock;
import exc.block.Block;
import exc.block.SimpleBlock;
import exc.block.Statement;
import exc.object.Ident;
import exc.object.LineNo;
import exc.object.StorageClass;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjArgs;
import exc.object.XobjList;
import exc.object.XobjString;
import exc.object.Xobject;
import exc.object.XobjectIterator;
import exc.object.Xtype;
import exc.object.topdownXobjectIterator;
import xcodeml.util.XmLog;
import xcodeml.util.XmOption;

public class BlockList {
    Block head;
    Block tail;
    Block parent;
    Xcode code;
    XobjString block_name;
    Xobject id_list;
    Xobject decls;
    Xobject id_local_coarrays;

    public BlockList() {
    }

    public BlockList(Block block) {
        if (block != null) {
            this.add(block);
        }
    }

    public BlockList(Xobject xobject, Xobject xobject2) {
        this.id_list = xobject;
        this.decls = xobject2;
    }

    public BlockList(BlockList blockList) {
        if (blockList.id_list != null) {
            this.id_list = blockList.id_list.copy();
        }
        if (blockList.decls != null) {
            this.decls = blockList.decls.copy();
        }
        for (Block block = blockList.getHead(); block != null; block = block.getNext()) {
            this.add(block.copy());
        }
    }

    public BlockList copy() {
        return new BlockList(this);
    }

    public Block getTail() {
        return this.tail;
    }

    public Block getHead() {
        return this.head;
    }

    public LineNo getHeadLineNo() {
        return this.head != null ? this.head.getLineNo() : null;
    }

    public Block getParent() {
        return this.parent;
    }

    public BlockList getParentList() {
        return this.parent == null ? null : this.parent.getParent();
    }

    public void setParent(Block block) {
        this.parent = block;
    }

    public void add(Block block) {
        if (block == null) {
            return;
        }
        if (this.head == null) {
            this.head = this.tail = block;
            block.prev = null;
        } else {
            this.tail.next = block;
            block.prev = this.tail;
            this.tail = block;
        }
        block.next = null;
        block.setParent(this);
    }

    public void add(BasicBlock basicBlock) {
        this.add(new SimpleBlock(Xcode.LIST, basicBlock));
    }

    public void add(Xobject xobject) {
        this.add(new SimpleBlock(Xcode.LIST, BasicBlock.Statement(xobject)));
    }

    public void removeFirst() {
        if (this.head == null) {
            return;
        }
        this.head = this.head.next;
        this.head.prev = null;
    }

    public void insert(Block block) {
        if (this.head == null) {
            this.head = this.tail = block;
            block.next = null;
        } else {
            this.head.prev = block;
            block.next = this.head;
            this.head = block;
        }
        block.prev = null;
        block.setParent(this);
    }

    public void insert(BasicBlock basicBlock) {
        this.insert(new SimpleBlock(Xcode.LIST, basicBlock));
    }

    public void insert(Xobject xobject) {
        this.insert(new SimpleBlock(Xcode.LIST, BasicBlock.Statement(xobject)));
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    public boolean isSingle() {
        return this.head != null && this.head == this.tail;
    }

    public XobjList getIdentList() {
        return (XobjList)this.id_list;
    }

    public void setIdentList(Xobject xobject) {
        this.id_list = xobject;
    }

    public void setDecls(Xobject xobject) {
        this.decls = xobject;
    }

    public Xobject getDecls() {
        return this.decls;
    }

    public Ident findLocalIdent(Ident ident) {
        if (this.id_list == null) {
            return null;
        }
        for (Xobject xobject : (XobjList)this.id_list) {
            if (xobject != ident) continue;
            return ident;
        }
        return null;
    }

    public Ident findLocalIdent(String string) {
        if (this.id_list == null) {
            return null;
        }
        for (Xobject xobject : (XobjList)this.id_list) {
            Ident ident = (Ident)xobject;
            if (!string.equals(ident.getName())) continue;
            return ident;
        }
        return null;
    }

    public Xobject findLocalDecl(String string) {
        if (this.decls == null) {
            return null;
        }
        for (Xobject xobject : (XobjList)this.decls) {
            if (xobject.Opcode() != Xcode.VAR_DECL || !string.equals(xobject.getArg(0).getName())) continue;
            return xobject;
        }
        return null;
    }

    public Ident findLocalIdent(Xtype xtype) {
        if (this.id_list == null) {
            return null;
        }
        for (Xobject xobject : (XobjList)this.id_list) {
            if (xobject.Type() != xtype) continue;
            return (Ident)xobject;
        }
        return null;
    }

    public Ident declLocalIdent(String string, Xtype xtype) {
        Ident ident = this.findLocalIdent(string);
        if (ident == null) {
            ident = Ident.Local(string, xtype);
            this.addIdent(ident);
        }
        return ident;
    }

    public Ident declLocalIdent(String string, Xtype xtype, StorageClass storageClass, Xobject xobject) {
        Ident ident = Ident.Local(string, xtype);
        ident.setStorageClass(storageClass);
        XobjList xobjList = this.getIdentList();
        if (xobjList == null) {
            xobjList = Xcons.List();
            this.setIdentList(xobjList);
        }
        xobjList.add(ident);
        if (xobject != null) {
            ident.setIsDeclared(true);
            XobjList xobjList2 = (XobjList)this.getDecls();
            if (xobjList2 == null) {
                xobjList2 = Xcons.List();
                this.setDecls(xobjList2);
            }
            xobjList2.add(Xcons.List(Xcode.VAR_DECL, ident, xobject, null));
        }
        return ident;
    }

    public void addIdent(Ident ident) {
        if (this.id_list == null) {
            this.id_list = Xcons.IDList();
        }
        this.id_list.add(ident);
    }

    public Boolean removeIdent(String string) {
        Boolean bl = false;
        Boolean bl2 = false;
        if (this.id_list == null) {
            return false;
        }
        for (XobjArgs xobjArgs = this.id_list.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            if (!xobjArgs.getArg().getName().equals(string)) continue;
            this.id_list.removeArgs(xobjArgs);
            bl = true;
            break;
        }
        for (XobjArgs xobjArgs = this.decls.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
            if (!xobjArgs.getArg().getArg(0).getName().equals(string)) continue;
            this.decls.removeArgs(xobjArgs);
            bl2 = true;
            break;
        }
        return bl | bl2;
    }

    public void addLocalCoarray(Ident ident) {
        if (this.id_local_coarrays == null) {
            this.id_local_coarrays = Xcons.IDList();
        }
        this.id_local_coarrays.add(ident);
    }

    public void initLocalCoarrays(XobjList xobjList) {
        this.id_local_coarrays = xobjList;
        if (this.id_local_coarrays != null) {
            for (Xobject xobject : xobjList) {
                ((Ident)xobject).setDeclaredBlock(this);
            }
        }
    }

    public Xobject getLocalCoarrays() {
        return this.id_local_coarrays;
    }

    public void removeDeclInit() {
        Object object;
        Ident ident;
        if (this.decls == null) {
            return;
        }
        boolean bl = false;
        for (Object object2 : (XobjList)this.decls) {
            if (((Xobject)object2).Opcode() != Xcode.VAR_DECL) continue;
            ident = this.findLocalIdent(((Xobject)object2).getArg(0).getName());
            if (ident == null) {
                XmLog.fatal((String)"removeDeclInit: no ID");
            }
            if (!ident.Type().isVariableArray()) continue;
            Object object3 = ident.Type().getArraySizeExpr().topdownIterator();
            while (!((topdownXobjectIterator)object3).end()) {
                Ident ident2;
                object = ((XobjectIterator)object3).getXobject();
                if (((Xobject)object).isVarRef() && (ident2 = this.findLocalIdent(((Xobject)object).getName())) != null) {
                    ident2.setIsUsedInArraySize(true);
                }
                ((topdownXobjectIterator)object3).next();
            }
        }
        for (Object object2 : (XobjList)this.decls) {
            if (((Xobject)object2).Opcode() != Xcode.VAR_DECL || ((Xobject)object2).getArg(1) == null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        BasicBlock basicBlock = new BasicBlock();
        for (Object object3 : (XobjList)this.decls) {
            if (((Xobject)object3).Opcode() != Xcode.VAR_DECL || ((Xobject)object3).getArg(1) == null) continue;
            ident = this.findLocalIdent(((Xobject)object3).getArg(0).getName());
            if (ident == null) {
                XmLog.fatal((String)"removeDeclInit: no ID");
            }
            if (ident.getStorageClass() == StorageClass.STATIC || ident.Type().isConst() || ident.isUsedInArraySize()) continue;
            object = ((Xobject)object3).getArgs().nextArgs();
            if (((XobjArgs)object).getArg().Opcode() == Xcode.LIST || ((XobjArgs)object).getArg().Opcode() == Xcode.STRING_CONSTANT) {
                this.expandInitializer(basicBlock, ident.Ref(), (XobjArgs)object);
            } else if (StorageClass.REGISTER != ident.getStorageClass()) {
                basicBlock.add(Xcons.Set(ident.Ref(), ((XobjArgs)object).getArg()));
            }
            ((Xobject)object3).setArg(1, null);
        }
        this.insert(basicBlock);
    }

    void expandInitializer(BasicBlock basicBlock, Xobject xobject, XobjArgs xobjArgs) {
        if (xobjArgs == null) {
            return;
        }
        Xtype xtype = xobject.Type();
        switch (xtype.getKind()) {
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                Xobject xobject2 = xobjArgs.getArg();
                if (xobject2.Opcode() == Xcode.LIST) {
                    XmLog.fatal((String)"expandInit: bad scalar init");
                }
                basicBlock.add(Xcons.Set(xobject, xobject2));
                break;
            }
            case 3: {
                Xobject xobject3 = xobjArgs.getArg();
                if (xobject3.Opcode() == Xcode.LIST) {
                    xobjArgs = xobject3.getArgs();
                }
                XobjArgs xobjArgs2 = xtype.getMemberList().getArgs();
                while (xobjArgs != null) {
                    Ident ident = (Ident)xobjArgs2.getArg();
                    Xobject xobject4 = Xcons.memberRef(Xcons.AddrOf(xobject), ident.getName());
                    this.expandInitializer(basicBlock, xobject4, xobjArgs);
                    xobjArgs2 = xobjArgs2.nextArgs();
                    xobjArgs = xobjArgs.nextArgs();
                }
                break;
            }
            case 6: {
                Xobject xobject5 = xobjArgs.getArg();
                if (xobject5.Opcode() == Xcode.STRING_CONSTANT) {
                    XobjString xobjString = Xcons.Symbol(Xcode.FUNC_ADDR, Xtype.Pointer(Xtype.Function(Xtype.voidType)), "strcpy");
                    basicBlock.add(Xcons.functionCall(xobjString, Xcons.List(xobject, xobject5)));
                    break;
                }
                if (xobject5.Opcode() == Xcode.LIST) {
                    xobjArgs = xobject5.getArgs();
                }
                int n = 0;
                while (xobjArgs != null) {
                    Xobject xobject6 = Xcons.binaryOp(Xcode.PLUS_EXPR, xobject, Xcons.IntConstant(n++));
                    this.expandInitializer(basicBlock, Xcons.PointerRef(xobject6), xobjArgs);
                    xobjArgs = xobjArgs.nextArgs();
                }
                break;
            }
            case 4: {
                Xobject xobject7 = xobjArgs.getArg();
                if (xobject7.Nargs() != 1 || xobject7.getArg(0).Opcode() == Xcode.LIST) {
                    XmLog.fatal((String)"cannot expand initializer for UNION which is initialized by multiple values or designator.");
                    break;
                }
                Ident ident = (Ident)xtype.getMemberList().getArg(0);
                Xobject xobject8 = Xcons.memberRef(Xcons.AddrOf(xobject), ident.getName());
                this.expandInitializer(basicBlock, xobject8, xobject7.getArgs());
                break;
            }
            default: {
                XmLog.fatal((String)"expandInitializer: unknown type");
            }
        }
    }

    public Xobject toXobject() {
        Xobject xobject;
        if (this.head == null) {
            xobject = Xcons.statementList();
        } else if (this.head == this.tail && this.head.Opcode() != Xcode.LIST) {
            xobject = this.head.toXobject();
        } else {
            xobject = Xcons.statementList();
            for (Block block = this.head; block != null; block = block.getNext()) {
                if (block.Opcode() != Xcode.LIST) {
                    xobject.add(block.toXobject());
                    continue;
                }
                for (Statement statement : block.getBasicBlock()) {
                    if (statement.getExpr() == null) continue;
                    Xobject xobject2 = null;
                    if (statement.getExpr().Opcode().isFstatement() || statement.getExpr().Opcode() == Xcode.EXPR_STATEMENT) {
                        xobject2 = statement.getExpr();
                    } else {
                        xobject2 = new XobjList(Xcode.EXPR_STATEMENT, statement.getExpr());
                        xobject2.setLineNo(statement.getLineNo());
                    }
                    xobject.add(xobject2);
                }
            }
        }
        if (XmOption.isLanguageC()) {
            if (this.id_list == null && this.decls == null) {
                return xobject;
            }
            return Xcons.CompoundStatement(this.id_list, this.decls, xobject);
        }
        if (this.code == Xcode.F_BLOCK_STATEMENT) {
            return Xcons.List(this.code, (Xtype)null, this.block_name, this.id_list, this.decls, xobject, this.id_local_coarrays);
        }
        return Xcons.FstatementList(xobject);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("[BlockList code=" + (Object)((Object)this.code) + " name=" + this.block_name + " id_list=" + this.id_list + " decls=" + this.decls + " coarrays=" + this.id_local_coarrays + " ");
        int n = 0;
        for (Block block = this.head; block != null; block = block.getNext()) {
            if (n++ > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(block.toString());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

