/*
 * Decompiled with CFR 0.152.
 */
package exc.block;

import exc.block.BasicBlock;
import exc.block.BasicBlockVisitor;
import exc.block.Bcons;
import exc.block.BlockList;
import exc.block.CompoundBlock;
import exc.block.FunctionBlock;
import exc.object.IVarContainer;
import exc.object.Ident;
import exc.object.LineNo;
import exc.object.PropObject;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjString;
import exc.object.Xobject;
import exc.xmpF.XMPobject;
import exc.xmpF.XMPsymbolTable;

public class Block
extends PropObject
implements IVarContainer {
    protected static int BlockCounter = 0;
    Xcode code;
    BasicBlock bblock;
    Block prev;
    Block next;
    private BlockList parent;
    private LineNo lineno;
    private String construct_name;

    public Block(Xcode xcode, BasicBlock basicBlock, String string) {
        this.code = xcode;
        this.bblock = basicBlock;
        if (basicBlock != null) {
            basicBlock.parent = this;
        }
        this.construct_name = string;
        this.id = BlockCounter++;
    }

    public Block(Xcode xcode, BasicBlock basicBlock) {
        this(xcode, basicBlock, null);
    }

    public Block(Block block) {
        this.code = block.code;
        this.lineno = block.lineno;
        if (block.bblock != null) {
            this.bblock = block.bblock.copy();
            this.bblock.parent = this;
        }
        this.construct_name = block.construct_name;
        this.id = BlockCounter++;
    }

    public Block copy() {
        return new Block(this);
    }

    public Xcode Opcode() {
        return this.code;
    }

    public BasicBlock getBasicBlock() {
        return this.bblock;
    }

    public Block getNext() {
        return this.next;
    }

    public Block getPrev() {
        return this.prev;
    }

    public BlockList getParent() {
        return this.parent;
    }

    public void setParent(BlockList blockList) {
        this.parent = blockList;
    }

    public Block getParentBlock() {
        return this.parent == null ? null : this.parent.getParent();
    }

    public void setLineNo(LineNo lineNo) {
        this.lineno = lineNo;
    }

    public LineNo getLineNo() {
        return this.lineno;
    }

    public XobjString getConstructNameObj() {
        if (this.construct_name == null) {
            return null;
        }
        return Xcons.Symbol(Xcode.IDENT, this.construct_name);
    }

    public String toString() {
        return "Block." + this.code.toString() + "#" + this.id;
    }

    public void visitBasicBlock(BasicBlockVisitor basicBlockVisitor) {
        basicBlockVisitor.visit(this.bblock);
    }

    public void visitBody(BasicBlockVisitor basicBlockVisitor) {
        basicBlockVisitor.visit(this.getBody());
    }

    public Xobject toXobject() {
        throw new UnsupportedOperationException(this.toString());
    }

    public BlockList getBody() {
        return null;
    }

    public void setBody(BlockList blockList) {
        throw new UnsupportedOperationException(this.toString());
    }

    public BasicBlock getCondBBlock() {
        throw new UnsupportedOperationException(this.toString());
    }

    public BlockList getThenBody() {
        throw new UnsupportedOperationException(this.toString());
    }

    public BlockList getElseBody() {
        throw new UnsupportedOperationException(this.toString());
    }

    public void setThenBody(BlockList blockList) {
        throw new UnsupportedOperationException(this.toString());
    }

    public void setElseBody(BlockList blockList) {
        throw new UnsupportedOperationException(this.toString());
    }

    public BasicBlock getInitBBlock() {
        throw new UnsupportedOperationException(this.toString());
    }

    public void setInitBBlock(BasicBlock basicBlock) {
        throw new UnsupportedOperationException(this.toString());
    }

    public BasicBlock getIterBBlock() {
        throw new UnsupportedOperationException(this.toString());
    }

    public void setIterBBlock(BasicBlock basicBlock) {
        throw new UnsupportedOperationException(this.toString());
    }

    public Xobject getLabel() {
        throw new UnsupportedOperationException(this.toString());
    }

    public void setLabel(Xobject xobject) {
        throw new UnsupportedOperationException(this.toString());
    }

    public Xobject getInfoExpr() {
        return null;
    }

    public Block add(Block block) {
        block.parent = this.parent;
        block.next = this.next;
        this.next = block;
        block.prev = this;
        if (block.next == null) {
            this.parent.tail = block;
        } else {
            block.next.prev = block;
        }
        return block;
    }

    public Block add(BasicBlock basicBlock) {
        return this.add(Bcons.BasicBlock(basicBlock));
    }

    public Block add(Xobject xobject) {
        if (this.code == Xcode.LIST) {
            this.bblock.add(xobject);
            return this;
        }
        return this.add(Bcons.Statement(xobject));
    }

    public Block insert(Block block) {
        block.parent = this.parent;
        block.prev = this.prev;
        this.prev = block;
        block.next = this;
        if (block.prev == null) {
            this.parent.head = block;
        } else {
            block.prev.next = block;
        }
        return block;
    }

    public Block insert(BasicBlock basicBlock) {
        return this.insert(Bcons.BasicBlock(basicBlock));
    }

    public Block insert(Xobject xobject) {
        if (this.code == Xcode.LIST) {
            this.bblock.insert(xobject);
            return this;
        }
        return this.insert(Bcons.Statement(xobject));
    }

    public void replace(Block block) {
        block.parent = this.parent;
        block.prev = this.prev;
        block.next = this.next;
        if (this.prev != null) {
            this.prev.next = block;
        } else {
            this.parent.head = block;
        }
        if (this.next != null) {
            this.next.prev = block;
        } else {
            this.parent.tail = block;
        }
        this.parent = null;
        this.prev = null;
        this.next = null;
    }

    public Block remove() {
        if (this.prev != null) {
            this.prev.next = this.next;
        } else {
            this.parent.head = this.next;
        }
        if (this.next != null) {
            this.next.prev = this.prev;
        } else {
            this.parent.tail = this.prev;
        }
        this.parent = null;
        this.next = null;
        this.prev = null;
        return this;
    }

    @Override
    public Ident findVarIdent(String string) {
        return this.findVarIdent(string, this.getParent());
    }

    public Ident findVarIdent(String string, BlockList blockList) {
        for (BlockList blockList2 = blockList; blockList2 != null; blockList2 = blockList2.getParentList()) {
            Ident ident = blockList2.findLocalIdent(string);
            if (ident != null) {
                return ident;
            }
            if (!(blockList2.getParent() instanceof FunctionBlock)) continue;
            return ((FunctionBlock)blockList2.getParent()).getEnv().findVarIdent(string);
        }
        return null;
    }

    public CompoundBlock findVarIdentBlock(String string) {
        return this.findVarIdentBlock(string, this.getParent());
    }

    public CompoundBlock findVarIdentBlock(String string, BlockList blockList) {
        for (BlockList blockList2 = blockList; blockList2 != null; blockList2 = blockList2.getParentList()) {
            Ident ident = blockList2.findLocalIdent(string);
            if (ident == null) continue;
            return (CompoundBlock)blockList2.getParent();
        }
        return null;
    }

    public Block findParentBlockStmt() {
        Block block = this;
        while (block.Opcode() != Xcode.F_BLOCK_STATEMENT && block.Opcode() != Xcode.FUNCTION_DEFINITION) {
            if ((block = block.getParentBlock()) != null) continue;
            return null;
        }
        return block.Opcode() == Xcode.F_BLOCK_STATEMENT ? block : null;
    }

    @Override
    public Ident findCommonIdent(String string) {
        return null;
    }

    public Boolean removeVarIdent(String string) {
        for (BlockList blockList = this.parent; blockList != null; blockList = blockList.getParentList()) {
            if (!blockList.removeIdent(string).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static final int numberOfBlock() {
        return BlockCounter;
    }

    public static final int numberOfBasicBlock() {
        return BasicBlock.BasicBlockCounter;
    }

    public XMPsymbolTable getXMPsymbolTable() {
        return null;
    }

    public XMPobject getXMPobject(String string) {
        XMPsymbolTable xMPsymbolTable = this.getXMPsymbolTable();
        return xMPsymbolTable != null ? xMPsymbolTable.getXMPobject(string) : null;
    }

    public XMPobject findXMPobject(String string) {
        for (Block block = this; block != null; block = block.getParentBlock()) {
            XMPobject xMPobject = block.getXMPobject(string);
            if (xMPobject != null) {
                return xMPobject;
            }
            if (block instanceof FunctionBlock) break;
        }
        return null;
    }
}

