/*
 * Decompiled with CFR 0.152.
 */
package exc.block;

import exc.block.BasicBlock;
import exc.block.Block;
import exc.block.BlockList;
import exc.block.CforBlock;
import exc.block.CompoundBlock;
import exc.block.CondBlock;
import exc.block.FcaseLabelBlock;
import exc.block.FdoBlock;
import exc.block.FforAllBlock;
import exc.block.FunctionBlock;
import exc.block.IfBlock;
import exc.block.LabelBlock;
import exc.block.NullBlock;
import exc.block.PragmaBlock;
import exc.block.SimpleBlock;
import exc.block.Statement;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjList;
import exc.object.XobjString;
import exc.object.Xobject;
import exc.object.XobjectDef;
import xcodeml.util.XmLog;
import xcodeml.util.XmOption;

public class Bcons {
    private static Xcode statement_list_code() {
        return XmOption.isLanguageC() ? Xcode.LIST : Xcode.F_STATEMENT_LIST;
    }

    public static Block Statement(Xobject xobject) {
        return new SimpleBlock(Bcons.statement_list_code(), BasicBlock.Statement(xobject));
    }

    public static Block Cond(Xobject xobject) {
        return new SimpleBlock(Xcode.LIST, BasicBlock.Cond(xobject));
    }

    public static Block BasicBlock(BasicBlock basicBlock) {
        return new SimpleBlock(Bcons.statement_list_code(), basicBlock);
    }

    public static Block emptyBlock() {
        return new SimpleBlock(Bcons.statement_list_code(), new BasicBlock());
    }

    public static BlockList emptyBody() {
        return new BlockList();
    }

    public static BlockList blockList(Block ... blockArray) {
        BlockList blockList = new BlockList();
        for (Block block : blockArray) {
            blockList.add(block);
        }
        return blockList;
    }

    public static BlockList emptyBody(Xobject xobject, Xobject xobject2) {
        return new BlockList(xobject, xobject2);
    }

    public static Block COMPOUND(BlockList blockList) {
        if (XmOption.isLanguageC()) {
            return new CompoundBlock(blockList);
        }
        return new CompoundBlock(Xcode.F_STATEMENT_LIST, blockList);
    }

    public static Block COMPOUND(BlockList blockList, Xcode xcode) {
        return new CompoundBlock(xcode, blockList);
    }

    public static Block PRAGMA(Xcode xcode, String string, Xobject xobject, BlockList blockList) {
        return new PragmaBlock(xcode, string, xobject, blockList);
    }

    public static Block IF(Xcode xcode, BasicBlock basicBlock, BlockList blockList, BlockList blockList2, String string) {
        if (blockList != null && blockList.getIdentList() != null) {
            blockList = new BlockList(Bcons.COMPOUND(blockList));
        }
        if (blockList2 != null && blockList2.getIdentList() != null) {
            blockList2 = new BlockList(Bcons.COMPOUND(blockList2));
        }
        return new IfBlock(xcode, basicBlock, blockList, blockList2, string);
    }

    public static Block IF(BasicBlock basicBlock, BlockList blockList, BlockList blockList2) {
        return Bcons.IF(Xcode.IF_STATEMENT, basicBlock, blockList, blockList2, null);
    }

    public static Block IF(Xobject xobject, Block block, Block block2) {
        return Bcons.IF(BasicBlock.Cond(xobject), new BlockList(block), new BlockList(block2));
    }

    public static Block IF(Xobject xobject, Xobject xobject2, Xobject xobject3) {
        return Bcons.IF(xobject, Bcons.buildBlock(xobject2), xobject3 != null ? Bcons.buildBlock(xobject3) : null);
    }

    public static Block Fwhere(BasicBlock basicBlock, BlockList blockList, BlockList blockList2, String string) {
        return Bcons.IF(Xcode.F_WHERE_STATEMENT, basicBlock, blockList, blockList2, string);
    }

    public static Block FOR(BasicBlock basicBlock, BasicBlock basicBlock2, BasicBlock basicBlock3, BlockList blockList, String string) {
        return new CforBlock(basicBlock, basicBlock2, basicBlock3, blockList, null);
    }

    public static Block FOR(BasicBlock basicBlock, BasicBlock basicBlock2, BasicBlock basicBlock3, BlockList blockList) {
        return Bcons.FOR(basicBlock, basicBlock2, basicBlock3, blockList, null);
    }

    public static Block FOR(Xobject xobject, Xobject xobject2, Xobject xobject3, Block block, String string) {
        return new CforBlock(BasicBlock.Statement(xobject), BasicBlock.Cond(xobject2), BasicBlock.Statement(xobject3), new BlockList(block), string);
    }

    public static Block FOR(Xobject xobject, Xobject xobject2, Xobject xobject3, Block block) {
        return Bcons.FOR(xobject, xobject2, xobject3, block, null);
    }

    public static Block FforAll(Xobject xobject) {
        String string = xobject.getArgOrNull(0) != null ? xobject.getArgOrNull(0).getName() : null;
        XobjList xobjList = new XobjList();
        int n = 1;
        while (xobject.getArg(n).Opcode() == Xcode.VAR && xobject.getArg(n + 1).Opcode() == Xcode.F_INDEX_RANGE) {
            xobjList.add(new XobjList(null, xobject.getArg(n), xobject.getArg(n + 1)));
            n += 2;
        }
        BasicBlock basicBlock = null;
        if (xobject.getArg(n).Opcode() != Xcode.F_STATEMENT_LIST) {
            basicBlock = BasicBlock.Cond(xobject.getArg(n++));
        }
        BlockList blockList = Bcons.buildList(xobject.getArg(n));
        return new FforAllBlock(xobject.Type(), basicBlock, xobjList, blockList, string);
    }

    public static Block FORall(Xobject xobject, Xobject xobject2, Xobject xobject3, Xobject xobject4, Xcode xcode, BlockList blockList) {
        return Bcons.FOR(Xcons.Set(xobject, xobject2), Xcons.binaryOp(xcode, xobject, xobject3), Xcons.asgOp(Xcode.ASG_PLUS_EXPR, xobject, xobject4), Bcons.COMPOUND(blockList));
    }

    public static Block Fdo(Xobject xobject, Xobject xobject2, BlockList blockList, String string) {
        return new FdoBlock(null, xobject, xobject2, blockList, string);
    }

    public static Block Fdo(Xobject xobject) {
        return new FdoBlock(xobject.getLineNo(), xobject.getArg(1), xobject.getArg(2), Bcons.buildList(xobject.getArg(3)), Bcons.getArg0Name(xobject));
    }

    public static Block WHILE(Xcode xcode, BasicBlock basicBlock, BlockList blockList, String string) {
        return new CondBlock(xcode, basicBlock, blockList, string);
    }

    public static Block WHILE(BasicBlock basicBlock, BlockList blockList) {
        return Bcons.WHILE(Xcode.WHILE_STATEMENT, basicBlock, blockList, null);
    }

    public static Block WHILE(Xobject xobject, Block block) {
        return Bcons.WHILE(BasicBlock.Cond(xobject), new BlockList(block));
    }

    public static Block DO_WHILE(BasicBlock basicBlock, BlockList blockList) {
        return Bcons.WHILE(Xcode.F_DO_WHILE_STATEMENT, basicBlock, blockList, null);
    }

    public static Block DO_WHILE(Xobject xobject, Block block) {
        return Bcons.DO_WHILE(BasicBlock.Cond(xobject), new BlockList(block));
    }

    public static Block DO(BlockList blockList, BasicBlock basicBlock, String string) {
        return new CondBlock(Xcode.DO_STATEMENT, basicBlock, blockList, string);
    }

    public static Block DO(BlockList blockList, BasicBlock basicBlock) {
        return Bcons.DO(blockList, basicBlock, null);
    }

    public static Block DO(Block block, Xobject xobject) {
        return Bcons.DO(new BlockList(block), BasicBlock.Cond(xobject));
    }

    public static Block SWITCH(BasicBlock basicBlock, BlockList blockList) {
        return new CondBlock(Xcode.SWITCH_STATEMENT, basicBlock, blockList, null);
    }

    public static Block SWITCH(Xobject xobject, Block block) {
        return Bcons.SWITCH(BasicBlock.Cond(xobject), new BlockList(block));
    }

    public static Block FselectCase(Xobject xobject, BlockList blockList, String string) {
        if (xobject.Opcode() != Xcode.F_VALUE) {
            xobject = Xcons.List(Xcode.F_VALUE, xobject);
        }
        return new CondBlock(Xcode.F_SELECT_CASE_STATEMENT, BasicBlock.Cond(xobject), blockList, string);
    }

    public static Block BREAK() {
        return new SimpleBlock(Xcode.BREAK_STATEMENT);
    }

    public static Block CONTINUE() {
        return new SimpleBlock(Xcode.CONTINUE_STATEMENT);
    }

    public static Block Fcycle() {
        return new SimpleBlock(Xcode.F_CYCLE_STATEMENT);
    }

    public static Block GOTO(Xobject xobject) {
        return new LabelBlock(Xcode.GOTO_STATEMENT, xobject);
    }

    public static Block GOTO(Xobject xobject, Xobject xobject2, Xobject xobject3) {
        return new LabelBlock(Xcode.GOTO_STATEMENT, xobject, xobject2, xobject3);
    }

    public static Block LABEL(Xobject xobject) {
        return new LabelBlock(Xcode.STATEMENT_LABEL, xobject);
    }

    public static Block CASE(Xobject xobject) {
        return new LabelBlock(Xcode.CASE_LABEL, xobject);
    }

    public static Block FcaseLabel(XobjList xobjList, BlockList blockList, String string) {
        return new FcaseLabelBlock(xobjList, blockList, string);
    }

    public static Block DEFAULT_LABEL() {
        return new SimpleBlock(Xcode.DEFAULT_LABEL);
    }

    public static Block RETURN() {
        return new SimpleBlock(Xcode.RETURN_STATEMENT);
    }

    public static Block RETURN(BasicBlock basicBlock) {
        return new SimpleBlock(Xcode.RETURN_STATEMENT, basicBlock);
    }

    public static Block RETURN(Xobject xobject) {
        return new SimpleBlock(Xcode.RETURN_STATEMENT, BasicBlock.Cond(xobject));
    }

    public static FunctionBlock buildFunctionBlock(XobjectDef xobjectDef) {
        return new FunctionBlock(xobjectDef.getDef().getLineNo(), xobjectDef.getDef().Opcode(), xobjectDef.getNameObj(), xobjectDef.getFuncIdList(), xobjectDef.getFuncDecls(), Bcons.buildBlock(xobjectDef.getFuncBody()), xobjectDef.getFuncGccAttributes(), xobjectDef.getParentEnv(), xobjectDef.getParentNameObj());
    }

    static BlockList buildList(Xobject xobject) {
        BlockList blockList = new BlockList();
        if (xobject == null) {
            return blockList;
        }
        blockList.code = xobject.Opcode();
        switch (xobject.Opcode()) {
            case LIST: 
            case F_STATEMENT_LIST: {
                break;
            }
            case F_BLOCK_STATEMENT: {
                blockList.block_name = (XobjString)xobject.getArg(0);
                blockList.id_list = xobject.getArg(1);
                blockList.decls = xobject.getArg(2);
                blockList.initLocalCoarrays((XobjList)xobject.getArgOrNull(4));
                xobject = xobject.getArg(3);
                break;
            }
            case COMPOUND_STATEMENT: {
                blockList.id_list = xobject.getArg(0);
                blockList.decls = xobject.getArg(1);
                xobject = xobject.getArg(2);
                break;
            }
            default: {
                Block block = Bcons.buildBlock(xobject);
                block.setLineNo(xobject.getLineNo());
                blockList.add(block);
                return blockList;
            }
        }
        Bcons.addBlocks(xobject, blockList);
        return blockList;
    }

    private static void addBlocks(Xobject xobject, BlockList blockList) {
        if (xobject == null) {
            return;
        }
        switch (xobject.Opcode()) {
            case LIST: 
            case F_STATEMENT_LIST: {
                for (Xobject xobject2 : (XobjList)xobject) {
                    Bcons.addBlocks(xobject2, blockList);
                }
                break;
            }
            case EXPR_STATEMENT: {
                Block block = blockList.getTail();
                if (block == null || block.Opcode() != Xcode.LIST) {
                    block = new SimpleBlock(Bcons.statement_list_code());
                    block.setLineNo(xobject.getLineNo());
                    blockList.add(block);
                }
                Statement statement = null;
                statement = xobject.getArg(0).Opcode() == Xcode.FUNCTION_CALL ? new Statement(xobject) : new Statement(xobject.getArg(0));
                statement.setLineNo(xobject.getLineNo());
                block.getBasicBlock().add(statement);
                break;
            }
            default: {
                Block block = Bcons.buildBlock(xobject);
                if (block.getLineNo() == null) {
                    block.setLineNo(xobject.getLineNo());
                }
                blockList.add(block);
            }
        }
    }

    public static Block buildBlock(Xobject xobject) {
        if (xobject == null) {
            return null;
        }
        Xcode xcode = xobject.Opcode();
        switch (xcode) {
            default: {
                if (xcode.isFstatement()) {
                    return Bcons.Statement(xobject);
                }
                XmLog.fatal((String)("build: unknown code: " + xobject.OpcodeName()));
                return null;
            }
            case GCC_ASM_STATEMENT: {
                return Bcons.Statement(xobject);
            }
            case NULL: {
                return new NullBlock();
            }
            case LIST: {
                XmLog.fatal((String)"LIST is appear in non-compound statement");
                return null;
            }
            case F_STATEMENT_LIST: 
            case F_BLOCK_STATEMENT: 
            case COMPOUND_STATEMENT: {
                CompoundBlock compoundBlock = (CompoundBlock)Bcons.COMPOUND(Bcons.buildList(xobject), xcode);
                compoundBlock.setLineNo(xobject.getLineNo());
                return compoundBlock;
            }
            case OMP_PRAGMA: {
                return Bcons.PRAGMA(Xcode.OMP_PRAGMA, xobject.getArg(0).getString(), xobject.getArgOrNull(1), Bcons.buildList(xobject.getArgOrNull(2)));
            }
            case XMP_PRAGMA: {
                return Bcons.PRAGMA(Xcode.XMP_PRAGMA, xobject.getArg(0).getString(), xobject.getArg(1), Bcons.buildList(xobject.getArgOrNull(2)));
            }
            case ACC_PRAGMA: {
                return Bcons.PRAGMA(Xcode.ACC_PRAGMA, xobject.getArg(0).getString(), xobject.getArgOrNull(1), Bcons.buildList(xobject.getArgOrNull(2)));
            }
            case IF_STATEMENT: {
                return Bcons.IF(BasicBlock.Cond(xobject.getArg(0)), Bcons.buildList(xobject.getArg(1)), Bcons.buildList(xobject.getArg(2)));
            }
            case F_FORALL_STATEMENT: {
                return Bcons.FforAll(xobject);
            }
            case FOR_STATEMENT: {
                return Bcons.FOR(BasicBlock.Statement(xobject.getArg(0)), BasicBlock.Cond(xobject.getArg(1)), BasicBlock.Statement(xobject.getArg(2)), Bcons.buildList(xobject.getArg(3)));
            }
            case WHILE_STATEMENT: {
                return Bcons.WHILE(BasicBlock.Cond(xobject.getArg(0)), Bcons.buildList(xobject.getArg(1)));
            }
            case DO_STATEMENT: {
                return Bcons.DO(Bcons.buildList(xobject.getArg(0)), BasicBlock.Cond(xobject.getArg(1)));
            }
            case SWITCH_STATEMENT: {
                return Bcons.SWITCH(BasicBlock.Cond(xobject.getArg(0)), Bcons.buildList(xobject.getArg(1)));
            }
            case BREAK_STATEMENT: {
                return Bcons.BREAK();
            }
            case CONTINUE_STATEMENT: {
                return Bcons.CONTINUE();
            }
            case GOTO_STATEMENT: {
                return Bcons.GOTO(xobject.getArg(0), xobject.getArgOrNull(1), xobject.getArgOrNull(2));
            }
            case STATEMENT_LABEL: {
                return Bcons.LABEL(xobject.getArg(0));
            }
            case CASE_LABEL: {
                return Bcons.CASE(xobject.getArg(0));
            }
            case DEFAULT_LABEL: {
                return Bcons.DEFAULT_LABEL();
            }
            case RETURN_STATEMENT: {
                return Bcons.RETURN(BasicBlock.Cond(xobject.getArgOrNull(0)));
            }
            case EXPR_STATEMENT: {
                if (xobject.getArg(0).Opcode() == Xcode.FUNCTION_CALL) {
                    return Bcons.Statement(xobject);
                }
                return Bcons.Statement(xobject.getArg(0));
            }
            case PRAGMA_LINE: {
                return Bcons.PRAGMA(Xcode.PRAGMA_LINE, xobject.getArg(0).getString(), null, null);
            }
            case TEXT: 
            case LINEMARKER: {
                return new SimpleBlock(Bcons.statement_list_code(), BasicBlock.Statement(xobject));
            }
            case F_IF_STATEMENT: {
                return Bcons.IF(xcode, BasicBlock.Cond(xobject.getArg(1)), Bcons.buildList(xobject.getArg(2)), Bcons.buildList(xobject.getArg(3)), Bcons.getArg0Name(xobject));
            }
            case F_WHERE_STATEMENT: {
                return Bcons.Fwhere(BasicBlock.Cond(xobject.getArg(1)), Bcons.buildList(xobject.getArg(2)), Bcons.buildList(xobject.getArg(3)), Bcons.getArg0Name(xobject));
            }
            case F_DO_STATEMENT: {
                return Bcons.Fdo(xobject);
            }
            case F_DO_WHILE_STATEMENT: {
                return Bcons.WHILE(xcode, BasicBlock.Cond(xobject.getArg(1)), Bcons.buildList(xobject.getArg(2)), Bcons.getArg0Name(xobject));
            }
            case F_SELECT_CASE_STATEMENT: {
                return Bcons.FselectCase(xobject.getArg(1), Bcons.buildList(xobject.getArg(2)), Bcons.getArg0Name(xobject));
            }
            case F_CASE_LABEL: 
        }
        return Bcons.FcaseLabel((XobjList)xobject.getArg(1), Bcons.buildList(xobject.getArgOrNull(2)), Bcons.getArg0Name(xobject));
    }

    private static String getArg0Name(Xobject xobject) {
        Xobject xobject2 = xobject.getArgOrNull(0);
        if (xobject2 == null) {
            return null;
        }
        return xobject2.getName();
    }
}

