/*
 * Decompiled with CFR 0.152.
 */
package exc.block;

import exc.block.BasicBlock;
import exc.block.BasicBlockVisitor;
import exc.block.Block;
import exc.block.BlockList;
import java.util.Vector;

public class BasicBlockIterator
implements BasicBlockVisitor {
    Vector<BasicBlock> bblocks;
    BasicBlock currentBlock;
    int index;

    public BasicBlockIterator(Block block) {
        this.init(block);
    }

    public BasicBlockIterator(BlockList blockList) {
        this.init(blockList);
    }

    public void init() {
        this.index = 0;
        if (this.bblocks.size() > 0) {
            this.currentBlock = this.bblocks.elementAt(0);
        }
    }

    public void init(Block block) {
        this.bblocks = new Vector();
        this.visit(block);
        this.index = 0;
        if (this.bblocks.size() > 0) {
            this.currentBlock = this.bblocks.elementAt(0);
        }
    }

    public void init(BlockList blockList) {
        this.bblocks = new Vector();
        this.visit(blockList);
        this.index = 0;
        if (this.bblocks.size() > 0) {
            this.currentBlock = this.bblocks.elementAt(0);
        }
    }

    @Override
    public void visit(Block block) {
        if (block == null) {
            return;
        }
        block.visitBasicBlock(this);
        block.visitBody(this);
    }

    @Override
    public void visit(BasicBlock basicBlock) {
        if (basicBlock != null) {
            this.bblocks.addElement(basicBlock);
        }
    }

    @Override
    public void visit(BlockList blockList) {
        if (blockList == null) {
            return;
        }
        for (Block block = blockList.getHead(); block != null; block = block.getNext()) {
            this.visit(block);
        }
    }

    public void next() {
        this.currentBlock = ++this.index >= this.bblocks.size() ? null : this.bblocks.elementAt(this.index);
    }

    public boolean end() {
        return this.index == this.bblocks.size();
    }

    public int size() {
        return this.bblocks.size();
    }

    public BasicBlock getBasicBlock() {
        return this.currentBlock;
    }
}

