/*
 * Decompiled with CFR 0.152.
 */
package exc.block;

import exc.block.BasicBlock;
import exc.block.BasicBlockIterator;
import exc.block.Block;
import exc.block.BlockList;
import exc.block.Statement;
import exc.block.StatementIterator;
import exc.object.LineNo;
import exc.object.Xobject;

public class BasicBlockExprIterator {
    BasicBlockIterator i;
    protected StatementIterator is;
    protected Statement current_statement;
    protected BasicBlock current_bblock;

    public BasicBlockExprIterator(Block block) {
        this.init(block);
    }

    public BasicBlockExprIterator(BlockList blockList) {
        this.init(blockList);
    }

    public BasicBlockExprIterator() {
    }

    public void init(Block block) {
        this.i = new BasicBlockIterator(block);
        this.initialize();
    }

    public void init(BlockList blockList) {
        this.i = new BasicBlockIterator(blockList);
        this.initialize();
    }

    public void init() {
        this.i.init();
        this.initialize();
    }

    void initialize() {
        this.current_bblock = this.i.getBasicBlock();
        if (this.current_bblock == null) {
            return;
        }
        this.is = this.current_bblock.statements();
        this.next();
    }

    public void next() {
        this.current_statement = null;
        while (true) {
            if (this.is != null) {
                if (this.is.hasMoreStatement()) {
                    this.current_statement = this.is.nextStatement();
                    return;
                }
                this.is = null;
                if (this.current_bblock.getExpr() != null) {
                    return;
                }
            }
            this.nextBasicBlock();
            if (this.current_bblock == null) {
                return;
            }
            this.is = this.current_bblock.statements();
        }
    }

    public void nextBasicBlock() {
        this.i.next();
        this.current_bblock = this.i.end() ? null : this.i.getBasicBlock();
    }

    public boolean end() {
        return this.current_bblock == null;
    }

    public Statement getStatement() {
        return this.current_statement;
    }

    public BasicBlock getBasicBlock() {
        return this.current_bblock;
    }

    public Xobject getExpr() {
        if (this.current_statement != null) {
            return this.current_statement.getExpr();
        }
        return this.current_bblock.getExpr();
    }

    public void setExpr(Xobject xobject) {
        if (this.current_statement != null) {
            this.current_statement.setExpr(xobject);
        } else {
            this.current_bblock.setExpr(xobject);
        }
    }

    public void insertStatement(Xobject xobject) {
        if (this.current_statement != null) {
            this.current_statement.insert(xobject);
        } else {
            this.current_bblock.add(xobject);
        }
    }

    public void addStatement(Xobject xobject) {
        if (this.current_statement != null) {
            this.current_statement.add(xobject);
        } else {
            this.current_bblock.add(xobject);
        }
    }

    public LineNo getLineNo() {
        if (this.current_statement != null) {
            return this.current_statement.getLineNo();
        }
        return this.current_bblock.getParent().getLineNo();
    }
}

