/*
 * Decompiled with CFR 0.152.
 */
package exc.block;

import exc.block.Block;
import exc.block.BlockList;
import exc.block.ForBlock;
import exc.block.IfBlock;
import exc.block.SimpleBlock;
import exc.block.Statement;
import exc.block.StatementIterator;
import exc.block.forwardStatementIterator;
import exc.object.PropObject;
import exc.object.Xcode;
import exc.object.Xcons;
import exc.object.XobjArgs;
import exc.object.XobjList;
import exc.object.Xobject;
import java.util.Iterator;
import java.util.Vector;
import xcodeml.util.XmOption;

public class BasicBlock
extends PropObject
implements Iterable<Statement> {
    protected static int BasicBlockCounter = 0;
    Xobject exp;
    Block parent;
    Statement head;
    Statement tail;
    Vector<BasicBlock> cflow_in;
    Vector<BasicBlock> cflow_out;
    int depth_first_num;
    BasicBlock top_next;
    BasicBlock top_prev;
    boolean mark;

    public BasicBlock() {
        this.id = BasicBlockCounter++;
        this.cflow_in = new Vector();
        this.cflow_out = new Vector();
    }

    public BasicBlock(BasicBlock basicBlock) {
        for (Statement statement = basicBlock.head; statement != null; statement = statement.getNext()) {
            this.add(statement.getExpr().copy());
        }
        if (basicBlock.exp != null) {
            this.exp = basicBlock.exp.copy();
        }
    }

    public BasicBlock copy() {
        return new BasicBlock(this);
    }

    public final Block getParent() {
        return this.parent;
    }

    public final void setParent(Block block) {
        this.parent = block;
    }

    public final Statement getHead() {
        return this.head;
    }

    public final Statement getTail() {
        return this.tail;
    }

    public Xobject getExpr() {
        return this.exp;
    }

    public void setExpr(Xobject xobject) {
        this.exp = xobject;
    }

    public StatementIterator statements() {
        return new forwardStatementIterator(this.getHead());
    }

    @Override
    public Iterator<Statement> iterator() {
        return this.statements();
    }

    public Vector<BasicBlock> getCflowIn() {
        return this.cflow_in;
    }

    public Vector<BasicBlock> getCflowOut() {
        return this.cflow_out;
    }

    public BasicBlock getCflowIn(int n) {
        return this.cflow_in.elementAt(n);
    }

    public BasicBlock getCflowOut(int n) {
        return this.cflow_out.elementAt(n);
    }

    public void addCflowTo(BasicBlock basicBlock) {
        this.cflow_out.addElement(basicBlock);
        basicBlock.cflow_in.addElement(this);
    }

    public void removeCflowTo(BasicBlock basicBlock) {
        this.cflow_out.removeElement(basicBlock);
        basicBlock.cflow_in.removeElement(this);
    }

    public BasicBlock topNext() {
        return this.top_next;
    }

    public BasicBlock topPrev() {
        return this.top_prev;
    }

    public void setTopNext(BasicBlock basicBlock) {
        this.top_next = basicBlock;
    }

    public void setTopPrev(BasicBlock basicBlock) {
        this.top_prev = basicBlock;
    }

    public void resetMark() {
        this.mark = false;
    }

    public void setMark() {
        this.mark = true;
    }

    public boolean isMarked() {
        return this.mark;
    }

    public int DFN() {
        return this.depth_first_num;
    }

    public void setDFN(int n) {
        this.depth_first_num = n;
    }

    public void add(Statement statement) {
        statement.parent = this;
        if (this.tail == null) {
            this.head = this.tail = statement;
            return;
        }
        this.tail.next = statement;
        statement.prev = this.tail;
        this.tail = statement;
    }

    public void add(Xobject xobject) {
        this.add(new Statement(xobject));
    }

    public void addStatement(Statement statement) {
        BasicBlock basicBlock = this;
        Block block = basicBlock.parent;
        if (block instanceof ForBlock) {
            if (block.prev == null) {
                BlockList blockList = block.getParent();
                SimpleBlock simpleBlock = new SimpleBlock(Xcode.LIST, new BasicBlock());
                if (blockList.head != block) {
                    System.err.println("ForBlock is not first Block in BlockList");
                    System.exit(1);
                }
                blockList.head = simpleBlock;
                simpleBlock.next = block;
                block.prev = simpleBlock;
            }
            basicBlock = block.prev.getBasicBlock();
        }
        statement.parent = basicBlock;
        if (basicBlock.tail == null) {
            basicBlock.head = basicBlock.tail = statement;
            return;
        }
        basicBlock.tail.next = statement;
        statement.prev = basicBlock.tail;
        basicBlock.tail = statement;
    }

    public void addStatement(Xobject xobject) {
        this.addStatement(new Statement(xobject));
    }

    public void insert(Xobject xobject) {
        this.insert(new Statement(xobject));
    }

    public void insert(Statement statement) {
        statement.parent = this;
        if (this.tail == null) {
            this.head = this.tail = statement;
            return;
        }
        this.head.prev = statement;
        statement.next = this.head;
        this.head = statement;
    }

    public void insertStatement(Xobject xobject) {
        this.insertStatement(new Statement(xobject));
    }

    public void insertStatement(Statement statement) {
        BasicBlock basicBlock = this;
        Block block = basicBlock.parent;
        if ((block instanceof ForBlock || block instanceof IfBlock) && block.getParent() instanceof BlockList) {
            BlockList blockList = block.getParent();
            SimpleBlock simpleBlock = new SimpleBlock(Xcode.LIST, new BasicBlock());
            if (blockList.head == block) {
                blockList.head = simpleBlock;
                simpleBlock.next = block;
                block.prev = simpleBlock;
            } else if (blockList.tail == block) {
                simpleBlock.prev = block.prev;
                block.prev.next = simpleBlock;
                simpleBlock.next = block;
            } else {
                simpleBlock.prev = block.prev;
                block.prev.next = simpleBlock;
                simpleBlock.next = block;
                block.prev = simpleBlock;
            }
            basicBlock = simpleBlock.getBasicBlock();
        }
        statement.parent = basicBlock;
        if (basicBlock.tail == null) {
            basicBlock.head = basicBlock.tail = statement;
            return;
        }
        basicBlock.head.prev = statement;
        statement.next = basicBlock.head;
        basicBlock.head = statement;
    }

    public boolean isEmpty() {
        return this.exp == null && this.head == null;
    }

    public boolean isSingle() {
        return this.exp == null && this.head != null && this.head == this.tail;
    }

    public static BasicBlock Cond(Xobject xobject) {
        BasicBlock basicBlock = new BasicBlock();
        basicBlock.exp = xobject;
        return basicBlock;
    }

    public static BasicBlock Statement(Xobject xobject) {
        BasicBlock basicBlock = new BasicBlock();
        if (xobject == null) {
            return basicBlock;
        }
        if (xobject.Opcode() == Xcode.COMMA_EXPR) {
            for (XobjArgs xobjArgs = xobject.getArgs(); xobjArgs != null; xobjArgs = xobjArgs.nextArgs()) {
                basicBlock.add(xobjArgs.getArg());
            }
        } else {
            basicBlock.add(xobject);
        }
        return basicBlock;
    }

    public static BasicBlock Expr(Block block, Xobject xobject) {
        BasicBlock basicBlock = new BasicBlock();
        basicBlock.parent = block;
        basicBlock.exp = xobject;
        return basicBlock;
    }

    public Xobject toXobject() {
        if (this.head == null) {
            return this.exp;
        }
        if (this.head == this.tail && this.exp == null) {
            Xobject xobject = this.head.getExpr();
            if (XmOption.isLanguageF() && !xobject.Opcode().isFstatement() && xobject.Opcode() != Xcode.EXPR_STATEMENT) {
                xobject = Xcons.List(Xcode.EXPR_STATEMENT, xobject);
            }
            return xobject;
        }
        XobjList xobjList = Xcons.List(XmOption.isLanguageC() ? Xcode.COMMA_EXPR : Xcode.F_STATEMENT_LIST);
        for (Statement statement = this.head; statement != null; statement = statement.getNext()) {
            if (statement.getExpr() == null) continue;
            ((Xobject)xobjList).add(statement.getExpr());
        }
        if (this.exp != null) {
            ((Xobject)xobjList).add(this.exp);
        }
        if (XmOption.isLanguageC()) {
            xobjList.setType(((Xobject)xobjList).getTail().Type());
        }
        return xobjList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("(BB:" + this.id);
        for (Statement statement = this.head; statement != null; statement = statement.getNext()) {
            stringBuilder.append(statement.toString());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

