/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.util;

import xcodeml.util.XmBindingException;

public final class XmStringUtil {
    private XmStringUtil() {
    }

    public static final String trim(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return string;
    }

    public static int getAsCInt(String string) {
        return (int)XmStringUtil.getAsCLong(string, Radix.ALL);
    }

    public static long getAsCLong(String string) {
        return XmStringUtil.getAsCLong(string, Radix.ALL);
    }

    public static long getAsCLong(String string, Radix radix) {
        if ((string = XmStringUtil.trim(string)) == null) {
            throw new XmBindingException("not integer value '" + string + "'");
        }
        if (string.startsWith("0x") && radix == Radix.ALL || radix == Radix.HEX) {
            if (string.length() > 2) {
                try {
                    return Long.parseLong(string.substring(2, string.length()), 16);
                }
                catch (Exception exception) {}
            }
        } else if (radix == Radix.ALL || radix == Radix.DEC) {
            try {
                return Long.parseLong(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        switch (radix) {
            case HEX: {
                throw new XmBindingException("invalid hex integer value '" + string + "'");
            }
            case DEC: {
                throw new XmBindingException("invalid integer value '" + string + "'");
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean getAsBool(String string) {
        if (string == null) {
            string = XmStringUtil.trim(string);
        }
        if (string == null) {
            throw new XmBindingException("invalid bool value");
        }
        if (string.equals("1") || string.equals("true")) {
            return true;
        }
        if (string.equals("0") || string.equals("false")) {
            return false;
        }
        throw new XmBindingException("invalid bool value '" + string + "'");
    }

    public static enum Radix {
        ALL,
        HEX,
        DEC;

    }
}

