/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.util;

import xcodeml.util.ILineNo;
import xcodeml.util.IXobject;
import xcodeml.util.XmOption;

public class XmLog {
    private static void printlnToOut(String string) {
        System.out.println(string);
        System.out.flush();
    }

    private static void printlnToErr(String string) {
        System.err.println(string);
        System.err.flush();
    }

    public static void info(String string) {
        XmLog.printlnToOut(string);
    }

    public static void warning(String string) {
        XmLog.printlnToErr("warn: " + string);
    }

    public static void warning(ILineNo iLineNo, String string) {
        XmLog.warning(XmLog.wrapLocation(iLineNo, string));
    }

    public static void error(String string) {
        XmLog.printlnToErr("error: " + string);
    }

    public static void error(ILineNo iLineNo, String string) {
        XmLog.error(XmLog.wrapLocation(iLineNo, string));
    }

    private static String getExceptionMessage(Exception exception) {
        if (exception.getCause() != null) {
            return exception.getCause().getMessage();
        }
        return exception.getMessage();
    }

    public static void error(ILineNo iLineNo, Exception exception) {
        XmLog.error(XmLog.wrapLocation(iLineNo, XmLog.getExceptionMessage(exception)));
        if (XmOption.isDebugOutput()) {
            exception.printStackTrace();
        }
    }

    public static void fatal(String string) {
        System.out.flush();
        System.err.flush();
        XmLog.printlnToErr("fatal: " + string);
        Thread.dumpStack();
        System.exit(1);
    }

    public static void fatal_dump(String string, IXobject iXobject) {
        System.out.flush();
        System.err.flush();
        XmLog.printlnToErr("fatal: " + string);
        XmLog.printlnToErr("Xcode = " + iXobject.toString());
        Thread.dumpStack();
        System.exit(1);
    }

    public static void fatal(Throwable throwable) {
        XmLog.printlnToErr("fatal:");
        throwable.printStackTrace();
        Thread.dumpStack();
    }

    public static void fatal(ILineNo iLineNo, String string) {
        XmLog.fatal(XmLog.wrapLocation(iLineNo, string));
    }

    public static void debug(String string) {
        if (XmOption.isDebugOutput()) {
            XmLog.printlnToOut(string);
        }
    }

    public static void debugAlways(String string) {
        XmLog.printlnToOut(string);
    }

    private static String wrapLocation(ILineNo iLineNo, String string) {
        if (iLineNo == null) {
            return string;
        }
        return (iLineNo.fileName() != null ? iLineNo.fileName() : "") + ":" + iLineNo.lineNo() + ": " + string;
    }
}

