/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.util;

import java.util.ArrayList;
import java.util.HashSet;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmDomUtil {
    public static Node getElement(Node node, String string) {
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
            return node2;
        }
        return null;
    }

    public static Node getContent(Node node) {
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            return node2;
        }
        return null;
    }

    public static String getContentText(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getFirstChild() == null) {
            return "";
        }
        return node.getFirstChild().getNodeValue();
    }

    public static String getAttr(Node node, String string) {
        if (node == null) {
            return null;
        }
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return null;
    }

    public static boolean hasAttr(Node node, String string) {
        if (node == null) {
            return false;
        }
        String string2 = XmDomUtil.getAttr(node, string);
        return string2 != null && !string2.isEmpty();
    }

    public static boolean getAttrBool(Node node, String string) {
        if (node == null) {
            return false;
        }
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            return false;
        }
        String string2 = node2.getNodeValue();
        if (string2 == null) {
            return false;
        }
        if ("true".equals(string2.toLowerCase())) {
            return true;
        }
        return "1".equals(string2.toLowerCase());
    }

    public static Node[] collectElementsAsArray(Node node, String string) {
        if (node == null) {
            return new Node[0];
        }
        return XmDomUtil.collectElements(node, string).toArray(new Node[0]);
    }

    public static ArrayList<Node> collectElements(Node node, String ... stringArray) {
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            for (String string : stringArray) {
                if (!node2.getNodeName().equals(string)) continue;
                arrayList.add(node2);
            }
        }
        return arrayList;
    }

    public static ArrayList<Node> collectElementsExclude(Node node, String ... stringArray) {
        if (node == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String object : stringArray) {
            hashSet.add(object);
        }
        NodeList nodeList = node.getChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || hashSet.contains(node2.getNodeName())) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }

    public static ArrayList<Node> collectChildNodes(Node node) {
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }
}

