/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.c.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import xcodeml.c.decompile.XcArrayRefObj;
import xcodeml.c.decompile.XcBltInOpObj;
import xcodeml.c.decompile.XcCastObj;
import xcodeml.c.decompile.XcCompStmtObj;
import xcodeml.c.decompile.XcCompoundValueObj;
import xcodeml.c.decompile.XcConstObj;
import xcodeml.c.decompile.XcControlStmtObj;
import xcodeml.c.decompile.XcDeclObj;
import xcodeml.c.decompile.XcDeclsObj;
import xcodeml.c.decompile.XcDesignatedValueObj;
import xcodeml.c.decompile.XcDirectiveObj;
import xcodeml.c.decompile.XcExprObj;
import xcodeml.c.decompile.XcExprStmtObj;
import xcodeml.c.decompile.XcFuncCallObj;
import xcodeml.c.decompile.XcFuncDefObj;
import xcodeml.c.decompile.XcGccAsmDefinition;
import xcodeml.c.decompile.XcGccAsmStmtObj;
import xcodeml.c.decompile.XcGccCompoundExprObj;
import xcodeml.c.decompile.XcIndexRangeObj;
import xcodeml.c.decompile.XcMemberDesignator;
import xcodeml.c.decompile.XcNameObj;
import xcodeml.c.decompile.XcNullExpr;
import xcodeml.c.decompile.XcObj;
import xcodeml.c.decompile.XcOperandObj;
import xcodeml.c.decompile.XcOperatorEnum;
import xcodeml.c.decompile.XcOperatorObj;
import xcodeml.c.decompile.XcProgramObj;
import xcodeml.c.decompile.XcRefObj;
import xcodeml.c.decompile.XcSizeOfExprObj;
import xcodeml.c.decompile.XcSourcePosObj;
import xcodeml.c.decompile.XcSourcePositioned;
import xcodeml.c.decompile.XcVarObj;
import xcodeml.c.decompile.XcXmpCoArrayRefObj;
import xcodeml.c.decompile.XcXmpSubArrayRefObj;
import xcodeml.c.obj.XcNode;
import xcodeml.c.type.XcArrayLikeType;
import xcodeml.c.type.XcArrayType;
import xcodeml.c.type.XcBaseType;
import xcodeml.c.type.XcBaseTypeEnum;
import xcodeml.c.type.XcBasicType;
import xcodeml.c.type.XcCompositeType;
import xcodeml.c.type.XcEnumType;
import xcodeml.c.type.XcFuncType;
import xcodeml.c.type.XcGccAttributable;
import xcodeml.c.type.XcGccAttribute;
import xcodeml.c.type.XcGccAttributeList;
import xcodeml.c.type.XcIdent;
import xcodeml.c.type.XcIdentTable;
import xcodeml.c.type.XcIdentTableEnum;
import xcodeml.c.type.XcIdentTableStack;
import xcodeml.c.type.XcLazyEvalType;
import xcodeml.c.type.XcParamList;
import xcodeml.c.type.XcPointerType;
import xcodeml.c.type.XcStructType;
import xcodeml.c.type.XcSymbolKindEnum;
import xcodeml.c.type.XcType;
import xcodeml.c.type.XcTypeEnum;
import xcodeml.c.type.XcUnionType;
import xcodeml.c.type.XcVarKindEnum;
import xcodeml.c.type.XcVoidType;
import xcodeml.c.type.XcXmpCoArrayType;
import xcodeml.c.util.XcLazyVisitor;
import xcodeml.c.util.XmcBindingUtil;
import xcodeml.c.util.XmcVarCollector;
import xcodeml.util.XmDomUtil;
import xcodeml.util.XmException;
import xcodeml.util.XmStringUtil;
import xcodeml.util.XmTranslationException;

public class XmcXcodeToXcTranslator {
    Pair[] pairs = new Pair[]{new Pair("globalDeclarations", new GlobalDeclarationsNodeVisitor()), new Pair("declarations", new DeclarationsNodeVisitor()), new Pair("exprStatement", new ExprStatementNodeVisitor()), new Pair("typeTable", new TypeTableNodeVisitor()), new Pair("globalSymbols", new GlobalSymbolsNodeVisitor()), new Pair("symbols", new SymbolsNodeVisitor()), new Pair("gccAttribute", new GccAttributeVisitor()), new Pair("gccAttributes", new GccAttributesVisitor()), new Pair("basicType", new BasicTypeVisitor()), new Pair("arrayType", new ArrayTypeVisitor()), new Pair("arraySize", new ArraySizeVisitor()), new Pair("pointerType", new PointerTypeVisitor()), new Pair("enumType", new EnumTypeVisitor()), new Pair("structType", new StructTypeVisitor()), new Pair("unionType", new UnionTypeVisitor()), new Pair("functionType", new FunctionTypeVisitor()), new Pair("id", new IdVisitor()), new Pair("varDecl", new VarDeclVisitor()), new Pair("value", new ValueVisitor()), new Pair("designatedValue", new DesignatedValueVisitor()), new Pair("functionDecl", new FunctionDeclVisitor()), new Pair("functionDefinition", new FunctionDefinitionVisitor()), new Pair("body", new BodyVisitor()), new Pair("compoundStatement", new CompoundStatementNodeVisitor()), new Pair("ifStatement", new IfStatementVisitor()), new Pair("condition", new ConditionVisitor()), new Pair("init", new InitVisitor()), new Pair("iter", new IterVisitor()), new Pair("then", new ThenVisitor()), new Pair("else", new ElseVisitor()), new Pair("whileStatement", new WhileStatementVisitor()), new Pair("doStatement", new DoStatementVisitor()), new Pair("forStatement", new ForStatementVisitor()), new Pair("breakStatement", new BreakStatementVisitor()), new Pair("continueStatement", new ContinueStatementVisitor()), new Pair("returnStatement", new ReturnStatementVisitor()), new Pair("gotoStatement", new GotoStatementVisitor()), new Pair("name", new NameVisitor()), new Pair("switchStatement", new SwitchStatementVisitor()), new Pair("caseLabel", new CaseLabelVisitor()), new Pair("defaultLabel", new DefaultLabelVisitor()), new Pair("statementLabel", new StatementLabelVisitor()), new Pair("floatConstant", new FloatConstantVisitor()), new Pair("intConstant", new IntConstantVisitor()), new Pair("longlongConstant", new LonglongConstantVisitor()), new Pair("stringConstant", new StringConstaantVisitor()), new Pair("string", new StringConstaantVisitor()), new Pair("moeConstant", new MoeConstantVisitor()), new Pair("unaryMinusExpr", new UnaryMinusVisitor()), new Pair("postDecrExpr", new PostDecrVisitor()), new Pair("postIncrExpr", new PostIncrVisitor()), new Pair("preDecrExpr", new PreDecrVisitor()), new Pair("preIncrExpr", new PreIncrVisitor()), new Pair("asgBitAndExpr", new AsgBitAndExprVisitor()), new Pair("asgBitOrExpr", new AsgBitOrExprVisitor()), new Pair("asgBitXorExpr", new AsgBitXorExprVisitor()), new Pair("asgDivExpr", new AsgDivExprVisitor()), new Pair("asgLshiftExpr", new AsgLshiftExprVisitor()), new Pair("asgMinusExpr", new AsgMinusExprVisitor()), new Pair("asgModExpr", new AsgModExprVisitor()), new Pair("asgMulExpr", new AsgMulExprVisitor()), new Pair("asgPlusExpr", new AsgPlusExprVisitor()), new Pair("asgRshiftExpr", new AsgRshiftExprVisitor()), new Pair("assignExpr", new AssignExprVisitor()), new Pair("bitAndExpr", new BitAndExprVisitor()), new Pair("bitOrExpr", new BitOrExprVisitor()), new Pair("bitNotExpr", new BitNotExprVisitor()), new Pair("bitXorExpr", new BitXorExprVisitor()), new Pair("divExpr", new DivExprVisitor()), new Pair("logAndExpr", new LogAndExprVisitor()), new Pair("logEQExpr", new LogEQExprVisitor()), new Pair("logGEExpr", new LogGEExprVisitor()), new Pair("logGTExpr", new LogGTExprVisitor()), new Pair("logLEExpr", new LogLEExprVisitor()), new Pair("logLTExpr", new LogLTExprVisitor()), new Pair("logNEQExpr", new LogNEQExprVisitor()), new Pair("logNotExpr", new LogNotExprVisitor()), new Pair("logOrExpr", new LogOrExprVisitor()), new Pair("LshiftExpr", new LshiftExprVisitor()), new Pair("modExpr", new ModExprVisitor()), new Pair("mulExpr", new MulExprVisitor()), new Pair("minusExpr", new MinusExprVisitor()), new Pair("plusExpr", new PlusExprVisitor()), new Pair("RshiftExpr", new RshiftExprVisitor()), new Pair("condExpr", new CondExprVisitor()), new Pair("commaExpr", new CommaExprVisitor()), new Pair("castExpr", new CastExprVisitor()), new Pair("Var", new VarVisitor()), new Pair("arrayRef", new ArrayRefVisitor()), new Pair("varAddr", new VarAddrVisitor()), new Pair("funcAddr", new FuncAddrVisitor()), new Pair("arrayAddr", new ArrayAddrVisitor()), new Pair("memberAddr", new MemberAddrVisitor()), new Pair("memberRef", new MemberRefVisitor()), new Pair("memberArrayAddr", new MemberArrayAddrVisitor()), new Pair("memberArrayRef", new MemberArrayRefVisitor()), new Pair("pointerRef", new PointerRefVisitor()), new Pair("functionCall", new FunctionCallVisitor()), new Pair("function", new FunctionVisitor()), new Pair("arguments", new ArgumentsVisitor()), new Pair("sizeOfExpr", new SizeOfExprVisitor()), new Pair("addrOfExpr", new AddrOfExprVisitor()), new Pair("gccAlignOfExpr", new GccAlignOfExprVisitor()), new Pair("xmpDescOf", new XmpDescOfVisitor()), new Pair("gccLabelAddr", new GccLabelAddrVisitor()), new Pair("gccAsmDefinition", new GccAsmDefinitionVisitor()), new Pair("pragma", new PragmaVisitor()), new Pair("linemarker", new LinemarkerVisitor()), new Pair("OMPPragma", new OMPPragmaVisitor()), new Pair("ACCPragma", new ACCPragmaVisitor()), new Pair("text", new TextVisitor()), new Pair("gccAsmStatement", new GccAsmStatementVisitor()), new Pair("gccAsmOperand", new GccAsmOperandVisitor()), new Pair("gccAsmOperands", new GccAsmOperandsVisitor()), new Pair("gccAsmClobbers", new GccAsmClobbersVisitor()), new Pair("builtin_op", new BuiltinOpoVisitor()), new Pair("typeName", new TypeNameVisitor()), new Pair("gccMemberDesignator", new GccMemberDesignatorVisitor()), new Pair("gccRangedCaseLabel", new GccRangedCaseLabelVisitor()), new Pair("gccCompoundExpr", new GccCompoundExprVisitor()), new Pair("compoundValue", new CompoundValueExprVisitor()), new Pair("compoundValueAddr", new CompoundValueAddrExprVisitor()), new Pair("coArrayRef", new CoArrayRefVisitor()), new Pair("coArrayType", new CoArrayTypeVisitor()), new Pair("subArrayRef", new SubArrayRefVisitor()), new Pair("indexRange", new IndexRangeVisitor()), new Pair("base", new BaseVisitor()), new Pair("length", new LengthVisitor()), new Pair("step", new StepBoundVisitor())};
    private Map<String, XcodeNodeVisitor> visitorMap;

    public XmcXcodeToXcTranslator() {
        this.createVisitorMap(this.pairs);
    }

    public XcProgramObj trans(Document document) {
        Element element = document.getDocumentElement();
        XcIdentTableStack xcIdentTableStack = new XcIdentTableStack();
        XcIdentTable xcIdentTable = xcIdentTableStack.push();
        TranslationContext translationContext = new TranslationContext(xcIdentTableStack, ScopeEnum.GLOBAL);
        XcProgramObj xcProgramObj = this.createXcodeProgram(translationContext, element);
        xcProgramObj.setIdentTable(xcIdentTable);
        XmcXcodeToXcTranslator._checkChild(xcProgramObj);
        return xcProgramObj;
    }

    private static void _checkChild(XcNode xcNode) {
        if (xcNode == null) {
            return;
        }
        xcNode.checkChild();
        XcNode[] xcNodeArray = xcNode.getChild();
        if (xcNodeArray != null) {
            for (XcNode xcNode2 : xcNodeArray) {
                XmcXcodeToXcTranslator._checkChild(xcNode2);
            }
        }
    }

    private void trans(TranslationContext translationContext, Node node, XcNode xcNode) {
        XcodeNodeVisitor xcodeNodeVisitor = this.getVisitor(node.getNodeName());
        if (xcodeNodeVisitor == null) {
            throw new XmTranslationException(null, "unknown node : " + node.getNodeName());
        }
        xcodeNodeVisitor.enter(translationContext, node, xcNode);
    }

    private void transChildren(TranslationContext translationContext, Node node, XcNode xcNode) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            this.trans(translationContext, node2, xcNode);
        }
    }

    private void transChildren(TranslationContext translationContext, XcNode xcNode, List<Node> list) {
        for (Node node : list) {
            if (node.getNodeType() != 1) continue;
            this.trans(translationContext, node, xcNode);
        }
    }

    private XcNode addChild(XcNode xcNode, XcNode xcNode2) {
        if (xcNode != null) {
            xcNode.addChild(xcNode2);
        }
        return xcNode;
    }

    private XcodeNodeVisitor getVisitor(String string) {
        return this.visitorMap.get(string);
    }

    private XcProgramObj createXcodeProgram(TranslationContext translationContext, Node node) {
        XcProgramObj xcProgramObj = new XcProgramObj();
        xcProgramObj.setLanguage(XmDomUtil.getAttr((Node)node, (String)"language"));
        xcProgramObj.setTime(XmDomUtil.getAttr((Node)node, (String)"time"));
        xcProgramObj.setSource(XmDomUtil.getAttr((Node)node, (String)"source"));
        xcProgramObj.setVersion(XmDomUtil.getAttr((Node)node, (String)"version"));
        xcProgramObj.setCompilerInfo(XmDomUtil.getAttr((Node)node, (String)"compiler-info"));
        this.enterNodes(translationContext, (XcNode)xcProgramObj, XmDomUtil.getElement((Node)node, (String)"typeTable"), XmDomUtil.getElement((Node)node, (String)"globalSymbols"), XmDomUtil.getElement((Node)node, (String)"globalDeclarations"));
        return xcProgramObj;
    }

    void enterNodes(TranslationContext translationContext, XcNode xcNode, Node ... nodeArray) {
        this.enterNodes(translationContext, xcNode, false, nodeArray);
    }

    void enterNodes(TranslationContext translationContext, XcNode xcNode, boolean bl, Node ... nodeArray) {
        for (Node node : nodeArray) {
            if (node == null) {
                if (!bl) continue;
                this.addChild(xcNode, XcNullExpr.createXcNullExpr());
                continue;
            }
            this.trans(translationContext, node, xcNode);
        }
    }

    void enterNodesWithNull(TranslationContext translationContext, XcNode xcNode, Node ... nodeArray) {
        this.enterNodes(translationContext, xcNode, true, nodeArray);
    }

    void setSourcePos(XcSourcePositioned xcSourcePositioned, Node node) {
        xcSourcePositioned.setSourcePos(new XcSourcePosObj(XmDomUtil.getAttr((Node)node, (String)"file"), XmDomUtil.getAttr((Node)node, (String)"lineno"), XmDomUtil.getAttr((Node)node, (String)"rawlineno")));
    }

    String getType(Node node) {
        return XmDomUtil.getAttr((Node)node, (String)"type");
    }

    void _enterArrayType(TranslationContext translationContext, XcArrayLikeType xcArrayLikeType, Node node) {
        String string = XmDomUtil.getAttr((Node)node, (String)"array_size");
        if (string == null) {
            xcArrayLikeType.setIsArraySize(false);
            xcArrayLikeType.setIsArraySizeExpr(false);
        } else if (string.equals("*")) {
            xcArrayLikeType.setIsArraySize(false);
            xcArrayLikeType.setIsArraySizeExpr(true);
            Node node2 = XmDomUtil.getContent((Node)XmDomUtil.getElement((Node)node, (String)"arraySize"));
            XcArrayLikeType xcArrayLikeType2 = xcArrayLikeType;
            xcArrayLikeType2.setIsLazyEvalType(true);
            xcArrayLikeType2.setLazyBindings(new Node[]{node2});
        } else {
            xcArrayLikeType.setIsArraySize(true);
            xcArrayLikeType.setIsArraySizeExpr(false);
            xcArrayLikeType.setArraySize(XmStringUtil.getAsCInt((String)string));
        }
        xcArrayLikeType.setTempRefTypeId(XmDomUtil.getAttr((Node)node, (String)"element_type"));
        this._addType(translationContext, xcArrayLikeType, node);
    }

    void _enterCompositeType(TranslationContext translationContext, XcCompositeType xcCompositeType, Node node) {
        XmcXcodeToXcTranslator._setTypeAttr(xcCompositeType, node);
        Node node2 = XmDomUtil.getElement((Node)node, (String)"symbols");
        if (node2 == null) {
            xcCompositeType.setMemberList(null);
            this._addType(translationContext, xcCompositeType, node);
            return;
        }
        NodeList nodeList = node2.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node3 = nodeList.item(i);
            if (node3.getNodeType() != 1 || !"id".equals(string = node3.getNodeName())) continue;
            String string2 = XmStringUtil.trim((String)this.getType(node3));
            Node node4 = XmDomUtil.getElement((Node)node3, (String)"name");
            if (string2 == null && node4 != null) {
                string2 = XmStringUtil.trim((String)this.getType(node4));
            }
            XmcXcodeToXcTranslator._ensureAttr(node3, string2, "type");
            String string3 = null;
            if (node4 != null) {
                string3 = XmStringUtil.trim((String)XmDomUtil.getContentText((Node)node4));
            }
            XcIdent xcIdent = new XcIdent(string3);
            xcIdent.setTempTypeId(string2);
            xcIdent.setIsGccExtension(XmDomUtil.getAttrBool((Node)node3, (String)"is_gccExtension"));
            xcIdent.setIsGccThread(XmDomUtil.getAttrBool((Node)node3, (String)"is_gccThread"));
            String string4 = XmDomUtil.getAttr((Node)node3, (String)"bit_field");
            if (string4 != null) {
                if (string4.equals("*")) {
                    Node node5 = XmDomUtil.getElement((Node)node3, (String)"bitField");
                    if (node5 == null) {
                        throw new XmTranslationException(node5, "bitFidld must be specified");
                    }
                    xcIdent.setIsBitField(true);
                    xcIdent.setIsBitFieldExpr(true);
                    XcIdent xcIdent2 = xcIdent;
                    xcIdent2.setIsLazyEvalType(true);
                    xcIdent2.setLazyBindings(new Node[]{XmDomUtil.getContent((Node)node5)});
                } else {
                    xcIdent.setIsBitField(true);
                    xcIdent.setIsBitFieldExpr(false);
                    xcIdent.setBitField(XmStringUtil.getAsCInt((String)string4));
                }
            }
            this._addGccAttribute(xcIdent, node);
            xcCompositeType.addMember(xcIdent);
        }
        this._addType(translationContext, xcCompositeType, node);
    }

    static void _ensureAttr(Node node, Object object, String string) {
        if (object == null || object instanceof String && XmStringUtil.trim((String)((String)object)) == null) {
            throw new XmTranslationException(node, "no " + string);
        }
    }

    static void _setTypeAttr(XcType xcType, Node node) {
        xcType.setIsConst(XmDomUtil.getAttrBool((Node)node, (String)"is_const"));
        xcType.setIsVolatile(XmDomUtil.getAttrBool((Node)node, (String)"is_volatile"));
        xcType.setIsRestrict(XmDomUtil.getAttrBool((Node)node, (String)"is_restrict"));
    }

    void _addType(TranslationContext translationContext, XcType xcType, Node node) {
        try {
            translationContext.identTableStack.addType(xcType);
        }
        catch (XmException xmException) {
            throw new XmTranslationException(node, (Throwable)xmException);
        }
    }

    void _addGccAttribute(XcGccAttributable xcGccAttributable, Node node) {
        Node node2 = XmDomUtil.getElement((Node)node, (String)"gccAttributes");
        if (node2 != null) {
            xcGccAttributable.setGccAttribute(new XcGccAttributeList(node2));
        } else {
            xcGccAttributable.setGccAttribute(null);
        }
    }

    String _getContentString(Node node) {
        if (node == null) {
            return null;
        }
        return XmStringUtil.trim((String)XmDomUtil.getContentText((Node)node));
    }

    String _getContent(Node node) {
        String string = XmStringUtil.trim((String)XmDomUtil.getContentText((Node)node));
        if (string == null) {
            throw new XmTranslationException(node, "content is empty");
        }
        return string;
    }

    XcIdent _getIdent(TranslationContext translationContext, XcSymbolKindEnum xcSymbolKindEnum, Node node) {
        String string = this._getContent(node);
        XcIdent xcIdent = translationContext.identTableStack.getIdent(xcSymbolKindEnum, string);
        if (xcIdent == null) {
            throw new XmTranslationException(node, "variable '" + string + "' is not defined");
        }
        return xcIdent;
    }

    XcIdent _getIdentVarOrFunc(TranslationContext translationContext, Node node) {
        String string = this._getContent(node);
        if (string == null) {
            throw new XmTranslationException(node, "variable or function name is not specified");
        }
        XcIdent xcIdent = translationContext.identTableStack.getIdent(XcSymbolKindEnum.VAR, string);
        if (xcIdent == null && (xcIdent = translationContext.identTableStack.getIdent(XcSymbolKindEnum.FUNC, string)) == null) {
            if (string.startsWith("_XMP_") || string.startsWith("xmp_") || string.startsWith("xmpc_")) {
                return new XcIdent(string);
            }
            if (string.startsWith("_ACC_") || string.startsWith("acc_")) {
                return new XcIdent(string);
            }
            throw new XmTranslationException(node, "variable or function '" + string + "' is not defined");
        }
        return xcIdent;
    }

    XcIdent _getIdentFunc(TranslationContext translationContext, Node node) {
        return this._getIdent(translationContext, XcSymbolKindEnum.FUNC, node);
    }

    XcIdent _getIdentFunc(TranslationContext translationContext, Node node, Node node2) {
        XcIdent xcIdent = this._getIdentFunc(translationContext, node);
        XcType xcType = xcIdent.getType();
        if (!XcTypeEnum.FUNC.equals((Object)xcType.getTypeEnum())) {
            throw new XmTranslationException(node, "symbol '" + xcIdent.getSymbol() + "' is not function type");
        }
        XcFuncType xcFuncType = (XcFuncType)xcType;
        XcParamList xcParamList = xcFuncType.getParamList();
        ArrayList arrayList = null;
        if (node2 != null) {
            arrayList = XmDomUtil.collectElements((Node)node2, (String[])new String[]{"name"});
        }
        if (!xcParamList.isEmpty()) {
            int n;
            int n2 = n = arrayList != null ? arrayList.size() : 0;
            if (!xcParamList.isVoid() && n != xcParamList.size()) {
                throw new XmTranslationException(node2, "parameter type is not applicable as function '" + xcType.getTypeId() + "'");
            }
        } else {
            xcFuncType = xcFuncType.copy();
            xcIdent.setType(xcFuncType);
            for (Node node3 : arrayList) {
                String string = XmStringUtil.trim((String)this.getType(node3));
                XmcXcodeToXcTranslator._ensureAttr(node3, string, "type");
                String string2 = this._getContent(node3);
                XcIdent xcIdent2 = new XcIdent(string2);
                xcIdent2.setTempTypeId(string);
                xcFuncType.addParam(xcIdent2);
            }
            try {
                xcFuncType.getParamList().resolve(translationContext.identTableStack);
            }
            catch (XmException xmException) {
                throw new XmTranslationException(node, (Throwable)xmException);
            }
        }
        return xcIdent;
    }

    XcIdent _getIdentEnumerator(TranslationContext translationContext, Node node, String string, String string2) {
        XcEnumType xcEnumType;
        try {
            xcEnumType = (XcEnumType)translationContext.identTableStack.getTypeAs(XcTypeEnum.ENUM, string);
        }
        catch (XmException xmException) {
            throw new XmTranslationException(node, (Throwable)xmException);
        }
        XcIdent xcIdent = xcEnumType.getEnumerator(string2);
        if (xcIdent == null) {
            throw new XmTranslationException(node, "enum type '" + string + "' does not have enumerator '" + string2 + "'");
        }
        return xcIdent;
    }

    String _getChildTypeIdMember(Node node) {
        Node node2 = XmDomUtil.getContent((Node)node);
        if (node2 == null) {
            throw new XmTranslationException(node, "no composite type is specified");
        }
        return this.getType(node2);
    }

    XcIdent _getIdentCompositeTypeMember(TranslationContext translationContext, Node node) {
        XcType xcType;
        String string = this._getChildTypeIdMember(node);
        String string2 = XmDomUtil.getAttr((Node)node, (String)"member");
        XmcXcodeToXcTranslator._ensureAttr(node, string, "type");
        XmcXcodeToXcTranslator._ensureAttr(node, string2, "member");
        try {
            XcType xcType2 = translationContext.identTableStack.getType(string).getRealType();
            xcType = xcType2.getRefType().getRealType();
        }
        catch (XmException xmException) {
            throw new XmTranslationException(node, (Throwable)xmException);
        }
        if (!(xcType instanceof XcCompositeType)) {
            throw new XmTranslationException(node, "type '" + string + "' is not struct/union pointer type");
        }
        XcCompositeType xcCompositeType = (XcCompositeType)xcType;
        XcIdent xcIdent = xcCompositeType.getMember(string2);
        if (xcIdent == null) {
            throw new XmTranslationException(node, "symbol '" + string2 + "' is not a member of type '" + xcCompositeType.getTypeId() + "'");
        }
        return xcIdent;
    }

    XcExprObj _shiftUpCoArray(XcOperatorObj xcOperatorObj) {
        if (xcOperatorObj.getOperatorEnum() != XcOperatorEnum.PLUS) {
            return xcOperatorObj;
        }
        XcExprObj[] xcExprObjArray = xcOperatorObj.getExprObjs();
        if (!(xcExprObjArray[0] instanceof XcXmpCoArrayRefObj)) {
            return xcOperatorObj;
        }
        XcXmpCoArrayRefObj xcXmpCoArrayRefObj = (XcXmpCoArrayRefObj)xcExprObjArray[0];
        XcType xcType = xcXmpCoArrayRefObj.getElementType().getRealType();
        if (!(xcType.getTypeEnum() == XcTypeEnum.ARRAY)) {
            return xcOperatorObj;
        }
        XcArrayType xcArrayType = (XcArrayType)xcType;
        XcPointerType xcPointerType = new XcPointerType("XMPP", xcArrayType.getRefType());
        xcXmpCoArrayRefObj.turnOver(xcOperatorObj, xcPointerType);
        return xcXmpCoArrayRefObj;
    }

    XcExprObj _shiftUpCoArray(TranslationContext translationContext, XcRefObj xcRefObj, Node node) {
        XcExprObj xcExprObj = xcRefObj.getExpr();
        if (!(xcExprObj instanceof XcXmpCoArrayRefObj)) {
            return xcRefObj;
        }
        XcXmpCoArrayRefObj xcXmpCoArrayRefObj = (XcXmpCoArrayRefObj)xcExprObj;
        String string = this.getType(node);
        XcType xcType = null;
        try {
            xcType = translationContext.identTableStack.getType(string);
        }
        catch (XmException xmException) {
            throw new XmTranslationException(node, "type " + string + "is not found ");
        }
        xcXmpCoArrayRefObj.turnOver(xcRefObj, xcType);
        return xcXmpCoArrayRefObj;
    }

    void _enterUnaryExpr(TranslationContext translationContext, Node node, XcNode xcNode, XcOperatorEnum xcOperatorEnum) {
        XcOperatorObj xcOperatorObj = new XcOperatorObj(xcOperatorEnum);
        this.addChild(xcNode, xcOperatorObj);
        this.enterNodes(translationContext, (XcNode)xcOperatorObj, XmDomUtil.getContent((Node)node));
    }

    void _enterBinaryExpr(TranslationContext translationContext, Node node, XcNode xcNode, XcOperatorEnum xcOperatorEnum) {
        XcOperatorObj xcOperatorObj = new XcOperatorObj(xcOperatorEnum);
        this.transChildren(translationContext, node, xcOperatorObj);
        XcExprObj xcExprObj = this._shiftUpCoArray(xcOperatorObj);
        this.addChild(xcNode, xcExprObj);
    }

    XcNode _enterVar(TranslationContext translationContext, Node node, XcNode xcNode) {
        XcIdent xcIdent = this._getIdent(translationContext, XcSymbolKindEnum.VAR, node);
        this.addChild(xcNode, xcIdent);
        return xcIdent;
    }

    void _enterSymbolAddr(TranslationContext translationContext, Node node, XcNode xcNode) {
        XcIdent xcIdent = this._getIdentVarOrFunc(translationContext, node);
        XcRefObj.Addr addr = new XcRefObj.Addr(xcIdent);
        this.addChild(xcNode, addr);
    }

    void _enterExprOrType(TranslationContext translationContext, Node node, XcNode xcNode, XcOperatorEnum xcOperatorEnum) {
        Node node2 = XmDomUtil.getContent((Node)node);
        if ("typeName".equals(node2.getNodeName())) {
            XcType xcType = null;
            try {
                xcType = translationContext.identTableStack.getType(this.getType(node2));
            }
            catch (XmException xmException) {
                throw new XmTranslationException(node, (Throwable)xmException);
            }
            XcSizeOfExprObj xcSizeOfExprObj = new XcSizeOfExprObj(xcOperatorEnum, xcType);
            if (xcType instanceof XcLazyEvalType) {
                XmcXcodeToXcLazyVisitor xmcXcodeToXcLazyVisitor = new XmcXcodeToXcLazyVisitor(translationContext);
                xmcXcodeToXcLazyVisitor.lazyEnter((XcLazyEvalType)((Object)xcType));
                ((XcLazyEvalType)((Object)xcType)).setIsLazyEvalType(false);
            }
            this.addChild(xcNode, xcSizeOfExprObj);
        } else {
            XcOperatorObj xcOperatorObj = new XcOperatorObj(xcOperatorEnum);
            this.addChild(xcNode, xcOperatorObj);
            this.enterNodes(translationContext, (XcNode)xcOperatorObj, node2);
        }
    }

    void enterCompoundValue(TranslationContext translationContext, Node node, XcNode xcNode) {
        XcCompoundValueObj xcCompoundValueObj = new XcCompoundValueObj();
        this.addChild(xcNode, xcCompoundValueObj);
        this.transChildren(translationContext, node, xcCompoundValueObj);
    }

    void enterArrayRef(TranslationContext translationContext, Node node, XcNode xcNode) {
        ArrayList arrayList = XmDomUtil.collectChildNodes((Node)node);
        Node node2 = (Node)arrayList.remove(0);
        String string = node2.getNodeName();
        XcIdent xcIdent = null;
        XcObj xcObj = null;
        if (string.equals("arrayAddr") || string.equals("Var")) {
            xcIdent = this._getIdent(translationContext, XcSymbolKindEnum.VAR, node2);
            xcObj = new XcVarObj(xcIdent);
        } else if (string.equals("memberArrayRef")) {
            xcIdent = this._getIdentCompositeTypeMember(translationContext, node2);
            xcObj = new XcRefObj.MemberRef(xcIdent);
            this.enterNodes(translationContext, (XcNode)xcObj, XmDomUtil.getContent((Node)node2));
        } else if (string.equals("functionCall")) {
            xcIdent = this._getIdentFunc(translationContext, node2);
            xcObj = new XcFuncCallObj();
            this.enterNodes(translationContext, (XcNode)xcObj, XmDomUtil.getContent((Node)node2));
        } else {
            throw new XmTranslationException(node, "Invalid arrayRef: arrayAddr not found.");
        }
        if (xcNode instanceof XcArrayRefObj) {
            XcArrayRefObj xcArrayRefObj = (XcArrayRefObj)xcNode;
            xcArrayRefObj.setType(xcIdent.getType());
            xcArrayRefObj.setElementType(xcIdent.getType().getRefType());
            xcArrayRefObj.setArrayAddr((XcExprObj)((Object)xcObj));
        } else if (xcNode instanceof XcXmpSubArrayRefObj) {
            XcXmpSubArrayRefObj xcXmpSubArrayRefObj = (XcXmpSubArrayRefObj)xcNode;
            xcXmpSubArrayRefObj.setType(xcIdent.getType());
            xcXmpSubArrayRefObj.setElementType(xcIdent.getType().getRefType());
            xcXmpSubArrayRefObj.setArrayAddr((XcExprObj)((Object)xcObj));
        } else if (xcNode instanceof XcXmpSubArrayRefObj) {
            XcXmpSubArrayRefObj xcXmpSubArrayRefObj = (XcXmpSubArrayRefObj)xcNode;
            xcXmpSubArrayRefObj.setType(xcIdent.getType());
            xcXmpSubArrayRefObj.setElementType(xcIdent.getType().getRefType());
            xcXmpSubArrayRefObj.setArrayAddr((XcExprObj)((Object)xcObj));
        } else {
            throw new XmTranslationException(node, "Unknown ArrayRef object");
        }
        this.transChildren(translationContext, xcNode, arrayList);
    }

    void createVisitorMap(Pair[] pairArray) {
        this.visitorMap = new HashMap<String, XcodeNodeVisitor>();
        for (Pair pair : pairArray) {
            this.visitorMap.put(pair.codeName, pair.visitor);
        }
    }

    static class Pair {
        public String codeName;
        public XcodeNodeVisitor visitor;

        public Pair(String string, XcodeNodeVisitor xcodeNodeVisitor) {
            this.codeName = string;
            this.visitor = xcodeNodeVisitor;
        }
    }

    static class TranslationContext {
        public XcIdentTableStack identTableStack;
        public ScopeEnum scopeEnum;
        Stack<XcNode> parentNodeStack;

        public TranslationContext(XcIdentTableStack xcIdentTableStack, ScopeEnum scopeEnum) {
            this.identTableStack = xcIdentTableStack;
            this.scopeEnum = scopeEnum;
            this.parentNodeStack = new Stack();
        }

        public void pushParentNode(XcNode xcNode) {
            this.parentNodeStack.push(xcNode);
        }

        public XcNode popParentNode() {
            return this.parentNodeStack.pop();
        }
    }

    class XmcXcodeToXcLazyVisitor
    implements XcLazyVisitor {
        private TranslationContext tc;

        public XmcXcodeToXcLazyVisitor(TranslationContext translationContext) {
            this.tc = translationContext;
        }

        @Override
        public void lazyEnter(XcLazyEvalType xcLazyEvalType) {
            if (!xcLazyEvalType.isLazyEvalType()) {
                return;
            }
            XmcVarCollector xmcVarCollector = new XmcVarCollector(xcLazyEvalType.getDependVar());
            for (Node node : xcLazyEvalType.getLazyBindingNodes()) {
                xmcVarCollector.collectVars(node);
            }
            XmcXcodeToXcTranslator.this.enterNodes(this.tc, (XcNode)((Object)xcLazyEvalType), xcLazyEvalType.getLazyBindingNodes());
            xcLazyEvalType.setIsLazyEvalType(false);
        }

        @Override
        public void pushParamListIdentTable(XcParamList xcParamList) {
            XcIdentTable xcIdentTable = this.tc.identTableStack.push();
            for (XcIdent xcIdent : xcParamList) {
                xcIdentTable.add(XcIdentTableEnum.MAIN, xcIdent);
            }
        }

        @Override
        public void popIdentTable() {
            this.tc.identTableStack.pop();
        }
    }

    class StepBoundVisitor
    extends XcodeNodeVisitor {
        StepBoundVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this.enterNodesWithNull(translationContext, xcNode, XmDomUtil.getContent((Node)node));
        }
    }

    class LengthVisitor
    extends XcodeNodeVisitor {
        LengthVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this.enterNodesWithNull(translationContext, xcNode, XmDomUtil.getContent((Node)node));
        }
    }

    class BaseVisitor
    extends XcodeNodeVisitor {
        BaseVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this.enterNodesWithNull(translationContext, xcNode, XmDomUtil.getContent((Node)node));
        }
    }

    class IndexRangeVisitor
    extends XcodeNodeVisitor {
        IndexRangeVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcIndexRangeObj xcIndexRangeObj = new XcIndexRangeObj();
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcIndexRangeObj);
            XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcIndexRangeObj, XmDomUtil.getElement((Node)node, (String)"base"), XmDomUtil.getElement((Node)node, (String)"length"), XmDomUtil.getElement((Node)node, (String)"step"));
        }
    }

    class SubArrayRefVisitor
    extends XcodeNodeVisitor {
        SubArrayRefVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcXmpSubArrayRefObj xcXmpSubArrayRefObj = new XcXmpSubArrayRefObj();
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcXmpSubArrayRefObj);
            XmcXcodeToXcTranslator.this.enterArrayRef(translationContext, node, xcXmpSubArrayRefObj);
        }
    }

    class CoArrayTypeVisitor
    extends XcodeNodeVisitor {
        CoArrayTypeVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            String string = XmStringUtil.trim((String)XmcXcodeToXcTranslator.this.getType(node));
            XmcXcodeToXcTranslator._ensureAttr(node, string, "type");
            XcXmpCoArrayType xcXmpCoArrayType = new XcXmpCoArrayType(string);
            XmcXcodeToXcTranslator.this._enterArrayType(translationContext, xcXmpCoArrayType, node);
        }
    }

    class CoArrayRefVisitor
    extends XcodeNodeVisitor {
        CoArrayRefVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcXmpCoArrayRefObj xcXmpCoArrayRefObj = new XcXmpCoArrayRefObj();
            ArrayList arrayList = XmDomUtil.collectChildNodes((Node)node);
            Node node2 = (Node)arrayList.remove(0);
            String string = node2.getNodeName();
            if (string.equals("Var")) {
                XcIdent xcIdent = XmcXcodeToXcTranslator.this._getIdent(translationContext, XcSymbolKindEnum.VAR, node2);
                XcVarObj xcVarObj = new XcVarObj(xcIdent);
                xcXmpCoArrayRefObj.setType(xcIdent.getType());
                xcXmpCoArrayRefObj.setElementType(xcIdent.getType().getRefType());
                xcXmpCoArrayRefObj.setContent(xcVarObj);
            } else if (string.equals("arrayRef")) {
                XcArrayRefObj xcArrayRefObj = new XcArrayRefObj();
                XmcXcodeToXcTranslator.this.enterArrayRef(translationContext, node2, xcArrayRefObj);
            } else if (string.equals("subArrayRef")) {
                XcXmpSubArrayRefObj xcXmpSubArrayRefObj = new XcXmpSubArrayRefObj();
                XmcXcodeToXcTranslator.this.enterArrayRef(translationContext, node2, xcXmpSubArrayRefObj);
            } else if (string.equals("memberRef")) {
                XcIdent xcIdent = XmcXcodeToXcTranslator.this._getIdentCompositeTypeMember(translationContext, node2);
                XcRefObj.MemberRef memberRef = new XcRefObj.MemberRef(xcIdent);
                XmcXcodeToXcTranslator.this.addChild(xcNode, memberRef);
                XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)memberRef, XmDomUtil.getContent((Node)node2));
                xcXmpCoArrayRefObj.setType(xcIdent.getType());
                xcXmpCoArrayRefObj.setElementType(xcIdent.getType().getRefType());
                xcXmpCoArrayRefObj.setContent(memberRef);
            } else {
                throw new XmTranslationException(node, "content must be either Var, ArrayRef, SubArrayRef, or MemberRef.");
            }
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcXmpCoArrayRefObj);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, xcNode, arrayList);
        }
    }

    class CompoundValueAddrExprVisitor
    extends XcodeNodeVisitor {
        CompoundValueAddrExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcType xcType;
            String string = XmcXcodeToXcTranslator.this.getType(node);
            XmcXcodeToXcTranslator._ensureAttr(node, string, "type");
            try {
                xcType = translationContext.identTableStack.getType(string);
            }
            catch (XmException xmException) {
                throw new XmTranslationException(node, (Throwable)xmException);
            }
            xcType = xcType.getRealType().getRefType();
            XcCompoundValueObj.AddrRef addrRef = new XcCompoundValueObj.AddrRef();
            addrRef.setType(xcType);
            XmcXcodeToXcTranslator.this.addChild(xcNode, addrRef);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, addrRef);
        }
    }

    class CompoundValueExprVisitor
    extends XcodeNodeVisitor {
        CompoundValueExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcType xcType;
            String string = XmcXcodeToXcTranslator.this.getType(node);
            XmcXcodeToXcTranslator._ensureAttr(node, string, "type");
            try {
                xcType = translationContext.identTableStack.getType(string);
            }
            catch (XmException xmException) {
                throw new XmTranslationException(node, (Throwable)xmException);
            }
            XcCompoundValueObj.Ref ref = new XcCompoundValueObj.Ref();
            ref.setType(xcType);
            XmcXcodeToXcTranslator.this.addChild(xcNode, ref);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, ref);
        }
    }

    class CompoundValueVisitor
    extends XcodeNodeVisitor {
        CompoundValueVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this.enterCompoundValue(translationContext, node, xcNode);
        }
    }

    class GccCompoundExprVisitor
    extends XcodeNodeVisitor {
        GccCompoundExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcGccCompoundExprObj xcGccCompoundExprObj = new XcGccCompoundExprObj();
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcGccCompoundExprObj);
            xcGccCompoundExprObj.setIsGccExtension(XmDomUtil.getAttrBool((Node)node, (String)"is_gccExtension"));
            XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcGccCompoundExprObj, XmDomUtil.getElement((Node)node, (String)"compoundStatement"));
        }
    }

    class GccRangedCaseLabelVisitor
    extends XcodeNodeVisitor {
        GccRangedCaseLabelVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcControlStmtObj.GccRangedCaseLabel gccRangedCaseLabel = new XcControlStmtObj.GccRangedCaseLabel();
            XmcXcodeToXcTranslator.this.setSourcePos(gccRangedCaseLabel, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, gccRangedCaseLabel);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, gccRangedCaseLabel);
        }
    }

    class GccMemberDesignatorVisitor
    extends XcodeNodeVisitor {
        GccMemberDesignatorVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcMemberDesignator xcMemberDesignator = new XcMemberDesignator();
            String string = XmDomUtil.getAttr((Node)node, (String)"ref");
            String string2 = XmDomUtil.getAttr((Node)node, (String)"member");
            XcType xcType = null;
            try {
                xcType = translationContext.identTableStack.getType(string);
            }
            catch (XmException xmException) {
                throw new XmTranslationException(node, "type " + string + " is not found ");
            }
            if (xcType == null) {
                throw new XmTranslationException(node, "type " + string + " is not found ");
            }
            if ((xcType = translationContext.identTableStack.getRealType(xcType)) instanceof XcCompositeType && string2 != null) {
                XcCompositeType xcCompositeType = (XcCompositeType)xcType;
                XcIdent xcIdent = xcCompositeType.getMember(string2);
                if (xcIdent == null) {
                    throw new XmTranslationException(node, "symbol '" + string2 + "' is not a member of type '" + xcCompositeType.getTypeId() + "'");
                }
                xcMemberDesignator.setMember(string2);
            }
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcMemberDesignator);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcMemberDesignator);
        }
    }

    class TypeNameVisitor
    extends XcodeNodeVisitor {
        TypeNameVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            String string = XmcXcodeToXcTranslator.this.getType(node);
            try {
                XcType xcType = translationContext.identTableStack.getType(string);
                XmcXcodeToXcTranslator.this.addChild(xcNode, xcType);
            }
            catch (XmException xmException) {
                throw new XmTranslationException(node, "type " + string + "is not found ");
            }
        }
    }

    class BuiltinOpoVisitor
    extends XcodeNodeVisitor {
        BuiltinOpoVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcBltInOpObj xcBltInOpObj = new XcBltInOpObj();
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcBltInOpObj);
            String string = XmDomUtil.getAttr((Node)node, (String)"name");
            XmcXcodeToXcTranslator._ensureAttr(node, string, "name");
            xcBltInOpObj.setName(string);
            xcBltInOpObj.setIsId(XmDomUtil.getAttrBool((Node)node, (String)"is_id"));
            xcBltInOpObj.setIsAddrOf(XmDomUtil.getAttrBool((Node)node, (String)"is_addrOf"));
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcBltInOpObj);
        }
    }

    class GccAsmClobbersVisitor
    extends XcodeNodeVisitor {
        GccAsmClobbersVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcNode);
        }
    }

    class GccAsmOperandsVisitor
    extends XcodeNodeVisitor {
        GccAsmOperandsVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcNode);
        }
    }

    class GccAsmOperandVisitor
    extends XcodeNodeVisitor {
        GccAsmOperandVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcOperandObj xcOperandObj = new XcOperandObj();
            xcOperandObj.setMatch(XmDomUtil.getAttr((Node)node, (String)"match"));
            xcOperandObj.setConstraint(XmDomUtil.getAttr((Node)node, (String)"constraint"));
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcOperandObj);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcOperandObj);
        }
    }

    class GccAsmStatementVisitor
    extends XcodeNodeVisitor {
        GccAsmStatementVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcGccAsmStmtObj xcGccAsmStmtObj = new XcGccAsmStmtObj();
            XmcXcodeToXcTranslator.this.setSourcePos(xcGccAsmStmtObj, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcGccAsmStmtObj);
            Node node2 = XmDomUtil.getElement((Node)node, (String)"stringConstant");
            if (node2 == null) {
                throw new XmTranslationException(node, "content is empty");
            }
            xcGccAsmStmtObj.setAsmCode(new XcConstObj.StringConst(XmDomUtil.getContentText((Node)node2)));
            xcGccAsmStmtObj.setIsVolatile(XmDomUtil.getAttrBool((Node)node, (String)"is_volatile"));
            ArrayList arrayList = XmDomUtil.collectElements((Node)node, (String[])new String[]{"gccAsmOperands"});
            if (arrayList.get(0) != null) {
                xcGccAsmStmtObj.initInputOperands();
                XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcGccAsmStmtObj, (Node)arrayList.get(0));
                xcGccAsmStmtObj.setInputOperandsEnd();
            }
            if (arrayList.size() >= 2 && arrayList.get(1) != null) {
                xcGccAsmStmtObj.initOutputOperands();
                XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcGccAsmStmtObj, (Node)arrayList.get(1));
            }
            XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcGccAsmStmtObj, XmDomUtil.getElement((Node)node, (String)"gccAsmClobbers"));
        }
    }

    class TextVisitor
    extends XcodeNodeVisitor {
        TextVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcDirectiveObj xcDirectiveObj = new XcDirectiveObj();
            xcDirectiveObj.setLine(XmDomUtil.getContentText((Node)node));
            XmcXcodeToXcTranslator.this.setSourcePos(xcDirectiveObj, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcDirectiveObj);
        }
    }

    class ACCPragmaVisitor
    extends XcodeNodeVisitor {
        ACCPragmaVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            Object object;
            Object object2;
            XcDirectiveObj xcDirectiveObj = new XcDirectiveObj();
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcDirectiveObj);
            Node node2 = node.getFirstChild();
            String string = XmDomUtil.getContentText((Node)node2).toLowerCase();
            if (string.equals("parallel_loop")) {
                string = "parallel loop";
            } else if (string.equals("kernels_loop")) {
                string = "kernels loop";
            } else if (string.equals("enter_data")) {
                string = "enter data";
            } else if (string.equals("exit_data")) {
                string = "exit data";
            }
            xcDirectiveObj.setLine("#pragma acc " + string);
            if (string.equals("wait")) {
                Node node3 = node2.getNextSibling();
                if (!node3.getNodeName().equals("list")) {
                    xcDirectiveObj.addToken("(");
                    this.enterIntExprNode(translationContext, xcDirectiveObj, node3);
                    xcDirectiveObj.addToken(")");
                }
                return;
            }
            if (string.equals("cache")) {
                NodeList nodeList = node2.getNextSibling().getChildNodes();
                xcDirectiveObj.addToken("(");
                this.enterVarListNode(translationContext, xcDirectiveObj, nodeList);
                xcDirectiveObj.addToken(")");
                return;
            }
            if (string.equals("host_data use_device")) {
                NodeList nodeList = node2.getNextSibling().getChildNodes();
                xcDirectiveObj.addToken("(");
                this.enterVarListNode(translationContext, xcDirectiveObj, nodeList);
                xcDirectiveObj.addToken(")");
                Node node4 = node2.getNextSibling();
                Node node5 = node4.getNextSibling();
                NodeList nodeList2 = node5.getChildNodes();
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    Node node6 = nodeList2.item(i);
                    if (node6.getNodeType() != 1) continue;
                    XmcXcodeToXcTranslator.this.enterNodes(translationContext, xcNode, node6);
                }
                return;
            }
            Node node7 = node2.getNextSibling();
            NodeList nodeList = node7.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object2 = nodeList.item(i);
                if (object2.getNodeType() != 1) continue;
                Node node8 = object2.getFirstChild();
                object = XmDomUtil.getContentText((Node)node8).toLowerCase();
                String string2 = "";
                if (((String)object).equals("dev_resident")) {
                    object = "device_resident";
                } else if (((String)object).equals("vect_len")) {
                    object = "vector_length";
                } else if (((String)object).equals("routine_arg")) {
                    object = "";
                } else if (((String)object).equals("reduction_plus")) {
                    object = "reduction";
                    string2 = "+";
                } else if (((String)object).equals("reduction_mul")) {
                    object = "reduction";
                    string2 = "*";
                } else if (((String)object).equals("reduction_bitand")) {
                    object = "reduction";
                    string2 = "&";
                } else if (((String)object).equals("reduction_bitor")) {
                    object = "reduction";
                    string2 = "|";
                } else if (((String)object).equals("reduction_bitxor")) {
                    object = "reduction";
                    string2 = "^";
                } else if (((String)object).equals("reduction_logand")) {
                    object = "reduction";
                    string2 = "&&";
                } else if (((String)object).equals("reduction_logor")) {
                    object = "reduction";
                    string2 = "||";
                } else if (((String)object).equals("reduction_min")) {
                    object = "reduction";
                    string2 = "min";
                } else if (((String)object).equals("reduction_max")) {
                    object = "reduction";
                    string2 = "max";
                }
                xcDirectiveObj.addToken((String)object);
                Node node9 = object2.getFirstChild().getNextSibling();
                if (node9 == null) continue;
                xcDirectiveObj.addToken("(");
                if (string2 != "") {
                    xcDirectiveObj.addToken(string2 + " :");
                }
                if (!node9.getNodeName().equals("list")) {
                    XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcDirectiveObj, node9);
                } else {
                    NodeList nodeList3 = node9.getChildNodes();
                    this.enterVarListNode(translationContext, xcDirectiveObj, nodeList3);
                }
                xcDirectiveObj.addToken(")");
            }
            Node node10 = node7.getNextSibling();
            object2 = node10.getChildNodes();
            for (int i = 0; i < object2.getLength(); ++i) {
                object = object2.item(i);
                if (object.getNodeType() != 1) continue;
                XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcDirectiveObj, new Node[]{object});
            }
        }

        private void enterVarListNode(TranslationContext translationContext, XcDirectiveObj xcDirectiveObj, NodeList nodeList) {
            this.enterVarNode(translationContext, xcDirectiveObj, nodeList.item(0));
            for (int i = 1; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                xcDirectiveObj.addToken(",");
                this.enterVarNode(translationContext, xcDirectiveObj, node);
            }
        }

        private void enterIntExprNode(TranslationContext translationContext, XcDirectiveObj xcDirectiveObj, Node node) {
            String string = XmDomUtil.getContentText((Node)node);
            xcDirectiveObj.addToken(string);
        }

        private void enterVarNode(TranslationContext translationContext, XcDirectiveObj xcDirectiveObj, Node node) {
            if (node.getNodeName().equals("list")) {
                String string = "";
                NodeList nodeList = node.getChildNodes();
                XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcDirectiveObj, nodeList.item(0));
                for (int i = 1; i < nodeList.getLength(); ++i) {
                    Node node2 = nodeList.item(i);
                    String string2 = "";
                    xcDirectiveObj.addToken("[");
                    if (node2.getNodeName().equals("list")) {
                        NodeList nodeList2 = node2.getChildNodes();
                        XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcDirectiveObj, nodeList2.item(0));
                        xcDirectiveObj.addToken(":");
                        String string3 = "";
                        if (nodeList2.item(1) != null) {
                            XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcDirectiveObj, nodeList2.item(1));
                        }
                    } else {
                        XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcDirectiveObj, nodeList.item(i));
                    }
                    xcDirectiveObj.addToken("]");
                }
                xcDirectiveObj.addToken(string);
            } else {
                XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcDirectiveObj, node);
            }
        }
    }

    class OMPPragmaVisitor
    extends XcodeNodeVisitor {
        OMPPragmaVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            Object object;
            Object object2;
            XcDirectiveObj xcDirectiveObj = new XcDirectiveObj();
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcDirectiveObj);
            Node node2 = node.getFirstChild();
            String string = XmDomUtil.getContentText((Node)node2).toLowerCase();
            if (string.equals("parallel_for")) {
                string = "parallel for";
            }
            xcDirectiveObj.setLine("#pragma omp " + string);
            if (string.equals("barrier")) {
                return;
            }
            if (string.equals("threadprivate")) {
                xcDirectiveObj.addToken("(");
                NodeList nodeList = node2.getNextSibling().getChildNodes();
                XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcDirectiveObj, nodeList.item(0));
                for (int i = 1; i < nodeList.getLength(); ++i) {
                    Node node3 = nodeList.item(i);
                    xcDirectiveObj.addToken(",");
                    XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcDirectiveObj, node3);
                }
                xcDirectiveObj.addToken(")");
                return;
            }
            Node node4 = node2.getNextSibling();
            NodeList nodeList = node4.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string2;
                Object object3;
                object2 = nodeList.item(i);
                if (object2.getNodeType() != 1) continue;
                String string3 = XmDomUtil.getContentText((Node)object2).toLowerCase();
                object = "";
                if (string3.equals("data_default")) {
                    string3 = "default";
                } else if (string3.equals("data_private")) {
                    string3 = "private";
                } else if (string3.equals("data_shared")) {
                    string3 = "shared";
                } else if (string3.equals("data_firstprivate")) {
                    string3 = "firstprivate";
                } else if (string3.equals("data_lastprivate")) {
                    string3 = "lastprivate";
                } else if (string3.equals("data_copyin")) {
                    string3 = "copyin";
                } else if (string3.equals("data_reduction_plus")) {
                    string3 = "reduction";
                    object = "+";
                } else if (string3.equals("data_reduction_minus")) {
                    string3 = "reduction";
                    object = "-";
                } else if (string3.equals("data_reduction_mul")) {
                    string3 = "reduction";
                    object = "*";
                } else if (string3.equals("data_reduction_bitand")) {
                    string3 = "reduction";
                    object = "iand";
                } else if (string3.equals("data_reduction_bitor")) {
                    string3 = "reduction";
                    object = "ior";
                } else if (string3.equals("data_reduction_bitxor")) {
                    string3 = "reduction";
                    object = "ieor";
                } else if (string3.equals("data_reduction_logand")) {
                    string3 = "reduction";
                    object = ".and.";
                } else if (string3.equals("data_reduction_logor")) {
                    string3 = "reduction";
                    object = ".or.";
                } else if (string3.equals("data_reduction_min")) {
                    string3 = "reduction";
                    object = "min";
                } else if (string3.equals("data_reduction_max")) {
                    string3 = "reduction";
                    object = "max";
                } else if (string3.equals("data_reduction_eqv")) {
                    string3 = "reduction";
                    object = ".eqv.";
                } else if (string3.equals("data_reduction_neqv")) {
                    string3 = "reduction";
                    object = ".neqv.";
                } else if (string3.equals("dir_ordered")) {
                    string3 = "ordered";
                } else if (string3.equals("dir_if")) {
                    string3 = "if";
                } else if (string3.equals("dir_nowait")) {
                    string3 = "nowait";
                } else if (string3.equals("dir_schedule")) {
                    string3 = "schedule";
                } else if (string3.equals("dir_num_threads")) {
                    string3 = "num_threads";
                }
                xcDirectiveObj.addToken(string3);
                Node node5 = object2.getFirstChild().getNextSibling();
                if (node5 == null) continue;
                xcDirectiveObj.addToken("(");
                if (object != "") {
                    xcDirectiveObj.addToken((String)object + " :");
                }
                if (!node5.getNodeName().equals("list")) {
                    object3 = XmDomUtil.getContentText((Node)node5);
                    if (string3.equals("if") || string3.equals("num_threads")) {
                        xcDirectiveObj.addToken((String)object3);
                    } else {
                        string2 = ((String)object3).toLowerCase();
                        if (string2.equals("default_shared")) {
                            string2 = "shared";
                        } else if (string2.equals("default_none")) {
                            string2 = "none";
                        }
                        xcDirectiveObj.addToken(string2);
                    }
                } else {
                    object3 = node5.getChildNodes();
                    string2 = XmDomUtil.getContentText((Node)object3.item(0)).toLowerCase();
                    if (string2.equals("sched_static")) {
                        xcDirectiveObj.addToken("static");
                    } else if (string2.equals("sched_dynamic")) {
                        xcDirectiveObj.addToken("static");
                    } else if (string2.equals("sched_guided")) {
                        xcDirectiveObj.addToken("guided");
                    } else if (string2.equals("sched_auto")) {
                        xcDirectiveObj.addToken("auto");
                    } else if (string2.equals("sched_runtime")) {
                        xcDirectiveObj.addToken("runtime");
                    } else {
                        XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcDirectiveObj, object3.item(0));
                    }
                    for (int j = 1; j < object3.getLength(); ++j) {
                        Node node6 = object3.item(j);
                        xcDirectiveObj.addToken(",");
                        XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcDirectiveObj, node6);
                    }
                }
                xcDirectiveObj.addToken(")");
            }
            Node node7 = node4.getNextSibling();
            object2 = node7.getChildNodes();
            for (int i = 0; i < object2.getLength(); ++i) {
                object = object2.item(i);
                if (object.getNodeType() != 1) continue;
                XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcDirectiveObj, new Node[]{object});
            }
        }
    }

    class LinemarkerVisitor
    extends XcodeNodeVisitor {
        LinemarkerVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcDirectiveObj xcDirectiveObj = new XcDirectiveObj(true);
            String string = XmDomUtil.getAttr((Node)node, (String)"lineno");
            String string2 = XmDomUtil.getAttr((Node)node, (String)"file");
            String string3 = XmDomUtil.getAttr((Node)node, (String)"flag");
            xcDirectiveObj.setLine("# " + string + " \"" + string2 + "\" " + string3);
            XmcXcodeToXcTranslator.this.setSourcePos(xcDirectiveObj, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcDirectiveObj);
        }
    }

    class PragmaVisitor
    extends XcodeNodeVisitor {
        PragmaVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcDirectiveObj xcDirectiveObj = new XcDirectiveObj();
            xcDirectiveObj.setLine("#pragma " + XmDomUtil.getContentText((Node)node));
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcDirectiveObj);
        }
    }

    class GccAsmDefinitionVisitor
    extends XcodeNodeVisitor {
        GccAsmDefinitionVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcGccAsmDefinition xcGccAsmDefinition = new XcGccAsmDefinition();
            xcGccAsmDefinition.setIsGccExtension(XmDomUtil.getAttrBool((Node)node, (String)"is_gccExtension"));
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcGccAsmDefinition);
            XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcGccAsmDefinition, XmDomUtil.getElement((Node)node, (String)"stringConstant"));
        }
    }

    class GccLabelAddrVisitor
    extends XcodeNodeVisitor {
        GccLabelAddrVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcOperatorObj xcOperatorObj = new XcOperatorObj();
            xcOperatorObj.getClass();
            XcOperatorObj.LabelAddrExpr labelAddrExpr = xcOperatorObj.new XcOperatorObj.LabelAddrExpr(XmDomUtil.getContentText((Node)node));
            XmcXcodeToXcTranslator.this.addChild(xcNode, labelAddrExpr);
        }
    }

    class XmpDescOfVisitor
    extends XcodeNodeVisitor {
        XmpDescOfVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcOperatorObj xcOperatorObj = new XcOperatorObj(XcOperatorEnum.XMPDESCOF);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcOperatorObj);
        }
    }

    class GccAlignOfExprVisitor
    extends XcodeNodeVisitor {
        GccAlignOfExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterExprOrType(translationContext, node, xcNode, XcOperatorEnum.ALIGNOF);
        }
    }

    class AddrOfExprVisitor
    extends XcodeNodeVisitor {
        AddrOfExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcOperatorObj xcOperatorObj = new XcOperatorObj(XcOperatorEnum.ADDROF);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcOperatorObj);
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcOperatorObj);
        }
    }

    class SizeOfExprVisitor
    extends XcodeNodeVisitor {
        SizeOfExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterExprOrType(translationContext, node, xcNode, XcOperatorEnum.SIZEOF);
        }
    }

    class ArgumentsVisitor
    extends XcodeNodeVisitor {
        ArgumentsVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcNode);
        }
    }

    class FunctionVisitor
    extends XcodeNodeVisitor {
        FunctionVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcNode);
        }
    }

    class FunctionCallVisitor
    extends XcodeNodeVisitor {
        FunctionCallVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcFuncCallObj xcFuncCallObj = new XcFuncCallObj();
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcFuncCallObj);
            XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcFuncCallObj, XmDomUtil.getElement((Node)node, (String)"function"), XmDomUtil.getElement((Node)node, (String)"arguments"));
        }
    }

    class PointerRefVisitor
    extends XcodeNodeVisitor {
        PointerRefVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcRefObj.PointerRef pointerRef = new XcRefObj.PointerRef();
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, pointerRef);
            XcExprObj xcExprObj = pointerRef.getExpr();
            if (xcExprObj instanceof XcXmpCoArrayRefObj) {
                XcXmpCoArrayRefObj xcXmpCoArrayRefObj = (XcXmpCoArrayRefObj)xcExprObj;
                XcType xcType = xcXmpCoArrayRefObj.getElementType();
                if (xcType.getTypeEnum() == XcTypeEnum.POINTER) {
                    xcType = xcType.getRefType();
                    xcXmpCoArrayRefObj.turnOver(pointerRef, xcType);
                    XmcXcodeToXcTranslator.this.addChild(xcNode, xcXmpCoArrayRefObj);
                    return;
                }
                if (xcXmpCoArrayRefObj.isNeedPointerRef()) {
                    xcXmpCoArrayRefObj.unsetPointerRef();
                    XmcXcodeToXcTranslator.this.addChild(xcNode, xcXmpCoArrayRefObj);
                    return;
                }
            }
            XmcXcodeToXcTranslator.this.addChild(xcNode, pointerRef);
        }
    }

    class MemberArrayRefVisitor
    extends XcodeNodeVisitor {
        MemberArrayRefVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcIdent xcIdent = XmcXcodeToXcTranslator.this._getIdentCompositeTypeMember(translationContext, node);
            XcRefObj.MemberRef memberRef = new XcRefObj.MemberRef(xcIdent);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, memberRef);
            XcExprObj xcExprObj = XmcXcodeToXcTranslator.this._shiftUpCoArray(translationContext, memberRef, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcExprObj);
        }
    }

    class MemberArrayAddrVisitor
    extends XcodeNodeVisitor {
        MemberArrayAddrVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcIdent xcIdent = XmcXcodeToXcTranslator.this._getIdentCompositeTypeMember(translationContext, node);
            XcRefObj.MemberAddr memberAddr = new XcRefObj.MemberAddr(xcIdent);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, memberAddr);
            XcExprObj xcExprObj = XmcXcodeToXcTranslator.this._shiftUpCoArray(translationContext, memberAddr, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcExprObj);
        }
    }

    class MemberRefVisitor
    extends XcodeNodeVisitor {
        MemberRefVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcIdent xcIdent = XmcXcodeToXcTranslator.this._getIdentCompositeTypeMember(translationContext, node);
            XcRefObj.MemberRef memberRef = new XcRefObj.MemberRef(xcIdent);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, memberRef);
            XcExprObj xcExprObj = XmcXcodeToXcTranslator.this._shiftUpCoArray(translationContext, memberRef, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcExprObj);
        }
    }

    class MemberAddrVisitor
    extends XcodeNodeVisitor {
        MemberAddrVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcIdent xcIdent = XmcXcodeToXcTranslator.this._getIdentCompositeTypeMember(translationContext, node);
            XcRefObj.MemberAddr memberAddr = new XcRefObj.MemberAddr(xcIdent);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, memberAddr);
            XcExprObj xcExprObj = XmcXcodeToXcTranslator.this._shiftUpCoArray(translationContext, memberAddr, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcExprObj);
        }
    }

    class ArrayAddrVisitor
    extends XcodeNodeVisitor {
        ArrayAddrVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcIdent xcIdent = XmcXcodeToXcTranslator.this._getIdent(translationContext, XcSymbolKindEnum.VAR, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcIdent);
        }
    }

    class FuncAddrVisitor
    extends XcodeNodeVisitor {
        FuncAddrVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcIdent xcIdent = XmcXcodeToXcTranslator.this._getIdentVarOrFunc(translationContext, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcIdent);
        }
    }

    class VarAddrVisitor
    extends XcodeNodeVisitor {
        VarAddrVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterSymbolAddr(translationContext, node, xcNode);
        }
    }

    class ArrayRefVisitor
    extends XcodeNodeVisitor {
        ArrayRefVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcArrayRefObj xcArrayRefObj = new XcArrayRefObj();
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcArrayRefObj);
            XmcXcodeToXcTranslator.this.enterArrayRef(translationContext, node, xcArrayRefObj);
        }
    }

    class VarVisitor
    extends XcodeNodeVisitor {
        VarVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcIdent xcIdent = XmcXcodeToXcTranslator.this._getIdent(translationContext, XcSymbolKindEnum.VAR, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcIdent);
        }
    }

    class CastExprVisitor
    extends XcodeNodeVisitor {
        CastExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcType xcType;
            String string = XmcXcodeToXcTranslator.this.getType(node);
            XmcXcodeToXcTranslator._ensureAttr(node, string, "type");
            try {
                xcType = translationContext.identTableStack.getType(string);
            }
            catch (XmException xmException) {
                throw new XmTranslationException(node, (Throwable)xmException);
            }
            XcCastObj xcCastObj = new XcCastObj(xcType);
            xcCastObj.setIsGccExtension(XmDomUtil.getAttrBool((Node)node, (String)"is_gccExtension"));
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcCastObj);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcCastObj);
            XmcXcodeToXcLazyVisitor xmcXcodeToXcLazyVisitor = new XmcXcodeToXcLazyVisitor(translationContext);
            this.lazyEval(xcType, xmcXcodeToXcLazyVisitor);
        }

        public void lazyEval(XcType xcType, XcLazyVisitor xcLazyVisitor) {
            this._lazyEval(xcType, xcLazyVisitor);
            while (xcType instanceof XcBasicType) {
                xcType = xcType.getRefType();
            }
            switch (xcType.getTypeEnum()) {
                case STRUCT: 
                case UNION: {
                    XcCompositeType xcCompositeType = (XcCompositeType)xcType;
                    if (xcCompositeType.getMemberList() == null) break;
                    for (XcIdent xcIdent : xcCompositeType.getMemberList()) {
                        xcIdent.lazyEval(xcLazyVisitor);
                    }
                    break;
                }
                case ENUM: {
                    XcEnumType xcEnumType = (XcEnumType)xcType;
                    if (xcEnumType.getEnumeratorList() == null) break;
                    for (XcIdent xcIdent : xcEnumType.getEnumeratorList()) {
                        xcIdent.lazyEval(xcLazyVisitor);
                    }
                    break;
                }
                case FUNC: {
                    XcFuncType xcFuncType = (XcFuncType)xcType;
                    if (xcFuncType.getParamList() == null) break;
                    xcLazyVisitor.pushParamListIdentTable(xcFuncType.getParamList());
                    for (XcIdent xcIdent : xcFuncType.getParamList()) {
                        xcIdent.lazyEval(xcLazyVisitor);
                    }
                    xcLazyVisitor.popIdentTable();
                    break;
                }
            }
        }

        private void _lazyEval(XcType xcType, XcLazyVisitor xcLazyVisitor) {
            if (xcType == null || xcType instanceof XcBaseType) {
                return;
            }
            XcGccAttributeList xcGccAttributeList = xcType.getGccAttribute();
            if (xcGccAttributeList != null) {
                xcLazyVisitor.lazyEnter(xcGccAttributeList);
            }
            if (xcType instanceof XcArrayType) {
                xcLazyVisitor.lazyEnter((XcLazyEvalType)((Object)xcType));
            }
            xcType = xcType.getRefType();
            this._lazyEval(xcType, xcLazyVisitor);
        }
    }

    class CommaExprVisitor
    extends XcodeNodeVisitor {
        CommaExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            ArrayList arrayList = XmDomUtil.collectChildNodes((Node)node);
            XcOperatorObj xcOperatorObj = new XcOperatorObj(XcOperatorEnum.COMMA, new XcExprObj[arrayList.size()]);
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcOperatorObj);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcOperatorObj);
        }
    }

    class CondExprVisitor
    extends XcodeNodeVisitor {
        CondExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcOperatorObj xcOperatorObj = new XcOperatorObj(XcOperatorEnum.COND, new XcExprObj[3]);
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcOperatorObj);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcOperatorObj);
        }
    }

    class RshiftExprVisitor
    extends XcodeNodeVisitor {
        RshiftExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.RSHIFT);
        }
    }

    class PlusExprVisitor
    extends XcodeNodeVisitor {
        PlusExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.PLUS);
        }
    }

    class MinusExprVisitor
    extends XcodeNodeVisitor {
        MinusExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.MINUS);
        }
    }

    class MulExprVisitor
    extends XcodeNodeVisitor {
        MulExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.MUL);
        }
    }

    class ModExprVisitor
    extends XcodeNodeVisitor {
        ModExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.MOD);
        }
    }

    class LshiftExprVisitor
    extends XcodeNodeVisitor {
        LshiftExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.LSHIFT);
        }
    }

    class LogOrExprVisitor
    extends XcodeNodeVisitor {
        LogOrExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.LOG_OR);
        }
    }

    class LogNotExprVisitor
    extends XcodeNodeVisitor {
        LogNotExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterUnaryExpr(translationContext, node, xcNode, XcOperatorEnum.LOG_NOT);
        }
    }

    class LogNEQExprVisitor
    extends XcodeNodeVisitor {
        LogNEQExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.LOG_NEQ);
        }
    }

    class LogLTExprVisitor
    extends XcodeNodeVisitor {
        LogLTExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.LOG_LT);
        }
    }

    class LogLEExprVisitor
    extends XcodeNodeVisitor {
        LogLEExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.LOG_LE);
        }
    }

    class LogGTExprVisitor
    extends XcodeNodeVisitor {
        LogGTExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.LOG_GT);
        }
    }

    class LogGEExprVisitor
    extends XcodeNodeVisitor {
        LogGEExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.LOG_GE);
        }
    }

    class LogEQExprVisitor
    extends XcodeNodeVisitor {
        LogEQExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.LOG_EQ);
        }
    }

    class LogAndExprVisitor
    extends XcodeNodeVisitor {
        LogAndExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.LOG_AND);
        }
    }

    class DivExprVisitor
    extends XcodeNodeVisitor {
        DivExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.DIV);
        }
    }

    class BitXorExprVisitor
    extends XcodeNodeVisitor {
        BitXorExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.BIT_XOR);
        }
    }

    class BitNotExprVisitor
    extends XcodeNodeVisitor {
        BitNotExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterUnaryExpr(translationContext, node, xcNode, XcOperatorEnum.BIT_NOT);
        }
    }

    class BitOrExprVisitor
    extends XcodeNodeVisitor {
        BitOrExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.BIT_OR);
        }
    }

    class BitAndExprVisitor
    extends XcodeNodeVisitor {
        BitAndExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.BIT_AND);
        }
    }

    class AssignExprVisitor
    extends XcodeNodeVisitor {
        AssignExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.ASSIGN);
        }
    }

    class AsgRshiftExprVisitor
    extends XcodeNodeVisitor {
        AsgRshiftExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.ASSIGN_RSHIFT);
        }
    }

    class AsgPlusExprVisitor
    extends XcodeNodeVisitor {
        AsgPlusExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.ASSIGN_PLUS);
        }
    }

    class AsgMulExprVisitor
    extends XcodeNodeVisitor {
        AsgMulExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.ASSIGN_MUL);
        }
    }

    class AsgModExprVisitor
    extends XcodeNodeVisitor {
        AsgModExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.ASSIGN_MOD);
        }
    }

    class AsgMinusExprVisitor
    extends XcodeNodeVisitor {
        AsgMinusExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.ASSIGN_MINUS);
        }
    }

    class AsgLshiftExprVisitor
    extends XcodeNodeVisitor {
        AsgLshiftExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.ASSIGN_LSHIFT);
        }
    }

    class AsgDivExprVisitor
    extends XcodeNodeVisitor {
        AsgDivExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.ASSIGN_DIV);
        }
    }

    class AsgBitXorExprVisitor
    extends XcodeNodeVisitor {
        AsgBitXorExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.ASSIGN_BIT_XOR);
        }
    }

    class AsgBitOrExprVisitor
    extends XcodeNodeVisitor {
        AsgBitOrExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.ASSIGN_BIT_OR);
        }
    }

    class AsgBitAndExprVisitor
    extends XcodeNodeVisitor {
        AsgBitAndExprVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterBinaryExpr(translationContext, node, xcNode, XcOperatorEnum.ASSIGN_BIT_AND);
        }
    }

    class PreIncrVisitor
    extends XcodeNodeVisitor {
        PreIncrVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterUnaryExpr(translationContext, node, xcNode, XcOperatorEnum.PRE_INCR);
        }
    }

    class PreDecrVisitor
    extends XcodeNodeVisitor {
        PreDecrVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterUnaryExpr(translationContext, node, xcNode, XcOperatorEnum.PRE_DECR);
        }
    }

    class PostIncrVisitor
    extends XcodeNodeVisitor {
        PostIncrVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterUnaryExpr(translationContext, node, xcNode, XcOperatorEnum.POST_INCR);
        }
    }

    class PostDecrVisitor
    extends XcodeNodeVisitor {
        PostDecrVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterUnaryExpr(translationContext, node, xcNode, XcOperatorEnum.POST_DECR);
        }
    }

    class UnaryMinusVisitor
    extends XcodeNodeVisitor {
        UnaryMinusVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this._enterUnaryExpr(translationContext, node, xcNode, XcOperatorEnum.UNARY_MINUS);
        }
    }

    class MoeConstantVisitor
    extends XcodeNodeVisitor {
        MoeConstantVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            String string = XmStringUtil.trim((String)XmcXcodeToXcTranslator.this.getType(node));
            String string2 = XmStringUtil.trim((String)XmDomUtil.getContentText((Node)node));
            XmcXcodeToXcTranslator._ensureAttr(node, string, "type");
            XmcXcodeToXcTranslator._ensureAttr(node, string2, "enumerator symbol");
            XcIdent xcIdent = XmcXcodeToXcTranslator.this._getIdentEnumerator(translationContext, node, string, string2);
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcIdent);
        }
    }

    class StringConstaantVisitor
    extends XcodeNodeVisitor {
        StringConstaantVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            String string = XmDomUtil.getContentText((Node)node);
            XcConstObj.StringConst stringConst = new XcConstObj.StringConst(string);
            stringConst.setIsWide(XmDomUtil.getAttrBool((Node)node, (String)"is_wide"));
            XmcXcodeToXcTranslator.this.addChild(xcNode, stringConst);
        }
    }

    class LonglongConstantVisitor
    extends XcodeNodeVisitor {
        LonglongConstantVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            String string = XmStringUtil.trim((String)XmcXcodeToXcTranslator.this.getType(node));
            XcConstObj.LongLongConst longLongConst = XmcBindingUtil.createLongLongConst(XmDomUtil.getContentText((Node)node), string);
            XmcXcodeToXcTranslator.this.addChild(xcNode, longLongConst);
        }
    }

    class IntConstantVisitor
    extends XcodeNodeVisitor {
        IntConstantVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcConstObj.IntConst intConst;
            String string = XmcXcodeToXcTranslator.this._getContentString(node);
            if (string == null) {
                throw new XmTranslationException(node, "invalid constant value");
            }
            String string2 = XmStringUtil.trim((String)XmcXcodeToXcTranslator.this.getType(node));
            XcBaseTypeEnum xcBaseTypeEnum = string2 == null ? XcBaseTypeEnum.INT : XcBaseTypeEnum.getByXcode(string2);
            if (xcBaseTypeEnum == null) {
                throw new XmTranslationException(node, "invalid type '" + string2 + "' as int constant");
            }
            try {
                intConst = new XcConstObj.IntConst(string, xcBaseTypeEnum);
            }
            catch (XmException xmException) {
                throw new XmTranslationException(node, (Throwable)xmException);
            }
            XmcXcodeToXcTranslator.this.addChild(xcNode, intConst);
        }
    }

    class FloatConstantVisitor
    extends XcodeNodeVisitor {
        FloatConstantVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcBaseTypeEnum xcBaseTypeEnum;
            String string = XmcXcodeToXcTranslator.this._getContentString(node);
            if (string == null) {
                throw new XmTranslationException(node, "invalid float fraction/exponential");
            }
            String string2 = XmStringUtil.trim((String)XmcXcodeToXcTranslator.this.getType(node));
            if (string2 == null) {
                xcBaseTypeEnum = XcBaseTypeEnum.DOUBLE;
            } else {
                xcBaseTypeEnum = XcBaseTypeEnum.getByXcode(string2);
                if (xcBaseTypeEnum == null) {
                    throw new XmTranslationException(node, "invalid type '" + string2 + "' as float constant");
                }
            }
            XcConstObj.FloatConst floatConst = new XcConstObj.FloatConst(string, xcBaseTypeEnum);
            XmcXcodeToXcTranslator.this.addChild(xcNode, floatConst);
        }
    }

    class StatementLabelVisitor
    extends XcodeNodeVisitor {
        StatementLabelVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            String string = XmcXcodeToXcTranslator.this._getContentString(XmDomUtil.getElement((Node)node, (String)"name"));
            if (string == null) {
                throw new XmTranslationException(node, "no label name");
            }
            XcControlStmtObj.Label label = new XcControlStmtObj.Label(string);
            XmcXcodeToXcTranslator.this.setSourcePos(label, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, label);
        }
    }

    class DefaultLabelVisitor
    extends XcodeNodeVisitor {
        DefaultLabelVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcControlStmtObj.DefaultLabel defaultLabel = new XcControlStmtObj.DefaultLabel();
            XmcXcodeToXcTranslator.this.setSourcePos(defaultLabel, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, defaultLabel);
        }
    }

    class CaseLabelVisitor
    extends XcodeNodeVisitor {
        CaseLabelVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcControlStmtObj.CaseLabel caseLabel = new XcControlStmtObj.CaseLabel();
            XmcXcodeToXcTranslator.this.setSourcePos(caseLabel, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, caseLabel);
            XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)caseLabel, XmDomUtil.getElement((Node)node, (String)"value"));
        }
    }

    class SwitchStatementVisitor
    extends XcodeNodeVisitor {
        SwitchStatementVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcControlStmtObj.Switch switch_ = new XcControlStmtObj.Switch();
            XmcXcodeToXcTranslator.this.setSourcePos(switch_, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, switch_);
            XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)switch_, XmDomUtil.getElement((Node)node, (String)"value"), XmDomUtil.getElement((Node)node, (String)"body"));
        }
    }

    class NameVisitor
    extends XcodeNodeVisitor {
        NameVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcNameObj xcNameObj = new XcNameObj(XmDomUtil.getContentText((Node)node));
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcNameObj);
        }
    }

    class GotoStatementVisitor
    extends XcodeNodeVisitor {
        GotoStatementVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcControlStmtObj.Goto goto_ = new XcControlStmtObj.Goto();
            XmcXcodeToXcTranslator.this.setSourcePos(goto_, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, goto_);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, goto_);
        }
    }

    class ReturnStatementVisitor
    extends XcodeNodeVisitor {
        ReturnStatementVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcControlStmtObj.Return return_ = new XcControlStmtObj.Return();
            XmcXcodeToXcTranslator.this.setSourcePos(return_, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, return_);
            XmcXcodeToXcTranslator.this.enterNodesWithNull(translationContext, return_, XmDomUtil.getContent((Node)node));
        }
    }

    class ContinueStatementVisitor
    extends XcodeNodeVisitor {
        ContinueStatementVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcControlStmtObj.Continue continue_ = new XcControlStmtObj.Continue();
            XmcXcodeToXcTranslator.this.setSourcePos(continue_, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, continue_);
        }
    }

    class BreakStatementVisitor
    extends XcodeNodeVisitor {
        BreakStatementVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcControlStmtObj.Break break_ = new XcControlStmtObj.Break();
            XmcXcodeToXcTranslator.this.setSourcePos(break_, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, break_);
        }
    }

    class ForStatementVisitor
    extends XcodeNodeVisitor {
        ForStatementVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcControlStmtObj.For for_ = new XcControlStmtObj.For();
            XmcXcodeToXcTranslator.this.setSourcePos(for_, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, for_);
            XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)for_, XmDomUtil.getElement((Node)node, (String)"init"), XmDomUtil.getElement((Node)node, (String)"condition"), XmDomUtil.getElement((Node)node, (String)"iter"), XmDomUtil.getElement((Node)node, (String)"body"));
        }
    }

    class DoStatementVisitor
    extends XcodeNodeVisitor {
        DoStatementVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcControlStmtObj.Do do_ = new XcControlStmtObj.Do();
            XmcXcodeToXcTranslator.this.setSourcePos(do_, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, do_);
            XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)do_, XmDomUtil.getElement((Node)node, (String)"condition"), XmDomUtil.getElement((Node)node, (String)"body"));
        }
    }

    class WhileStatementVisitor
    extends XcodeNodeVisitor {
        WhileStatementVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcControlStmtObj.While while_ = new XcControlStmtObj.While();
            XmcXcodeToXcTranslator.this.setSourcePos(while_, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, while_);
            XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)while_, XmDomUtil.getElement((Node)node, (String)"condition"), XmDomUtil.getElement((Node)node, (String)"body"));
        }
    }

    class ElseVisitor
    extends XcodeNodeVisitor {
        ElseVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcNode);
        }
    }

    class ThenVisitor
    extends XcodeNodeVisitor {
        ThenVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            ArrayList arrayList = XmDomUtil.collectChildNodes((Node)node);
            if (arrayList.isEmpty()) {
                XcCompStmtObj xcCompStmtObj = new XcCompStmtObj();
                XcDeclsObj xcDeclsObj = new XcDeclsObj();
                XmcXcodeToXcTranslator.this.addChild(xcCompStmtObj, xcDeclsObj);
                XmcXcodeToXcTranslator.this.addChild(xcNode, xcCompStmtObj);
            } else {
                XmcXcodeToXcTranslator.this.transChildren(translationContext, xcNode, arrayList);
            }
        }
    }

    class IterVisitor
    extends XcodeNodeVisitor {
        IterVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this.enterNodes(translationContext, xcNode, XmDomUtil.getContent((Node)node));
        }
    }

    class InitVisitor
    extends XcodeNodeVisitor {
        InitVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this.enterNodesWithNull(translationContext, xcNode, XmDomUtil.getContent((Node)node));
        }
    }

    class ConditionVisitor
    extends XcodeNodeVisitor {
        ConditionVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this.enterNodesWithNull(translationContext, xcNode, XmDomUtil.getContent((Node)node));
        }
    }

    class IfStatementVisitor
    extends XcodeNodeVisitor {
        IfStatementVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcControlStmtObj.If if_ = new XcControlStmtObj.If();
            XmcXcodeToXcTranslator.this.setSourcePos(if_, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, if_);
            XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)if_, XmDomUtil.getElement((Node)node, (String)"condition"), XmDomUtil.getElement((Node)node, (String)"then"), XmDomUtil.getElement((Node)node, (String)"else"));
        }
    }

    class CompoundStatementNodeVisitor
    extends XcodeNodeVisitor {
        CompoundStatementNodeVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcCompStmtObj xcCompStmtObj = new XcCompStmtObj();
            XmcXcodeToXcTranslator.this.setSourcePos(xcCompStmtObj, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcCompStmtObj);
            xcCompStmtObj.setIdentTable(translationContext.identTableStack.push());
            XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcCompStmtObj, XmDomUtil.getElement((Node)node, (String)"symbols"), XmDomUtil.getElement((Node)node, (String)"declarations"), XmDomUtil.getElement((Node)node, (String)"body"));
            translationContext.identTableStack.pop();
        }
    }

    class BodyVisitor
    extends XcodeNodeVisitor {
        BodyVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            ArrayList arrayList = XmDomUtil.collectChildNodes((Node)node);
            if (xcNode instanceof XcCompStmtObj || xcNode instanceof XcFuncDefObj && arrayList.size() == 1 && ((Node)arrayList.get(0)).getNodeName().equals("compoundStatement")) {
                XmcXcodeToXcTranslator.this.transChildren(translationContext, xcNode, arrayList);
            } else {
                XcCompStmtObj xcCompStmtObj = new XcCompStmtObj();
                xcCompStmtObj.setIdentTable(translationContext.identTableStack.getLast());
                XmcXcodeToXcTranslator.this.addChild(xcNode, xcCompStmtObj);
                XmcXcodeToXcTranslator.this.transChildren(translationContext, xcCompStmtObj, arrayList);
            }
        }
    }

    class FunctionDefinitionVisitor
    extends XcodeNodeVisitor {
        FunctionDefinitionVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            Object object;
            Node node2 = XmDomUtil.getElement((Node)node, (String)"params");
            XcIdent xcIdent = XmcXcodeToXcTranslator.this._getIdentFunc(translationContext, XmDomUtil.getElement((Node)node, (String)"name"), node2);
            XcFuncDefObj xcFuncDefObj = new XcFuncDefObj(xcIdent);
            XmcXcodeToXcTranslator.this.setSourcePos(xcFuncDefObj, node);
            xcFuncDefObj.setIsGccExtension(XmDomUtil.getAttrBool((Node)node, (String)"is_gccExtension"));
            XcParamList xcParamList = ((XcFuncType)xcIdent.getType()).getParamList();
            if (node2 == null && xcParamList != null) {
                throw new XmTranslationException(node, "mismatch with type by parameter size.");
            }
            Iterator<XcIdent> iterator = xcParamList.iterator();
            if (node2 != null) {
                object = node2.getChildNodes();
                for (int i = 0; i < object.getLength(); ++i) {
                    XcType xcType;
                    String string;
                    Node node3 = object.item(i);
                    if (node3.getNodeType() != 1 || !"name".equals(string = node3.getNodeName())) continue;
                    if (!iterator.hasNext()) {
                        throw new XmTranslationException(node, "mismatch with type by parameter size.");
                    }
                    iterator.next();
                    String string2 = XmStringUtil.trim((String)XmDomUtil.getContentText((Node)node3));
                    String string3 = XmStringUtil.trim((String)XmcXcodeToXcTranslator.this.getType(node3));
                    XmcXcodeToXcTranslator._ensureAttr(node3, string3, "type");
                    XcIdent xcIdent2 = new XcIdent(string2);
                    try {
                        xcType = translationContext.identTableStack.getType(string3);
                    }
                    catch (XmException xmException) {
                        throw new XmTranslationException(node, (Throwable)xmException);
                    }
                    xcIdent2.setType(xcType);
                    xcFuncDefObj.addParam(xcIdent2);
                }
                if (iterator.hasNext()) {
                    XcIdent xcIdent3 = iterator.next();
                    if (!(xcIdent3.getType() instanceof XcVoidType)) {
                        throw new XmTranslationException(node, "mismatch with type of parameter.");
                    }
                    xcFuncDefObj.addParam(xcIdent3);
                }
                xcFuncDefObj.setIsEllipsised(xcParamList.isEllipsised());
            }
            object = translationContext.identTableStack.push();
            ScopeEnum scopeEnum = translationContext.scopeEnum;
            translationContext.scopeEnum = ScopeEnum.LOCAL;
            XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcFuncDefObj, XmDomUtil.getElement((Node)node, (String)"symbols"), XmDomUtil.getElement((Node)node, (String)"body"), XmDomUtil.getElement((Node)node, (String)"gccAttributes"));
            if (xcFuncDefObj.getCompStmt() != null && xcFuncDefObj.getCompStmt().getIdentTable() == null) {
                xcFuncDefObj.getCompStmt().setIdentTable((XcIdentTable)object);
            }
            translationContext.identTableStack.pop();
            translationContext.scopeEnum = scopeEnum;
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcFuncDefObj);
        }
    }

    class FunctionDeclVisitor
    extends XcodeNodeVisitor {
        FunctionDeclVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcIdent xcIdent = XmcXcodeToXcTranslator.this._getIdentFunc(translationContext, XmDomUtil.getElement((Node)node, (String)"name"));
            XcType xcType = xcIdent.getType();
            if (!(xcType instanceof XcFuncType)) {
                throw new XmTranslationException(node, "symbol is declared as function, but type of symbol is not function.");
            }
            XcGccAttributeList xcGccAttributeList = xcIdent.getGccAttribute();
            if (xcGccAttributeList != null && xcGccAttributeList.containsAttrAlias() && xcIdent.isDeclared()) {
                return;
            }
            xcIdent.setDeclared();
            XcDeclObj xcDeclObj = new XcDeclObj(xcIdent);
            XmcXcodeToXcTranslator.this.setSourcePos(xcDeclObj, node);
            Node node2 = XmDomUtil.getElement((Node)node, (String)"gccAsm");
            if (node2 != null) {
                String string = XmDomUtil.getContentText((Node)XmDomUtil.getElement((Node)node2, (String)"stringConstant"));
                xcDeclObj.setGccAsmCode(string);
            }
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcDeclObj);
        }
    }

    class DesignatedValueVisitor
    extends XcodeNodeVisitor {
        DesignatedValueVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcDesignatedValueObj xcDesignatedValueObj = new XcDesignatedValueObj();
            xcDesignatedValueObj.setMember(XmDomUtil.getAttr((Node)node, (String)"member"));
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcDesignatedValueObj);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcDesignatedValueObj);
            XmcXcodeToXcTranslator.this.enterNodesWithNull(translationContext, xcDesignatedValueObj, XmDomUtil.getContent((Node)node));
        }
    }

    class ValueVisitor
    extends XcodeNodeVisitor {
        ValueVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            Node node2 = XmDomUtil.getContent((Node)node);
            Node node3 = node.getParentNode();
            if (node3 != null && node3.getNodeName().equals("value")) {
                XmcXcodeToXcTranslator.this.enterCompoundValue(translationContext, node, xcNode);
            } else {
                XmcXcodeToXcTranslator.this.enterNodes(translationContext, xcNode, node2);
            }
        }
    }

    class VarDeclVisitor
    extends XcodeNodeVisitor {
        VarDeclVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            Node node2;
            XcIdent xcIdent = XmcXcodeToXcTranslator.this._getIdent(translationContext, XcSymbolKindEnum.VAR, XmDomUtil.getElement((Node)node, (String)"name"));
            XcDeclObj xcDeclObj = new XcDeclObj(xcIdent);
            XmcXcodeToXcTranslator.this.setSourcePos(xcDeclObj, node);
            String string = null;
            Node node3 = XmDomUtil.getElement((Node)node, (String)"gccAsm");
            if (node3 != null && (node2 = XmDomUtil.getElement((Node)node3, (String)"gccAsmExpression")) != null) {
                string = XmDomUtil.getContentText((Node)XmDomUtil.getElement((Node)node2, (String)"stringConstant"));
            }
            xcDeclObj.setGccAsmCode(string);
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcDeclObj);
            XmcXcodeToXcTranslator.this.enterNodes(translationContext, (XcNode)xcDeclObj, XmDomUtil.getElement((Node)node, (String)"value"));
        }
    }

    class IdVisitor
    extends XcodeNodeVisitor {
        IdVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            Node node2 = XmDomUtil.getElement((Node)node, (String)"name");
            String string = XmDomUtil.getContentText((Node)node2);
            XmcXcodeToXcTranslator._ensureAttr(node2, string, "name");
            String string2 = XmcXcodeToXcTranslator.this.getType(node);
            if (string2 == null) {
                string2 = XmcXcodeToXcTranslator.this.getType(node2);
                XmcXcodeToXcTranslator._ensureAttr(node2, string2, "type");
            }
            XcIdent xcIdent = new XcIdent(string);
            XmcXcodeToXcTranslator.this._addGccAttribute(xcIdent, node);
            xcIdent.setTempTypeId(string2);
            xcIdent.setIsGccExtension(XmDomUtil.getAttrBool((Node)node, (String)"is_gccExtension"));
            xcIdent.setIsGccThread(XmDomUtil.getAttrBool((Node)node, (String)"is_gccThread"));
            try {
                xcIdent.resolve(translationContext.identTableStack);
            }
            catch (XmException xmException) {
                throw new XmTranslationException(node, (Throwable)xmException);
            }
            String string3 = XmStringUtil.trim((String)XmDomUtil.getAttr((Node)node, (String)"sclass"));
            XcSymbolKindEnum xcSymbolKindEnum = null;
            if (string3 != null && !"auto".equals(string3)) {
                if ("extern".equals(string3)) {
                    xcIdent.setIsExtern(true);
                } else if ("extern_def".equals(string3)) {
                    xcIdent.setIsExternDef(true);
                } else if ("static".equals(string3)) {
                    xcIdent.setIsStatic(true);
                } else if ("register".equals(string3)) {
                    xcIdent.setIsRegister(true);
                } else if ("typedef_name".equals(string3)) {
                    xcIdent.setIsTypedef(true);
                    xcSymbolKindEnum = XcSymbolKindEnum.TYPE;
                } else if ("param".equals(string3)) {
                    xcIdent.setVarKindEnum(XcVarKindEnum.PARAM);
                    xcSymbolKindEnum = XcSymbolKindEnum.VAR;
                } else if ("label".equals(string3)) {
                    xcSymbolKindEnum = XcSymbolKindEnum.LABEL;
                } else if ("tagname".equals(string3)) {
                    xcSymbolKindEnum = XcSymbolKindEnum.TAGNAME;
                } else if ("moe".equals(string3)) {
                    xcSymbolKindEnum = XcSymbolKindEnum.MOE;
                }
            }
            XcType xcType = xcIdent.getType();
            if (xcSymbolKindEnum == null) {
                xcSymbolKindEnum = xcType != null && XcTypeEnum.FUNC.equals((Object)xcType.getTypeEnum()) ? XcSymbolKindEnum.FUNC : XcSymbolKindEnum.VAR;
            }
            if (XcSymbolKindEnum.VAR.equals((Object)xcSymbolKindEnum) && xcIdent.getVarKindEnum() == null) {
                switch (translationContext.scopeEnum) {
                    case GLOBAL: {
                        xcIdent.setVarKindEnum(XcVarKindEnum.GLOBAL);
                        break;
                    }
                    case LOCAL: {
                        xcIdent.setVarKindEnum(XcVarKindEnum.LOCAL);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            try {
                translationContext.identTableStack.addIdent(xcSymbolKindEnum, xcIdent);
            }
            catch (XmException xmException) {
                throw new XmTranslationException(node, (Throwable)xmException);
            }
            if (XcSymbolKindEnum.MOE.equals((Object)xcSymbolKindEnum) && ((XcEnumType)xcType).getTagName() == null) {
                xcIdent = new XcIdent(null);
                xcIdent.setType(xcType);
                try {
                    translationContext.identTableStack.addAnonIdent(xcIdent);
                }
                catch (XmException xmException) {
                    throw new XmTranslationException(node, (Throwable)xmException);
                }
            }
        }
    }

    class FunctionTypeVisitor
    extends XcodeNodeVisitor {
        FunctionTypeVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            Node node2;
            String string = XmStringUtil.trim((String)XmcXcodeToXcTranslator.this.getType(node));
            XmcXcodeToXcTranslator._ensureAttr(node, string, "type");
            XcFuncType xcFuncType = new XcFuncType(string);
            XmcXcodeToXcTranslator._setTypeAttr(xcFuncType, node);
            xcFuncType.setIsInline(XmDomUtil.getAttrBool((Node)node, (String)"is_inline"));
            xcFuncType.setIsStatic(XmDomUtil.getAttrBool((Node)node, (String)"is_static"));
            String string2 = XmDomUtil.getAttr((Node)node, (String)"return_type");
            if (string2 != null) {
                xcFuncType.setTempRefTypeId(string2);
            }
            if ((node2 = XmDomUtil.getElement((Node)node, (String)"params")) != null) {
                NodeList nodeList = node2.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node3 = nodeList.item(i);
                    if (node3.getNodeType() != 1) continue;
                    String string3 = node3.getNodeName();
                    if ("name".equals(string3)) {
                        String string4 = XmStringUtil.trim((String)XmDomUtil.getContentText((Node)node3));
                        String string5 = XmStringUtil.trim((String)XmcXcodeToXcTranslator.this.getType(node3));
                        XmcXcodeToXcTranslator._ensureAttr(node3, string5, "type");
                        XcIdent xcIdent = new XcIdent(string4);
                        xcIdent.setTempTypeId(string5);
                        xcFuncType.addParam(xcIdent);
                        continue;
                    }
                    if (!"ellipsis".equals(string3)) continue;
                    xcFuncType.setIsEllipsised(true);
                }
            }
            XmcXcodeToXcTranslator.this._addGccAttribute(xcFuncType, node);
            XmcXcodeToXcTranslator.this._addType(translationContext, xcFuncType, node);
        }
    }

    class UnionTypeVisitor
    extends XcodeNodeVisitor {
        UnionTypeVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            String string = XmStringUtil.trim((String)XmcXcodeToXcTranslator.this.getType(node));
            XmcXcodeToXcTranslator._ensureAttr(node, string, "type");
            XcUnionType xcUnionType = new XcUnionType(string);
            XmcXcodeToXcTranslator.this._addGccAttribute(xcUnionType, node);
            XmcXcodeToXcTranslator.this._enterCompositeType(translationContext, xcUnionType, node);
        }
    }

    class StructTypeVisitor
    extends XcodeNodeVisitor {
        StructTypeVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            String string = XmStringUtil.trim((String)XmcXcodeToXcTranslator.this.getType(node));
            XmcXcodeToXcTranslator._ensureAttr(node, string, "type");
            XcStructType xcStructType = new XcStructType(string);
            XmcXcodeToXcTranslator.this._addGccAttribute(xcStructType, node);
            XmcXcodeToXcTranslator.this._enterCompositeType(translationContext, xcStructType, node);
        }
    }

    class EnumTypeVisitor
    extends XcodeNodeVisitor {
        EnumTypeVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            String string = XmStringUtil.trim((String)XmcXcodeToXcTranslator.this.getType(node));
            XmcXcodeToXcTranslator._ensureAttr(node, string, "type");
            XcEnumType xcEnumType = new XcEnumType(string);
            XmcXcodeToXcTranslator._setTypeAttr(xcEnumType, node);
            Node node2 = XmDomUtil.getElement((Node)node, (String)"symbols");
            if (node2 != null) {
                boolean bl = true;
                int n = 0;
                NodeList nodeList = node2.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String string2;
                    Node node3 = nodeList.item(i);
                    if (node3.getNodeType() != 1 || !"id".equals(string2 = node3.getNodeName())) continue;
                    Node node4 = XmDomUtil.getElement((Node)node3, (String)"name");
                    String string3 = XmStringUtil.trim((String)XmDomUtil.getContentText((Node)node4));
                    XmcXcodeToXcTranslator._ensureAttr(node4, string3, "name");
                    XcIdent.MoeConstant moeConstant = new XcIdent.MoeConstant(string3, xcEnumType);
                    Node node5 = XmDomUtil.getElement((Node)node3, (String)"value");
                    if (node5 != null) {
                        Node node6 = XmDomUtil.getContent((Node)node5);
                        String string4 = node6.getNodeName();
                        if ("intConstant".equals(string4)) {
                            n = XmStringUtil.getAsCInt((String)XmDomUtil.getContentText((Node)node6));
                            moeConstant.setValue(new XcConstObj.IntConst(n++, XcBaseTypeEnum.INT));
                        } else {
                            XcIdent.MoeConstant moeConstant2 = moeConstant;
                            moeConstant2.setIsLazyEvalType(true);
                            moeConstant2.setLazyBindings(new Node[]{node6});
                            bl = false;
                        }
                    } else if (bl) {
                        moeConstant.setValue(new XcConstObj.IntConst(n++, XcBaseTypeEnum.INT));
                    } else {
                        moeConstant.setValue(null);
                    }
                    xcEnumType.addEnumerator(moeConstant);
                }
            }
            XmcXcodeToXcTranslator.this._addType(translationContext, xcEnumType, node);
            XmcXcodeToXcTranslator.this._addGccAttribute(xcEnumType, node);
        }
    }

    class PointerTypeVisitor
    extends XcodeNodeVisitor {
        PointerTypeVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            String string = XmStringUtil.trim((String)XmcXcodeToXcTranslator.this.getType(node));
            String string2 = XmStringUtil.trim((String)XmDomUtil.getAttr((Node)node, (String)"ref"));
            XmcXcodeToXcTranslator._ensureAttr(node, string, "type");
            XmcXcodeToXcTranslator._ensureAttr(node, string2, "reference type");
            XcPointerType xcPointerType = new XcPointerType(string);
            XmcXcodeToXcTranslator._setTypeAttr(xcPointerType, node);
            xcPointerType.setTempRefTypeId(string2);
            XmcXcodeToXcTranslator.this._addType(translationContext, xcPointerType, node);
            XmcXcodeToXcTranslator.this._addGccAttribute(xcPointerType, node);
        }
    }

    class ArraySizeVisitor
    extends XcodeNodeVisitor {
        ArraySizeVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this.enterNodes(translationContext, xcNode, XmDomUtil.getElement((Node)node, (String)"expressions"));
        }
    }

    class ArrayTypeVisitor
    extends XcodeNodeVisitor {
        ArrayTypeVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            String string = XmStringUtil.trim((String)XmcXcodeToXcTranslator.this.getType(node));
            XmcXcodeToXcTranslator._ensureAttr(node, string, "type");
            XcArrayType xcArrayType = new XcArrayType(string);
            XmcXcodeToXcTranslator._setTypeAttr(xcArrayType, node);
            xcArrayType.setIsStatic(XmDomUtil.getAttrBool((Node)node, (String)"is_static"));
            XmcXcodeToXcTranslator.this._addGccAttribute(xcArrayType, node);
            XmcXcodeToXcTranslator.this._enterArrayType(translationContext, xcArrayType, node);
        }
    }

    class BasicTypeVisitor
    extends XcodeNodeVisitor {
        BasicTypeVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            String string = XmStringUtil.trim((String)XmcXcodeToXcTranslator.this.getType(node));
            XmcXcodeToXcTranslator._ensureAttr(node, string, "type");
            String string2 = XmStringUtil.trim((String)XmDomUtil.getAttr((Node)node, (String)"name"));
            XmcXcodeToXcTranslator._ensureAttr(node, string2, "name");
            XcBasicType xcBasicType = new XcBasicType(string);
            xcBasicType.setTempRefTypeId(string2);
            XmcXcodeToXcTranslator._setTypeAttr(xcBasicType, node);
            XmcXcodeToXcTranslator.this._addType(translationContext, xcBasicType, node);
            XmcXcodeToXcTranslator.this._addGccAttribute(xcBasicType, node);
        }
    }

    class GccAttributesVisitor
    extends XcodeNodeVisitor {
        GccAttributesVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcGccAttributeList xcGccAttributeList = new XcGccAttributeList();
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcGccAttributeList);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcGccAttributeList);
        }
    }

    class GccAttributeVisitor
    extends XcodeNodeVisitor {
        GccAttributeVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcGccAttribute xcGccAttribute = new XcGccAttribute();
            xcGccAttribute.setName(XmDomUtil.getAttr((Node)node, (String)"name"));
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcGccAttribute);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcGccAttribute);
        }
    }

    class SymbolsNodeVisitor
    extends XcodeNodeVisitor {
        SymbolsNodeVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcNode);
            XmcXcodeToXcLazyVisitor xmcXcodeToXcLazyVisitor = new XmcXcodeToXcLazyVisitor(translationContext);
            try {
                translationContext.identTableStack.resolveDependency(xmcXcodeToXcLazyVisitor);
            }
            catch (XmException xmException) {
                throw new XmTranslationException(node, (Throwable)xmException);
            }
        }
    }

    class GlobalSymbolsNodeVisitor
    extends XcodeNodeVisitor {
        GlobalSymbolsNodeVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcNode);
            XmcXcodeToXcLazyVisitor xmcXcodeToXcLazyVisitor = new XmcXcodeToXcLazyVisitor(translationContext);
            try {
                translationContext.identTableStack.resolveDependency(xmcXcodeToXcLazyVisitor);
            }
            catch (XmException xmException) {
                throw new XmTranslationException(node, (Throwable)xmException);
            }
        }
    }

    class TypeTableNodeVisitor
    extends XcodeNodeVisitor {
        TypeTableNodeVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcNode);
            try {
                translationContext.identTableStack.resolveType();
            }
            catch (XmException xmException) {
                throw new XmTranslationException(node, (Throwable)xmException);
            }
        }
    }

    class ExprStatementNodeVisitor
    extends XcodeNodeVisitor {
        ExprStatementNodeVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcExprStmtObj xcExprStmtObj = new XcExprStmtObj();
            XmcXcodeToXcTranslator.this.setSourcePos(xcExprStmtObj, node);
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcExprStmtObj);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcExprStmtObj);
        }
    }

    class DeclarationsNodeVisitor
    extends XcodeNodeVisitor {
        DeclarationsNodeVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XcDeclsObj xcDeclsObj = new XcDeclsObj();
            XmcXcodeToXcTranslator.this.addChild(xcNode, xcDeclsObj);
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcDeclsObj);
        }
    }

    class GlobalDeclarationsNodeVisitor
    extends XcodeNodeVisitor {
        GlobalDeclarationsNodeVisitor() {
        }

        @Override
        public void enter(TranslationContext translationContext, Node node, XcNode xcNode) {
            XmcXcodeToXcTranslator.this.transChildren(translationContext, node, xcNode);
        }
    }

    abstract class XcodeNodeVisitor {
        XcodeNodeVisitor() {
        }

        public abstract void enter(TranslationContext var1, Node var2, XcNode var3);
    }

    static enum ScopeEnum {
        GLOBAL,
        LOCAL;

    }
}

