/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.c.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import xcodeml.c.decompile.XcAppendable;
import xcodeml.c.decompile.XcCompoundValueObj;
import xcodeml.c.decompile.XcOperatorEnum;
import xcodeml.c.decompile.XcOperatorObj;
import xcodeml.c.type.XcIdent;
import xcodeml.util.XmException;

public class XmcWriter {
    private PrintWriter _writer;
    private StringWriter _swriter;
    private char _lastChar;
    private boolean _isDebugMode = false;

    public XmcWriter() {
        this(4096);
    }

    public XmcWriter(int n) {
        this._swriter = new StringWriter(n);
        this._writer = new PrintWriter(this._swriter);
    }

    public XmcWriter(Writer writer) {
        this._writer = new PrintWriter(writer);
    }

    public void setIsDebugMode(boolean bl) {
        this._isDebugMode = bl;
    }

    public boolean getIsDebugMode() {
        return this._isDebugMode;
    }

    private void _print(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this._lastChar = string.charAt(string.length() - 1);
        this._writer.print(string);
    }

    private void _print(char c) {
        if (c == '\u0000') {
            return;
        }
        this._lastChar = c;
        this._writer.print(c);
    }

    private void _print(int n) {
        this._lastChar = (char)48;
        this._writer.print(n);
    }

    private void _print(double d) {
        this._lastChar = (char)48;
        this._writer.print(d);
    }

    public void println(String string) {
        this._println(string);
    }

    private void _println(String string) {
        this._lastChar = (char)10;
        if (string == null || string.length() == 0) {
            return;
        }
        this._writer.println(string);
    }

    private void _println() {
        this._lastChar = (char)10;
        this._writer.println("");
    }

    public final XmcWriter spc() {
        if (this._lastChar != '\u0000') {
            switch (this._lastChar) {
                case '\t': 
                case '\n': 
                case ' ': 
                case '(': 
                case '[': 
                case '{': {
                    break;
                }
                default: {
                    this._print(" ");
                }
            }
        }
        return this;
    }

    public final XmcWriter lf() {
        this._println();
        return this;
    }

    public final XmcWriter noLfOrLf() {
        if (this._lastChar != '\n') {
            this._println();
        }
        return this;
    }

    public final XmcWriter eos() {
        this._println(";");
        return this;
    }

    public final XmcWriter add(String string) {
        if (string != null) {
            this._print(string);
        }
        return this;
    }

    public final XmcWriter add(char c) {
        this._print(c);
        return this;
    }

    public final XmcWriter addSpc(String string) {
        this.spc();
        if (string != null) {
            this._print(string);
        }
        return this;
    }

    public final XmcWriter add(int n) {
        this._print(n);
        return this;
    }

    public final XmcWriter add(double d) {
        this._print(d);
        return this;
    }

    public final XmcWriter addSpc(int n) {
        this.spc();
        this._print(n);
        return this;
    }

    public final XmcWriter addBrace(XcAppendable xcAppendable) throws XmException {
        if (xcAppendable == null) {
            return this;
        }
        if (xcAppendable != null) {
            this._print('(');
            xcAppendable.appendCode(this);
            this._print(')');
        }
        return this;
    }

    public final XmcWriter addBraceIfNeeded(XcAppendable xcAppendable) throws XmException {
        if (xcAppendable != null) {
            if (xcAppendable instanceof XcIdent || xcAppendable instanceof XcCompoundValueObj || xcAppendable instanceof XcOperatorObj && ((XcOperatorObj)xcAppendable).getOperatorEnum() == XcOperatorEnum.COMMA) {
                xcAppendable.appendCode(this);
            } else {
                this._print('(');
                xcAppendable.appendCode(this);
                this._print(')');
            }
        }
        return this;
    }

    public final XmcWriter addSpc(XcAppendable xcAppendable) throws XmException {
        this.spc();
        return this.add(xcAppendable);
    }

    public final XmcWriter add(XcAppendable xcAppendable) throws XmException {
        if (xcAppendable != null) {
            xcAppendable.appendCode(this);
        }
        return this;
    }

    public final void flush() {
        this._writer.flush();
    }

    public final void close() {
        this._writer.close();
    }

    public final String toString() {
        if (this._swriter != null) {
            return this._swriter.toString();
        }
        return super.toString();
    }
}

