/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.c.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import xcodeml.c.decompile.XcObj;
import xcodeml.c.type.XcArrayType;
import xcodeml.c.type.XcBaseType;
import xcodeml.c.type.XcBaseTypeEnum;
import xcodeml.c.type.XcBasicType;
import xcodeml.c.type.XcCompositeType;
import xcodeml.c.type.XcEnumType;
import xcodeml.c.type.XcExtType;
import xcodeml.c.type.XcFuncType;
import xcodeml.c.type.XcGccAttributable;
import xcodeml.c.type.XcGccAttributeList;
import xcodeml.c.type.XcIdentTableStack;
import xcodeml.c.type.XcMemberList;
import xcodeml.c.type.XcTaggedType;
import xcodeml.c.type.XcTypeEnum;
import xcodeml.c.type.XcXmpCoArrayType;
import xcodeml.c.util.XmcWriter;
import xcodeml.util.XmException;

public abstract class XcType
extends XcObj
implements Cloneable,
XcGccAttributable {
    private XcTypeEnum _typeEnum;
    private String _typeId;
    private boolean _isConst;
    private boolean _isVolatile;
    private boolean _isRestrict;
    private XcType _refType;
    private String _tempRefTypeId;
    private boolean _resolved;
    private XcGccAttributeList _gccAttrs;

    protected XcType() {
    }

    protected XcType(XcTypeEnum xcTypeEnum, String string) {
        this._typeEnum = xcTypeEnum;
        this._typeId = string;
    }

    protected abstract void resolveOverride(XcIdentTableStack var1) throws XmException;

    public XcType copy() {
        try {
            return (XcType)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public final XcTypeEnum getTypeEnum() {
        return this._typeEnum;
    }

    public final String getTypeId() {
        return this._typeId;
    }

    public final boolean isConst() {
        return this._isConst;
    }

    public final void setIsConst(boolean bl) {
        this._isConst = bl;
    }

    public final boolean isVolatile() {
        return this._isVolatile;
    }

    public final void setIsVolatile(boolean bl) {
        this._isVolatile = bl;
    }

    public final boolean isRestrict() {
        return this._isRestrict;
    }

    public final void setIsRestrict(boolean bl) {
        this._isRestrict = bl;
    }

    public final void copyTypeQualifiersFrom(XcType xcType) {
        this._isConst = xcType._isConst;
        this._isRestrict = xcType._isRestrict;
        this._isVolatile = xcType._isVolatile;
    }

    public final void resetTypeQualifiers() {
        this._isConst = false;
        this._isRestrict = false;
        this._isVolatile = false;
    }

    public final XcType getRefType() {
        return this._refType;
    }

    public final void setRefType(XcType xcType) {
        this._refType = xcType;
    }

    public final String getTempRefTypeId() {
        return this._tempRefTypeId;
    }

    public final void setTempRefTypeId(String string) {
        this._tempRefTypeId = string;
    }

    public final boolean canBeBottomType() {
        switch (this.getTypeEnum()) {
            case BASETYPE: 
            case BUILTIN: 
            case STRUCT: 
            case UNION: 
            case ENUM: {
                return true;
            }
        }
        return false;
    }

    public final void appendTypeNameCode(XmcWriter xmcWriter) throws XmException {
        switch (this.getTypeEnum()) {
            case BASETYPE: {
                xmcWriter.addSpc(((XcBaseType)this).getBaseTypeEnum().getCCode());
                break;
            }
            case BASICTYPE: {
                break;
            }
            case STRUCT: 
            case UNION: 
            case ENUM: {
                XcTaggedType xcTaggedType = (XcTaggedType)((Object)this);
                xmcWriter.addSpc(xcTaggedType.getTypeNameHeader());
                if (xcTaggedType.getTagName() == null) break;
                xmcWriter.addSpc(xcTaggedType.getTagName());
                break;
            }
            default: {
                throw new XmException("pointer/array/function type has no name");
            }
        }
    }

    @Override
    public final void appendCode(XmcWriter xmcWriter) throws XmException {
        this.appendDeclCode(xmcWriter, null, true, false);
    }

    public final void appendCode(XmcWriter xmcWriter, String string) throws XmException {
        this.appendDeclCode(xmcWriter, string, true, false);
    }

    public final void appendBodyCode(XmcWriter xmcWriter) throws XmException {
        this.appendBodyCode(xmcWriter, false);
    }

    public final void appendBodyCode(XmcWriter xmcWriter, boolean bl) throws XmException {
        switch (this.getTypeEnum()) {
            case STRUCT: 
            case UNION: 
            case ENUM: {
                XcTaggedType xcTaggedType = (XcTaggedType)((Object)this);
                xmcWriter.addSpc(xcTaggedType.getTypeNameHeader());
                this.appendGccAtrribute(xmcWriter);
                if (xcTaggedType.getTagName() != null) {
                    xmcWriter.addSpc(xcTaggedType.getTagName());
                }
                if (this instanceof XcCompositeType) {
                    XcMemberList xcMemberList = ((XcCompositeType)xcTaggedType).getMemberList();
                    if (xcMemberList == null || bl) break;
                    xcMemberList.appendCode(xmcWriter);
                    break;
                }
                ((XcEnumType)this).getEnumeratorList().appendCode(xmcWriter);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public final void appendTypeDefCode(XmcWriter xmcWriter, String string) throws XmException {
        if (this instanceof XcTaggedType) {
            this.appendDeclCode(xmcWriter, null, true, false);
            xmcWriter.addSpc(string);
        } else {
            this.appendDeclCode(xmcWriter, string, true, false);
        }
    }

    public final void appendSizeOfCode(XmcWriter xmcWriter) throws XmException {
        this.appendDeclCode(xmcWriter, null, true, false, this._gccAttrs);
    }

    private final boolean isGccAligned() throws XmException {
        if (this._gccAttrs == null) {
            return false;
        }
        return this._gccAttrs.isGccAligned();
    }

    public final void appendGccAtrribute(XmcWriter xmcWriter) throws XmException {
        if (this._gccAttrs != null) {
            this._gccAttrs.appendCode(xmcWriter);
        }
    }

    public final void appendDeclCode(XmcWriter xmcWriter, String string, boolean bl, boolean bl2) throws XmException {
        this.appendDeclCode(xmcWriter, string, bl, bl2, null);
    }

    public final void appendDeclCode(XmcWriter xmcWriter, String string, boolean bl, boolean bl2, XcGccAttributeList xcGccAttributeList) throws XmException {
        this.appendDeclCode(xmcWriter, string, bl, bl2, xcGccAttributeList, false);
    }

    public final void appendDeclCode(XmcWriter xmcWriter, String string, boolean bl, boolean bl2, XcGccAttributeList xcGccAttributeList, boolean bl3) throws XmException {
        XcFuncType xcFuncType;
        Stack<XcType> stack = new Stack<XcType>();
        XcType xcType = this;
        while (xcType.getTypeEnum() == XcTypeEnum.COARRAY) {
            xcType = ((XcXmpCoArrayType)xcType).getRefType();
        }
        while (xcType != null && xcType instanceof XcExtType) {
            stack.push(xcType);
            xcType = xcType.getRefType();
        }
        if (!xcType.canBeBottomType()) {
            throw new XmException("invalid type");
        }
        if (this.getTypeEnum() == XcTypeEnum.FUNC && !(xcFuncType = (XcFuncType)this).isPrototype()) {
            if (xcFuncType.isStatic()) {
                xmcWriter.addSpc("static");
            }
            if (xcFuncType.isInline()) {
                xmcWriter.addSpc("inline");
            }
        }
        boolean bl4 = false;
        if (string != null && XcType._needAttrGuard(xcType, stack)) {
            xmcWriter.addSpc("typeof(");
            bl4 = true;
        }
        xmcWriter.addSpc(xcGccAttributeList);
        xcType.appendTypeQualCode(xmcWriter);
        xcType.appendTypeNameCode(xmcWriter);
        if (!stack.isEmpty()) {
            xmcWriter.spc();
        } else if (string == null) {
            return;
        }
        XcType._appendCode(xmcWriter, stack, string, bl2, bl4, null, null, bl3);
    }

    private static void _appendBasicType(XmcWriter xmcWriter, Stack<XcType> stack, List<XcGccAttributeList> list) throws XmException {
        if (!stack.isEmpty()) {
            XcType xcType = stack.pop();
            while (xcType instanceof XcBasicType) {
                if (list == null) {
                    xcType.appendGccAtrribute(xmcWriter);
                } else if (xcType.getGccAttribute() != null) {
                    list.add(xcType.getGccAttribute());
                }
                xcType.appendTypeQualCode(xmcWriter);
                if (stack.isEmpty()) break;
                xcType = stack.pop();
            }
            if (!(xcType instanceof XcBasicType)) {
                stack.push(xcType);
            }
        }
    }

    private static XcType _peekRealType(Stack<XcType> stack) {
        XcType xcType = null;
        if (stack.isEmpty()) {
            return null;
        }
        XcType xcType2 = stack.pop();
        xcType = xcType2.getTypeEnum() == XcTypeEnum.BASICTYPE ? XcType._peekRealType(stack) : xcType2;
        stack.push(xcType2);
        return xcType;
    }

    private static boolean _recNeedAttrGuard(Stack<XcType> stack, boolean bl) {
        if (stack.isEmpty()) {
            return false;
        }
        boolean bl2 = false;
        XcType xcType = stack.pop();
        XcTypeEnum xcTypeEnum = xcType.getTypeEnum();
        switch (xcTypeEnum) {
            case POINTER: {
                if (!bl) break;
                bl2 = true;
                break;
            }
            case ARRAY: {
                if (stack.isEmpty()) {
                    bl2 = false;
                    break;
                }
                if (!bl) break;
                bl2 = true;
                break;
            }
            default: {
                if (!bl && xcType.getGccAttribute() != null && !xcType.getGccAttribute().isEmpty()) {
                    bl = true;
                }
                bl2 = XcType._recNeedAttrGuard(stack, bl);
            }
        }
        stack.push(xcType);
        return bl2;
    }

    private static boolean _needAttrGuard(XcType xcType, Stack<XcType> stack) {
        XcType xcType2 = xcType.getRealType();
        if (xcType2.getTypeEnum() != XcTypeEnum.BASETYPE) {
            return false;
        }
        boolean bl = xcType.getGccAttribute() != null && !xcType.getGccAttribute().isEmpty();
        return XcType._recNeedAttrGuard(stack, bl);
    }

    private static final void _appendCode(XmcWriter xmcWriter, Stack<XcType> stack, String string, boolean bl, boolean bl2, XcGccAttributeList xcGccAttributeList, List<XcGccAttributeList> list) throws XmException {
        XcType._appendCode(xmcWriter, stack, string, bl, bl2, xcGccAttributeList, list, false);
    }

    private static final void _appendCode(XmcWriter xmcWriter, Stack<XcType> stack, String string, boolean bl, boolean bl2, XcGccAttributeList xcGccAttributeList, List<XcGccAttributeList> list, boolean bl3) throws XmException {
        if (stack.isEmpty()) {
            if (string != null) {
                if (xcGccAttributeList != null) {
                    xmcWriter.addSpc(xcGccAttributeList);
                }
                xmcWriter.addSpc(string);
            }
            return;
        }
        boolean bl4 = false;
        XcType xcType = stack.pop();
        XcTypeEnum xcTypeEnum = xcType.getTypeEnum();
        XcType xcType2 = XcType._peekRealType(stack);
        if (xcType2 != null && xcTypeEnum != XcTypeEnum.POINTER && xcType2.getTypeEnum() == XcTypeEnum.POINTER) {
            bl4 = true;
        }
        switch (xcTypeEnum) {
            case BASICTYPE: {
                if (!bl3 || !xcType.isGccAligned()) {
                    xcType.appendGccAtrribute(xmcWriter);
                }
                xcType.appendTypeQualCode(xmcWriter);
                XcType._appendCode(xmcWriter, stack, string, bl, bl2, xcGccAttributeList, list);
                break;
            }
            case POINTER: {
                if (bl2) {
                    xmcWriter.add(")");
                }
                bl2 = false;
                xmcWriter.addSpc("*").spc();
                xcType.appendGccAtrribute(xmcWriter);
                xcType.appendTypeQualCode(xmcWriter);
                XcType._appendCode(xmcWriter, stack, string, bl, bl2, xcGccAttributeList, list);
                break;
            }
            case FUNC: {
                xcType.appendGccAtrribute(xmcWriter);
                XcFuncType xcFuncType = (XcFuncType)xcType;
                bl = xcFuncType.isPreDecl();
                XcType._appendBasicType(xmcWriter, stack, null);
                if (bl4) {
                    xmcWriter.add("(");
                }
                XcType._appendCode(xmcWriter, stack, string, bl, bl2, xcGccAttributeList, list);
                if (bl4) {
                    xmcWriter.add(")");
                }
                if (!xcFuncType.getParamList().isEmpty()) {
                    xcFuncType.getParamList().appendArgs(xmcWriter, !bl4 && !xcFuncType.isPrototype(), bl);
                    break;
                }
                xmcWriter.add("()");
                break;
            }
            case ARRAY: {
                if (list == null) {
                    list = new ArrayList<XcGccAttributeList>();
                }
                if (xcType.getGccAttribute() != null) {
                    list.add(xcType.getGccAttribute());
                }
                XcArrayType xcArrayType = (XcArrayType)xcType;
                XcType._appendBasicType(xmcWriter, stack, list);
                if (!stack.isEmpty() && stack.peek().getTypeEnum() == XcTypeEnum.FUNC) {
                    if (bl2) {
                        xmcWriter.add(")");
                    }
                    bl2 = false;
                    xmcWriter.add("*");
                    XcType._appendCode(xmcWriter, stack, string, bl, bl2, xcGccAttributeList, list);
                    break;
                }
                boolean bl5 = stack.isEmpty();
                if (bl4) {
                    xmcWriter.add("(");
                }
                XcType._appendCode(xmcWriter, stack, string, bl, bl2, xcGccAttributeList, list);
                if (bl4) {
                    xmcWriter.add(")");
                }
                xcArrayType.appendArraySpecCode(xmcWriter, bl, bl5);
                XcType xcType3 = xcArrayType.getRefType().getRealType();
                if (xcType3.getTypeEnum() == XcTypeEnum.ARRAY || list == null) break;
                for (XcGccAttributeList xcGccAttributeList2 : list) {
                    xcGccAttributeList2.appendCode(xmcWriter);
                }
                break;
            }
            default: {
                throw new XmException();
            }
        }
    }

    public final void appendTypeQualCode(XmcWriter xmcWriter) throws XmException {
        if (this._isConst) {
            xmcWriter.addSpc("const");
        }
        if (this._isVolatile) {
            xmcWriter.addSpc("volatile");
        }
        if (this._isRestrict) {
            xmcWriter.addSpc("restrict");
        }
    }

    protected final StringBuilder commonToString(StringBuilder stringBuilder) {
        stringBuilder.append("type=").append((Object)this._typeEnum);
        stringBuilder.append(",typeId=").append(this._typeId);
        if (this instanceof XcTaggedType) {
            stringBuilder.append(",tagged=").append(((XcTaggedType)((Object)this)).getTagName());
        }
        return stringBuilder;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("[");
        this.commonToString(stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public void resolve(XcIdentTableStack xcIdentTableStack) throws XmException {
        if (this._resolved || this._refType != null) {
            return;
        }
        this.resolveOverride(xcIdentTableStack);
        if (!this.canBeBottomType()) {
            this._refType = XcBaseTypeEnum.createTypeByXcode(this._tempRefTypeId);
            if (this._refType == null) {
                this._refType = xcIdentTableStack.getType(this._tempRefTypeId);
            }
            this._tempRefTypeId = null;
        }
        this._resolved = true;
    }

    public XcType getRealType() {
        XcType xcType = this;
        while (xcType instanceof XcBasicType && (xcType = xcType.getRefType()) != null) {
        }
        return xcType;
    }

    @Override
    public void setGccAttribute(XcGccAttributeList xcGccAttributeList) {
        this._gccAttrs = xcGccAttributeList;
    }

    @Override
    public XcGccAttributeList getGccAttribute() {
        return this._gccAttrs;
    }
}

