/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.c.type;

import java.util.HashSet;
import java.util.Set;
import xcodeml.c.decompile.XcRefObj;
import xcodeml.c.obj.XcNode;
import xcodeml.c.type.XcArrayType;
import xcodeml.c.type.XcBaseType;
import xcodeml.c.type.XcBasicType;
import xcodeml.c.type.XcCompositeType;
import xcodeml.c.type.XcEnumType;
import xcodeml.c.type.XcFuncType;
import xcodeml.c.type.XcIdent;
import xcodeml.c.type.XcPointerType;
import xcodeml.c.type.XcTagAndDefSet;
import xcodeml.c.type.XcTaggedType;
import xcodeml.c.type.XcType;

public class XcTagAndDefDepend {
    private Set<XcTagAndDefDepend> _dependOn = new HashSet<XcTagAndDefDepend>();
    private Set<XcTagAndDefDepend> _defineOf = new HashSet<XcTagAndDefDepend>();
    private XcTagAndDefSet _set;
    private String _symbol;
    private String _typeDefName;
    private XcIdent _ident;
    private boolean _isReferenceType = false;

    public void dumpSymbol() {
        if (this._typeDefName != null) {
            System.out.print("typedef_" + this._typeDefName);
        } else {
            if (this._isReferenceType) {
                System.out.print("ref_");
            }
            System.out.print(this._symbol);
        }
    }

    public void dump() {
        this.dumpSymbol();
        System.out.println();
        System.out.print("depend:");
        for (XcTagAndDefDepend xcTagAndDefDepend : this._dependOn) {
            xcTagAndDefDepend.dumpSymbol();
            System.out.print(",");
        }
        System.out.println();
        System.out.print("define:");
        for (XcTagAndDefDepend xcTagAndDefDepend : this._defineOf) {
            xcTagAndDefDepend.dumpSymbol();
            System.out.print(",");
        }
        System.out.println();
    }

    public void setIsReferenceType(boolean bl) {
        this._isReferenceType = bl;
    }

    public boolean isReferenceType() {
        return this._isReferenceType;
    }

    public XcTagAndDefDepend() {
    }

    public XcTagAndDefDepend(String string) {
        this._symbol = string;
    }

    public XcTagAndDefDepend(String string, XcTagAndDefSet xcTagAndDefSet) {
        this._set = xcTagAndDefSet;
        this._symbol = string;
    }

    public XcTagAndDefDepend(XcTagAndDefSet xcTagAndDefSet) {
        this._set = xcTagAndDefSet;
    }

    public String getSymbol() {
        return this._symbol;
    }

    public String getTypeDefName() {
        return this._typeDefName;
    }

    public void setTypeDefName(String string) {
        this._typeDefName = string;
    }

    public void addDepend(XcTagAndDefDepend xcTagAndDefDepend) {
        if (xcTagAndDefDepend == null || xcTagAndDefDepend.getSymbol() == null) {
            return;
        }
        this._dependOn.add(xcTagAndDefDepend);
    }

    public void addDefine(XcTagAndDefDepend xcTagAndDefDepend) {
        if (xcTagAndDefDepend == null || xcTagAndDefDepend.getSymbol() == null) {
            return;
        }
        this._defineOf.add(xcTagAndDefDepend);
    }

    public boolean containIdAsDepend(String string) {
        for (XcTagAndDefDepend xcTagAndDefDepend : this._dependOn) {
            if (!string.equals(xcTagAndDefDepend.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean containIdAsDefine(String string) {
        for (XcTagAndDefDepend xcTagAndDefDepend : this._defineOf) {
            if (!string.equals(xcTagAndDefDepend.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean containsDepend(XcTagAndDefDepend xcTagAndDefDepend) {
        return this._dependOn.contains(xcTagAndDefDepend);
    }

    public boolean containsDependAll(Set<XcTagAndDefDepend> set) {
        return this._dependOn.containsAll(set);
    }

    public void removeAll(Set<String> set) {
        this._dependOn.removeAll(set);
    }

    public String toString() {
        return this._symbol;
    }

    public Set<XcTagAndDefDepend> getDependSet() {
        return this._dependOn;
    }

    public Set<XcTagAndDefDepend> getDefineSet() {
        return this._defineOf;
    }

    public XcIdent getIdent() {
        return this._ident;
    }

    public void setIdent(XcIdent xcIdent) {
        this._ident = xcIdent;
        this._dependOn.clear();
    }

    public void tagnameCrowler() {
        this._tagnameCrowler(this._ident);
    }

    public void setMap(XcTagAndDefSet xcTagAndDefSet) {
        this._set = xcTagAndDefSet;
    }

    private void _tagnameCrowler(XcIdent xcIdent) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        XcType xcType = xcIdent.getType();
        switch (xcType.getTypeEnum()) {
            case STRUCT: 
            case UNION: {
                XcCompositeType xcCompositeType = (XcCompositeType)xcType;
                if (xcCompositeType.getMemberList() != null) {
                    for (XcIdent xcIdent2 : xcCompositeType.getMemberList()) {
                        this._tagnameCrowler(bl, bl2, bl3, new XcNode[]{xcIdent2});
                    }
                    this.addDefine(this);
                }
                this.addDefine(this._set.getRef(this._symbol));
                break;
            }
            case ENUM: {
                this.addDefine(this);
                this.addDefine(this._set.getRef(this._symbol));
                XcEnumType xcEnumType = (XcEnumType)xcType;
                if (xcEnumType.getEnumeratorList() == null) break;
                for (XcIdent xcIdent3 : xcEnumType.getEnumeratorList()) {
                    this._tagnameCrowler(bl, bl2, bl3, xcIdent3.getValue());
                }
                break;
            }
            case FUNC: {
                XcFuncType xcFuncType = (XcFuncType)xcType;
                XcType xcType2 = xcType.getRefType();
                this._tagnameCrowler(bl, true, bl3, xcType2);
                bl = true;
                for (XcIdent xcIdent4 : xcFuncType.getParamList()) {
                    this._tagnameCrowler(bl, bl2, bl3, xcIdent4);
                }
                if (xcFuncType.getParamList() != null || !xcFuncType.getParamList().isEmpty()) {
                    this.addDefine(this);
                }
                this.addDefine(this._set.getRef(this._symbol));
            }
            case ARRAY: 
            case BASICTYPE: {
                this.addDefine(this);
            }
            case POINTER: {
                this.addDefine(this._set.getRef(this._symbol));
                this._tagnameCrowler(bl, bl2, bl3, xcType);
                break;
            }
            case BASETYPE: 
            case BUILTIN: {
                break;
            }
        }
        this._tagnameCrowler(bl, bl2, bl3, xcIdent.getGccAttribute());
    }

    private void _tagnameCrowler(boolean bl, boolean bl2, boolean bl3, XcIdent xcIdent) {
        if (xcIdent instanceof XcIdent.MoeConstant) {
            XcEnumType xcEnumType = ((XcIdent.MoeConstant)xcIdent).getEnumType();
            if (!this._defineOf.contains(this._set.get(xcEnumType.getTagName()))) {
                this._tagnameCrowler(false, false, false, xcEnumType);
            }
            return;
        }
        XcType xcType = xcIdent.getType();
        this._tagnameCrowler(bl, bl2, bl3, xcIdent.getGccAttribute());
        this._tagnameCrowler(bl, bl2, bl3, xcType);
    }

    private void _tagnameCrowler(boolean bl, boolean bl2, boolean bl3, XcType xcType) {
        if (xcType == null) {
            return;
        }
        while (xcType instanceof XcBasicType) {
            xcType = xcType.getRefType();
        }
        if (xcType instanceof XcBaseType) {
            return;
        }
        if (xcType instanceof XcTaggedType) {
            XcTaggedType xcTaggedType = (XcTaggedType)((Object)xcType);
            String string = xcTaggedType.getTagName();
            if (bl3) {
                this.addDepend(this._set.get(string));
                bl3 = false;
            } else if (bl) {
                if (string != this._symbol) {
                    XcTagAndDefDepend xcTagAndDefDepend = this._set.getRef(string);
                    this.addDepend(xcTagAndDefDepend);
                    if (bl2) {
                        xcTagAndDefDepend.setIsReferenceType(true);
                    }
                }
                this.addDefine(this._set.getRef(string));
            } else if (bl2) {
                this.addDepend(this._set.getRef(string));
            } else {
                this.addDepend(this._set.get(string));
            }
        } else if (xcType instanceof XcFuncType) {
            XcFuncType xcFuncType = (XcFuncType)xcType;
            bl2 = true;
            this._tagnameCrowler(bl, bl2, bl3, ((XcFuncType)xcType).getRefType());
            bl2 = false;
            bl = true;
            for (XcIdent xcIdent : xcFuncType.getParamList()) {
                this._tagnameCrowler(bl, bl2, bl3, xcIdent);
            }
        } else if (xcType instanceof XcArrayType) {
            this._tagnameCrowler(bl, bl2, bl3, ((XcArrayType)xcType).getArraySizeExpr());
        } else if (xcType instanceof XcPointerType) {
            bl2 = true;
        }
        this._tagnameCrowler(bl, bl2, bl3, xcType.getGccAttribute());
        this._tagnameCrowler(bl, bl2, bl3, xcType.getRefType());
    }

    private void _tagnameCrowler(boolean bl, boolean bl2, boolean bl3, XcNode ... xcNodeArray) {
        if (xcNodeArray == null || xcNodeArray.length == 0) {
            return;
        }
        for (XcNode xcNode : xcNodeArray) {
            if (xcNode == null) continue;
            if (xcNode instanceof XcIdent) {
                this._tagnameCrowler(bl, bl2, bl3, (XcIdent)xcNode);
            }
            if (xcNode instanceof XcType) {
                this._tagnameCrowler(bl, bl2, bl3, (XcType)xcNode);
            }
            if (xcNode instanceof XcRefObj.MemberRef || xcNode instanceof XcRefObj.MemberAddr) {
                bl3 = true;
            }
            this._tagnameCrowler(bl, bl2, bl3, xcNode.getChild());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        XcTagAndDefDepend xcTagAndDefDepend = (XcTagAndDefDepend)object;
        if (this._symbol == null || xcTagAndDefDepend._symbol == null) {
            return false;
        }
        return this._symbol.equals(xcTagAndDefDepend._symbol) && this._isReferenceType == xcTagAndDefDepend._isReferenceType;
    }

    public int hashCode() {
        if (this._typeDefName != null) {
            return this._typeDefName.hashCode();
        }
        return this._symbol.hashCode();
    }
}

