/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.c.type;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import xcodeml.c.type.XcBaseType;
import xcodeml.c.type.XcBaseTypeEnum;
import xcodeml.c.type.XcBasicType;
import xcodeml.c.type.XcIdent;
import xcodeml.c.type.XcIdentTable;
import xcodeml.c.type.XcIdentTableEnum;
import xcodeml.c.type.XcSymbolKindEnum;
import xcodeml.c.type.XcTagAndDefSet;
import xcodeml.c.type.XcTaggedType;
import xcodeml.c.type.XcType;
import xcodeml.c.type.XcTypeEnum;
import xcodeml.c.type.XcTypeList;
import xcodeml.c.util.XcLazyVisitor;
import xcodeml.util.XmException;

public final class XcIdentTableStack {
    private Stack<XcIdentTable> _stack = new Stack();
    private Map<String, XcType> _typeMap = new HashMap<String, XcType>();
    private XcTypeList _preResolvedTypeList = new XcTypeList();

    public final XcIdentTable getLast() {
        return this._stack.peek();
    }

    public final XcIdentTable push() {
        XcTagAndDefSet xcTagAndDefSet = null;
        if (!this._stack.isEmpty()) {
            xcTagAndDefSet = this.getLast().getDefinedTypeSet();
        }
        XcIdentTable xcIdentTable = new XcIdentTable();
        xcIdentTable.copyTypeSet(xcTagAndDefSet);
        this._stack.push(xcIdentTable);
        return this.getLast();
    }

    public final void pop() {
        this._stack.pop();
    }

    private XcIdentTableEnum _getIdentTableEnum(XcSymbolKindEnum xcSymbolKindEnum) {
        if (xcSymbolKindEnum == null) {
            throw new IllegalArgumentException();
        }
        switch (xcSymbolKindEnum) {
            case FUNC: 
            case VAR: 
            case MOE: 
            case TYPE: {
                return XcIdentTableEnum.MAIN;
            }
            case TAGNAME: {
                return XcIdentTableEnum.TAGNAME;
            }
            case LABEL: {
                return XcIdentTableEnum.LABEL;
            }
            case ANONYM: {
                return XcIdentTableEnum.ANONYM;
            }
        }
        throw new IllegalArgumentException(xcSymbolKindEnum.toString());
    }

    public void addIdent(XcSymbolKindEnum xcSymbolKindEnum, XcIdent xcIdent) throws XmException {
        XcIdentTableEnum xcIdentTableEnum;
        if (xcIdent == null) {
            throw new IllegalArgumentException();
        }
        if (this._stack.isEmpty()) {
            throw new IllegalStateException();
        }
        XcIdentTable xcIdentTable = this.getLast();
        if (xcIdentTable.containsIdent(xcIdentTableEnum = this._getIdentTableEnum(xcSymbolKindEnum), xcIdent.getSymbol())) {
            throw new XmException("redeclaration of '" + xcIdent.getSymbol() + "'");
        }
        xcIdent.setSymbolKindEnum(xcSymbolKindEnum);
        xcIdentTable.add(xcIdentTableEnum, xcIdent);
        if (xcSymbolKindEnum == XcSymbolKindEnum.TAGNAME) {
            ((XcTaggedType)((Object)xcIdent.getType())).setTagName(xcIdent.getSymbol());
        }
    }

    public void addAnonIdent(XcIdent xcIdent) throws XmException {
        if (xcIdent == null) {
            throw new IllegalArgumentException();
        }
        if (this._stack.isEmpty()) {
            throw new IllegalStateException();
        }
        XcIdentTable xcIdentTable = this.getLast();
        xcIdentTable.addAnonIdent(xcIdent);
    }

    public void resolveDependency(XcLazyVisitor xcLazyVisitor) throws XmException {
        XcIdentTable xcIdentTable = this.getLast();
        xcIdentTable.resolveDependency(xcLazyVisitor);
    }

    public XcIdent getIdent(XcSymbolKindEnum xcSymbolKindEnum, String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this._stack.isEmpty()) {
            throw new IllegalStateException();
        }
        XcIdentTableEnum xcIdentTableEnum = this._getIdentTableEnum(xcSymbolKindEnum);
        XcIdent xcIdent = null;
        for (XcIdentTable xcIdentTable : this._stack) {
            XcIdent xcIdent2 = xcIdentTable.getIdent(xcIdentTableEnum, string);
            if (xcIdent2 == null) continue;
            xcIdent = xcIdent2;
        }
        return xcIdent;
    }

    public void addType(XcType xcType) throws XmException {
        if (xcType == null) {
            throw new IllegalArgumentException();
        }
        if (this._stack.isEmpty()) {
            throw new IllegalStateException();
        }
        String string = xcType.getTypeId();
        if (this._typeMap.containsKey(string)) {
            throw new XmException("redeclaration of '" + xcType.getTypeId() + "'");
        }
        this._typeMap.put(xcType.getTypeId(), xcType);
        this._preResolvedTypeList.add(xcType);
    }

    public XcType getTypeOrNull(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this._stack.isEmpty()) {
            throw new IllegalStateException();
        }
        return this._typeMap.get(string);
    }

    public boolean contains(String string) {
        if (XcBaseTypeEnum.isBuiltInType(string)) {
            return true;
        }
        return this._typeMap.containsKey(string);
    }

    public XcType getType(String string) throws XmException {
        XcBaseType xcBaseType = XcBaseTypeEnum.createTypeByXcode(string);
        if (xcBaseType != null) {
            return xcBaseType;
        }
        XcType xcType = this.getTypeOrNull(string);
        if (xcType == null) {
            throw new XmException("type '" + string + "' is not found");
        }
        return xcType;
    }

    public XcType getTypeAs(XcTypeEnum xcTypeEnum, String string) throws XmException {
        XcType xcType = this.getType(string);
        if (!xcType.getTypeEnum().equals((Object)xcTypeEnum)) {
            throw new XmException("type '" + string + "' is not " + xcTypeEnum.getDescription());
        }
        return xcType;
    }

    public void resolveType() throws XmException {
        this._preResolvedTypeList.resolve(this);
        this._preResolvedTypeList.clear();
    }

    public final XcType getRealType(XcType xcType) {
        while (xcType != null && xcType instanceof XcBasicType) {
            xcType = xcType.getRefType();
        }
        return xcType;
    }
}

